/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.io.Closeable;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.org.apache.avro.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class AvroSchemaCache
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(AvroSchemaCache.class);
    private Map<Integer, Schema> versionIdToSchema = new HashMap<Integer, Schema>();
    private Map<Schema, Integer> schemaToVersionId = new HashMap<Schema, Integer>();
    private int nextVersionId = 0;

    private AvroSchemaCache() {
    }

    public static AvroSchemaCache getInstance() {
        return new AvroSchemaCache();
    }

    public Integer cacheSchema(Schema schema) {
        Integer versionId = this.schemaToVersionId.get(schema);
        if (versionId == null) {
            versionId = this.nextVersionId++;
            this.schemaToVersionId.put(schema, versionId);
            this.versionIdToSchema.put(versionId, schema);
        }
        return versionId;
    }

    public Option<Schema> getSchema(Integer versionId) {
        return Option.ofNullable(this.versionIdToSchema.get(versionId));
    }

    @Override
    public void close() {
        this.schemaToVersionId.clear();
        this.versionIdToSchema.clear();
    }
}

