/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;

public class CustomizedThreadFactory
implements ThreadFactory {
    private static final AtomicLong POOL_NUM = new AtomicLong(1L);
    private final AtomicLong threadNum = new AtomicLong(1L);
    private final String threadName;
    private final boolean daemon;
    private Runnable preExecuteRunnable;

    public CustomizedThreadFactory() {
        this("pool-" + POOL_NUM.getAndIncrement(), false);
    }

    public CustomizedThreadFactory(String threadNamePrefix) {
        this(threadNamePrefix, false);
    }

    public CustomizedThreadFactory(String threadNamePrefix, Runnable preExecuteRunnable) {
        this(threadNamePrefix, false, preExecuteRunnable);
    }

    public CustomizedThreadFactory(String threadNamePrefix, boolean daemon, Runnable preExecuteRunnable) {
        this.threadName = threadNamePrefix + "-thread-";
        this.daemon = daemon;
        this.preExecuteRunnable = preExecuteRunnable;
    }

    public CustomizedThreadFactory(String threadNamePrefix, boolean daemon) {
        this.threadName = threadNamePrefix + "-thread-";
        this.daemon = daemon;
    }

    @Override
    public Thread newThread(final @Nonnull Runnable r) {
        Thread runThread = this.preExecuteRunnable == null ? new Thread(r) : new Thread(new Runnable(){

            @Override
            public void run() {
                CustomizedThreadFactory.this.preExecuteRunnable.run();
                r.run();
            }
        });
        runThread.setDaemon(this.daemon);
        runThread.setName(this.threadName + this.threadNum.getAndIncrement());
        return runThread;
    }
}

