/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.bloom.BloomFilterFactory;
import org.apache.hudi.common.bloom.BloomFilterTypeCode;
import org.apache.hudi.common.model.HoodieColumnRangeMetadata;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.keygen.BaseKeyGenerator;
import org.apache.hudi.org.apache.avro.Schema;
import org.apache.hudi.org.apache.avro.generic.GenericRecord;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;

public abstract class FileFormatUtils {
    public static <T extends Comparable<T>> HoodieColumnRangeMetadata<T> getColumnRangeInPartition(String relativePartitionPath, @Nonnull List<HoodieColumnRangeMetadata<T>> fileColumnRanges) {
        ValidationUtils.checkArgument(!fileColumnRanges.isEmpty(), "fileColumnRanges should not be empty.");
        return fileColumnRanges.stream().map(e -> HoodieColumnRangeMetadata.create(relativePartitionPath, e.getColumnName(), e.getMinValue(), e.getMaxValue(), e.getNullCount(), e.getValueCount(), e.getTotalSize(), e.getTotalUncompressedSize())).reduce(HoodieColumnRangeMetadata::merge).orElseThrow(() -> new HoodieException("MergingColumnRanges failed."));
    }

    public Set<String> readRowKeys(HoodieStorage storage, StoragePath filePath) {
        return this.filterRowKeys(storage, filePath, new HashSet<String>()).stream().map(Pair::getKey).collect(Collectors.toSet());
    }

    public BloomFilter readBloomFilterFromMetadata(HoodieStorage storage, StoragePath filePath) {
        Map<String, String> footerVals = this.readFooter(storage, false, filePath, "org.apache.hudi.bloomfilter", "com.uber.hoodie.bloomfilter", "hoodie_bloom_filter_type_code");
        String footerVal = footerVals.get("org.apache.hudi.bloomfilter");
        if (null == footerVal) {
            footerVal = footerVals.get("com.uber.hoodie.bloomfilter");
        }
        BloomFilter toReturn = null;
        if (footerVal != null) {
            toReturn = footerVals.containsKey("hoodie_bloom_filter_type_code") ? BloomFilterFactory.fromString(footerVal, footerVals.get("hoodie_bloom_filter_type_code")) : BloomFilterFactory.fromString(footerVal, BloomFilterTypeCode.SIMPLE.name());
        }
        return toReturn;
    }

    public String[] readMinMaxRecordKeys(HoodieStorage storage, StoragePath filePath) {
        Map<String, String> minMaxKeys = this.readFooter(storage, true, filePath, "hoodie_min_record_key", "hoodie_max_record_key");
        if (minMaxKeys.size() != 2) {
            throw new HoodieException(String.format("Could not read min/max record key out of footer correctly from %s. read) : %s", filePath, minMaxKeys));
        }
        return new String[]{minMaxKeys.get("hoodie_min_record_key"), minMaxKeys.get("hoodie_max_record_key")};
    }

    public abstract List<GenericRecord> readAvroRecords(HoodieStorage var1, StoragePath var2);

    public abstract List<GenericRecord> readAvroRecords(HoodieStorage var1, StoragePath var2, Schema var3);

    public abstract Map<String, String> readFooter(HoodieStorage var1, boolean var2, StoragePath var3, String ... var4);

    public abstract long getRowCount(HoodieStorage var1, StoragePath var2);

    public abstract Set<Pair<String, Long>> filterRowKeys(HoodieStorage var1, StoragePath var2, Set<String> var3);

    public abstract List<Pair<HoodieKey, Long>> fetchRecordKeysWithPositions(HoodieStorage var1, StoragePath var2);

    public abstract ClosableIterator<HoodieKey> getHoodieKeyIterator(HoodieStorage var1, StoragePath var2, Option<BaseKeyGenerator> var3);

    public abstract ClosableIterator<HoodieKey> getHoodieKeyIterator(HoodieStorage var1, StoragePath var2);

    public abstract List<Pair<HoodieKey, Long>> fetchRecordKeysWithPositions(HoodieStorage var1, StoragePath var2, Option<BaseKeyGenerator> var3);

    public abstract Schema readAvroSchema(HoodieStorage var1, StoragePath var2);

    public abstract List<HoodieColumnRangeMetadata<Comparable>> readColumnStatsFromMetadata(HoodieStorage var1, StoragePath var2, List<String> var3);

    public abstract HoodieFileFormat getFormat();

    public abstract void writeMetaFile(HoodieStorage var1, StoragePath var2, Properties var3) throws IOException;

    public abstract byte[] serializeRecordsToLogBlock(HoodieStorage var1, List<HoodieRecord> var2, Schema var3, Schema var4, String var5, Map<String, String> var6) throws IOException;

    public static class HoodieKeyIterator
    implements ClosableIterator<HoodieKey> {
        private final ClosableIterator<GenericRecord> nestedItr;
        private final Function<GenericRecord, HoodieKey> func;

        public static HoodieKeyIterator getInstance(ClosableIterator<GenericRecord> nestedItr, Option<BaseKeyGenerator> keyGenerator) {
            return new HoodieKeyIterator(nestedItr, keyGenerator);
        }

        private HoodieKeyIterator(ClosableIterator<GenericRecord> nestedItr, Option<BaseKeyGenerator> keyGenerator) {
            this.nestedItr = nestedItr;
            this.func = keyGenerator.isPresent() ? retVal -> {
                String recordKey = ((BaseKeyGenerator)keyGenerator.get()).getRecordKey((GenericRecord)retVal);
                String partitionPath = ((BaseKeyGenerator)keyGenerator.get()).getPartitionPath((GenericRecord)retVal);
                return new HoodieKey(recordKey, partitionPath);
            } : retVal -> {
                String recordKey = retVal.get(HoodieRecord.RECORD_KEY_METADATA_FIELD).toString();
                String partitionPath = retVal.get(HoodieRecord.PARTITION_PATH_METADATA_FIELD).toString();
                return new HoodieKey(recordKey, partitionPath);
            };
        }

        @Override
        public void close() {
            if (this.nestedItr != null) {
                this.nestedItr.close();
            }
        }

        @Override
        public boolean hasNext() {
            return this.nestedItr.hasNext();
        }

        @Override
        public HoodieKey next() {
            return this.func.apply((GenericRecord)this.nestedItr.next());
        }
    }
}

