/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public final class Option<T>
implements Serializable {
    private static final long serialVersionUID = 0L;
    private static final Option<?> EMPTY = new Option();
    private final T val;

    public Optional<T> toJavaOptional() {
        return Optional.ofNullable(this.val);
    }

    public static <T> Option<T> fromJavaOptional(Optional<T> v) {
        return Option.ofNullable(v.orElse(null));
    }

    private Option() {
        this.val = null;
    }

    private Option(T val) {
        if (null == val) {
            throw new NullPointerException("Expected a non-null value. Got null");
        }
        this.val = val;
    }

    public static <T> Option<T> empty() {
        return EMPTY;
    }

    public static <T> Option<T> of(T value) {
        return new Option<T>(value);
    }

    public static <T> Option<T> ofNullable(T value) {
        return null == value ? Option.empty() : Option.of(value);
    }

    public boolean isPresent() {
        return null != this.val;
    }

    public boolean isEmpty() {
        return null == this.val;
    }

    public T get() {
        if (null == this.val) {
            throw new NoSuchElementException("No value present in Option");
        }
        return this.val;
    }

    public void ifPresent(Consumer<? super T> consumer) {
        if (this.val != null) {
            consumer.accept(this.val);
        }
    }

    public <U> Option<U> map(Function<? super T, ? extends U> mapper) {
        if (null == mapper) {
            throw new NullPointerException("mapper should not be null");
        }
        if (!this.isPresent()) {
            return Option.empty();
        }
        return Option.ofNullable(mapper.apply(this.val));
    }

    public <U> Option<U> flatMap(Function<? super T, Option<U>> mapper) {
        if (null == mapper) {
            throw new NullPointerException("mapper should not be null");
        }
        if (!this.isPresent()) {
            return Option.empty();
        }
        return Objects.requireNonNull(mapper.apply(this.val));
    }

    public Option<T> or(Option<T> other) {
        return this.val != null ? this : other;
    }

    public Option<T> or(Supplier<? extends Option<T>> other) {
        return this.val != null ? this : other.get();
    }

    public T orElse(T other) {
        return this.val != null ? this.val : other;
    }

    public T orElseGet(Supplier<? extends T> other) {
        return this.val != null ? this.val : other.get();
    }

    public <X extends Throwable> T orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        if (this.val != null) {
            return this.val;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Option option = (Option)o;
        return Objects.equals(this.val, option.val);
    }

    public int hashCode() {
        return Objects.hash(this.val);
    }

    public String toString() {
        return this.val != null ? "Option{val=" + this.val + "}" : "Optional.empty";
    }
}

