/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.config.metrics;

import java.util.Map;
import java.util.Properties;
import org.apache.hudi.common.config.ConfigClassProperty;
import org.apache.hudi.common.config.ConfigGroups;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.HoodieConfig;

@ConfigClassProperty(name="Metrics Configurations for Amazon CloudWatch", groupName=ConfigGroups.Names.METRICS, description="Enables reporting on Hudi metrics using Amazon CloudWatch.  Hudi publishes metrics on every commit, clean, rollback etc.")
public class HoodieMetricsCloudWatchConfig
extends HoodieConfig {
    public static final String CLOUDWATCH_PREFIX = "hoodie.metrics.cloudwatch";
    public static final ConfigProperty<Integer> REPORT_PERIOD_SECONDS = ConfigProperty.key("hoodie.metrics.cloudwatch.report.period.seconds").defaultValue(60).markAdvanced().sinceVersion("0.10.0").withDocumentation("Reporting interval in seconds");
    public static final ConfigProperty<String> METRIC_PREFIX = ConfigProperty.key("hoodie.metrics.cloudwatch.metric.prefix").defaultValue("").markAdvanced().sinceVersion("0.10.0").withDocumentation("Metric prefix of reporter");
    public static final ConfigProperty<String> METRIC_NAMESPACE = ConfigProperty.key("hoodie.metrics.cloudwatch.namespace").defaultValue("Hudi").markAdvanced().sinceVersion("0.10.0").withDocumentation("Namespace of reporter");
    public static final ConfigProperty<Integer> MAX_DATUMS_PER_REQUEST = ConfigProperty.key("hoodie.metrics.cloudwatch.maxDatumsPerRequest").defaultValue(20).markAdvanced().sinceVersion("0.10.0").withDocumentation("Max number of Datums per request");

    static Builder newBuilder() {
        return new Builder();
    }

    static class Builder {
        private final HoodieMetricsCloudWatchConfig hoodieMetricsCloudWatchConfig = new HoodieMetricsCloudWatchConfig();

        Builder() {
        }

        public Builder fromProperties(Properties props) {
            this.hoodieMetricsCloudWatchConfig.getProps().putAll((Map<?, ?>)props);
            return this;
        }

        public HoodieMetricsCloudWatchConfig build() {
            this.hoodieMetricsCloudWatchConfig.setDefaults(HoodieMetricsCloudWatchConfig.class.getName());
            return this.hoodieMetricsCloudWatchConfig;
        }
    }
}

