/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.expression;

import java.io.Serializable;
import java.util.List;
import org.apache.hudi.expression.ExpressionVisitor;
import org.apache.hudi.expression.StructLike;
import org.apache.hudi.internal.schema.Type;

public interface Expression
extends Serializable {
    public List<Expression> getChildren();

    public Type getDataType();

    default public Object eval(StructLike data) {
        throw new UnsupportedOperationException("Cannot evaluate expression " + this);
    }

    public <T> T accept(ExpressionVisitor<T> var1);

    public String toString();

    public static enum Operator {
        TRUE("TRUE", "TRUE"),
        FALSE("FALSE", "FALSE"),
        AND("AND", "&&"),
        OR("OR", "||"),
        GT(">", ">"),
        LT("<", "<"),
        EQ("=", "="),
        GT_EQ(">=", ">="),
        LT_EQ("<=", "<="),
        STARTS_WITH(null, null),
        CONTAINS(null, null),
        IS_NULL(null, null),
        IS_NOT_NULL(null, null),
        IN("IN", "IN"),
        NOT("NOT", "NOT");

        public final String sqlOperator;
        public final String symbol;

        private Operator(String sqlOperator, String symbol) {
            this.sqlOperator = sqlOperator;
            this.symbol = symbol;
        }
    }
}

