/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.hfile;

import org.apache.hudi.common.util.Option;
import org.apache.hudi.io.hfile.KeyValue;

public class HFileCursor {
    private static final int INVALID_POSITION = -1;
    private int offset = -1;
    private Option<KeyValue> keyValue = Option.empty();
    private boolean eof = false;

    public boolean isSeeked() {
        return this.offset != -1 || this.eof;
    }

    public boolean isValid() {
        return this.offset != -1 && !this.eof;
    }

    public int getOffset() {
        return this.offset;
    }

    public Option<KeyValue> getKeyValue() {
        return this.keyValue;
    }

    public void set(int offset, KeyValue keyValue) {
        this.offset = offset;
        this.keyValue = Option.of(keyValue);
    }

    public void setOffset(int offset) {
        this.offset = offset;
        this.keyValue = Option.empty();
    }

    public void setKeyValue(KeyValue keyValue) {
        this.keyValue = Option.of(keyValue);
    }

    public void setEof() {
        this.eof = true;
        this.keyValue = Option.empty();
    }

    public void unsetEof() {
        this.eof = false;
    }

    public void increment(long incr) {
        this.offset = (int)((long)this.offset + incr);
        this.keyValue = Option.empty();
    }

    public String toString() {
        return "HFilePosition{offset=" + this.offset + ", keyValue=" + this.keyValue.toString() + "}";
    }
}

