/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class IOUtils {
    public static int readInt(byte[] bytes, int offset) {
        return (bytes[offset] & 0xFF) << 24 | (bytes[offset + 1] & 0xFF) << 16 | (bytes[offset + 2] & 0xFF) << 8 | bytes[offset + 3] & 0xFF;
    }

    public static long readLong(byte[] bytes, int offset) {
        return (long)(bytes[offset] & 0xFF) << 56 | (long)(bytes[offset + 1] & 0xFF) << 48 | (long)(bytes[offset + 2] & 0xFF) << 40 | (long)(bytes[offset + 3] & 0xFF) << 32 | (long)(bytes[offset + 4] & 0xFF) << 24 | (long)(bytes[offset + 5] & 0xFF) << 16 | (long)(bytes[offset + 6] & 0xFF) << 8 | (long)(bytes[offset + 7] & 0xFF);
    }

    public static short readShort(byte[] bytes, int offset) {
        short n = 0;
        n = (short)((n ^ bytes[offset]) & 0xFF);
        n = (short)(n << 8);
        n = (short)(n ^ (short)(bytes[offset + 1] & 0xFF));
        return n;
    }

    public static int decodeVarLongSizeOnDisk(byte[] bytes, int offset) {
        byte firstByte = bytes[offset];
        return IOUtils.decodeVarLongSize(firstByte);
    }

    public static int decodeVarLongSize(byte value) {
        if (value >= -112) {
            return 1;
        }
        if (value < -120) {
            return -119 - value;
        }
        return -111 - value;
    }

    public static long readVarLong(byte[] bytes, int offset) {
        return IOUtils.readVarLong(bytes, offset, IOUtils.decodeVarLongSizeOnDisk(bytes, offset));
    }

    public static long readVarLong(byte[] bytes, int offset, int varLongSizeOnDisk) {
        byte firstByte = bytes[offset];
        if (varLongSizeOnDisk == 1) {
            return firstByte;
        }
        long value = 0L;
        for (int i = 0; i < varLongSizeOnDisk - 1; ++i) {
            value <<= 8;
            value |= (long)(bytes[offset + 1 + i] & 0xFF);
        }
        return IOUtils.isNegativeVarLong(firstByte) ? value ^ 0xFFFFFFFFFFFFFFFFL : value;
    }

    public static boolean isNegativeVarLong(byte value) {
        return value < -120 || value >= -112 && value < 0;
    }

    public static byte[] copy(byte[] bytes, int offset, int length) {
        byte[] copy = new byte[length];
        System.arraycopy(bytes, offset, copy, 0, length);
        return copy;
    }

    public static int compareTo(byte[] bytes1, byte[] bytes2) {
        return IOUtils.compareTo(bytes1, 0, bytes1.length, bytes2, 0, bytes2.length);
    }

    public static int compareTo(byte[] bytes1, int offset1, int length1, byte[] bytes2, int offset2, int length2) {
        if (bytes1 == bytes2 && offset1 == offset2 && length1 == length2) {
            return 0;
        }
        int end1 = offset1 + length1;
        int end2 = offset2 + length2;
        int i = offset1;
        for (int j = offset2; i < end1 && j < end2; ++i, ++j) {
            int a = bytes1[i] & 0xFF;
            int b = bytes2[j] & 0xFF;
            if (a == b) continue;
            return a - b;
        }
        return length1 - length2;
    }

    public static int indexOf(byte[] array, byte[] target) {
        if (target.length == 0) {
            return 0;
        }
        block0: for (int i = 0; i < array.length - target.length + 1; ++i) {
            for (int j = 0; j < target.length; ++j) {
                if (array[i + j] != target[j]) continue block0;
            }
            return i;
        }
        return -1;
    }

    public static String bytesToString(byte[] bytes, int offset, int length) {
        StringBuilder sb = new StringBuilder();
        for (int i = offset; i < offset + length; ++i) {
            sb.append((char)bytes[i]);
        }
        return sb.toString();
    }

    public static byte[] toBytes(int val) {
        byte[] b = new byte[4];
        for (int i = 3; i > 0; --i) {
            b[i] = (byte)val;
            val >>>= 8;
        }
        b[0] = (byte)val;
        return b;
    }

    public static byte[] toBytes(long val) {
        byte[] b = new byte[8];
        for (int i = 7; i > 0; --i) {
            b[i] = (byte)val;
            val >>>= 8;
        }
        b[0] = (byte)val;
        return b;
    }

    public static int hashCode(byte[] bytes, int offset, int length) {
        int hash = 1;
        for (int i = offset; i < offset + length; ++i) {
            hash = 31 * hash + bytes[i];
        }
        return hash;
    }

    public static int readFully(InputStream inputStream, byte[] targetByteArray, int offset, int length) throws IOException {
        int totalBytesRead;
        int bytesRead;
        for (totalBytesRead = 0; totalBytesRead < length && (bytesRead = inputStream.read(targetByteArray, offset + totalBytesRead, length - totalBytesRead)) >= 0; totalBytesRead += bytesRead) {
        }
        return totalBytesRead;
    }

    public static byte[] readAsByteArray(InputStream input, int outputSize) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(outputSize);
        IOUtils.copy(input, bos);
        return bos.toByteArray();
    }

    public static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        while ((len = inputStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, len);
        }
    }

    public static DataInputStream getDataInputStream(ByteBuffer byteBuffer) {
        return new DataInputStream(new ByteArrayInputStream(byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.limit() - byteBuffer.arrayOffset()));
    }

    public static byte[] toBytes(ByteBuffer buf) {
        ByteBuffer dup = buf.duplicate();
        dup.position(0);
        return IOUtils.readBytes(dup);
    }

    private static byte[] readBytes(ByteBuffer buf) {
        byte[] result = new byte[buf.remaining()];
        buf.get(result);
        return result;
    }
}

