/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metrics.m3;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metered;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import com.uber.m3.tally.Scope;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import org.apache.hudi.common.util.collection.Pair;

public class M3ScopeReporterAdaptor
extends ScheduledReporter {
    private final Scope scope;

    protected M3ScopeReporterAdaptor(MetricRegistry registry, Scope scope) {
        super(registry, "hudi-m3-reporter", MetricFilter.ALL, TimeUnit.SECONDS, TimeUnit.SECONDS);
        this.scope = scope;
    }

    public void start(long period, TimeUnit unit) {
    }

    public void stop() {
    }

    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        this.report(this.scope, gauges, counters, histograms, meters, timers);
    }

    private void report(Scope scope, Map<String, Gauge> gauges, Map<String, Counter> counters, Map<String, Histogram> histograms, Map<String, Meter> meters, Map<String, Timer> timers) {
        for (Map.Entry<String, Gauge> entry : gauges.entrySet()) {
            scope.gauge(entry.getKey()).update(((Number)entry.getValue().getValue()).doubleValue());
        }
        for (Map.Entry<String, Gauge> entry : counters.entrySet()) {
            scope.counter(entry.getKey()).inc(((Number)((Counter)entry.getValue()).getCount()).longValue());
        }
        for (Map.Entry<String, Gauge> entry : histograms.entrySet()) {
            scope.gauge(MetricRegistry.name((String)entry.getKey(), (String[])new String[]{"count"})).update((double)((Histogram)entry.getValue()).getCount());
            this.reportSnapshot(entry.getKey(), ((Histogram)entry.getValue()).getSnapshot());
        }
        for (Map.Entry<String, Gauge> entry : meters.entrySet()) {
            this.reportMetered(entry.getKey(), (Metered)entry.getValue());
        }
        for (Map.Entry<String, Gauge> entry : timers.entrySet()) {
            this.reportTimer(entry.getKey(), (Timer)entry.getValue());
        }
    }

    private void reportMetered(String name, Metered meter) {
        this.scope.counter(MetricRegistry.name((String)name, (String[])new String[]{"count"})).inc(meter.getCount());
        List<Pair> meterGauges = Arrays.asList(Pair.of("m1_rate", meter.getOneMinuteRate()), Pair.of("m5_rate", meter.getFiveMinuteRate()), Pair.of("m15_rate", meter.getFifteenMinuteRate()), Pair.of("mean_rate", meter.getMeanRate()));
        for (Pair pair : meterGauges) {
            this.scope.gauge(MetricRegistry.name((String)name, (String[])new String[]{(String)pair.getLeft()})).update(((Double)pair.getRight()).doubleValue());
        }
    }

    private void reportSnapshot(String name, Snapshot snapshot) {
        List<Pair> snapshotGauges = Arrays.asList(Pair.of("max", snapshot.getMax()), Pair.of("mean", snapshot.getMean()), Pair.of("min", snapshot.getMin()), Pair.of("stddev", snapshot.getStdDev()), Pair.of("p50", snapshot.getMedian()), Pair.of("p75", snapshot.get75thPercentile()), Pair.of("p95", snapshot.get95thPercentile()), Pair.of("p98", snapshot.get98thPercentile()), Pair.of("p99", snapshot.get99thPercentile()), Pair.of("p999", snapshot.get999thPercentile()));
        for (Pair pair : snapshotGauges) {
            this.scope.gauge(MetricRegistry.name((String)name, (String[])new String[]{(String)pair.getLeft()})).update(((Number)pair.getRight()).doubleValue());
        }
    }

    private void reportTimer(String name, Timer timer) {
        this.reportMetered(name, (Metered)timer);
        this.reportSnapshot(name, timer.getSnapshot());
    }
}

