/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase;

import java.io.IOException;
import java.net.UnknownHostException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hudi.org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hudi.org.apache.hadoop.hbase.Stoppable;
import org.apache.hudi.org.apache.hadoop.hbase.security.User;
import org.apache.hudi.org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hudi.org.apache.hadoop.hbase.util.DNS;
import org.apache.hudi.org.apache.hadoop.hbase.util.Strings;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@InterfaceAudience.Public
public final class AuthUtil {
    private static final Logger LOG = LoggerFactory.getLogger(AuthUtil.class);
    private static final String GROUP_PREFIX = "@";
    public static final String HBASE_CLIENT_KEYTAB_FILE = "hbase.client.keytab.file";
    public static final String HBASE_CLIENT_KERBEROS_PRINCIPAL = "hbase.client.keytab.principal";

    private AuthUtil() {
    }

    @InterfaceAudience.Private
    public static User loginClient(Configuration conf) throws IOException {
        boolean securityOn;
        UserProvider provider = UserProvider.instantiate(conf);
        User user = provider.getCurrent();
        boolean bl = securityOn = provider.isHBaseSecurityEnabled() && provider.isHadoopSecurityEnabled();
        if (securityOn) {
            boolean fromKeytab = provider.shouldLoginFromKeytab();
            if (user.getUGI().hasKerberosCredentials()) {
                if (fromKeytab) {
                    return AuthUtil.checkPrincipalMatch(conf, user.getUGI().getUserName()) ? user : AuthUtil.loginFromKeytabAndReturnUser(provider);
                }
                return user;
            }
            if (fromKeytab) {
                return AuthUtil.loginFromKeytabAndReturnUser(provider);
            }
        }
        return user;
    }

    private static boolean checkPrincipalMatch(Configuration conf, String loginUserName) {
        String configuredUserName = conf.get(HBASE_CLIENT_KERBEROS_PRINCIPAL);
        boolean match = configuredUserName.equals(loginUserName);
        if (!match) {
            LOG.warn("Trying to login with a different user: {}, existed user is {}.", (Object)configuredUserName, (Object)loginUserName);
        }
        return match;
    }

    private static User loginFromKeytabAndReturnUser(UserProvider provider) throws IOException {
        try {
            provider.login(HBASE_CLIENT_KEYTAB_FILE, HBASE_CLIENT_KERBEROS_PRINCIPAL);
        }
        catch (IOException ioe) {
            LOG.error("Error while trying to login as user {} through {}, with message: {}.", new Object[]{HBASE_CLIENT_KERBEROS_PRINCIPAL, HBASE_CLIENT_KEYTAB_FILE, ioe.getMessage()});
            throw ioe;
        }
        return provider.getCurrent();
    }

    private static User loginClientAsService(Configuration conf) throws IOException {
        UserProvider provider = UserProvider.instantiate(conf);
        if (provider.isHBaseSecurityEnabled() && provider.isHadoopSecurityEnabled()) {
            try {
                if (provider.shouldLoginFromKeytab()) {
                    String host2 = Strings.domainNamePointerToHostName(DNS.getDefaultHost(conf.get("hbase.client.dns.interface", "default"), conf.get("hbase.client.dns.nameserver", "default")));
                    provider.login(HBASE_CLIENT_KEYTAB_FILE, HBASE_CLIENT_KERBEROS_PRINCIPAL, host2);
                }
            }
            catch (UnknownHostException e) {
                LOG.error("Error resolving host name: " + e.getMessage(), (Throwable)e);
                throw e;
            }
            catch (IOException e) {
                LOG.error("Error while trying to perform the initial login: " + e.getMessage(), (Throwable)e);
                throw e;
            }
        }
        return provider.getCurrent();
    }

    @InterfaceAudience.Private
    public static ScheduledChore getAuthRenewalChore(final UserGroupInformation user) {
        if (!user.hasKerberosCredentials()) {
            return null;
        }
        Stoppable stoppable = AuthUtil.createDummyStoppable();
        int CHECK_TGT_INTERVAL = 30000;
        return new ScheduledChore("RefreshCredentials", stoppable, 30000){

            @Override
            protected void chore() {
                try {
                    user.checkTGTAndReloginFromKeytab();
                }
                catch (IOException e) {
                    LOG.error("Got exception while trying to refresh credentials: " + e.getMessage(), (Throwable)e);
                }
            }
        };
    }

    @Deprecated
    public static ScheduledChore getAuthChore(Configuration conf) throws IOException {
        User user = AuthUtil.loginClientAsService(conf);
        return AuthUtil.getAuthRenewalChore(user.getUGI());
    }

    private static Stoppable createDummyStoppable() {
        return new Stoppable(){
            private volatile boolean isStopped = false;

            @Override
            public void stop(String why) {
                this.isStopped = true;
            }

            @Override
            public boolean isStopped() {
                return this.isStopped;
            }
        };
    }

    @InterfaceAudience.Private
    public static boolean isGroupPrincipal(String name) {
        return name != null && name.startsWith(GROUP_PREFIX);
    }

    @InterfaceAudience.Private
    public static String getGroupName(String aclKey) {
        if (!AuthUtil.isGroupPrincipal(aclKey)) {
            return aclKey;
        }
        return aclKey.substring(GROUP_PREFIX.length());
    }

    @InterfaceAudience.Private
    public static String toGroupEntry(String name) {
        return GROUP_PREFIX + name;
    }
}

