/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.master.zksyncer;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hudi.org.apache.hadoop.hbase.Server;
import org.apache.hudi.org.apache.hadoop.hbase.master.zksyncer.ClientZKSyncer;
import org.apache.hudi.org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MetaLocationSyncer
extends ClientZKSyncer {
    private volatile int metaReplicaCount = 1;

    public MetaLocationSyncer(ZKWatcher watcher, ZKWatcher clientZkWatcher, Server server) {
        super(watcher, clientZkWatcher, server);
    }

    @Override
    protected boolean validate(String path) {
        return this.watcher.getZNodePaths().isMetaZNodePath(path);
    }

    @Override
    protected Set<String> getPathsToWatch() {
        return IntStream.range(0, this.metaReplicaCount).mapToObj(this.watcher.getZNodePaths()::getZNodeForReplica).collect(Collectors.toSet());
    }

    public void setMetaReplicaCount(int replicaCount) {
        if (replicaCount != this.metaReplicaCount) {
            this.metaReplicaCount = replicaCount;
            this.refreshWatchingList();
        }
    }
}

