/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.procedure.flush;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.hudi.org.apache.hadoop.hbase.errorhandling.ForeignException;
import org.apache.hudi.org.apache.hadoop.hbase.errorhandling.ForeignExceptionDispatcher;
import org.apache.hudi.org.apache.hadoop.hbase.procedure.ProcedureMember;
import org.apache.hudi.org.apache.hadoop.hbase.procedure.Subprocedure;
import org.apache.hudi.org.apache.hadoop.hbase.procedure.flush.RegionServerFlushTableProcedureManager;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.FlushLifeCycleTracker;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class FlushTableSubprocedure
extends Subprocedure {
    private static final Logger LOG = LoggerFactory.getLogger(FlushTableSubprocedure.class);
    private final String table;
    private final String family;
    private final List<HRegion> regions;
    private final RegionServerFlushTableProcedureManager.FlushTableSubprocedurePool taskManager;

    public FlushTableSubprocedure(ProcedureMember member, ForeignExceptionDispatcher errorListener, long wakeFrequency, long timeout, List<HRegion> regions, String table, String family, RegionServerFlushTableProcedureManager.FlushTableSubprocedurePool taskManager) {
        super(member, table, errorListener, wakeFrequency, timeout);
        this.table = table;
        this.family = family;
        this.regions = regions;
        this.taskManager = taskManager;
    }

    private void flushRegions() throws ForeignException {
        if (this.regions.isEmpty()) {
            return;
        }
        this.monitor.rethrowException();
        if (this.taskManager.hasTasks()) {
            throw new IllegalStateException("Attempting to flush " + this.table + " but we currently have outstanding tasks");
        }
        List<byte[]> families = null;
        if (this.family != null) {
            LOG.debug("About to flush family {} on all regions for table {}", (Object)this.family, (Object)this.table);
            families = Collections.singletonList(Bytes.toBytes(this.family));
        }
        for (HRegion region : this.regions) {
            this.taskManager.submitTask(new RegionFlushTask(region, families));
            this.monitor.rethrowException();
        }
        LOG.debug("Flush region tasks submitted for " + this.regions.size() + " regions");
        try {
            this.taskManager.waitForOutstandingTasks();
        }
        catch (InterruptedException e) {
            throw new ForeignException(this.getMemberName(), e);
        }
    }

    @Override
    public void acquireBarrier() throws ForeignException {
        this.flushRegions();
    }

    @Override
    public byte[] insideBarrier() throws ForeignException {
        return new byte[0];
    }

    @Override
    public void cleanup(Exception e) {
        LOG.info("Aborting all flush region subprocedure task threads for '" + this.table + "' due to error", (Throwable)e);
        try {
            this.taskManager.cancelTasks();
        }
        catch (InterruptedException e1) {
            Thread.currentThread().interrupt();
        }
    }

    public void releaseBarrier() {
    }

    private static class RegionFlushTask
    implements Callable<Void> {
        HRegion region;
        List<byte[]> families;

        RegionFlushTask(HRegion region, List<byte[]> families) {
            this.region = region;
            this.families = families;
        }

        @Override
        public Void call() throws Exception {
            LOG.debug("Starting region operation on " + this.region);
            this.region.startRegionOperation();
            try {
                LOG.debug("Flush region " + this.region.toString() + " started...");
                if (this.families == null) {
                    this.region.flush(true);
                } else {
                    this.region.flushcache(this.families, false, FlushLifeCycleTracker.DUMMY);
                }
            }
            finally {
                LOG.debug("Closing region operation on " + this.region);
                this.region.closeRegionOperation();
            }
            return null;
        }
    }
}

