/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.regionserver;

import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.LimitedPrivate(value={"Coprocesssor"})
public class MemStoreSize {
    private final long dataSize;
    private final long heapSize;
    private final long offHeapSize;
    private final int cellsCount;

    MemStoreSize() {
        this(0L, 0L, 0L, 0);
    }

    MemStoreSize(long dataSize, long heapSize, long offHeapSize, int cellsCount) {
        this.dataSize = dataSize;
        this.heapSize = heapSize;
        this.offHeapSize = offHeapSize;
        this.cellsCount = cellsCount;
    }

    MemStoreSize(MemStoreSize memStoreSize) {
        this.dataSize = memStoreSize.getDataSize();
        this.heapSize = memStoreSize.getHeapSize();
        this.offHeapSize = memStoreSize.getOffHeapSize();
        this.cellsCount = memStoreSize.getCellsCount();
    }

    public boolean isEmpty() {
        return this.dataSize == 0L && this.heapSize == 0L && this.offHeapSize == 0L && this.cellsCount == 0;
    }

    public long getDataSize() {
        return this.dataSize;
    }

    public long getHeapSize() {
        return this.heapSize;
    }

    public long getOffHeapSize() {
        return this.offHeapSize;
    }

    public int getCellsCount() {
        return this.cellsCount;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MemStoreSize)) {
            return false;
        }
        MemStoreSize other = (MemStoreSize)obj;
        return this.dataSize == other.dataSize && this.heapSize == other.heapSize && this.offHeapSize == other.offHeapSize && this.cellsCount == other.cellsCount;
    }

    public int hashCode() {
        long h = this.dataSize;
        h = h * 31L + this.heapSize;
        h = h * 31L + this.offHeapSize;
        h = h * 31L + (long)this.cellsCount;
        return (int)h;
    }

    public String toString() {
        return "dataSize=" + this.dataSize + ", getHeapSize=" + this.heapSize + ", getOffHeapSize=" + this.offHeapSize + ", getCellsCount=" + this.cellsCount;
    }
}

