/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.http.client.fluent;

import java.net.URI;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hudi.org.apache.http.HttpVersion;
import org.apache.hudi.org.apache.http.ProtocolVersion;
import org.apache.hudi.org.apache.http.RequestLine;
import org.apache.hudi.org.apache.http.annotation.NotThreadSafe;
import org.apache.hudi.org.apache.http.client.config.RequestConfig;
import org.apache.hudi.org.apache.http.client.methods.Configurable;
import org.apache.hudi.org.apache.http.client.methods.HttpExecutionAware;
import org.apache.hudi.org.apache.http.client.methods.HttpUriRequest;
import org.apache.hudi.org.apache.http.concurrent.Cancellable;
import org.apache.hudi.org.apache.http.message.AbstractHttpMessage;
import org.apache.hudi.org.apache.http.message.BasicRequestLine;
import org.apache.hudi.org.apache.http.util.Args;

@NotThreadSafe
class InternalHttpRequest
extends AbstractHttpMessage
implements HttpUriRequest,
HttpExecutionAware,
Configurable {
    private final String method;
    private ProtocolVersion version;
    private URI uri;
    private RequestConfig config;
    private final AtomicBoolean aborted;
    private final AtomicReference<Cancellable> cancellableRef;

    InternalHttpRequest(String method, URI requestURI) {
        Args.notBlank(method, "Method");
        Args.notNull(requestURI, "Request URI");
        this.method = method;
        this.uri = requestURI;
        this.aborted = new AtomicBoolean(false);
        this.cancellableRef = new AtomicReference<Object>(null);
    }

    public void setProtocolVersion(ProtocolVersion version) {
        this.version = version;
    }

    @Override
    public ProtocolVersion getProtocolVersion() {
        return this.version != null ? this.version : HttpVersion.HTTP_1_1;
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public void abort() throws UnsupportedOperationException {
        Cancellable cancellable;
        if (this.aborted.compareAndSet(false, true) && (cancellable = (Cancellable)this.cancellableRef.getAndSet(null)) != null) {
            cancellable.cancel();
        }
    }

    @Override
    public boolean isAborted() {
        return this.aborted.get();
    }

    @Override
    public void setCancellable(Cancellable cancellable) {
        if (!this.aborted.get()) {
            this.cancellableRef.set(cancellable);
        }
    }

    @Override
    public RequestLine getRequestLine() {
        ProtocolVersion ver = this.getProtocolVersion();
        URI uriCopy = this.getURI();
        String uritext = null;
        if (uriCopy != null) {
            uritext = uriCopy.toASCIIString();
        }
        if (uritext == null || uritext.isEmpty()) {
            uritext = "/";
        }
        return new BasicRequestLine(this.getMethod(), uritext, ver);
    }

    @Override
    public RequestConfig getConfig() {
        return this.config;
    }

    public void setConfig(RequestConfig config) {
        this.config = config;
    }

    public void setURI(URI uri2) {
        this.uri = uri2;
    }

    public String toString() {
        return this.getMethod() + " " + this.getURI() + " " + this.getProtocolVersion();
    }
}

