/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.openjdk.jol.heap;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.apache.hudi.org.openjdk.jol.heap.HeapDumpException;
import org.apache.hudi.org.openjdk.jol.info.ClassData;
import org.apache.hudi.org.openjdk.jol.info.FieldData;
import org.apache.hudi.org.openjdk.jol.util.Multiset;

public class HeapDumpReader {
    private final InputStream is;
    private final Map<Long, String> strings;
    private final Map<Long, String> classNames;
    private final Multiset<ClassData> classCounts;
    private final Map<Long, ClassData> classDatas;
    private final File file;
    private int idSize;
    private long readBytes;
    private final byte[] buf;
    private final ByteBuffer wrapBuf;
    private String header;

    public HeapDumpReader(File file) throws IOException {
        this.file = file;
        this.is = file.getName().endsWith(".gz") ? new BufferedInputStream(new GZIPInputStream(new FileInputStream(file)), 0x1000000) : new BufferedInputStream(new FileInputStream(file), 0x1000000);
        this.strings = new HashMap<Long, String>();
        this.classNames = new HashMap<Long, String>();
        this.classCounts = new Multiset();
        this.classDatas = new HashMap<Long, ClassData>();
        this.buf = new byte[32768];
        this.wrapBuf = ByteBuffer.wrap(this.buf);
    }

    private int read() throws HeapDumpException {
        try {
            int v = this.is.read();
            if (v != -1) {
                ++this.readBytes;
                return v;
            }
            throw new HeapDumpException(this.errorMessage("EOF"));
        }
        catch (IOException e) {
            throw new HeapDumpException(this.errorMessage(e.getMessage()));
        }
    }

    private int read(byte[] b, int size) throws HeapDumpException {
        try {
            int read = this.is.read(b, 0, size);
            this.readBytes += (long)read;
            return read;
        }
        catch (IOException e) {
            throw new HeapDumpException(this.errorMessage(e.getMessage()));
        }
    }

    public Multiset<ClassData> parse() throws IOException, HeapDumpException {
        block9: {
            long len;
            long lastCount;
            this.header = this.readNullTerminated();
            this.idSize = (int)this.read_U4();
            this.read_U4();
            this.read_U4();
            block7: do {
                int tag;
                try {
                    tag = this.read_U1();
                }
                catch (HeapDumpException e) {
                    break block9;
                }
                this.read_U4();
                len = this.read_U4();
                lastCount = this.readBytes;
                switch (tag) {
                    case 1: {
                        long id = this.read_ID();
                        String s = this.readString(len - (long)this.idSize);
                        this.strings.put(id, s);
                        break;
                    }
                    case 2: {
                        this.read_U4();
                        long id = this.read_ID();
                        this.read_U4();
                        long nameID = this.read_ID();
                        this.classNames.put(id, this.strings.get(nameID));
                        break;
                    }
                    case 12: 
                    case 28: {
                        while (this.readBytes - lastCount < len) {
                            this.digestHeapDump();
                        }
                        continue block7;
                    }
                    default: {
                        this.read_null(len);
                    }
                }
            } while (this.readBytes - lastCount == len);
            throw new HeapDumpException(this.errorMessage("Expected to read " + len + " bytes, but read " + (this.readBytes - lastCount) + " bytes"));
        }
        return this.classCounts;
    }

    private void digestHeapDump() throws HeapDumpException {
        int subTag = this.read_U1();
        switch (subTag) {
            case 1: {
                this.read_ID();
                this.read_ID();
                return;
            }
            case 2: {
                this.read_ID();
                this.read_U4();
                this.read_U4();
                return;
            }
            case 3: {
                this.read_ID();
                this.read_U4();
                this.read_U4();
                return;
            }
            case 4: {
                this.read_ID();
                this.read_U4();
                return;
            }
            case 5: {
                this.read_ID();
                return;
            }
            case 6: {
                this.read_ID();
                this.read_U4();
                return;
            }
            case 7: {
                this.read_ID();
                return;
            }
            case 8: {
                this.read_ID();
                this.read_U4();
                this.read_U4();
                return;
            }
            case 32: {
                this.digestClass();
                return;
            }
            case 33: {
                this.digestInstance();
                return;
            }
            case 34: {
                this.digestObjArray();
                return;
            }
            case 35: {
                this.digestPrimArray();
                return;
            }
        }
        throw new HeapDumpException(this.errorMessage(String.format("Unknown heap dump subtag 0x%x", subTag)));
    }

    private void digestPrimArray() throws HeapDumpException {
        long id = this.read_ID();
        this.read_U4();
        int elements = (int)this.read_U4();
        int typeClass = this.read_U1();
        int len = elements * this.getSize(typeClass);
        byte[] bytes = this.read_contents(len);
        String typeString = this.getTypeString(typeClass);
        this.classCounts.add(new ClassData(typeString + "[]", typeString, elements));
        this.visitPrimArray(id, typeString, elements, bytes);
    }

    private void digestObjArray() throws HeapDumpException {
        this.read_ID();
        this.read_U4();
        int elements = (int)this.read_U4();
        this.read_ID();
        this.read_null((long)elements * (long)this.idSize);
        this.classCounts.add(new ClassData("Object[]", "Object", elements));
    }

    private void digestInstance() throws HeapDumpException {
        long id = this.read_ID();
        this.read_U4();
        long klassID = this.read_ID();
        this.classCounts.add(this.classDatas.get(klassID));
        int instanceBytes = (int)this.read_U4();
        byte[] bytes = this.read_contents(instanceBytes);
        this.visitInstance(id, klassID, bytes);
    }

    private void digestClass() throws HeapDumpException {
        long klassID = this.read_ID();
        String name = this.classNames.get(klassID);
        ClassData cd = new ClassData(name);
        cd.addSuperClass(name);
        this.read_U4();
        long superKlassID = this.read_ID();
        ClassData superCd = this.classDatas.get(superKlassID);
        if (superCd != null) {
            cd.merge(superCd);
        }
        this.read_ID();
        this.read_ID();
        this.read_ID();
        this.read_ID();
        this.read_ID();
        this.read_U4();
        int cpCount = this.read_U2();
        for (int c = 0; c < cpCount; ++c) {
            this.read_U2();
            int type = this.read_U1();
            this.readValue(type);
        }
        int cpStatics = this.read_U2();
        for (int c = 0; c < cpStatics; ++c) {
            this.read_ID();
            int type = this.read_U1();
            this.readValue(type);
        }
        int offset = 0;
        ArrayList<Integer> oopIdx = new ArrayList<Integer>();
        int cpInstance = this.read_U2();
        for (int c = 0; c < cpInstance; ++c) {
            long index = this.read_ID();
            int type = this.read_U1();
            cd.addField(FieldData.create(name, this.strings.get(index), this.getTypeString(type)));
            if (type == 2) {
                oopIdx.add(offset);
            }
            offset += this.getSize(type);
        }
        this.classDatas.put(klassID, cd);
        this.visitClass(klassID, name, oopIdx, this.idSize);
    }

    private long readValue(int type) throws HeapDumpException {
        switch (type) {
            case 2: {
                if (this.idSize == 4) {
                    return this.read_U4();
                }
                if (this.idSize == 8) {
                    return this.read_U8();
                }
                throw new HeapDumpException("Illegal ID size");
            }
            case 4: 
            case 8: {
                return (byte)this.read_U1();
            }
            case 5: 
            case 9: {
                return (short)this.read_U2();
            }
            case 6: 
            case 10: {
                return (int)this.read_U4();
            }
            case 7: 
            case 11: {
                return this.read_U8();
            }
        }
        throw new HeapDumpException("Unknown type: " + type);
    }

    private int getSize(int type) throws HeapDumpException {
        switch (type) {
            case 2: {
                if (this.idSize == 4) {
                    return 4;
                }
                if (this.idSize == 8) {
                    return 8;
                }
                throw new HeapDumpException("Illegal ID size");
            }
            case 4: 
            case 8: {
                return 1;
            }
            case 5: 
            case 9: {
                return 2;
            }
            case 6: 
            case 10: {
                return 4;
            }
            case 7: 
            case 11: {
                return 8;
            }
        }
        throw new HeapDumpException("Unknown type: " + type);
    }

    private String getTypeString(int type) throws HeapDumpException {
        switch (type) {
            case 2: {
                return "Object";
            }
            case 4: {
                return "boolean";
            }
            case 8: {
                return "byte";
            }
            case 9: {
                return "short";
            }
            case 5: {
                return "char";
            }
            case 10: {
                return "int";
            }
            case 6: {
                return "float";
            }
            case 7: {
                return "double";
            }
            case 11: {
                return "long";
            }
        }
        throw new HeapDumpException("Unknown type: " + type);
    }

    private long read_ID() throws HeapDumpException {
        int read = this.read(this.buf, this.idSize);
        if (read == 4) {
            return (long)this.wrapBuf.getInt(0) & 0xFFFFFFFFL;
        }
        if (read == 8) {
            return this.wrapBuf.getLong(0);
        }
        throw new HeapDumpException("Unable to read " + this.idSize + " bytes");
    }

    byte[] read_null(long len) throws HeapDumpException {
        int toRead;
        int read;
        long rem = len;
        while ((rem -= (long)(read = this.read(this.buf, toRead = (int)Math.min((long)this.buf.length, rem)))) > 0L) {
        }
        return new byte[0];
    }

    byte[] read_contents(long len) throws HeapDumpException {
        int read;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        long rem = len;
        do {
            int toRead = (int)Math.min((long)this.buf.length, rem);
            read = this.read(this.buf, toRead);
            bos.write(this.buf, 0, read);
        } while ((rem -= (long)read) > 0L);
        return bos.toByteArray();
    }

    String readNullTerminated() throws HeapDumpException {
        int r;
        StringBuilder sb = new StringBuilder();
        while ((r = this.read()) != -1 && r != 0) {
            sb.append((char)(r & 0xFF));
        }
        return sb.toString();
    }

    String readString(long len) throws HeapDumpException {
        int r;
        StringBuilder sb = new StringBuilder();
        for (long l = 0L; l < len && (r = this.read()) != -1; ++l) {
            sb.append((char)(r & 0xFF));
        }
        return sb.toString();
    }

    long read_U8() throws HeapDumpException {
        int read = this.read(this.buf, 8);
        if (read == 8) {
            return this.wrapBuf.getLong(0);
        }
        throw new HeapDumpException(this.errorMessage("Unable to read 8 bytes"));
    }

    long read_U4() throws HeapDumpException {
        int read = this.read(this.buf, 4);
        if (read == 4) {
            return (long)this.wrapBuf.getInt(0) & 0xFFFFFFFFL;
        }
        throw new HeapDumpException(this.errorMessage("Unable to read 4 bytes"));
    }

    int read_U2() throws HeapDumpException {
        int read = this.read(this.buf, 2);
        if (read == 2) {
            return this.wrapBuf.getShort(0) & 0xFFFF;
        }
        throw new HeapDumpException(this.errorMessage("Unable to read 2 bytes"));
    }

    int read_U1() throws HeapDumpException {
        int read = this.read(this.buf, 1);
        if (read == 1) {
            return this.wrapBuf.get(0) & 0xFF;
        }
        throw new HeapDumpException(this.errorMessage("Unable to read 1 bytes"));
    }

    private String errorMessage(String message) throws HeapDumpException {
        return String.format("%s at offset 0x%x in %s (%s)", message, this.readBytes, this.file, this.header);
    }

    protected void visitInstance(long id, long klassID, byte[] bytes) {
    }

    protected void visitClass(long id, String name, List<Integer> oopIdx, int oopSize) {
    }

    protected void visitPrimArray(long id, String componentType, int count, byte[] bytes) {
    }
}

