/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.storage;

import java.io.Serializable;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;

public abstract class StorageConfiguration<T>
implements Serializable {
    public abstract StorageConfiguration<T> newInstance();

    public abstract T unwrap();

    public abstract T unwrapCopy();

    public abstract void set(String var1, String var2);

    public abstract Option<String> getString(String var1);

    public abstract StorageConfiguration<T> getInline();

    public final <U> U unwrapAs(Class<U> clazz) {
        return StorageConfiguration.castConfiguration(this.unwrap(), clazz);
    }

    public final <U> U unwrapCopyAs(Class<U> clazz) {
        return StorageConfiguration.castConfiguration(this.unwrapCopy(), clazz);
    }

    public final String getString(String key, String defaultValue) {
        Option<String> value = this.getString(key);
        return value.isPresent() ? value.get() : defaultValue;
    }

    public final boolean getBoolean(String key, boolean defaultValue) {
        Option<String> value = this.getString(key);
        return value.isPresent() ? (!StringUtils.isNullOrEmpty(value.get()) ? Boolean.parseBoolean(value.get()) : defaultValue) : defaultValue;
    }

    public final long getLong(String key, long defaultValue) {
        Option<String> value = this.getString(key);
        return value.isPresent() ? Long.parseLong(value.get()) : defaultValue;
    }

    public <T extends Enum<T>> T getEnum(String key, T defaultValue) {
        Option<String> value = this.getString(key);
        return value.isPresent() ? Enum.valueOf(defaultValue.getDeclaringClass(), value.get()) : defaultValue;
    }

    public final void setIfUnset(String key, String value) {
        if (this.getString(key).isEmpty()) {
            this.set(key, value);
        }
    }

    public static <U> U castConfiguration(Object conf, Class<U> clazz) {
        ValidationUtils.checkArgument(clazz.isAssignableFrom(conf.getClass()), "Cannot cast the underlying configuration to type " + clazz);
        return (U)conf;
    }
}

