/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security.authentication;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.WriteListener;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoggedOutAuthentication;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.security.UserAuthentication;
import org.eclipse.jetty.security.authentication.LoginAuthenticator;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class DeferredAuthentication
implements Authentication.Deferred {
    private static final Logger LOG = Log.getLogger(DeferredAuthentication.class);
    protected final LoginAuthenticator _authenticator;
    private Object _previousAssociation;
    static final HttpServletResponse __deferredResponse = new HttpServletResponse(){

        public void addCookie(Cookie cookie) {
        }

        public void addDateHeader(String name, long date) {
        }

        public void addHeader(String name, String value) {
        }

        public void addIntHeader(String name, int value) {
        }

        public boolean containsHeader(String name) {
            return false;
        }

        public String encodeRedirectURL(String url2) {
            return null;
        }

        public String encodeRedirectUrl(String url2) {
            return null;
        }

        public String encodeURL(String url2) {
            return null;
        }

        public String encodeUrl(String url2) {
            return null;
        }

        public void sendError(int sc) throws IOException {
        }

        public void sendError(int sc, String msg) throws IOException {
        }

        public void sendRedirect(String location) throws IOException {
        }

        public void setDateHeader(String name, long date) {
        }

        public void setHeader(String name, String value) {
        }

        public void setIntHeader(String name, int value) {
        }

        public void setStatus(int sc) {
        }

        public void setStatus(int sc, String sm) {
        }

        public void flushBuffer() throws IOException {
        }

        public int getBufferSize() {
            return 1024;
        }

        public String getCharacterEncoding() {
            return null;
        }

        public String getContentType() {
            return null;
        }

        public Locale getLocale() {
            return null;
        }

        public ServletOutputStream getOutputStream() throws IOException {
            return __nullOut;
        }

        public PrintWriter getWriter() throws IOException {
            return IO.getNullPrintWriter();
        }

        public boolean isCommitted() {
            return true;
        }

        public void reset() {
        }

        public void resetBuffer() {
        }

        public void setBufferSize(int size) {
        }

        public void setCharacterEncoding(String charset) {
        }

        public void setContentLength(int len) {
        }

        public void setContentLengthLong(long len) {
        }

        public void setContentType(String type) {
        }

        public void setLocale(Locale loc) {
        }

        public Collection<String> getHeaderNames() {
            return Collections.emptyList();
        }

        public String getHeader(String arg0) {
            return null;
        }

        public Collection<String> getHeaders(String arg0) {
            return Collections.emptyList();
        }

        public int getStatus() {
            return 0;
        }
    };
    private static ServletOutputStream __nullOut = new ServletOutputStream(){

        public void write(int b) throws IOException {
        }

        public void print(String s) throws IOException {
        }

        public void println(String s) throws IOException {
        }

        public void setWriteListener(WriteListener writeListener) {
        }

        public boolean isReady() {
            return false;
        }
    };

    public DeferredAuthentication(LoginAuthenticator authenticator) {
        if (authenticator == null) {
            throw new NullPointerException("No Authenticator");
        }
        this._authenticator = authenticator;
    }

    @Override
    public Authentication authenticate(ServletRequest request) {
        try {
            Authentication authentication = this._authenticator.validateRequest(request, (ServletResponse)__deferredResponse, true);
            if (authentication != null && authentication instanceof Authentication.User && !(authentication instanceof Authentication.ResponseSent)) {
                LoginService loginService = this._authenticator.getLoginService();
                IdentityService identityService = loginService.getIdentityService();
                if (identityService != null) {
                    this._previousAssociation = identityService.associate(((Authentication.User)authentication).getUserIdentity());
                }
                return authentication;
            }
        }
        catch (ServerAuthException e) {
            LOG.debug(e);
        }
        return this;
    }

    @Override
    public Authentication authenticate(ServletRequest request, ServletResponse response) {
        try {
            LoginService loginService = this._authenticator.getLoginService();
            IdentityService identityService = loginService.getIdentityService();
            Authentication authentication = this._authenticator.validateRequest(request, response, true);
            if (authentication instanceof Authentication.User && identityService != null) {
                this._previousAssociation = identityService.associate(((Authentication.User)authentication).getUserIdentity());
            }
            return authentication;
        }
        catch (ServerAuthException e) {
            LOG.debug(e);
            return this;
        }
    }

    @Override
    public Authentication login(String username, Object password, ServletRequest request) {
        if (username == null) {
            return null;
        }
        UserIdentity identity = this._authenticator.login(username, password, request);
        if (identity != null) {
            IdentityService identityService = this._authenticator.getLoginService().getIdentityService();
            UserAuthentication authentication = new UserAuthentication("API", identity);
            if (identityService != null) {
                this._previousAssociation = identityService.associate(identity);
            }
            return authentication;
        }
        return null;
    }

    @Override
    public Authentication logout(ServletRequest request) {
        SecurityHandler security = SecurityHandler.getCurrentSecurityHandler();
        if (security != null) {
            security.logout(null);
            if (this._authenticator instanceof LoginAuthenticator) {
                this._authenticator.logout(request);
                return new LoggedOutAuthentication(this._authenticator);
            }
        }
        return Authentication.UNAUTHENTICATED;
    }

    public Object getPreviousAssociation() {
        return this._previousAssociation;
    }

    public static boolean isDeferred(HttpServletResponse response) {
        return response == __deferredResponse;
    }
}

