/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.timeline.service.handlers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.common.table.timeline.dto.BaseFileDTO;
import org.apache.hudi.common.table.view.FileSystemViewManager;
import org.apache.hudi.timeline.service.TimelineService;
import org.apache.hudi.timeline.service.handlers.Handler;

public class BaseFileHandler
extends Handler {
    public BaseFileHandler(Configuration conf, TimelineService.Config timelineServiceConfig, FileSystem fileSystem, FileSystemViewManager viewManager) throws IOException {
        super(conf, timelineServiceConfig, fileSystem, viewManager);
    }

    public List<BaseFileDTO> getLatestDataFiles(String basePath, String partitionPath) {
        return this.viewManager.getFileSystemView(basePath).getLatestBaseFiles(partitionPath).map(BaseFileDTO::fromHoodieBaseFile).collect(Collectors.toList());
    }

    public List<BaseFileDTO> getLatestDataFile(String basePath, String partitionPath, String fileId) {
        return (List)this.viewManager.getFileSystemView(basePath).getLatestBaseFile(partitionPath, fileId).map(BaseFileDTO::fromHoodieBaseFile).map(xva$0 -> Arrays.asList(xva$0)).orElse(new ArrayList());
    }

    public List<BaseFileDTO> getLatestDataFiles(String basePath) {
        return this.viewManager.getFileSystemView(basePath).getLatestBaseFiles().map(BaseFileDTO::fromHoodieBaseFile).collect(Collectors.toList());
    }

    public List<BaseFileDTO> getLatestDataFilesBeforeOrOn(String basePath, String partitionPath, String maxInstantTime) {
        return this.viewManager.getFileSystemView(basePath).getLatestBaseFilesBeforeOrOn(partitionPath, maxInstantTime).map(BaseFileDTO::fromHoodieBaseFile).collect(Collectors.toList());
    }

    public List<BaseFileDTO> getLatestDataFileOn(String basePath, String partitionPath, String instantTime, String fileId) {
        ArrayList<BaseFileDTO> result = new ArrayList<BaseFileDTO>();
        this.viewManager.getFileSystemView(basePath).getBaseFileOn(partitionPath, instantTime, fileId).map(BaseFileDTO::fromHoodieBaseFile).ifPresent(result::add);
        return result;
    }

    public List<BaseFileDTO> getLatestDataFilesInRange(String basePath, List<String> instants) {
        return this.viewManager.getFileSystemView(basePath).getLatestBaseFilesInRange(instants).map(BaseFileDTO::fromHoodieBaseFile).collect(Collectors.toList());
    }

    public List<BaseFileDTO> getAllDataFiles(String basePath, String partitionPath) {
        return this.viewManager.getFileSystemView(basePath).getAllBaseFiles(partitionPath).map(BaseFileDTO::fromHoodieBaseFile).collect(Collectors.toList());
    }
}

