/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.timeline.service.handlers.marker;

import java.util.List;
import org.apache.hudi.common.util.HoodieTimer;
import org.apache.hudi.timeline.service.handlers.marker.BatchedMarkerCreationContext;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class BatchedMarkerCreationRunnable
implements Runnable {
    private static final Logger LOG = LogManager.getLogger(BatchedMarkerCreationRunnable.class);
    private final List<BatchedMarkerCreationContext> requestContextList;

    public BatchedMarkerCreationRunnable(List<BatchedMarkerCreationContext> requestContextList) {
        this.requestContextList = requestContextList;
    }

    @Override
    public void run() {
        LOG.debug((Object)"Start processing create marker requests");
        HoodieTimer timer = new HoodieTimer().startTimer();
        for (BatchedMarkerCreationContext requestContext : this.requestContextList) {
            requestContext.getMarkerDirState().processMarkerCreationRequests(requestContext.getFutures(), requestContext.getFileIndex());
        }
        LOG.debug((Object)("Finish batch processing of create marker requests in " + timer.endTimer() + " ms"));
    }
}

