/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.timeline.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.afterburner.AfterburnerModule;
import io.javalin.Javalin;
import io.javalin.http.BadRequestResponse;
import io.javalin.http.Context;
import io.javalin.http.Handler;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.metrics.Registry;
import org.apache.hudi.common.table.marker.MarkerOperation;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.dto.BaseFileDTO;
import org.apache.hudi.common.table.timeline.dto.ClusteringOpDTO;
import org.apache.hudi.common.table.timeline.dto.CompactionOpDTO;
import org.apache.hudi.common.table.timeline.dto.FileGroupDTO;
import org.apache.hudi.common.table.timeline.dto.FileSliceDTO;
import org.apache.hudi.common.table.timeline.dto.InstantDTO;
import org.apache.hudi.common.table.timeline.dto.InstantStateDTO;
import org.apache.hudi.common.table.timeline.dto.TimelineDTO;
import org.apache.hudi.common.table.view.FileSystemViewManager;
import org.apache.hudi.common.table.view.RemoteHoodieTableFileSystemView;
import org.apache.hudi.common.table.view.SyncableFileSystemView;
import org.apache.hudi.common.util.HoodieTimer;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.timeline.service.TimelineService;
import org.apache.hudi.timeline.service.handlers.BaseFileHandler;
import org.apache.hudi.timeline.service.handlers.FileSliceHandler;
import org.apache.hudi.timeline.service.handlers.InstantStateHandler;
import org.apache.hudi.timeline.service.handlers.MarkerHandler;
import org.apache.hudi.timeline.service.handlers.TimelineHandler;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestHandler {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().registerModule((Module)new AfterburnerModule());
    private static final Logger LOG = LoggerFactory.getLogger(RequestHandler.class);
    private static final TypeReference<List<String>> LIST_TYPE_REFERENCE = new TypeReference<List<String>>(){};
    private final TimelineService.Config timelineServiceConfig;
    private final FileSystemViewManager viewManager;
    private final Javalin app;
    private final TimelineHandler instantHandler;
    private final FileSliceHandler sliceHandler;
    private final BaseFileHandler dataFileHandler;
    private final MarkerHandler markerHandler;
    private final InstantStateHandler instantStateHandler;
    private final Registry metricsRegistry = Registry.getRegistry((String)"TimelineService");
    private final ScheduledExecutorService asyncResultService;

    public RequestHandler(Javalin app, StorageConfiguration<?> conf, TimelineService.Config timelineServiceConfig, HoodieEngineContext hoodieEngineContext, HoodieStorage storage, FileSystemViewManager viewManager) throws IOException {
        this.timelineServiceConfig = timelineServiceConfig;
        this.viewManager = viewManager;
        this.app = app;
        this.instantHandler = new TimelineHandler(conf, timelineServiceConfig, storage, viewManager);
        this.sliceHandler = new FileSliceHandler(conf, timelineServiceConfig, storage, viewManager);
        this.dataFileHandler = new BaseFileHandler(conf, timelineServiceConfig, storage, viewManager);
        this.markerHandler = timelineServiceConfig.enableMarkerRequests ? new MarkerHandler(conf, timelineServiceConfig, hoodieEngineContext, storage, viewManager, this.metricsRegistry) : null;
        this.instantStateHandler = timelineServiceConfig.enableInstantStateRequests ? new InstantStateHandler(conf, timelineServiceConfig, storage, viewManager) : null;
        this.asyncResultService = timelineServiceConfig.async ? Executors.newSingleThreadScheduledExecutor() : null;
    }

    public static String jsonifyResult(Context ctx, Object obj, Registry metricsRegistry, ObjectMapper objectMapper, Logger logger) throws JsonProcessingException {
        HoodieTimer timer = HoodieTimer.start();
        boolean prettyPrint = ctx.queryParam("pretty") != null;
        String result = prettyPrint ? objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(obj) : objectMapper.writeValueAsString(obj);
        long jsonifyTime = timer.endTimer();
        metricsRegistry.add("WRITE_VALUE_CNT", 1L);
        metricsRegistry.add("WRITE_VALUE_TIME", jsonifyTime);
        if (logger.isDebugEnabled()) {
            logger.debug("Jsonify TimeTaken={}", (Object)jsonifyTime);
        }
        return result;
    }

    private static String getBasePathParam(Context ctx) {
        return (String)ctx.queryParamAsClass("basepath", String.class).getOrThrow(e -> new HoodieException("Basepath is invalid"));
    }

    private static String getPartitionParam(Context ctx) {
        return (String)ctx.queryParamAsClass("partition", String.class).getOrDefault((Object)"");
    }

    private static String getFileIdParam(Context ctx) {
        return (String)ctx.queryParamAsClass("fileid", String.class).getOrThrow(e -> new HoodieException("FILEID is invalid"));
    }

    private static List<String> getInstantsParam(Context ctx) {
        return Arrays.asList(((String)ctx.queryParamAsClass("instants", String.class).getOrThrow(e -> new HoodieException("INSTANTS_PARAM is invalid"))).split(","));
    }

    private static String getMaxInstantParamMandatory(Context ctx) {
        return (String)ctx.queryParamAsClass("maxinstant", String.class).getOrThrow(e -> new HoodieException("MAX_INSTANT_PARAM is invalid"));
    }

    private static String getMaxInstantParamOptional(Context ctx) {
        return (String)ctx.queryParamAsClass("maxinstant", String.class).getOrDefault((Object)"");
    }

    private static String getMinInstantParam(Context ctx) {
        return (String)ctx.queryParamAsClass("mininstant", String.class).getOrDefault((Object)"");
    }

    private static String getMarkerDirParam(Context ctx) {
        return (String)ctx.queryParamAsClass("markerdirpath", String.class).getOrDefault((Object)"");
    }

    private static boolean getIncludeFilesInPendingCompactionParam(Context ctx) {
        return Boolean.parseBoolean((String)ctx.queryParamAsClass("includependingcompaction", String.class).getOrThrow(e -> new HoodieException("INCLUDE_FILES_IN_PENDING_COMPACTION_PARAM is invalid")));
    }

    private static String getInstantStateDirPathParam(Context ctx) {
        return ctx.queryParam("instantstatedirpath");
    }

    public void register() {
        this.registerDataFilesAPI();
        this.registerFileSlicesAPI();
        this.registerTimelineAPI();
        if (this.markerHandler != null) {
            this.registerMarkerAPI();
        }
        if (this.instantStateHandler != null) {
            this.registerInstantStateAPI();
        }
    }

    public void stop() {
        if (this.markerHandler != null) {
            this.markerHandler.stop();
        }
        if (this.asyncResultService != null) {
            this.asyncResultService.shutdown();
        }
    }

    private void writeValueAsString(Context ctx, Object obj) throws JsonProcessingException {
        if (this.timelineServiceConfig.async) {
            this.writeValueAsStringAsync(ctx, obj);
        } else {
            this.writeValueAsStringSync(ctx, obj);
        }
    }

    private void writeValueAsStringSync(Context ctx, Object obj) throws JsonProcessingException {
        String result = RequestHandler.jsonifyResult(ctx, obj, this.metricsRegistry, OBJECT_MAPPER, LOG);
        ctx.result(result);
    }

    private void writeValueAsStringAsync(Context ctx, Object obj) {
        ctx.future(CompletableFuture.supplyAsync(() -> {
            try {
                return RequestHandler.jsonifyResult(ctx, obj, this.metricsRegistry, OBJECT_MAPPER, LOG);
            }
            catch (JsonProcessingException e) {
                throw new HoodieException("Failed to JSON encode the value", (Throwable)e);
            }
        }, this.asyncResultService));
    }

    private void registerTimelineAPI() {
        this.app.get(RemoteHoodieTableFileSystemView.LAST_INSTANT_URL, (Handler)new ViewHandler(ctx -> {
            this.metricsRegistry.add("LAST_INSTANT", 1L);
            List<InstantDTO> dtos = this.instantHandler.getLastInstant(RequestHandler.getBasePathParam(ctx));
            this.writeValueAsString(ctx, dtos);
        }, false));
        this.app.get(RemoteHoodieTableFileSystemView.TIMELINE_URL, (Handler)new ViewHandler(ctx -> {
            this.metricsRegistry.add("TIMELINE", 1L);
            TimelineDTO dto = this.instantHandler.getTimeline(RequestHandler.getBasePathParam(ctx));
            this.writeValueAsString(ctx, dto);
        }, false));
    }

    private void registerDataFilesAPI() {
        this.app.get(RemoteHoodieTableFileSystemView.LATEST_PARTITION_DATA_FILES_URL, (Handler)new ViewHandler(ctx -> {
            this.metricsRegistry.add("LATEST_PARTITION_DATA_FILES", 1L);
            List<BaseFileDTO> dtos = this.dataFileHandler.getLatestDataFiles(RequestHandler.getBasePathParam(ctx), RequestHandler.getPartitionParam(ctx));
            this.writeValueAsString(ctx, dtos);
        }, true));
        this.app.get(RemoteHoodieTableFileSystemView.LATEST_PARTITION_DATA_FILE_URL, (Handler)new ViewHandler(ctx -> {
            this.metricsRegistry.add("LATEST_PARTITION_DATA_FILE", 1L);
            List<BaseFileDTO> dtos = this.dataFileHandler.getLatestDataFile(RequestHandler.getBasePathParam(ctx), RequestHandler.getPartitionParam(ctx), RequestHandler.getFileIdParam(ctx));
            this.writeValueAsString(ctx, dtos);
        }, true));
        this.app.get(RemoteHoodieTableFileSystemView.LATEST_ALL_DATA_FILES_URL, (Handler)new ViewHandler(ctx -> {
            this.metricsRegistry.add("LATEST_ALL_DATA_FILES", 1L);
            List<BaseFileDTO> dtos = this.dataFileHandler.getLatestDataFiles(RequestHandler.getBasePathParam(ctx));
            this.writeValueAsString(ctx, dtos);
        }, true));
        this.app.get(RemoteHoodieTableFileSystemView.LATEST_DATA_FILES_BEFORE_ON_INSTANT_URL, (Handler)new ViewHandler(ctx -> {
            this.metricsRegistry.add("LATEST_DATA_FILES_BEFORE_ON_INSTANT", 1L);
            List<BaseFileDTO> dtos = this.dataFileHandler.getLatestDataFilesBeforeOrOn(RequestHandler.getBasePathParam(ctx), RequestHandler.getPartitionParam(ctx), RequestHandler.getMaxInstantParamMandatory(ctx));
            this.writeValueAsString(ctx, dtos);
        }, true));
        this.app.get(RemoteHoodieTableFileSystemView.ALL_LATEST_BASE_FILES_BEFORE_ON_INSTANT_URL, (Handler)new ViewHandler(ctx -> {
            this.metricsRegistry.add("ALL_LATEST_BASE_FILES_BEFORE_ON_INSTANT", 1L);
            Map<String, List<BaseFileDTO>> dtos = this.dataFileHandler.getAllLatestDataFilesBeforeOrOn(RequestHandler.getBasePathParam(ctx), RequestHandler.getMaxInstantParamMandatory(ctx));
            this.writeValueAsString(ctx, dtos);
        }, true));
        this.app.get(RemoteHoodieTableFileSystemView.LATEST_DATA_FILE_ON_INSTANT_URL, (Handler)new ViewHandler(ctx -> {
            this.metricsRegistry.add("LATEST_DATA_FILE_ON_INSTANT", 1L);
            List<BaseFileDTO> dtos = this.dataFileHandler.getLatestDataFileOn(RequestHandler.getBasePathParam(ctx), RequestHandler.getPartitionParam(ctx), (String)ctx.queryParamAsClass("instant", String.class).get(), RequestHandler.getFileIdParam(ctx));
            this.writeValueAsString(ctx, dtos);
        }, true));
        this.app.get(RemoteHoodieTableFileSystemView.ALL_DATA_FILES_URL, (Handler)new ViewHandler(ctx -> {
            this.metricsRegistry.add("ALL_DATA_FILES", 1L);
            List<BaseFileDTO> dtos = this.dataFileHandler.getAllDataFiles(RequestHandler.getBasePathParam(ctx), RequestHandler.getPartitionParam(ctx));
            this.writeValueAsString(ctx, dtos);
        }, true));
        this.app.get(RemoteHoodieTableFileSystemView.LATEST_DATA_FILES_RANGE_INSTANT_URL, (Handler)new ViewHandler(ctx -> {
            this.metricsRegistry.add("LATEST_DATA_FILES_RANGE_INSTANT", 1L);
            List<BaseFileDTO> dtos = this.dataFileHandler.getLatestDataFilesInRange(RequestHandler.getBasePathParam(ctx), RequestHandler.getInstantsParam(ctx));
            this.writeValueAsString(ctx, dtos);
        }, true));
    }

    private void registerFileSlicesAPI() {
        this.app.get(RemoteHoodieTableFileSystemView.LATEST_PARTITION_SLICES_URL, (Handler)new ViewHandler(ctx -> {
            this.metricsRegistry.add("LATEST_PARTITION_SLICES", 1L);
            List<FileSliceDTO> dtos = this.sliceHandler.getLatestFileSlices(RequestHandler.getBasePathParam(ctx), RequestHandler.getPartitionParam(ctx));
            this.writeValueAsString(ctx, dtos);
        }, true));
        this.app.get(RemoteHoodieTableFileSystemView.LATEST_PARTITION_SLICES_INFLIGHT_URL, (Handler)new ViewHandler(ctx -> {
            this.metricsRegistry.add("LATEST_PARTITION_SLICES_INFLIGHT", 1L);
            List<FileSliceDTO> dtos = this.sliceHandler.getLatestFileSlicesIncludingInflight(RequestHandler.getBasePathParam(ctx), RequestHandler.getPartitionParam(ctx));
            this.writeValueAsString(ctx, dtos);
        }, true));
        this.app.get(RemoteHoodieTableFileSystemView.LATEST_PARTITION_SLICES_STATELESS_URL, (Handler)new ViewHandler(ctx -> {
            this.metricsRegistry.add("LATEST_PARTITION_SLICES_STATELESS", 1L);
            List<FileSliceDTO> dtos = this.sliceHandler.getLatestFileSlicesStateless(RequestHandler.getBasePathParam(ctx), RequestHandler.getPartitionParam(ctx));
            this.writeValueAsString(ctx, dtos);
        }, true));
        this.app.get(RemoteHoodieTableFileSystemView.LATEST_PARTITION_SLICE_URL, (Handler)new ViewHandler(ctx -> {
            this.metricsRegistry.add("LATEST_PARTITION_SLICE", 1L);
            List<FileSliceDTO> dtos = this.sliceHandler.getLatestFileSlice(RequestHandler.getBasePathParam(ctx), RequestHandler.getPartitionParam(ctx), RequestHandler.getFileIdParam(ctx));
            this.writeValueAsString(ctx, dtos);
        }, true));
        this.app.get(RemoteHoodieTableFileSystemView.LATEST_PARTITION_UNCOMPACTED_SLICES_URL, (Handler)new ViewHandler(ctx -> {
            this.metricsRegistry.add("LATEST_PARTITION_UNCOMPACTED_SLICES", 1L);
            List<FileSliceDTO> dtos = this.sliceHandler.getLatestUnCompactedFileSlices(RequestHandler.getBasePathParam(ctx), RequestHandler.getPartitionParam(ctx));
            this.writeValueAsString(ctx, dtos);
        }, true));
        this.app.get(RemoteHoodieTableFileSystemView.ALL_SLICES_URL, (Handler)new ViewHandler(ctx -> {
            this.metricsRegistry.add("ALL_SLICES", 1L);
            List<FileSliceDTO> dtos = this.sliceHandler.getAllFileSlices(RequestHandler.getBasePathParam(ctx), RequestHandler.getPartitionParam(ctx));
            this.writeValueAsString(ctx, dtos);
        }, true));
        this.app.get(RemoteHoodieTableFileSystemView.LATEST_SLICES_RANGE_INSTANT_URL, (Handler)new ViewHandler(ctx -> {
            this.metricsRegistry.add("LATEST_SLICE_RANGE_INSTANT", 1L);
            List<FileSliceDTO> dtos = this.sliceHandler.getLatestFileSliceInRange(RequestHandler.getBasePathParam(ctx), RequestHandler.getInstantsParam(ctx));
            this.writeValueAsString(ctx, dtos);
        }, true));
        this.app.get(RemoteHoodieTableFileSystemView.LATEST_SLICES_MERGED_BEFORE_ON_INSTANT_URL, (Handler)new ViewHandler(ctx -> {
            this.metricsRegistry.add("LATEST_SLICES_MERGED_BEFORE_ON_INSTANT", 1L);
            List<FileSliceDTO> dtos = this.sliceHandler.getLatestMergedFileSlicesBeforeOrOn(RequestHandler.getBasePathParam(ctx), RequestHandler.getPartitionParam(ctx), RequestHandler.getMaxInstantParamMandatory(ctx));
            this.writeValueAsString(ctx, dtos);
        }, true));
        this.app.get(RemoteHoodieTableFileSystemView.LATEST_SLICES_BEFORE_ON_INSTANT_URL, (Handler)new ViewHandler(ctx -> {
            this.metricsRegistry.add("LATEST_SLICES_BEFORE_ON_INSTANT", 1L);
            List<FileSliceDTO> dtos = this.sliceHandler.getLatestFileSlicesBeforeOrOn(RequestHandler.getBasePathParam(ctx), RequestHandler.getPartitionParam(ctx), RequestHandler.getMaxInstantParamMandatory(ctx), RequestHandler.getIncludeFilesInPendingCompactionParam(ctx));
            this.writeValueAsString(ctx, dtos);
        }, true));
        this.app.get(RemoteHoodieTableFileSystemView.ALL_LATEST_SLICES_BEFORE_ON_INSTANT_URL, (Handler)new ViewHandler(ctx -> {
            this.metricsRegistry.add("ALL_LATEST_SLICES_BEFORE_ON_INSTANT", 1L);
            Map<String, List<FileSliceDTO>> dtos = this.sliceHandler.getAllLatestFileSlicesBeforeOrOn(RequestHandler.getBasePathParam(ctx), RequestHandler.getMaxInstantParamMandatory(ctx));
            this.writeValueAsString(ctx, dtos);
        }, true));
        this.app.get(RemoteHoodieTableFileSystemView.PENDING_COMPACTION_OPS_URL, (Handler)new ViewHandler(ctx -> {
            this.metricsRegistry.add("PEDING_COMPACTION_OPS", 1L);
            List<CompactionOpDTO> dtos = this.sliceHandler.getPendingCompactionOperations(RequestHandler.getBasePathParam(ctx));
            this.writeValueAsString(ctx, dtos);
        }, true));
        this.app.get(RemoteHoodieTableFileSystemView.PENDING_LOG_COMPACTION_OPS_URL, (Handler)new ViewHandler(ctx -> {
            this.metricsRegistry.add("PEDING_LOG_COMPACTION_OPS", 1L);
            List<CompactionOpDTO> dtos = this.sliceHandler.getPendingLogCompactionOperations(RequestHandler.getBasePathParam(ctx));
            this.writeValueAsString(ctx, dtos);
        }, true));
        this.app.get(RemoteHoodieTableFileSystemView.ALL_FILEGROUPS_FOR_PARTITION_URL, (Handler)new ViewHandler(ctx -> {
            this.metricsRegistry.add("ALL_FILEGROUPS_FOR_PARTITION", 1L);
            List<FileGroupDTO> dtos = this.sliceHandler.getAllFileGroups(RequestHandler.getBasePathParam(ctx), RequestHandler.getPartitionParam(ctx));
            this.writeValueAsString(ctx, dtos);
        }, true));
        this.app.get(RemoteHoodieTableFileSystemView.ALL_FILEGROUPS_FOR_PARTITION_STATELESS_URL, (Handler)new ViewHandler(ctx -> {
            this.metricsRegistry.add("ALL_FILEGROUPS_FOR_PARTITION_STATELESS", 1L);
            List<FileGroupDTO> dtos = this.sliceHandler.getAllFileGroupsStateless(RequestHandler.getBasePathParam(ctx), RequestHandler.getPartitionParam(ctx));
            this.writeValueAsString(ctx, dtos);
        }, true));
        this.app.post(RemoteHoodieTableFileSystemView.REFRESH_TABLE_URL, (Handler)new ViewHandler(ctx -> {
            this.metricsRegistry.add("REFRESH_TABLE", 1L);
            boolean success = this.sliceHandler.refreshTable(RequestHandler.getBasePathParam(ctx));
            this.writeValueAsString(ctx, success);
        }, false));
        this.app.post(RemoteHoodieTableFileSystemView.LOAD_PARTITIONS_URL, (Handler)new ViewHandler(ctx -> {
            this.metricsRegistry.add("LOAD_PARTITIONS", 1L);
            String basePath = RequestHandler.getBasePathParam(ctx);
            try {
                List partitionPaths = (List)OBJECT_MAPPER.readValue((String)ctx.queryParamAsClass("partitions", String.class).getOrThrow(e -> new HoodieException("Partitions param is invalid")), LIST_TYPE_REFERENCE);
                boolean success = this.sliceHandler.loadPartitions(basePath, partitionPaths);
                this.writeValueAsString(ctx, success);
            }
            catch (IOException e2) {
                throw new HoodieIOException("Failed to parse request parameter", e2);
            }
        }, false));
        this.app.post(RemoteHoodieTableFileSystemView.LOAD_ALL_PARTITIONS_URL, (Handler)new ViewHandler(ctx -> {
            this.metricsRegistry.add("LOAD_ALL_PARTITIONS", 1L);
            boolean success = this.sliceHandler.loadAllPartitions(RequestHandler.getBasePathParam(ctx));
            this.writeValueAsString(ctx, success);
        }, false));
        this.app.get(RemoteHoodieTableFileSystemView.ALL_REPLACED_FILEGROUPS_BEFORE_OR_ON_URL, (Handler)new ViewHandler(ctx -> {
            this.metricsRegistry.add("ALL_REPLACED_FILEGROUPS_BEFORE_OR_ON", 1L);
            List<FileGroupDTO> dtos = this.sliceHandler.getReplacedFileGroupsBeforeOrOn(RequestHandler.getBasePathParam(ctx), RequestHandler.getMaxInstantParamOptional(ctx), RequestHandler.getPartitionParam(ctx));
            this.writeValueAsString(ctx, dtos);
        }, true));
        this.app.get(RemoteHoodieTableFileSystemView.ALL_REPLACED_FILEGROUPS_BEFORE_URL, (Handler)new ViewHandler(ctx -> {
            this.metricsRegistry.add("ALL_REPLACED_FILEGROUPS_BEFORE", 1L);
            List<FileGroupDTO> dtos = this.sliceHandler.getReplacedFileGroupsBefore(RequestHandler.getBasePathParam(ctx), RequestHandler.getMaxInstantParamOptional(ctx), RequestHandler.getPartitionParam(ctx));
            this.writeValueAsString(ctx, dtos);
        }, true));
        this.app.get(RemoteHoodieTableFileSystemView.ALL_REPLACED_FILEGROUPS_AFTER_OR_ON_URL, (Handler)new ViewHandler(ctx -> {
            this.metricsRegistry.add("ALL_REPLACED_FILEGROUPS_AFTER_OR_ON", 1L);
            List<FileGroupDTO> dtos = this.sliceHandler.getReplacedFileGroupsAfterOrOn(RequestHandler.getBasePathParam(ctx), RequestHandler.getMinInstantParam(ctx), RequestHandler.getPartitionParam(ctx));
            this.writeValueAsString(ctx, dtos);
        }, true));
        this.app.get(RemoteHoodieTableFileSystemView.ALL_REPLACED_FILEGROUPS_PARTITION_URL, (Handler)new ViewHandler(ctx -> {
            this.metricsRegistry.add("ALL_REPLACED_FILEGROUPS_PARTITION", 1L);
            List<FileGroupDTO> dtos = this.sliceHandler.getAllReplacedFileGroups(RequestHandler.getBasePathParam(ctx), RequestHandler.getPartitionParam(ctx));
            this.writeValueAsString(ctx, dtos);
        }, true));
        this.app.get(RemoteHoodieTableFileSystemView.PENDING_CLUSTERING_FILEGROUPS_URL, (Handler)new ViewHandler(ctx -> {
            this.metricsRegistry.add("PENDING_CLUSTERING_FILEGROUPS", 1L);
            List<ClusteringOpDTO> dtos = this.sliceHandler.getFileGroupsInPendingClustering(RequestHandler.getBasePathParam(ctx));
            this.writeValueAsString(ctx, dtos);
        }, true));
    }

    private void registerMarkerAPI() {
        this.app.get(MarkerOperation.ALL_MARKERS_URL, (Handler)new ViewHandler(ctx -> {
            this.metricsRegistry.add("ALL_MARKERS", 1L);
            Set<String> markers = this.markerHandler.getAllMarkers(RequestHandler.getMarkerDirParam(ctx));
            this.writeValueAsString(ctx, markers);
        }, false));
        this.app.get(MarkerOperation.CREATE_AND_MERGE_MARKERS_URL, (Handler)new ViewHandler(ctx -> {
            this.metricsRegistry.add("CREATE_AND_MERGE_MARKERS", 1L);
            Set<String> markers = this.markerHandler.getCreateAndMergeMarkers(RequestHandler.getMarkerDirParam(ctx));
            this.writeValueAsString(ctx, markers);
        }, false));
        this.app.get(MarkerOperation.MARKERS_DIR_EXISTS_URL, (Handler)new ViewHandler(ctx -> {
            this.metricsRegistry.add("MARKERS_DIR_EXISTS", 1L);
            boolean exist = this.markerHandler.doesMarkerDirExist(RequestHandler.getMarkerDirParam(ctx));
            this.writeValueAsString(ctx, exist);
        }, false));
        this.app.post(MarkerOperation.CREATE_MARKER_URL, (Handler)new ViewHandler(ctx -> {
            this.metricsRegistry.add("CREATE_MARKER", 1L);
            ctx.future(this.markerHandler.createMarker(ctx, RequestHandler.getMarkerDirParam(ctx), (String)ctx.queryParamAsClass("markername", String.class).getOrDefault((Object)""), (String)ctx.queryParamAsClass("basepath", String.class).getOrDefault((Object)"")));
        }, false));
        this.app.post(MarkerOperation.DELETE_MARKER_DIR_URL, (Handler)new ViewHandler(ctx -> {
            this.metricsRegistry.add("DELETE_MARKER_DIR", 1L);
            boolean success = this.markerHandler.deleteMarkers(RequestHandler.getMarkerDirParam(ctx));
            this.writeValueAsString(ctx, success);
        }, false));
    }

    private void registerInstantStateAPI() {
        this.app.get(InstantStateHandler.ALL_INSTANT_STATE_URL, (Handler)new ViewHandler(ctx -> {
            this.metricsRegistry.add("ALL_INSTANT_STATE", 1L);
            List<InstantStateDTO> instantStates = this.instantStateHandler.getAllInstantStates(RequestHandler.getInstantStateDirPathParam(ctx));
            this.writeValueAsString(ctx, instantStates);
        }, false));
        this.app.post(InstantStateHandler.REFRESH_INSTANT_STATE, (Handler)new ViewHandler(ctx -> {
            this.metricsRegistry.add("REFRESH_INSTANT_STATE", 1L);
            boolean success = this.instantStateHandler.refresh(RequestHandler.getInstantStateDirPathParam(ctx));
            this.writeValueAsString(ctx, success);
        }, false));
    }

    private class ViewHandler
    implements Handler {
        private final Handler handler;
        private final boolean performRefreshCheck;
        private final UserGroupInformation ugi;

        ViewHandler(Handler handler, boolean performRefreshCheck) {
            this.handler = handler;
            this.performRefreshCheck = performRefreshCheck;
            try {
                this.ugi = UserGroupInformation.getCurrentUser();
            }
            catch (Exception e) {
                LOG.warn("Fail to get ugi", (Throwable)e);
                throw new HoodieException((Throwable)e);
            }
        }

        public void handle(@NotNull Context context) throws Exception {
            this.ugi.doAs(() -> {
                long finalCheckTimeTaken;
                long handleTimeTaken;
                long refreshCheckTimeTaken;
                boolean synced;
                long beginTs;
                boolean success;
                block11: {
                    success = true;
                    beginTs = System.currentTimeMillis();
                    synced = false;
                    boolean refreshCheck = this.performRefreshCheck && !this.isRefreshCheckDisabledInQuery(context);
                    refreshCheckTimeTaken = 0L;
                    handleTimeTaken = 0L;
                    finalCheckTimeTaken = 0L;
                    try {
                        if (refreshCheck) {
                            long beginRefreshCheck = System.currentTimeMillis();
                            synced = this.syncIfLocalViewBehind(context);
                            long endRefreshCheck = System.currentTimeMillis();
                            refreshCheckTimeTaken = endRefreshCheck - beginRefreshCheck;
                        }
                        long handleBeginMs = System.currentTimeMillis();
                        this.handler.handle(context);
                        long handleEndMs = System.currentTimeMillis();
                        handleTimeTaken = handleEndMs - handleBeginMs;
                        if (!refreshCheck) break block11;
                        long beginFinalCheck = System.currentTimeMillis();
                        if (this.isLocalViewBehind(context)) {
                            String lastKnownInstantFromClient = this.getLastInstantTsParam(context);
                            String timelineHashFromClient = this.getTimelineHashParam(context);
                            HoodieTimeline localTimeline = RequestHandler.this.viewManager.getFileSystemView(context.queryParam("basepath")).getTimeline();
                            if (this.shouldThrowExceptionIfLocalViewBehind(localTimeline, timelineHashFromClient)) {
                                String errMsg = String.format("Last known instant from client was %s but server has the following timeline %s", lastKnownInstantFromClient, localTimeline.getInstants());
                                throw new BadRequestResponse(errMsg);
                            }
                        }
                        long endFinalCheck = System.currentTimeMillis();
                        finalCheckTimeTaken = endFinalCheck - beginFinalCheck;
                    }
                    catch (RuntimeException re) {
                        try {
                            success = false;
                            if (re instanceof BadRequestResponse) {
                                LOG.warn("Bad request response due to client view behind server view. {}", (Object)re.getMessage());
                            } else {
                                LOG.error(String.format("Got runtime exception servicing request %s", context.queryString()), (Throwable)re);
                            }
                            throw re;
                        }
                        catch (Throwable throwable) {
                            long endTs = System.currentTimeMillis();
                            long timeTakenMillis = endTs - beginTs;
                            RequestHandler.this.metricsRegistry.add("TOTAL_API_TIME", timeTakenMillis);
                            RequestHandler.this.metricsRegistry.add("TOTAL_REFRESH_TIME", refreshCheckTimeTaken);
                            RequestHandler.this.metricsRegistry.add("TOTAL_HANDLE_TIME", handleTimeTaken);
                            RequestHandler.this.metricsRegistry.add("TOTAL_CHECK_TIME", finalCheckTimeTaken);
                            RequestHandler.this.metricsRegistry.add("TOTAL_API_CALLS", 1L);
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("TimeTakenMillis[Total={}, Refresh={}, handle={}, Check={}], Success={}, Query={}, Host={}, synced={}", new Object[]{timeTakenMillis, refreshCheckTimeTaken, handleTimeTaken, finalCheckTimeTaken, success, context.queryString(), context.host(), synced});
                            }
                            throw throwable;
                        }
                    }
                }
                long endTs = System.currentTimeMillis();
                long timeTakenMillis = endTs - beginTs;
                RequestHandler.this.metricsRegistry.add("TOTAL_API_TIME", timeTakenMillis);
                RequestHandler.this.metricsRegistry.add("TOTAL_REFRESH_TIME", refreshCheckTimeTaken);
                RequestHandler.this.metricsRegistry.add("TOTAL_HANDLE_TIME", handleTimeTaken);
                RequestHandler.this.metricsRegistry.add("TOTAL_CHECK_TIME", finalCheckTimeTaken);
                RequestHandler.this.metricsRegistry.add("TOTAL_API_CALLS", 1L);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("TimeTakenMillis[Total={}, Refresh={}, handle={}, Check={}], Success={}, Query={}, Host={}, synced={}", new Object[]{timeTakenMillis, refreshCheckTimeTaken, handleTimeTaken, finalCheckTimeTaken, success, context.queryString(), context.host(), synced});
                }
                return null;
            });
        }

        private boolean isLocalViewBehind(Context ctx) {
            String basePath = ctx.queryParam("basepath");
            String lastKnownInstantFromClient = this.getLastInstantTsParam(ctx);
            String timelineHashFromClient = this.getTimelineHashParam(ctx);
            HoodieTimeline localTimeline = RequestHandler.this.viewManager.getFileSystemView(basePath).getTimeline().filterCompletedOrMajorOrMinorCompactionInstants();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Client [ LastTs={}, TimelineHash={}], localTimeline={}", new Object[]{lastKnownInstantFromClient, timelineHashFromClient, localTimeline.getInstants()});
            }
            if (!localTimeline.getInstantsAsStream().findAny().isPresent() && "0".equals(lastKnownInstantFromClient)) {
                return false;
            }
            String localTimelineHash = localTimeline.getTimelineHash();
            if (!localTimelineHash.equals(timelineHashFromClient)) {
                return true;
            }
            return !localTimeline.containsOrBeforeTimelineStarts(lastKnownInstantFromClient);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean syncIfLocalViewBehind(Context ctx) {
            SyncableFileSystemView view;
            String basePath = ctx.queryParam("basepath");
            SyncableFileSystemView syncableFileSystemView = view = RequestHandler.this.viewManager.getFileSystemView(basePath);
            synchronized (syncableFileSystemView) {
                if (this.isLocalViewBehind(ctx)) {
                    String lastKnownInstantFromClient = this.getLastInstantTsParam(ctx);
                    HoodieTimeline localTimeline = RequestHandler.this.viewManager.getFileSystemView(basePath).getTimeline();
                    if (LOG.isInfoEnabled()) {
                        LOG.info("Syncing view as client passed last known instant {} as last known instant but server has the following last instant on timeline: {}", (Object)lastKnownInstantFromClient, (Object)localTimeline.lastInstant());
                    }
                    view.sync();
                    return true;
                }
            }
            return false;
        }

        private boolean shouldThrowExceptionIfLocalViewBehind(HoodieTimeline localTimeline, String timelineHashFromClient) {
            Option lastInstant = localTimeline.lastInstant();
            return !lastInstant.isPresent() || !((HoodieInstant)lastInstant.get()).getAction().equals("clean") || !localTimeline.findInstantsBefore(((HoodieInstant)lastInstant.get()).requestedTime()).getTimelineHash().equals(timelineHashFromClient);
        }

        private boolean isRefreshCheckDisabledInQuery(Context ctx) {
            return Boolean.parseBoolean(ctx.queryParam("refreshoff"));
        }

        private String getLastInstantTsParam(Context ctx) {
            return (String)ctx.queryParamAsClass("lastinstantts", String.class).getOrDefault((Object)"0");
        }

        private String getTimelineHashParam(Context ctx) {
            return (String)ctx.queryParamAsClass("timelinehash", String.class).getOrDefault((Object)"");
        }
    }
}

