/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.timeline.service;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathInfo;
import org.apache.hudi.storage.hadoop.HoodieHadoopStorage;

public class MockHoodieHadoopStorage
extends HoodieHadoopStorage {
    private final String scheme;
    private final String authority;

    public MockHoodieHadoopStorage(StoragePath path, StorageConfiguration<?> conf) {
        super(MockHoodieHadoopStorage.convertToHadoopPath(path), conf);
        this.scheme = path.toUri().getScheme();
        this.authority = path.toUri().getAuthority();
    }

    private static StoragePath convertToHadoopPath(StoragePath storagePath) {
        return new StoragePath(storagePath.toUri().getPath());
    }

    public String getScheme() {
        return super.getScheme();
    }

    public boolean exists(StoragePath path) throws IOException {
        return super.exists(this.validateAndConvertPath(path));
    }

    public boolean createDirectory(StoragePath path) throws IOException {
        return super.createDirectory(this.validateAndConvertPath(path));
    }

    public OutputStream create(StoragePath path, boolean overwrite) throws IOException {
        return super.create(this.validateAndConvertPath(path), overwrite);
    }

    public OutputStream create(StoragePath path) throws IOException {
        return super.create(this.validateAndConvertPath(path));
    }

    public List<StoragePathInfo> listDirectEntries(StoragePath path) throws IOException {
        return super.listDirectEntries(this.validateAndConvertPath(path));
    }

    private StoragePath validateAndConvertPath(StoragePath path) {
        ValidationUtils.checkArgument((this.scheme == null || this.scheme.equals(path.toUri().getScheme()) ? 1 : 0) != 0, (String)String.format("Invalid scheme, expected %s, found %s", this.scheme, path.toUri().getScheme()));
        ValidationUtils.checkArgument((this.authority == null || this.authority.equals(path.toUri().getAuthority()) ? 1 : 0) != 0, (String)String.format("Invalid authority, expected %s, found %s", this.authority, path.toUri().getAuthority()));
        return MockHoodieHadoopStorage.convertToHadoopPath(path);
    }
}

