/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.timeline.service;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.config.HoodieStorageConfig;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.HoodieLocalEngineContext;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.marker.MarkerOperation;
import org.apache.hudi.common.table.view.FileSystemViewManager;
import org.apache.hudi.common.table.view.FileSystemViewStorageConfig;
import org.apache.hudi.common.table.view.FileSystemViewStorageType;
import org.apache.hudi.common.table.view.RemoteHoodieTableFileSystemView;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.hadoop.HadoopStorageConfiguration;
import org.apache.hudi.timeline.TimelineServiceClient;
import org.apache.hudi.timeline.TimelineServiceClientBase;
import org.apache.hudi.timeline.service.MockHoodieHadoopStorage;
import org.apache.hudi.timeline.service.TimelineService;
import org.apache.hudi.timeline.service.TimelineServiceTestHarness;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class TestRequestHandler
extends HoodieCommonTestHarness {
    private static final String DEFAULT_FILE_SCHEME = "file:/";
    private TimelineService server = null;
    private TimelineServiceClient timelineServiceClient;

    TestRequestHandler() {
    }

    @BeforeEach
    void setUp() throws IOException {
        TimelineServiceTestHarness.Builder builder;
        this.metaClient = HoodieTestUtils.init((String)this.tempDir.toAbsolutePath().toString());
        this.basePath = this.metaClient.getBasePath().toString();
        Configuration configuration = new Configuration();
        configuration.set(HoodieStorageConfig.HOODIE_STORAGE_CLASS.key(), MockHoodieHadoopStorage.class.getName());
        FileSystemViewStorageConfig sConf = FileSystemViewStorageConfig.newBuilder().withStorageType(FileSystemViewStorageType.SPILLABLE_DISK).build();
        HoodieMetadataConfig metadataConfig = HoodieMetadataConfig.newBuilder().build();
        HoodieCommonConfig commonConfig = HoodieCommonConfig.newBuilder().build();
        HoodieLocalEngineContext localEngineContext = new HoodieLocalEngineContext((StorageConfiguration)new HadoopStorageConfiguration(configuration));
        try {
            if (this.server != null) {
                this.server.close();
            }
            builder = TimelineServiceTestHarness.newBuilder();
            this.server = builder.build(configuration, TimelineService.Config.builder().serverPort(0).enableMarkerRequests(true).build(), FileSystemViewManager.createViewManager((HoodieEngineContext)localEngineContext, (HoodieMetadataConfig)metadataConfig, (FileSystemViewStorageConfig)sConf, (HoodieCommonConfig)commonConfig));
            this.server.startService();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        builder = FileSystemViewStorageConfig.newBuilder().withRemoteServerHost("localhost").withRemoteServerPort(Integer.valueOf(this.server.getServerPort())).withRemoteTimelineClientTimeoutSecs(Integer.valueOf(60));
        this.timelineServiceClient = new TimelineServiceClient(builder.build());
    }

    @AfterEach
    void tearDown() {
        this.server.close();
    }

    @Test
    void testRefreshTableAPIWithDifferentSchemes() throws IOException {
        this.assertRefreshTable(this.tempDir.resolve("base-path-1").toUri().toString(), "test1:/");
        this.assertRefreshTable(this.tempDir.resolve("base-path-2").toUri().toString(), "test2:/");
    }

    private void assertRefreshTable(String basePath, String scheme) throws IOException {
        HashMap<String, String> queryParameters = new HashMap<String, String>();
        queryParameters.put("basepath", this.getPathWithReplacedSchema(basePath, scheme));
        this.metaClient.getActiveTimeline().lastInstant().ifPresent(instant -> queryParameters.put("lastinstantts", instant.requestedTime()));
        queryParameters.put("timelinehash", this.metaClient.getActiveTimeline().getTimelineHash());
        boolean content = (Boolean)this.timelineServiceClient.makeRequest(TimelineServiceClientBase.Request.newBuilder((TimelineServiceClientBase.RequestMethod)TimelineServiceClientBase.RequestMethod.POST, (String)RemoteHoodieTableFileSystemView.REFRESH_TABLE_URL).addQueryParams(queryParameters).build()).getDecodedContent((TypeReference)new TypeReference<Boolean>(){});
        Assertions.assertTrue((boolean)content);
    }

    @Test
    void testCreateMarkerAPIWithDifferentSchemes() throws IOException {
        this.assertMarkerCreation(this.tempDir.resolve("base-path-1").toUri().toString(), "test1:/");
        this.assertMarkerCreation(this.tempDir.resolve("base-path-2").toUri().toString(), "test2:/");
    }

    private void assertMarkerCreation(String basePath, String schema) throws IOException {
        HashMap<String, String> queryParameters = new HashMap<String, String>();
        String basePathScheme = this.getPathWithReplacedSchema(basePath, schema);
        HoodieTableMetaClient metaClient = HoodieTestUtils.init((String)basePath, (HoodieTableType)this.getTableType());
        String markerDir = this.getPathWithReplacedSchema(metaClient.getMarkerFolderPath("101"), schema);
        queryParameters.put("basepath", basePathScheme);
        queryParameters.put("markerdirpath", markerDir);
        queryParameters.put("markername", "marker-file-1");
        boolean content = (Boolean)this.timelineServiceClient.makeRequest(TimelineServiceClientBase.Request.newBuilder((TimelineServiceClientBase.RequestMethod)TimelineServiceClientBase.RequestMethod.POST, (String)MarkerOperation.CREATE_MARKER_URL).addQueryParams(queryParameters).build()).getDecodedContent((TypeReference)new TypeReference<Boolean>(){});
        Assertions.assertTrue((boolean)content);
    }

    private String getPathWithReplacedSchema(String path, String schemaToUse) {
        if (path.startsWith(DEFAULT_FILE_SCHEME)) {
            return path.replace(DEFAULT_FILE_SCHEME, schemaToUse);
        }
        if (path.startsWith(String.valueOf('/'))) {
            return schemaToUse + '/' + path;
        }
        throw new IllegalArgumentException("Invalid file provided");
    }
}

