/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.timeline.service;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import org.apache.hudi.common.table.view.FileSystemViewManager;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.timeline.service.TimelineService;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class TestTimelineService {
    TestTimelineService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void createServerUsesRandomPortIfAnotherTimelineServiceRunningOnSamePort() throws Exception {
        TimelineService timelineService = null;
        TimelineService secondTimelineService = null;
        try {
            StorageConfiguration conf = HoodieTestUtils.getDefaultStorageConf();
            int originalServerPort = 8888;
            TimelineService.Config config = TimelineService.Config.builder().enableMarkerRequests(true).serverPort(originalServerPort).build();
            FileSystemViewManager viewManager = (FileSystemViewManager)Mockito.mock(FileSystemViewManager.class);
            timelineService = new TimelineService(conf, config, viewManager);
            Assertions.assertEquals((int)originalServerPort, (int)timelineService.startService());
            secondTimelineService = new TimelineService(conf, config, viewManager);
            Assertions.assertNotEquals((int)originalServerPort, (int)secondTimelineService.startService());
        }
        finally {
            if (timelineService != null) {
                timelineService.close();
            }
            if (secondTimelineService != null) {
                secondTimelineService.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void createServerUsesRandomPortIfProvidedPortInUse() throws Exception {
        TimelineService timelineService = null;
        HttpServer server = null;
        try {
            int originalServerPort = 8888;
            server = HttpServer.create(new InetSocketAddress(originalServerPort), 0);
            server.createContext("/", new MyHandler());
            server.setExecutor(null);
            server.start();
            TimelineService.Config config = TimelineService.Config.builder().enableMarkerRequests(true).serverPort(originalServerPort).build();
            FileSystemViewManager viewManager = (FileSystemViewManager)Mockito.mock(FileSystemViewManager.class);
            StorageConfiguration conf = HoodieTestUtils.getDefaultStorageConf();
            timelineService = new TimelineService(conf, config, viewManager);
            Assertions.assertNotEquals((int)originalServerPort, (int)timelineService.startService());
        }
        finally {
            if (timelineService != null) {
                timelineService.close();
            }
            if (server != null) {
                server.stop(0);
            }
        }
    }

    static class MyHandler
    implements HttpHandler {
        MyHandler() {
        }

        @Override
        public void handle(HttpExchange t) throws IOException {
            String response = "Hello World!";
            t.sendResponseHeaders(200, response.length());
            try (OutputStream os = t.getResponseBody();){
                os.write(response.getBytes());
            }
        }
    }
}

