/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.timeline.service;

import java.io.IOException;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.conf.Configuration;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.util.EntityUtils;
import org.apache.hudi.common.table.view.FileSystemViewManager;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.hadoop.HadoopStorageConfiguration;
import org.apache.hudi.timeline.service.TimelineService;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

public class TimelineServiceTestHarness
extends TimelineService {
    private static final String PROXY_ALL_URLS = "/*";
    private int numberOfSimulatedConnectionFailures;
    private Option<Server> server = Option.empty();
    private int serverPort = 0;

    public TimelineServiceTestHarness(Configuration hadoopConf, TimelineService.Config timelineServerConf, FileSystemViewManager globalFileSystemViewManager) throws IOException {
        super((StorageConfiguration)new HadoopStorageConfiguration(hadoopConf), timelineServerConf, globalFileSystemViewManager);
    }

    public void setNumberOfSimulatedConnectionFailures(int numberOfSimulatedConnectionFailures) {
        this.numberOfSimulatedConnectionFailures = numberOfSimulatedConnectionFailures;
    }

    public int startService() throws IOException {
        if (this.numberOfSimulatedConnectionFailures > 0) {
            try {
                int timelineServicePort = super.startService();
                this.server = Option.of((Object)new Server(this.serverPort));
                ServletContextHandler context = new ServletContextHandler(1);
                context.setContextPath("/");
                context.addServlet(new ServletHolder((Servlet)new FailureInducingHttpServlet(timelineServicePort, this.numberOfSimulatedConnectionFailures)), PROXY_ALL_URLS);
                ((Server)this.server.get()).setHandler((Handler)context);
                ((Server)this.server.get()).start();
                this.serverPort = ((Server)this.server.get()).getURI().getPort();
                return this.serverPort;
            }
            catch (Exception exception) {
                throw new IOException(exception);
            }
        }
        return super.startService();
    }

    public int getServerPort() {
        if (this.serverPort > 0) {
            return this.serverPort;
        }
        return super.getServerPort();
    }

    public void close() {
        super.close();
        this.server.ifPresent(server -> {
            try {
                server.stop();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    private static class FailureInducingHttpServlet
    extends HttpServlet {
        private final int timelineServerPort;
        private final int maxSimulatedConnectionFailures;
        private int currentNumConnectionSimulatedFailures;

        public FailureInducingHttpServlet(int timelineServerPort, int maxSimulatedConnectionFailures) {
            this.timelineServerPort = timelineServerPort;
            this.maxSimulatedConnectionFailures = maxSimulatedConnectionFailures;
            this.currentNumConnectionSimulatedFailures = 0;
        }

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
            Response response;
            if (++this.currentNumConnectionSimulatedFailures <= this.maxSimulatedConnectionFailures) {
                throw new NoHttpResponseException("Simulated connection failure");
            }
            URIBuilder builder = new URIBuilder().setHost("localhost").setPort(this.timelineServerPort).setPath(req.getPathInfo()).setScheme("http");
            Map parameterMap = req.getParameterMap();
            for (Map.Entry entry : parameterMap.entrySet()) {
                String[] paramValues;
                String paramName = (String)entry.getKey();
                for (String value : paramValues = (String[])entry.getValue()) {
                    builder.addParameter(paramName, value);
                }
            }
            String url = builder.toString();
            switch (req.getMethod()) {
                case "GET": {
                    response = Request.Get((String)url).connectTimeout(10000).socketTimeout(10000).execute();
                    break;
                }
                default: {
                    response = Request.Post((String)url).connectTimeout(10000).socketTimeout(10000).execute();
                }
            }
            HttpResponse httpResponse = response.returnResponse();
            resp.setContentType(httpResponse.getEntity().getContentType().getValue());
            resp.setStatus(httpResponse.getStatusLine().getStatusCode());
            resp.getWriter().println(EntityUtils.toString((HttpEntity)httpResponse.getEntity()));
        }
    }

    public static class Builder {
        private int numberOfSimulatedConnectionFailures = 0;

        public Builder withNumberOfSimulatedConnectionFailures(int numberOfSimulatedConnectionFailures) {
            this.numberOfSimulatedConnectionFailures = numberOfSimulatedConnectionFailures;
            return this;
        }

        public TimelineServiceTestHarness build(Configuration hadoopConf, TimelineService.Config timelineServerConf, FileSystemViewManager globalFileSystemViewManager) throws IOException {
            TimelineServiceTestHarness timelineServiceTestHarness = new TimelineServiceTestHarness(hadoopConf, timelineServerConf, globalFileSystemViewManager);
            timelineServiceTestHarness.setNumberOfSimulatedConnectionFailures(this.numberOfSimulatedConnectionFailures);
            return timelineServiceTestHarness;
        }
    }
}

