/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.timeline.service.functional;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.HoodieLocalEngineContext;
import org.apache.hudi.common.model.HoodieFileGroup;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.dto.DTOUtils;
import org.apache.hudi.common.table.timeline.dto.FileGroupDTO;
import org.apache.hudi.common.table.view.FileSystemViewManager;
import org.apache.hudi.common.table.view.FileSystemViewStorageConfig;
import org.apache.hudi.common.table.view.FileSystemViewStorageType;
import org.apache.hudi.common.table.view.RemoteHoodieTableFileSystemView;
import org.apache.hudi.common.table.view.SyncableFileSystemView;
import org.apache.hudi.common.table.view.TestHoodieTableFileSystemView;
import org.apache.hudi.common.testutils.MockHoodieTimeline;
import org.apache.hudi.exception.HoodieRemoteException;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.timeline.service.TimelineService;
import org.apache.hudi.timeline.service.TimelineServiceTestHarness;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRemoteHoodieTableFileSystemView
extends TestHoodieTableFileSystemView {
    private static final Logger LOG = LoggerFactory.getLogger(TestRemoteHoodieTableFileSystemView.class);
    private static int DEFAULT_READ_TIMEOUT_SECS = 60;
    private TimelineService server = null;
    private RemoteHoodieTableFileSystemView view;

    protected SyncableFileSystemView getFileSystemView(HoodieTimeline timeline) {
        return this.getFileSystemView(timeline, 0);
    }

    protected SyncableFileSystemView getFileSystemView(HoodieTimeline timeline, int numberOfSimulatedConnectionFailures) {
        FileSystemViewStorageConfig sConf = FileSystemViewStorageConfig.newBuilder().withStorageType(FileSystemViewStorageType.SPILLABLE_DISK).build();
        HoodieCommonConfig commonConfig = HoodieCommonConfig.newBuilder().build();
        HoodieMetadataConfig metadataConfig = HoodieMetadataConfig.newBuilder().build();
        HoodieLocalEngineContext localEngineContext = new HoodieLocalEngineContext(this.metaClient.getStorageConf());
        try {
            if (this.server != null) {
                this.server.close();
            }
            TimelineServiceTestHarness.Builder builder = TimelineServiceTestHarness.newBuilder();
            builder.withNumberOfSimulatedConnectionFailures(numberOfSimulatedConnectionFailures);
            this.server = builder.build((Configuration)HadoopFSUtils.getStorageConf().unwrap(), TimelineService.Config.builder().serverPort(0).build(), FileSystemViewManager.createViewManager((HoodieEngineContext)localEngineContext, (HoodieMetadataConfig)metadataConfig, (FileSystemViewStorageConfig)sConf, (HoodieCommonConfig)commonConfig));
            this.server.startService();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        LOG.info("Connecting to Timeline Server :{}", (Object)this.server.getServerPort());
        this.view = TestRemoteHoodieTableFileSystemView.initFsView(this.metaClient, this.server.getServerPort(), false);
        return this.view;
    }

    @Test
    public void testRemoteHoodieTableFileSystemViewWithRetry() {
        this.view.getLatestBaseFiles();
        this.getFileSystemView((HoodieTimeline)this.metaClient.getActiveTimeline(), 1);
        TestRemoteHoodieTableFileSystemView.validateRequestFailed(() -> ((RemoteHoodieTableFileSystemView)this.view).getLatestBaseFiles());
        this.getFileSystemView((HoodieTimeline)this.metaClient.getActiveTimeline(), 3);
        RemoteHoodieTableFileSystemView viewWithRetries = TestRemoteHoodieTableFileSystemView.initFsView(this.metaClient, this.server.getServerPort(), true);
        viewWithRetries.getLatestBaseFiles();
    }

    @Test
    public void testJettyServerDaemonThread() {
        this.view.getLatestBaseFiles();
        Thread.getAllStackTraces().keySet().stream().filter(t -> t.getName().startsWith("qtp") || t.getName().startsWith("Jetty") || t.getName().startsWith("TimelineService-JettyScheduler")).forEach(t -> Assertions.assertTrue((boolean)t.isDaemon()));
        this.server.close();
    }

    @Test
    public void testListFileGroupDTOPayload() throws IOException, NoSuchFieldException, IllegalAccessException {
        ObjectMapper mapper = new ObjectMapper();
        ArrayList<HoodieFileGroup> fileGroups = new ArrayList<HoodieFileGroup>();
        fileGroups.add(this.createHoodieFileGroup());
        fileGroups.add(this.createHoodieFileGroup());
        fileGroups.add(this.createHoodieFileGroup());
        Field timelineDTOField = FileGroupDTO.class.getDeclaredField("timeline");
        timelineDTOField.setAccessible(true);
        List fileGroupDTOs = DTOUtils.fileGroupDTOsfromFileGroups(fileGroups);
        Assertions.assertNotNull((Object)timelineDTOField.get(fileGroupDTOs.get(0)));
        Assertions.assertNull((Object)timelineDTOField.get(fileGroupDTOs.get(1)));
        Assertions.assertNull((Object)timelineDTOField.get(fileGroupDTOs.get(2)));
        String prettyResult = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)fileGroupDTOs);
        String normalResult = mapper.writeValueAsString((Object)fileGroupDTOs);
        Stream<HoodieFileGroup> prettyFileGroups = this.readFileGroupStream(prettyResult, mapper);
        Stream<HoodieFileGroup> normalFileGroups = this.readFileGroupStream(normalResult, mapper);
        prettyFileGroups.forEach(g -> Assertions.assertNotNull((Object)g.getTimeline()));
        normalFileGroups.forEach(g -> Assertions.assertNotNull((Object)g.getTimeline()));
    }

    private Stream<HoodieFileGroup> readFileGroupStream(String result, ObjectMapper mapper) throws IOException {
        return DTOUtils.fileGroupDTOsToFileGroups((List)((List)mapper.readValue(result, (TypeReference)new TypeReference<List<FileGroupDTO>>(){})), (HoodieTableMetaClient)this.metaClient);
    }

    private HoodieFileGroup createHoodieFileGroup() {
        Stream<String> completed = Stream.of("001");
        Stream<String> inflight = Stream.of("002");
        MockHoodieTimeline activeTimeline = new MockHoodieTimeline(completed, inflight);
        return new HoodieFileGroup("", "data", activeTimeline.getCommitsTimeline().filterCompletedInstants());
    }

    private static RemoteHoodieTableFileSystemView initFsView(HoodieTableMetaClient metaClient, int serverPort, boolean enableRetries) {
        FileSystemViewStorageConfig.Builder builder = FileSystemViewStorageConfig.newBuilder().withRemoteServerHost("localhost").withRemoteServerPort(Integer.valueOf(serverPort)).withRemoteTimelineClientTimeoutSecs(Integer.valueOf(DEFAULT_READ_TIMEOUT_SECS));
        if (enableRetries) {
            builder.withRemoteTimelineClientTimeoutSecs(Integer.valueOf(300)).withRemoteTimelineClientRetry(true).withRemoteTimelineClientMaxRetryIntervalMs(Long.valueOf(2000L)).withRemoteTimelineClientMaxRetryNumbers(Integer.valueOf(5));
        }
        return new RemoteHoodieTableFileSystemView(metaClient, builder.build());
    }

    private static void validateRequestFailed(Executable executable) {
        Assertions.assertThrows(HoodieRemoteException.class, (Executable)executable, (String)"Should catch a NoHTTPResponseException'");
    }
}

