/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.timeline.service.handlers.marker;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.HoodieStorageUtils;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.timeline.service.handlers.MarkerHandler;
import org.apache.hudi.timeline.service.handlers.marker.MarkerBasedEarlyConflictDetectionRunnable;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestMarkerBasedEarlyConflictDetectionRunnable
extends HoodieCommonTestHarness {
    private static final Logger LOG = LoggerFactory.getLogger(TestMarkerBasedEarlyConflictDetectionRunnable.class);

    @BeforeEach
    public void setUp() throws Exception {
        this.initPath();
    }

    @AfterEach
    public void tearDown() throws Exception {
        Path path = new Path(this.basePath);
        FileSystem fs = path.getFileSystem(new Configuration());
        fs.delete(path, true);
    }

    @Test
    public void testMarkerConflictDetectionRunnable() throws IOException, InterruptedException {
        AtomicBoolean hasConflict = new AtomicBoolean(false);
        HoodieStorage storage = HoodieStorageUtils.getStorage((String)this.basePath, (StorageConfiguration)HoodieTestUtils.getDefaultStorageConf());
        MarkerHandler markerHandler = (MarkerHandler)Mockito.mock(MarkerHandler.class);
        String rootBaseMarkerDir = this.basePath + "/.hoodie/.temp";
        String partition = "2016";
        this.metaClient = HoodieTestUtils.init((StorageConfiguration)HoodieTestUtils.getDefaultStorageConf(), (String)this.basePath, (HoodieTableType)HoodieTableType.COPY_ON_WRITE);
        String oldInstant = "001";
        Set<String> oldMarkers = Stream.of(partition + "/b21adfa2-7013-4452-a565-4cc39fea5b73-0_4-17-21_001.parquet.marker.CREATE", partition + "/4a266542-c7d5-426f-8fb8-fb85a2e88448-0_3-17-20_001.parquet.marker.CREATE").collect(Collectors.toSet());
        this.prepareFiles(rootBaseMarkerDir, oldInstant, oldMarkers, storage);
        String currentInstantTime = "002";
        String currentMarkerDir = rootBaseMarkerDir + "/" + currentInstantTime;
        Set<String> currentMarkers = Stream.of(partition + "/b21adfa2-7013-4452-a565-4cc39fea5b73-0_40-170-210_002.parquet.marker.MERGE", partition + "/1228caeb-4188-4e19-a18d-848e6f9b0448-0_55-55-425_002.parquet.marker.MERGE").collect(Collectors.toSet());
        this.prepareFiles(rootBaseMarkerDir, currentInstantTime, currentMarkers, storage);
        HashSet<HoodieInstant> oldInstants = new HashSet<HoodieInstant>();
        oldInstants.add(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "commit", oldInstant));
        Mockito.when((Object)markerHandler.getAllMarkers(currentMarkerDir)).thenReturn(currentMarkers);
        ScheduledExecutorService detectorExecutor = Executors.newSingleThreadScheduledExecutor();
        detectorExecutor.submit((Runnable)new MarkerBasedEarlyConflictDetectionRunnable(hasConflict, markerHandler, currentMarkerDir, this.basePath, storage, Long.MAX_VALUE, oldInstants, true));
        detectorExecutor.shutdown();
        detectorExecutor.awaitTermination(60L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)hasConflict.get());
    }

    private void prepareFiles(String baseMarkerDir, String instant, Set<String> markers, HoodieStorage storage) throws IOException {
        storage.create(new StoragePath(this.basePath + "/.hoodie/timeline/" + instant + ".commit"), true);
        String markerDir = baseMarkerDir + "/" + instant;
        storage.createDirectory(new StoragePath(markerDir));
        BufferedWriter out = new BufferedWriter(new FileWriter(markerDir + "/MARKERS0"));
        markers.forEach(ele -> {
            try {
                out.write((String)ele);
                out.write("\n");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
        out.close();
    }
}

