/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.timeline.service.handlers.marker;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.timeline.service.handlers.marker.BatchedMarkerCreationContext;
import org.apache.hudi.timeline.service.handlers.marker.BatchedMarkerCreationRunnable;
import org.apache.hudi.timeline.service.handlers.marker.MarkerCreationFuture;
import org.apache.hudi.timeline.service.handlers.marker.MarkerDirState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarkerCreationDispatchingRunnable
implements Runnable {
    public static final Logger LOG = LoggerFactory.getLogger(MarkerCreationDispatchingRunnable.class);
    private final Map<String, MarkerDirState> markerDirStateMap;
    private final ExecutorService executorService;

    public MarkerCreationDispatchingRunnable(Map<String, MarkerDirState> markerDirStateMap, ExecutorService executorService) {
        this.markerDirStateMap = markerDirStateMap;
        this.executorService = executorService;
    }

    @Override
    public void run() {
        ArrayList<BatchedMarkerCreationContext> requestContextList = new ArrayList<BatchedMarkerCreationContext>();
        for (Map.Entry<String, MarkerDirState> entry : this.markerDirStateMap.entrySet()) {
            String markerDir = entry.getKey();
            MarkerDirState markerDirState = entry.getValue();
            Option<Integer> fileIndex = markerDirState.getNextFileIndexToUse();
            if (!fileIndex.isPresent()) {
                LOG.debug("All marker files are busy, skip batch processing of create marker requests in {}", (Object)markerDir);
                continue;
            }
            List<MarkerCreationFuture> futures = markerDirState.fetchPendingMarkerCreationRequests();
            if (futures.isEmpty()) {
                markerDirState.markFileAsAvailable((Integer)fileIndex.get());
                continue;
            }
            requestContextList.add(new BatchedMarkerCreationContext(markerDir, markerDirState, futures, (Integer)fileIndex.get()));
        }
        if (requestContextList.size() > 0) {
            this.executorService.execute(new BatchedMarkerCreationRunnable(requestContextList));
        }
    }
}

