/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.io.hfile.bucket;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.Cacheable;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.bucket.BucketEntry;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.bucket.FileMmapIOEngine;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class SharedMemoryMmapIOEngine
extends FileMmapIOEngine {
    public SharedMemoryMmapIOEngine(String filePath, long capacity) throws IOException {
        super(filePath, capacity);
    }

    @Override
    public boolean usesSharedMemory() {
        return true;
    }

    @Override
    public Cacheable read(BucketEntry be) throws IOException {
        ByteBuffer[] buffers = this.bufferArray.asSubByteBuffers(be.offset(), be.getLength());
        return be.wrapAsCacheable(buffers);
    }
}

