/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.log.block;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.util.ClosableIterator;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.org.apache.avro.Schema;
import org.apache.hudi.org.apache.avro.generic.IndexedRecord;

public abstract class HoodieDataBlock
extends HoodieLogBlock {
    private final Option<List<IndexedRecord>> records;
    private final String keyFieldName;
    private final boolean enablePointLookups;
    protected final Schema readerSchema;
    protected InternalSchema internalSchema = InternalSchema.getEmptyInternalSchema();

    public HoodieDataBlock(List<IndexedRecord> records, Map<HoodieLogBlock.HeaderMetadataType, String> header, Map<HoodieLogBlock.HeaderMetadataType, String> footer, String keyFieldName) {
        super(header, footer, Option.empty(), Option.empty(), null, false);
        this.records = Option.of(records);
        this.keyFieldName = keyFieldName;
        this.readerSchema = HoodieDataBlock.getWriterSchema(super.getLogBlockHeader());
        this.enablePointLookups = false;
    }

    protected HoodieDataBlock(Option<byte[]> content, FSDataInputStream inputStream, boolean readBlockLazily, Option<HoodieLogBlock.HoodieLogBlockContentLocation> blockContentLocation, Option<Schema> readerSchema, Map<HoodieLogBlock.HeaderMetadataType, String> headers, Map<HoodieLogBlock.HeaderMetadataType, String> footer, String keyFieldName, boolean enablePointLookups) {
        super(headers, footer, blockContentLocation, content, inputStream, readBlockLazily);
        this.records = Option.empty();
        this.keyFieldName = keyFieldName;
        this.readerSchema = readerSchema.orElseGet(() -> HoodieDataBlock.getWriterSchema(super.getLogBlockHeader()));
        this.enablePointLookups = enablePointLookups;
    }

    protected HoodieDataBlock(Option<byte[]> content, FSDataInputStream inputStream, boolean readBlockLazily, Option<HoodieLogBlock.HoodieLogBlockContentLocation> blockContentLocation, Option<Schema> readerSchema, Map<HoodieLogBlock.HeaderMetadataType, String> headers, Map<HoodieLogBlock.HeaderMetadataType, String> footer, String keyFieldName, boolean enablePointLookups, InternalSchema internalSchema) {
        super(headers, footer, blockContentLocation, content, inputStream, readBlockLazily);
        this.records = Option.empty();
        this.keyFieldName = keyFieldName;
        this.readerSchema = readerSchema.orElseGet(() -> HoodieDataBlock.getWriterSchema(super.getLogBlockHeader()));
        this.enablePointLookups = enablePointLookups;
        this.internalSchema = internalSchema == null ? InternalSchema.getEmptyInternalSchema() : internalSchema;
    }

    @Override
    public byte[] getContentBytes() throws IOException {
        Option<byte[]> content = this.getContent();
        ValidationUtils.checkState(content.isPresent() || this.records.isPresent(), "Block is in invalid state");
        if (content.isPresent()) {
            return content.get();
        }
        return this.serializeRecords(this.records.get());
    }

    protected static Schema getWriterSchema(Map<HoodieLogBlock.HeaderMetadataType, String> logBlockHeader) {
        return new Schema.Parser().parse(logBlockHeader.get((Object)HoodieLogBlock.HeaderMetadataType.SCHEMA));
    }

    public final ClosableIterator<IndexedRecord> getRecordIterator() {
        if (this.records.isPresent()) {
            return HoodieDataBlock.list2Iterator(this.records.get());
        }
        try {
            return this.readRecordsFromBlockPayload();
        }
        catch (IOException io) {
            throw new HoodieIOException("Unable to convert content bytes to records", io);
        }
    }

    public Schema getSchema() {
        return this.readerSchema;
    }

    public final ClosableIterator<IndexedRecord> getRecordIterator(List<String> keys, boolean fullKey) throws IOException {
        boolean fullScan = keys.isEmpty();
        if (this.enablePointLookups && !fullScan) {
            return this.lookupRecords(keys, fullKey);
        }
        ClosableIterator<IndexedRecord> allRecords = this.getRecordIterator();
        if (fullScan) {
            return allRecords;
        }
        HashSet<String> keySet = new HashSet<String>(keys);
        return FilteringIterator.getInstance(allRecords, keySet, fullKey, this::getRecordKey);
    }

    protected ClosableIterator<IndexedRecord> readRecordsFromBlockPayload() throws IOException {
        if (this.readBlockLazily && !this.getContent().isPresent()) {
            this.inflate();
        }
        try {
            ClosableIterator<IndexedRecord> closableIterator = this.deserializeRecords(this.getContent().get());
            return closableIterator;
        }
        finally {
            this.deflate();
        }
    }

    protected ClosableIterator<IndexedRecord> lookupRecords(List<String> keys, boolean fullKey) throws IOException {
        throw new UnsupportedOperationException(String.format("Point lookups are not supported by this Data block type (%s)", new Object[]{this.getBlockType()}));
    }

    protected abstract byte[] serializeRecords(List<IndexedRecord> var1) throws IOException;

    protected abstract ClosableIterator<IndexedRecord> deserializeRecords(byte[] var1) throws IOException;

    @Override
    public abstract HoodieLogBlock.HoodieLogBlockType getBlockType();

    protected Option<Schema.Field> getKeyField(Schema schema) {
        return Option.ofNullable(schema.getField(this.keyFieldName));
    }

    protected Option<String> getRecordKey(IndexedRecord record) {
        return this.getKeyField(record.getSchema()).map(keyField -> record.get(keyField.pos())).map(Object::toString);
    }

    static <T> ClosableIterator<T> list2Iterator(List<T> list) {
        final Iterator<T> iterator = list.iterator();
        return new ClosableIterator<T>(){

            @Override
            public void close() {
            }

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public T next() {
                return iterator.next();
            }
        };
    }

    private static class FilteringIterator<T extends IndexedRecord>
    implements ClosableIterator<T> {
        private final ClosableIterator<T> nested;
        private final Set<String> keys;
        private final boolean fullKey;
        private final Function<T, Option<String>> keyExtract;
        private T next;

        private FilteringIterator(ClosableIterator<T> nested, Set<String> keys, boolean fullKey, Function<T, Option<String>> keyExtract) {
            this.nested = nested;
            this.keys = keys;
            this.fullKey = fullKey;
            this.keyExtract = keyExtract;
        }

        public static <T extends IndexedRecord> FilteringIterator<T> getInstance(ClosableIterator<T> nested, Set<String> keys, boolean fullKey, Function<T, Option<String>> keyExtract) {
            return new FilteringIterator<T>(nested, keys, fullKey, keyExtract);
        }

        @Override
        public void close() {
            this.nested.close();
        }

        @Override
        public boolean hasNext() {
            while (this.nested.hasNext()) {
                this.next = (IndexedRecord)this.nested.next();
                String key = this.keyExtract.apply(this.next).orElseGet(() -> {
                    throw new IllegalStateException(String.format("Record without a key (%s)", this.next));
                });
                if (!this.fullKey || !this.keys.contains(key)) {
                    if (this.fullKey) continue;
                    if (!this.keys.stream().anyMatch(key::startsWith)) continue;
                }
                return true;
            }
            return false;
        }

        @Override
        public T next() {
            return this.next;
        }
    }
}

