/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.regionserver;

import com.google.errorprone.annotations.RestrictedApi;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.com.google.protobuf.Message;
import org.apache.hudi.org.apache.hadoop.hbase.ByteBufferExtendedCell;
import org.apache.hudi.org.apache.hadoop.hbase.CacheEvictionStats;
import org.apache.hudi.org.apache.hadoop.hbase.CacheEvictionStatsBuilder;
import org.apache.hudi.org.apache.hadoop.hbase.Cell;
import org.apache.hudi.org.apache.hadoop.hbase.CellScannable;
import org.apache.hudi.org.apache.hadoop.hbase.CellScanner;
import org.apache.hudi.org.apache.hadoop.hbase.CellUtil;
import org.apache.hudi.org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hudi.org.apache.hadoop.hbase.DroppedSnapshotException;
import org.apache.hudi.org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hudi.org.apache.hadoop.hbase.HConstants;
import org.apache.hudi.org.apache.hadoop.hbase.MultiActionResultTooLarge;
import org.apache.hudi.org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hudi.org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hudi.org.apache.hadoop.hbase.RegionTooBusyException;
import org.apache.hudi.org.apache.hadoop.hbase.Server;
import org.apache.hudi.org.apache.hadoop.hbase.ServerName;
import org.apache.hudi.org.apache.hadoop.hbase.TableName;
import org.apache.hudi.org.apache.hadoop.hbase.UnknownScannerException;
import org.apache.hudi.org.apache.hadoop.hbase.client.Append;
import org.apache.hudi.org.apache.hadoop.hbase.client.CheckAndMutate;
import org.apache.hudi.org.apache.hadoop.hbase.client.CheckAndMutateResult;
import org.apache.hudi.org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hudi.org.apache.hadoop.hbase.client.Delete;
import org.apache.hudi.org.apache.hadoop.hbase.client.Durability;
import org.apache.hudi.org.apache.hadoop.hbase.client.Get;
import org.apache.hudi.org.apache.hadoop.hbase.client.Increment;
import org.apache.hudi.org.apache.hadoop.hbase.client.Mutation;
import org.apache.hudi.org.apache.hadoop.hbase.client.Put;
import org.apache.hudi.org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hudi.org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hudi.org.apache.hadoop.hbase.client.Result;
import org.apache.hudi.org.apache.hadoop.hbase.client.Row;
import org.apache.hudi.org.apache.hadoop.hbase.client.Scan;
import org.apache.hudi.org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hudi.org.apache.hadoop.hbase.client.VersionInfoUtil;
import org.apache.hudi.org.apache.hadoop.hbase.conf.ConfigurationObserver;
import org.apache.hudi.org.apache.hadoop.hbase.exceptions.FailedSanityCheckException;
import org.apache.hudi.org.apache.hadoop.hbase.exceptions.OutOfOrderScannerNextException;
import org.apache.hudi.org.apache.hadoop.hbase.exceptions.ScannerResetException;
import org.apache.hudi.org.apache.hadoop.hbase.exceptions.UnknownProtocolException;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hudi.org.apache.hadoop.hbase.ipc.HBaseRPCErrorHandler;
import org.apache.hudi.org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hudi.org.apache.hadoop.hbase.ipc.PriorityFunction;
import org.apache.hudi.org.apache.hadoop.hbase.ipc.QosPriority;
import org.apache.hudi.org.apache.hadoop.hbase.ipc.RpcCall;
import org.apache.hudi.org.apache.hadoop.hbase.ipc.RpcCallContext;
import org.apache.hudi.org.apache.hadoop.hbase.ipc.RpcCallback;
import org.apache.hudi.org.apache.hadoop.hbase.ipc.RpcScheduler;
import org.apache.hudi.org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hudi.org.apache.hadoop.hbase.ipc.RpcServerFactory;
import org.apache.hudi.org.apache.hadoop.hbase.ipc.RpcServerInterface;
import org.apache.hudi.org.apache.hadoop.hbase.ipc.ServerNotRunningYetException;
import org.apache.hudi.org.apache.hadoop.hbase.ipc.ServerRpcController;
import org.apache.hudi.org.apache.hadoop.hbase.log.HBaseMarkers;
import org.apache.hudi.org.apache.hadoop.hbase.master.HMaster;
import org.apache.hudi.org.apache.hadoop.hbase.master.MasterRpcServices;
import org.apache.hudi.org.apache.hadoop.hbase.namequeues.NamedQueuePayload;
import org.apache.hudi.org.apache.hadoop.hbase.namequeues.NamedQueueRecorder;
import org.apache.hudi.org.apache.hadoop.hbase.namequeues.request.NamedQueueGetRequest;
import org.apache.hudi.org.apache.hadoop.hbase.namequeues.response.NamedQueueGetResponse;
import org.apache.hudi.org.apache.hadoop.hbase.net.Address;
import org.apache.hudi.org.apache.hadoop.hbase.procedure2.RSProcedureCallable;
import org.apache.hudi.org.apache.hadoop.hbase.quotas.ActivePolicyEnforcement;
import org.apache.hudi.org.apache.hadoop.hbase.quotas.OperationQuota;
import org.apache.hudi.org.apache.hadoop.hbase.quotas.QuotaUtil;
import org.apache.hudi.org.apache.hadoop.hbase.quotas.RegionServerRpcQuotaManager;
import org.apache.hudi.org.apache.hadoop.hbase.quotas.RegionServerSpaceQuotaManager;
import org.apache.hudi.org.apache.hadoop.hbase.quotas.SpaceQuotaSnapshot;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.AnnotationReadingPriorityFunction;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.CompactSplit;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.FlushLifeCycleTracker;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.LeaseException;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.LeaseListener;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.LeaseManager;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.MetricsRegionServer;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.NoSuchColumnFamilyException;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.OperationStatus;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.RegionCoprocessorHost;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.RegionServerAbortedException;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.RegionServerStoppedException;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.RpcSchedulerFactory;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.ScannerIdGenerator;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.Shipper;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.SimpleRpcSchedulerFactory;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.compactions.CompactionLifeCycleTracker;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.handler.AssignRegionHandler;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.handler.OpenMetaHandler;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.handler.OpenPriorityRegionHandler;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.handler.OpenRegionHandler;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.handler.UnassignRegionHandler;
import org.apache.hudi.org.apache.hadoop.hbase.security.Superusers;
import org.apache.hudi.org.apache.hadoop.hbase.security.User;
import org.apache.hudi.org.apache.hadoop.hbase.security.access.AccessChecker;
import org.apache.hudi.org.apache.hadoop.hbase.security.access.NoopAccessChecker;
import org.apache.hudi.org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hudi.org.apache.hadoop.hbase.security.access.ZKPermissionWatcher;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.RequestConverter;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.ResponseConverter;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.ClusterStatusProtos;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.MapReduceProtos;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.QuotaProtos;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.RPCProtos;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.TooSlowLog;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.WALProtos;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.apache.hudi.org.apache.hadoop.hbase.util.DNS;
import org.apache.hudi.org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hudi.org.apache.hadoop.hbase.util.Pair;
import org.apache.hudi.org.apache.hadoop.hbase.util.ServerRegionReplicaUtil;
import org.apache.hudi.org.apache.hadoop.hbase.wal.WAL;
import org.apache.hudi.org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hudi.org.apache.hadoop.hbase.wal.WALKey;
import org.apache.hudi.org.apache.hadoop.hbase.wal.WALSplitUtil;
import org.apache.hudi.org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.common.cache.Cache;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.common.cache.CacheBuilder;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.protobuf.ByteString;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.protobuf.TextFormat;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.protobuf.UnsafeByteOperations;
import org.apache.hudi.org.apache.hbase.thirdparty.org.apache.commons.collections4.CollectionUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class RSRpcServices
implements HBaseRPCErrorHandler,
AdminProtos.AdminService.BlockingInterface,
ClientProtos.ClientService.BlockingInterface,
PriorityFunction,
ConfigurationObserver {
    protected static final Logger LOG = LoggerFactory.getLogger(RSRpcServices.class);
    public static final String REGION_SERVER_RPC_SCHEDULER_FACTORY_CLASS = "hbase.region.server.rpc.scheduler.factory.class";
    public static final String MASTER_RPC_SCHEDULER_FACTORY_CLASS = "hbase.master.rpc.scheduler.factory.class";
    private static final String REGION_SERVER_RPC_MINIMUM_SCAN_TIME_LIMIT_DELTA = "hbase.region.server.rpc.minimum.scan.time.limit.delta";
    private static final long DEFAULT_REGION_SERVER_RPC_MINIMUM_SCAN_TIME_LIMIT_DELTA = 10L;
    private static final String REJECT_BATCH_ROWS_OVER_THRESHOLD = "hbase.rpc.rows.size.threshold.reject";
    private static final boolean DEFAULT_REJECT_BATCH_ROWS_OVER_THRESHOLD = false;
    final LongAdder requestCount = new LongAdder();
    final LongAdder rpcGetRequestCount = new LongAdder();
    final LongAdder rpcScanRequestCount = new LongAdder();
    final LongAdder rpcFullScanRequestCount = new LongAdder();
    final LongAdder rpcMultiRequestCount = new LongAdder();
    final LongAdder rpcMutateRequestCount = new LongAdder();
    final RpcServerInterface rpcServer;
    final InetSocketAddress isa;
    protected final HRegionServer regionServer;
    private final long maxScannerResultSize;
    private final PriorityFunction priority;
    private ScannerIdGenerator scannerIdGenerator;
    private final ConcurrentMap<String, RegionScannerHolder> scanners = new ConcurrentHashMap<String, RegionScannerHolder>();
    private final Cache<String, String> closedScanners;
    private final int scannerLeaseTimeoutPeriod;
    private final int rpcTimeout;
    private final long minimumScanTimeLimitDelta;
    private final int rowSizeWarnThreshold;
    private final boolean rejectRowsWithSizeOverThreshold;
    final AtomicBoolean clearCompactionQueues = new AtomicBoolean(false);
    private AccessChecker accessChecker;
    private ZKPermissionWatcher zkPermissionWatcher;
    public static final String REGIONSERVER_ADMIN_SERVICE_CONFIG = "hbase.regionserver.admin.executorService";
    public static final String REGIONSERVER_CLIENT_SERVICE_CONFIG = "hbase.regionserver.client.executorService";
    @Deprecated
    private static final IOException SCANNER_ALREADY_CLOSED = new IOException(){
        private static final long serialVersionUID = -4305297078988180130L;

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    };

    private static ClientProtos.ResultOrException getResultOrException(ClientProtos.Result r, int index) {
        return RSRpcServices.getResultOrException(ResponseConverter.buildActionResult(r), index);
    }

    private static ClientProtos.ResultOrException getResultOrException(Exception e, int index) {
        return RSRpcServices.getResultOrException(ResponseConverter.buildActionResult(e), index);
    }

    private static ClientProtos.ResultOrException getResultOrException(ClientProtos.ResultOrException.Builder builder, int index) {
        return builder.setIndex(index).build();
    }

    private void rpcPreCheck(String requestName) throws ServiceException {
        try {
            this.checkOpen();
            this.requirePermission(requestName, Permission.Action.ADMIN);
        }
        catch (IOException ioe) {
            throw new ServiceException(ioe);
        }
    }

    private boolean isClientCellBlockSupport(RpcCallContext context) {
        return context != null && context.isClientCellBlockSupported();
    }

    private void addResult(ClientProtos.MutateResponse.Builder builder, Result result, HBaseRpcController rpcc, boolean clientCellBlockSupported) {
        if (result == null) {
            return;
        }
        if (clientCellBlockSupported) {
            builder.setResult(ProtobufUtil.toResultNoData(result));
            rpcc.setCellScanner(result.cellScanner());
        } else {
            ClientProtos.Result pbr = ProtobufUtil.toResult(result);
            builder.setResult(pbr);
        }
    }

    private void addResults(ClientProtos.ScanResponse.Builder builder, List<Result> results, HBaseRpcController controller, boolean isDefaultRegion, boolean clientCellBlockSupported) {
        builder.setStale(!isDefaultRegion);
        if (results.isEmpty()) {
            return;
        }
        if (clientCellBlockSupported) {
            for (Result res : results) {
                builder.addCellsPerResult(res.size());
                builder.addPartialFlagPerResult(res.mayHaveMoreCellsInRow());
            }
            controller.setCellScanner(CellUtil.createCellScanner(results));
        } else {
            for (Result res : results) {
                ClientProtos.Result pbr = ProtobufUtil.toResult(res);
                builder.addResults(pbr);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CheckAndMutateResult checkAndMutate(HRegion region, List<ClientProtos.Action> actions, CellScanner cellScanner, ClientProtos.Condition condition, long nonceGroup, ActivePolicyEnforcement spaceQuotaEnforcement) throws IOException {
        int countOfCompleteMutation = 0;
        try {
            if (!region.getRegionInfo().isMetaRegion()) {
                this.regionServer.getMemStoreFlusher().reclaimMemStoreMemory();
            }
            ArrayList<Mutation> mutations = new ArrayList<Mutation>();
            long nonce = 0L;
            block10: for (ClientProtos.Action action : actions) {
                if (action.hasGet()) {
                    throw new DoNotRetryIOException("Atomic put and/or delete only, not a Get=" + action.getGet());
                }
                ClientProtos.MutationProto mutation = action.getMutation();
                ClientProtos.MutationProto.MutationType type = mutation.getMutateType();
                switch (type) {
                    case PUT: {
                        Put put = ProtobufUtil.toPut(mutation, cellScanner);
                        ++countOfCompleteMutation;
                        this.checkCellSizeLimit(region, put);
                        spaceQuotaEnforcement.getPolicyEnforcement(region).check(put);
                        mutations.add(put);
                        continue block10;
                    }
                    case DELETE: {
                        Delete del = ProtobufUtil.toDelete(mutation, cellScanner);
                        ++countOfCompleteMutation;
                        spaceQuotaEnforcement.getPolicyEnforcement(region).check(del);
                        mutations.add(del);
                        continue block10;
                    }
                    case INCREMENT: {
                        Increment increment = ProtobufUtil.toIncrement(mutation, cellScanner);
                        nonce = mutation.hasNonce() ? mutation.getNonce() : 0L;
                        ++countOfCompleteMutation;
                        this.checkCellSizeLimit(region, increment);
                        spaceQuotaEnforcement.getPolicyEnforcement(region).check(increment);
                        mutations.add(increment);
                        continue block10;
                    }
                    case APPEND: {
                        Append append = ProtobufUtil.toAppend(mutation, cellScanner);
                        nonce = mutation.hasNonce() ? mutation.getNonce() : 0L;
                        ++countOfCompleteMutation;
                        this.checkCellSizeLimit(region, append);
                        spaceQuotaEnforcement.getPolicyEnforcement(region).check(append);
                        mutations.add(append);
                        continue block10;
                    }
                }
                throw new DoNotRetryIOException("invalid mutation type : " + type);
            }
            if (mutations.size() == 0) {
                CheckAndMutateResult checkAndMutateResult = new CheckAndMutateResult(true, null);
                return checkAndMutateResult;
            }
            CheckAndMutate checkAndMutate = ProtobufUtil.toCheckAndMutate(condition, mutations);
            CheckAndMutateResult result = null;
            if (region.getCoprocessorHost() != null) {
                result = region.getCoprocessorHost().preCheckAndMutate(checkAndMutate);
            }
            if (result == null) {
                result = region.checkAndMutate(checkAndMutate, nonceGroup, nonce);
                if (region.getCoprocessorHost() != null) {
                    result = region.getCoprocessorHost().postCheckAndMutate(checkAndMutate, result);
                }
            }
            CheckAndMutateResult checkAndMutateResult = result;
            return checkAndMutateResult;
        }
        finally {
            for (int i = countOfCompleteMutation; i < actions.size(); ++i) {
                this.skipCellsForMutation(actions.get(i), cellScanner);
            }
        }
    }

    private Result append(HRegion region, OperationQuota quota, ClientProtos.MutationProto mutation, CellScanner cellScanner, long nonceGroup, ActivePolicyEnforcement spaceQuota) throws IOException {
        long before = EnvironmentEdgeManager.currentTime();
        Append append = ProtobufUtil.toAppend(mutation, cellScanner);
        this.checkCellSizeLimit(region, append);
        spaceQuota.getPolicyEnforcement(region).check(append);
        quota.addMutation(append);
        long nonce = mutation.hasNonce() ? mutation.getNonce() : 0L;
        Result r = region.append(append, nonceGroup, nonce);
        if (this.regionServer.getMetrics() != null) {
            this.regionServer.getMetrics().updateAppend(region.getTableDescriptor().getTableName(), EnvironmentEdgeManager.currentTime() - before);
        }
        return r == null ? Result.EMPTY_RESULT : r;
    }

    private Result increment(HRegion region, OperationQuota quota, ClientProtos.MutationProto mutation, CellScanner cells, long nonceGroup, ActivePolicyEnforcement spaceQuota) throws IOException {
        long before = EnvironmentEdgeManager.currentTime();
        Increment increment = ProtobufUtil.toIncrement(mutation, cells);
        this.checkCellSizeLimit(region, increment);
        spaceQuota.getPolicyEnforcement(region).check(increment);
        quota.addMutation(increment);
        long nonce = mutation.hasNonce() ? mutation.getNonce() : 0L;
        Result r = region.increment(increment, nonceGroup, nonce);
        MetricsRegionServer metricsRegionServer = this.regionServer.getMetrics();
        if (metricsRegionServer != null) {
            metricsRegionServer.updateIncrement(region.getTableDescriptor().getTableName(), EnvironmentEdgeManager.currentTime() - before);
        }
        return r == null ? Result.EMPTY_RESULT : r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<CellScannable> doNonAtomicRegionMutation(HRegion region, OperationQuota quota, ClientProtos.RegionAction actions, CellScanner cellScanner, ClientProtos.RegionActionResult.Builder builder, List<CellScannable> cellsToReturn, long nonceGroup, RegionScannersCloseCallBack closeCallBack, RpcCallContext context, ActivePolicyEnforcement spaceQuotaEnforcement) {
        ArrayList<ClientProtos.Action> mutations = null;
        long maxQuotaResultSize = Math.min(this.maxScannerResultSize, quota.getReadAvailable());
        MultiActionResultTooLarge sizeIOE = null;
        Object lastBlock = null;
        ClientProtos.ResultOrException.Builder resultOrExceptionBuilder = ClientProtos.ResultOrException.newBuilder();
        boolean hasResultOrException = false;
        for (ClientProtos.Action action : actions.getActionList()) {
            HBaseProtos.NameBytesPair pair;
            hasResultOrException = false;
            resultOrExceptionBuilder.clear();
            try {
                Result r = null;
                if (context != null && context.isRetryImmediatelySupported() && (context.getResponseCellSize() > maxQuotaResultSize || context.getResponseBlockSize() + context.getResponseExceptionSize() > maxQuotaResultSize)) {
                    if (sizeIOE == null) {
                        sizeIOE = new MultiActionResultTooLarge("Max size exceeded CellSize: " + context.getResponseCellSize() + " BlockSize: " + context.getResponseBlockSize());
                        this.rpcServer.getMetrics().exception(sizeIOE);
                    }
                    pair = ResponseConverter.buildException(sizeIOE);
                    resultOrExceptionBuilder.setException(pair);
                    context.incrementResponseExceptionSize(pair.getSerializedSize());
                    resultOrExceptionBuilder.setIndex(action.getIndex());
                    builder.addResultOrException(resultOrExceptionBuilder.build());
                    this.skipCellsForMutation(action, cellScanner);
                    continue;
                }
                if (action.hasGet()) {
                    long before = EnvironmentEdgeManager.currentTime();
                    ClientProtos.Get pbGet = action.getGet();
                    if (pbGet.hasClosestRowBefore() && pbGet.getClosestRowBefore()) {
                        throw new UnknownProtocolException("Is this a pre-hbase-1.0.0 or asynchbase client? Client is invoking getClosestRowBefore removed in hbase-2.0.0 replaced by reverse Scan.");
                    }
                    try {
                        Get get = ProtobufUtil.toGet(pbGet);
                        if (context != null) {
                            r = this.get(get, region, closeCallBack, context);
                        }
                        r = region.get(get);
                    }
                    finally {
                        MetricsRegionServer metricsRegionServer = this.regionServer.getMetrics();
                        if (metricsRegionServer != null) {
                            metricsRegionServer.updateGet(region.getTableDescriptor().getTableName(), EnvironmentEdgeManager.currentTime() - before);
                        }
                    }
                } else if (action.hasServiceCall()) {
                    hasResultOrException = true;
                    Message result = this.execServiceOnRegion(region, action.getServiceCall());
                    ClientProtos.CoprocessorServiceResult.Builder serviceResultBuilder = ClientProtos.CoprocessorServiceResult.newBuilder();
                    resultOrExceptionBuilder.setServiceResult(serviceResultBuilder.setValue(serviceResultBuilder.getValueBuilder().setName(result.getClass().getName()).setValue(UnsafeByteOperations.unsafeWrap(result.toByteArray()))));
                } else if (action.hasMutation()) {
                    ClientProtos.MutationProto.MutationType type = action.getMutation().getMutateType();
                    if (type != ClientProtos.MutationProto.MutationType.PUT && type != ClientProtos.MutationProto.MutationType.DELETE && mutations != null && !mutations.isEmpty()) {
                        this.doNonAtomicBatchOp(builder, region, quota, mutations, cellScanner, spaceQuotaEnforcement);
                        mutations.clear();
                    }
                    switch (type) {
                        case APPEND: {
                            r = this.append(region, quota, action.getMutation(), cellScanner, nonceGroup, spaceQuotaEnforcement);
                            break;
                        }
                        case INCREMENT: {
                            r = this.increment(region, quota, action.getMutation(), cellScanner, nonceGroup, spaceQuotaEnforcement);
                            break;
                        }
                        case PUT: 
                        case DELETE: {
                            if (mutations == null) {
                                mutations = new ArrayList<ClientProtos.Action>(actions.getActionCount());
                            }
                            mutations.add(action);
                            break;
                        }
                        default: {
                            throw new DoNotRetryIOException("Unsupported mutate type: " + type.name());
                        }
                    }
                } else {
                    throw new HBaseIOException("Unexpected Action type");
                }
                if (r != null) {
                    ClientProtos.Result pbResult = null;
                    if (this.isClientCellBlockSupport(context)) {
                        pbResult = ProtobufUtil.toResultNoData(r);
                        if (cellsToReturn == null) {
                            cellsToReturn = new ArrayList<CellScannable>();
                        }
                        cellsToReturn.add(r);
                    } else {
                        pbResult = ProtobufUtil.toResult(r);
                    }
                    lastBlock = this.addSize(context, r, lastBlock);
                    hasResultOrException = true;
                    resultOrExceptionBuilder.setResult(pbResult);
                }
            }
            catch (IOException ie) {
                this.rpcServer.getMetrics().exception(ie);
                hasResultOrException = true;
                pair = ResponseConverter.buildException(ie);
                resultOrExceptionBuilder.setException(pair);
                context.incrementResponseExceptionSize(pair.getSerializedSize());
            }
            if (!hasResultOrException) continue;
            resultOrExceptionBuilder.setIndex(action.getIndex());
            builder.addResultOrException(resultOrExceptionBuilder.build());
        }
        if (!CollectionUtils.isEmpty(mutations)) {
            this.doNonAtomicBatchOp(builder, region, quota, mutations, cellScanner, spaceQuotaEnforcement);
        }
        return cellsToReturn;
    }

    private void checkCellSizeLimit(HRegion r, Mutation m) throws IOException {
        if (r.maxCellSize > 0L) {
            CellScanner cells = m.cellScanner();
            while (cells.advance()) {
                int size = PrivateCellUtil.estimatedSerializedSizeOf(cells.current());
                if ((long)size <= r.maxCellSize) continue;
                String msg = "Cell[" + cells.current() + "] with size " + size + " exceeds limit of " + r.maxCellSize + " bytes";
                LOG.debug(msg);
                throw new DoNotRetryIOException(msg);
            }
        }
    }

    private void doAtomicBatchOp(ClientProtos.RegionActionResult.Builder builder, HRegion region, OperationQuota quota, List<ClientProtos.Action> mutations, CellScanner cells, long nonceGroup, ActivePolicyEnforcement spaceQuotaEnforcement) throws IOException {
        this.doBatchOp(builder, region, quota, mutations, cells, nonceGroup, spaceQuotaEnforcement, true);
    }

    private void doNonAtomicBatchOp(ClientProtos.RegionActionResult.Builder builder, HRegion region, OperationQuota quota, List<ClientProtos.Action> mutations, CellScanner cells, ActivePolicyEnforcement spaceQuotaEnforcement) {
        try {
            this.doBatchOp(builder, region, quota, mutations, cells, 0L, spaceQuotaEnforcement, false);
        }
        catch (IOException e) {
            for (ClientProtos.Action mutation : mutations) {
                builder.addResultOrException(RSRpcServices.getResultOrException(e, mutation.getIndex()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doBatchOp(ClientProtos.RegionActionResult.Builder builder, HRegion region, OperationQuota quota, List<ClientProtos.Action> mutations, CellScanner cells, long nonceGroup, ActivePolicyEnforcement spaceQuotaEnforcement, boolean atomic) throws IOException {
        OperationStatus[] codes;
        int i;
        HashMap<Put, ClientProtos.Action> mutationActionMap;
        boolean batchContainsDelete;
        boolean batchContainsPuts;
        long before;
        Mutation[] mArray;
        block28: {
            mArray = new Mutation[mutations.size()];
            before = EnvironmentEdgeManager.currentTime();
            batchContainsPuts = false;
            batchContainsDelete = false;
            mutationActionMap = new HashMap<Put, ClientProtos.Action>();
            i = 0;
            long nonce = 0L;
            for (ClientProtos.Action action : mutations) {
                Mutation mutation;
                if (action.hasGet()) {
                    throw new DoNotRetryIOException("Atomic put and/or delete only, not a Get=" + action.getGet());
                }
                ClientProtos.MutationProto m = action.getMutation();
                switch (m.getMutateType()) {
                    case PUT: {
                        mutation = ProtobufUtil.toPut(m, cells);
                        batchContainsPuts = true;
                        break;
                    }
                    case DELETE: {
                        mutation = ProtobufUtil.toDelete(m, cells);
                        batchContainsDelete = true;
                        break;
                    }
                    case INCREMENT: {
                        mutation = ProtobufUtil.toIncrement(m, cells);
                        nonce = m.hasNonce() ? m.getNonce() : 0L;
                        break;
                    }
                    case APPEND: {
                        mutation = ProtobufUtil.toAppend(m, cells);
                        nonce = m.hasNonce() ? m.getNonce() : 0L;
                        break;
                    }
                    default: {
                        throw new DoNotRetryIOException("Invalid mutation type : " + m.getMutateType());
                    }
                }
                mutationActionMap.put((Put)mutation, action);
                mArray[i++] = mutation;
                this.checkCellSizeLimit(region, mutation);
                spaceQuotaEnforcement.getPolicyEnforcement(region).check(mutation);
                quota.addMutation(mutation);
            }
            if (!region.getRegionInfo().isMetaRegion()) {
                this.regionServer.getMemStoreFlusher().reclaimMemStoreMemory();
            }
            if (!atomic) {
                Arrays.sort(mArray, (v1, v2) -> Row.COMPARATOR.compare((Row)v1, (Row)v2));
            }
            codes = region.batchMutate(mArray, atomic, nonceGroup, nonce);
            if (!atomic) break block28;
            ArrayList<ClientProtos.ResultOrException> resultOrExceptions = new ArrayList<ClientProtos.ResultOrException>();
            ArrayList<Result> results = new ArrayList<Result>();
            for (i = 0; i < codes.length; ++i) {
                if (codes[i].getResult() != null) {
                    results.add(codes[i].getResult());
                }
                if (i == 0) continue;
                resultOrExceptions.add(RSRpcServices.getResultOrException(ClientProtos.Result.getDefaultInstance(), i));
            }
            if (results.isEmpty()) {
                builder.addResultOrException(RSRpcServices.getResultOrException(ClientProtos.Result.getDefaultInstance(), 0));
            } else {
                ArrayList<Cell> cellList = new ArrayList<Cell>();
                for (Result result : results) {
                    if (result.rawCells() == null) continue;
                    cellList.addAll(Arrays.asList(result.rawCells()));
                }
                Result result = Result.create(cellList);
                builder.addResultOrException(RSRpcServices.getResultOrException(ProtobufUtil.toResult(result), 0));
            }
            builder.addAllResultOrException(resultOrExceptions);
            int processedMutationIndex = 0;
            for (ClientProtos.Action mutation : mutations) {
                if (mArray[processedMutationIndex++] != null) continue;
                this.skipCellsForMutation(mutation, cells);
            }
            this.updateMutationMetrics(region, before, batchContainsPuts, batchContainsDelete);
            return;
        }
        try {
            block20: for (i = 0; i < codes.length; ++i) {
                Mutation currentMutation = mArray[i];
                ClientProtos.Action currentAction = (ClientProtos.Action)mutationActionMap.get(currentMutation);
                int index = currentAction.hasIndex() ? currentAction.getIndex() : i;
                switch (codes[i].getOperationStatusCode()) {
                    case BAD_FAMILY: {
                        IOException e = new NoSuchColumnFamilyException(codes[i].getExceptionMsg());
                        builder.addResultOrException(RSRpcServices.getResultOrException(e, index));
                        continue block20;
                    }
                    case SANITY_CHECK_FAILURE: {
                        IOException e = new FailedSanityCheckException(codes[i].getExceptionMsg());
                        builder.addResultOrException(RSRpcServices.getResultOrException(e, index));
                        continue block20;
                    }
                    default: {
                        IOException e = new DoNotRetryIOException(codes[i].getExceptionMsg());
                        builder.addResultOrException(RSRpcServices.getResultOrException(e, index));
                        continue block20;
                    }
                    case SUCCESS: {
                        builder.addResultOrException(RSRpcServices.getResultOrException(ClientProtos.Result.getDefaultInstance(), index));
                        continue block20;
                    }
                    case STORE_TOO_BUSY: {
                        IOException e = new RegionTooBusyException(codes[i].getExceptionMsg());
                        builder.addResultOrException(RSRpcServices.getResultOrException(e, index));
                    }
                }
            }
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            int processedMutationIndex = 0;
            for (ClientProtos.Action mutation : mutations) {
                if (mArray[processedMutationIndex++] != null) continue;
                this.skipCellsForMutation(mutation, cells);
            }
            this.updateMutationMetrics(region, before, batchContainsPuts, batchContainsDelete);
        }
    }

    private void updateMutationMetrics(HRegion region, long starttime, boolean batchContainsPuts, boolean batchContainsDelete) {
        MetricsRegionServer metricsRegionServer = this.regionServer.getMetrics();
        if (metricsRegionServer != null) {
            long after = EnvironmentEdgeManager.currentTime();
            if (batchContainsPuts) {
                metricsRegionServer.updatePutBatch(region.getTableDescriptor().getTableName(), after - starttime);
            }
            if (batchContainsDelete) {
                metricsRegionServer.updateDeleteBatch(region.getTableDescriptor().getTableName(), after - starttime);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationStatus[] doReplayBatchOp(HRegion region, List<WALSplitUtil.MutationReplay> mutations, long replaySeqId) throws IOException {
        long before = EnvironmentEdgeManager.currentTime();
        boolean batchContainsPuts = false;
        boolean batchContainsDelete = false;
        try {
            Iterator<WALSplitUtil.MutationReplay> it = mutations.iterator();
            while (it.hasNext()) {
                NavigableMap<byte[], List<Cell>> map;
                List metaCells;
                WALSplitUtil.MutationReplay m = it.next();
                if (m.getType() == ClientProtos.MutationProto.MutationType.PUT) {
                    batchContainsPuts = true;
                } else {
                    batchContainsDelete = true;
                }
                if ((metaCells = (List)(map = m.mutation.getFamilyCellMap()).get(WALEdit.METAFAMILY)) == null || metaCells.isEmpty()) continue;
                for (Cell metaCell : metaCells) {
                    WALProtos.CompactionDescriptor compactionDesc = WALEdit.getCompaction(metaCell);
                    boolean isDefaultReplica = RegionReplicaUtil.isDefaultReplica(region.getRegionInfo());
                    HRegion hRegion = region;
                    if (compactionDesc != null) {
                        hRegion.replayWALCompactionMarker(compactionDesc, !isDefaultReplica, isDefaultReplica, replaySeqId);
                        continue;
                    }
                    WALProtos.FlushDescriptor flushDesc = WALEdit.getFlushDescriptor(metaCell);
                    if (flushDesc != null && !isDefaultReplica) {
                        hRegion.replayWALFlushMarker(flushDesc, replaySeqId);
                        continue;
                    }
                    WALProtos.RegionEventDescriptor regionEvent = WALEdit.getRegionEventDescriptor(metaCell);
                    if (regionEvent != null && !isDefaultReplica) {
                        hRegion.replayWALRegionEventMarker(regionEvent);
                        continue;
                    }
                    WALProtos.BulkLoadDescriptor bulkLoadEvent = WALEdit.getBulkLoadDescriptor(metaCell);
                    if (bulkLoadEvent == null) continue;
                    hRegion.replayWALBulkLoadEventMarker(bulkLoadEvent);
                }
                it.remove();
            }
            this.requestCount.increment();
            if (!region.getRegionInfo().isMetaRegion()) {
                this.regionServer.getMemStoreFlusher().reclaimMemStoreMemory();
            }
            OperationStatus[] operationStatusArray = region.batchReplay(mutations.toArray(new WALSplitUtil.MutationReplay[mutations.size()]), replaySeqId);
            return operationStatusArray;
        }
        finally {
            this.updateMutationMetrics(region, before, batchContainsPuts, batchContainsDelete);
        }
    }

    private void closeAllScanners() {
        for (Map.Entry e : this.scanners.entrySet()) {
            try {
                ((RegionScannerHolder)e.getValue()).s.close();
            }
            catch (IOException ioe) {
                LOG.warn("Closing scanner " + (String)e.getKey(), (Throwable)ioe);
            }
        }
    }

    public RSRpcServices(HRegionServer rs) throws IOException {
        InetSocketAddress bindAddress;
        InetSocketAddress initialIsa;
        int port;
        String hostname;
        RpcSchedulerFactory rpcSchedulerFactory;
        Configuration conf = rs.getConfiguration();
        this.regionServer = rs;
        this.rowSizeWarnThreshold = conf.getInt("hbase.rpc.rows.warning.threshold", 5000);
        this.rejectRowsWithSizeOverThreshold = conf.getBoolean(REJECT_BATCH_ROWS_OVER_THRESHOLD, false);
        try {
            rpcSchedulerFactory = this.getRpcSchedulerFactoryClass().asSubclass(RpcSchedulerFactory.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
        if (this instanceof MasterRpcServices) {
            hostname = DNS.getHostname(conf, DNS.ServerType.MASTER);
            port = conf.getInt("hbase.master.port", 16000);
            initialIsa = new InetSocketAddress(hostname, port);
            bindAddress = new InetSocketAddress(conf.get("hbase.master.ipc.address", hostname), port);
        } else {
            hostname = DNS.getHostname(conf, DNS.ServerType.REGIONSERVER);
            port = conf.getInt("hbase.regionserver.port", 16020);
            initialIsa = new InetSocketAddress(hostname, port);
            bindAddress = new InetSocketAddress(conf.get("hbase.regionserver.ipc.address", hostname), port);
        }
        if (initialIsa.getAddress() == null) {
            throw new IllegalArgumentException("Failed resolve of " + initialIsa);
        }
        this.priority = this.createPriority();
        String name = rs.getProcessName() + "/" + Address.fromParts(initialIsa.getHostName(), initialIsa.getPort()).toStringWithoutDomain();
        ConnectionUtils.setServerSideHConnectionRetriesConfig(conf, name, LOG);
        this.rpcServer = this.createRpcServer(rs, rpcSchedulerFactory, bindAddress, name);
        this.rpcServer.setRsRpcServices(this);
        if (!(rs instanceof HMaster)) {
            this.rpcServer.setNamedQueueRecorder(rs.getNamedQueueRecorder());
        }
        this.scannerLeaseTimeoutPeriod = conf.getInt("hbase.client.scanner.timeout.period", 60000);
        this.maxScannerResultSize = conf.getLong("hbase.server.scanner.max.result.size", 0x6400000L);
        this.rpcTimeout = conf.getInt("hbase.rpc.timeout", 60000);
        this.minimumScanTimeLimitDelta = conf.getLong(REGION_SERVER_RPC_MINIMUM_SCAN_TIME_LIMIT_DELTA, 10L);
        InetSocketAddress address = this.rpcServer.getListenerAddress();
        if (address == null) {
            throw new IOException("Listener channel is closed");
        }
        this.isa = new InetSocketAddress(initialIsa.getHostName(), address.getPort());
        this.rpcServer.setErrorHandler(this);
        rs.setName(name);
        this.closedScanners = CacheBuilder.newBuilder().expireAfterAccess(this.scannerLeaseTimeoutPeriod, TimeUnit.MILLISECONDS).build();
    }

    protected RpcServerInterface createRpcServer(Server server, RpcSchedulerFactory rpcSchedulerFactory, InetSocketAddress bindAddress, String name) throws IOException {
        Configuration conf = server.getConfiguration();
        boolean reservoirEnabled = conf.getBoolean("hbase.server.allocator.pool.enabled", true);
        try {
            return RpcServerFactory.createRpcServer(server, name, this.getServices(), bindAddress, conf, rpcSchedulerFactory.create(conf, this, server), reservoirEnabled);
        }
        catch (BindException be) {
            throw new IOException(be.getMessage() + ". To switch ports use the '" + "hbase.regionserver.port" + "' configuration property.", be.getCause() != null ? be.getCause() : be);
        }
    }

    protected Class<?> getRpcSchedulerFactoryClass() {
        Configuration conf = this.regionServer.getConfiguration();
        return conf.getClass(REGION_SERVER_RPC_SCHEDULER_FACTORY_CLASS, SimpleRpcSchedulerFactory.class);
    }

    @Override
    public void onConfigurationChange(Configuration newConf) {
        if (this.rpcServer instanceof ConfigurationObserver) {
            ((ConfigurationObserver)((Object)this.rpcServer)).onConfigurationChange(newConf);
        }
    }

    protected PriorityFunction createPriority() {
        return new AnnotationReadingPriorityFunction(this);
    }

    protected void requirePermission(String request, Permission.Action perm) throws IOException {
        if (this.accessChecker != null) {
            this.accessChecker.requirePermission(RpcServer.getRequestUser().orElse(null), request, null, perm);
        }
    }

    public int getScannersCount() {
        return this.scanners.size();
    }

    RegionScanner getScanner(long scannerId) {
        RegionScannerHolder rsh = this.getRegionScannerHolder(scannerId);
        return rsh == null ? null : rsh.s;
    }

    private RegionScannerHolder getRegionScannerHolder(long scannerId) {
        return (RegionScannerHolder)this.scanners.get(RSRpcServices.toScannerName(scannerId));
    }

    public String getScanDetailsWithId(long scannerId) {
        RegionScanner scanner = this.getScanner(scannerId);
        if (scanner == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("table: ").append(scanner.getRegionInfo().getTable().getNameAsString());
        builder.append(" region: ").append(scanner.getRegionInfo().getRegionNameAsString());
        return builder.toString();
    }

    public String getScanDetailsWithRequest(ClientProtos.ScanRequest request) {
        try {
            if (!request.hasRegion()) {
                return null;
            }
            HRegion region = this.getRegion(request.getRegion());
            StringBuilder builder = new StringBuilder();
            builder.append("table: ").append(region.getRegionInfo().getTable().getNameAsString());
            builder.append(" region: ").append(region.getRegionInfo().getRegionNameAsString());
            return builder.toString();
        }
        catch (IOException ignored) {
            return null;
        }
    }

    long getScannerVirtualTime(long scannerId) {
        RegionScannerHolder rsh = this.getRegionScannerHolder(scannerId);
        return rsh == null ? 0L : rsh.getNextCallSeq();
    }

    Object addSize(RpcCallContext context, Result r, Object lastBlock) {
        if (context != null && r != null && !r.isEmpty()) {
            for (Cell c : r.rawCells()) {
                context.incrementResponseCellSize(PrivateCellUtil.estimatedSerializedSizeOf(c));
                if (c instanceof ByteBufferExtendedCell) {
                    ByteBufferExtendedCell bbCell = (ByteBufferExtendedCell)c;
                    ByteBuffer bb = bbCell.getValueByteBuffer();
                    if (bb == lastBlock) continue;
                    context.incrementResponseBlockSize(bb.capacity());
                    lastBlock = bb;
                    continue;
                }
                byte[] valueArray = c.getValueArray();
                if (valueArray == lastBlock) continue;
                context.incrementResponseBlockSize(valueArray.length);
                lastBlock = valueArray;
            }
        }
        return lastBlock;
    }

    @RestrictedApi(explanation="Should only be called in TestRSRpcServices and RSRpcServices", link="", allowedOnPath=".*(TestRSRpcServices|RSRpcServices).java")
    static String getRemoteClientIpAndPort() {
        RpcCall rpcCall = RpcServer.getCurrentCall().orElse(null);
        if (rpcCall == null) {
            return "";
        }
        InetAddress address = rpcCall.getRemoteAddress();
        if (address == null) {
            return "";
        }
        return Address.fromParts(address.getHostAddress(), rpcCall.getRemotePort()).toString();
    }

    @RestrictedApi(explanation="Should only be called in TestRSRpcServices and RSRpcServices", link="", allowedOnPath=".*(TestRSRpcServices|RSRpcServices).java")
    static String getUserName() {
        RpcCall rpcCall = RpcServer.getCurrentCall().orElse(null);
        if (rpcCall == null) {
            return "";
        }
        return rpcCall.getRequestUserName().orElse("");
    }

    private RegionScannerHolder addScanner(String scannerName, RegionScanner s, Shipper shipper, HRegion r, boolean needCursor, boolean fullRegionScan) throws LeaseManager.LeaseStillHeldException {
        LeaseManager.Lease lease = this.regionServer.getLeaseManager().createLease(scannerName, this.scannerLeaseTimeoutPeriod, new ScannerListener(scannerName));
        RegionScannerShippedCallBack shippedCallback = new RegionScannerShippedCallBack(scannerName, shipper, lease);
        RpcCallback closeCallback = s instanceof RpcCallback ? (RpcCallback)((Object)s) : new RegionScannerCloseCallBack(s);
        RegionScannerHolder rsh = new RegionScannerHolder(s, r, closeCallback, shippedCallback, needCursor, fullRegionScan, RSRpcServices.getRemoteClientIpAndPort(), RSRpcServices.getUserName());
        RegionScannerHolder existing = this.scanners.putIfAbsent(scannerName, rsh);
        assert (existing == null) : "scannerId must be unique within regionserver's whole lifecycle! " + scannerName + ", " + existing;
        return rsh;
    }

    private boolean isFullRegionScan(Scan scan, HRegion region) {
        return Bytes.compareTo(scan.getStartRow(), region.getRegionInfo().getStartKey()) <= 0 && (Bytes.compareTo(scan.getStopRow(), region.getRegionInfo().getEndKey()) >= 0 && !Bytes.equals(region.getRegionInfo().getEndKey(), HConstants.EMPTY_END_ROW) || Bytes.equals(scan.getStopRow(), HConstants.EMPTY_END_ROW));
    }

    public HRegion getRegion(HBaseProtos.RegionSpecifier regionSpecifier) throws IOException {
        return this.regionServer.getRegion(regionSpecifier.getValue().toByteArray());
    }

    private List<HRegion> getRegions(List<HBaseProtos.RegionSpecifier> regionSpecifiers, CacheEvictionStatsBuilder stats) {
        ArrayList<HRegion> regions = Lists.newArrayListWithCapacity(regionSpecifiers.size());
        for (HBaseProtos.RegionSpecifier regionSpecifier : regionSpecifiers) {
            try {
                regions.add(this.regionServer.getRegion(regionSpecifier.getValue().toByteArray()));
            }
            catch (NotServingRegionException e) {
                stats.addException(regionSpecifier.getValue().toByteArray(), e);
            }
        }
        return regions;
    }

    public PriorityFunction getPriority() {
        return this.priority;
    }

    public Configuration getConfiguration() {
        return this.regionServer.getConfiguration();
    }

    private RegionServerRpcQuotaManager getRpcQuotaManager() {
        return this.regionServer.getRegionServerRpcQuotaManager();
    }

    private RegionServerSpaceQuotaManager getSpaceQuotaManager() {
        return this.regionServer.getRegionServerSpaceQuotaManager();
    }

    void start(ZKWatcher zkWatcher) {
        this.accessChecker = AccessChecker.isAuthorizationSupported(this.getConfiguration()) ? new AccessChecker(this.getConfiguration()) : new NoopAccessChecker(this.getConfiguration());
        this.zkPermissionWatcher = new ZKPermissionWatcher(zkWatcher, this.accessChecker.getAuthManager(), this.getConfiguration());
        try {
            this.zkPermissionWatcher.start();
        }
        catch (KeeperException e) {
            LOG.error("ZooKeeper permission watcher initialization failed", (Throwable)e);
        }
        this.scannerIdGenerator = new ScannerIdGenerator(this.regionServer.serverName);
        this.rpcServer.start();
    }

    void stop() {
        if (this.zkPermissionWatcher != null) {
            this.zkPermissionWatcher.close();
        }
        this.closeAllScanners();
        this.rpcServer.stop();
    }

    protected void checkOpen() throws IOException {
        if (this.regionServer.isAborted()) {
            throw new RegionServerAbortedException("Server " + this.regionServer.serverName + " aborting");
        }
        if (this.regionServer.isStopped()) {
            throw new RegionServerStoppedException("Server " + this.regionServer.serverName + " stopping");
        }
        if (!this.regionServer.isDataFileSystemOk()) {
            throw new RegionServerStoppedException("File system not available");
        }
        if (!this.regionServer.isOnline()) {
            throw new ServerNotRunningYetException("Server " + this.regionServer.serverName + " is not running yet");
        }
    }

    protected List<RpcServer.BlockingServiceAndInterface> getServices() {
        boolean admin = this.getConfiguration().getBoolean(REGIONSERVER_ADMIN_SERVICE_CONFIG, true);
        boolean client = this.getConfiguration().getBoolean(REGIONSERVER_CLIENT_SERVICE_CONFIG, true);
        ArrayList<RpcServer.BlockingServiceAndInterface> bssi = new ArrayList<RpcServer.BlockingServiceAndInterface>();
        if (client) {
            bssi.add(new RpcServer.BlockingServiceAndInterface(ClientProtos.ClientService.newReflectiveBlockingService(this), ClientProtos.ClientService.BlockingInterface.class));
        }
        if (admin) {
            bssi.add(new RpcServer.BlockingServiceAndInterface(AdminProtos.AdminService.newReflectiveBlockingService(this), AdminProtos.AdminService.BlockingInterface.class));
        }
        return ((ImmutableList.Builder)new ImmutableList.Builder().addAll(bssi)).build();
    }

    public InetSocketAddress getSocketAddress() {
        return this.isa;
    }

    @Override
    public int getPriority(RPCProtos.RequestHeader header, org.apache.hudi.org.apache.hbase.thirdparty.com.google.protobuf.Message param, User user) {
        return this.priority.getPriority(header, param, user);
    }

    @Override
    public long getDeadline(RPCProtos.RequestHeader header, org.apache.hudi.org.apache.hbase.thirdparty.com.google.protobuf.Message param) {
        return this.priority.getDeadline(header, param);
    }

    @Override
    public boolean checkOOME(Throwable e) {
        return RSRpcServices.exitIfOOME(e);
    }

    public static boolean exitIfOOME(Throwable e) {
        boolean stop = false;
        try {
            if (e instanceof OutOfMemoryError || e.getCause() != null && e.getCause() instanceof OutOfMemoryError || e.getMessage() != null && e.getMessage().contains("java.lang.OutOfMemoryError")) {
                stop = true;
                LOG.error(HBaseMarkers.FATAL, "Run out of memory; " + RSRpcServices.class.getSimpleName() + " will abort itself immediately", e);
            }
        }
        finally {
            if (stop) {
                Runtime.getRuntime().halt(1);
            }
        }
        return stop;
    }

    @Override
    @QosPriority(priority=100)
    public AdminProtos.CloseRegionResponse closeRegion(RpcController controller, AdminProtos.CloseRegionRequest request) throws ServiceException {
        ServerName sn = request.hasDestinationServer() ? ProtobufUtil.toServerName(request.getDestinationServer()) : null;
        try {
            this.checkOpen();
            this.throwOnWrongStartCode(request);
            String encodedRegionName = ProtobufUtil.getRegionEncodedName(request.getRegion());
            this.requestCount.increment();
            if (sn == null) {
                LOG.info("Close " + encodedRegionName + " without moving");
            } else {
                LOG.info("Close " + encodedRegionName + ", moving to " + sn);
            }
            boolean closed = this.regionServer.closeRegion(encodedRegionName, false, sn);
            AdminProtos.CloseRegionResponse.Builder builder = AdminProtos.CloseRegionResponse.newBuilder().setClosed(closed);
            return builder.build();
        }
        catch (IOException ie) {
            throw new ServiceException(ie);
        }
    }

    @Override
    @QosPriority(priority=100)
    public AdminProtos.CompactRegionResponse compactRegion(RpcController controller, AdminProtos.CompactRegionRequest request) throws ServiceException {
        try {
            boolean major;
            this.checkOpen();
            this.requestCount.increment();
            HRegion region = this.getRegion(request.getRegion());
            if (QuotaUtil.isQuotaEnabled(this.getConfiguration()) && !Superusers.isSuperUser(RpcServer.getRequestUser().orElse(null)) && this.regionServer.getRegionServerSpaceQuotaManager().areCompactionsDisabled(region.getTableDescriptor().getTableName())) {
                throw new DoNotRetryIOException("Compactions on this region are disabled due to a space quota violation.");
            }
            region.startRegionOperation(Region.Operation.COMPACT_REGION);
            LOG.info("Compacting " + region.getRegionInfo().getRegionNameAsString());
            boolean bl = major = request.hasMajor() && request.getMajor();
            if (request.hasFamily()) {
                byte[] family = request.getFamily().toByteArray();
                String log = "User-triggered " + (major ? "major " : "") + "compaction for region " + region.getRegionInfo().getRegionNameAsString() + " and family " + Bytes.toString(family);
                LOG.trace(log);
                region.requestCompaction(family, log, 1, major, CompactionLifeCycleTracker.DUMMY);
            } else {
                String log = "User-triggered " + (major ? "major " : "") + "compaction for region " + region.getRegionInfo().getRegionNameAsString();
                LOG.trace(log);
                region.requestCompaction(log, 1, major, CompactionLifeCycleTracker.DUMMY);
            }
            return AdminProtos.CompactRegionResponse.newBuilder().build();
        }
        catch (IOException ie) {
            throw new ServiceException(ie);
        }
    }

    @Override
    public AdminProtos.CompactionSwitchResponse compactionSwitch(RpcController controller, AdminProtos.CompactionSwitchRequest request) throws ServiceException {
        this.rpcPreCheck("compactionSwitch");
        CompactSplit compactSplitThread = this.regionServer.getCompactSplitThread();
        this.requestCount.increment();
        boolean prevState = compactSplitThread.isCompactionsEnabled();
        AdminProtos.CompactionSwitchResponse response = AdminProtos.CompactionSwitchResponse.newBuilder().setPrevState(prevState).build();
        if (prevState == request.getEnabled()) {
            return response;
        }
        compactSplitThread.switchCompaction(request.getEnabled());
        return response;
    }

    @Override
    @QosPriority(priority=100)
    public AdminProtos.FlushRegionResponse flushRegion(RpcController controller, AdminProtos.FlushRegionRequest request) throws ServiceException {
        try {
            this.checkOpen();
            this.requestCount.increment();
            HRegion region = this.getRegion(request.getRegion());
            LOG.info("Flushing " + region.getRegionInfo().getRegionNameAsString());
            boolean shouldFlush = true;
            if (request.hasIfOlderThanTs()) {
                shouldFlush = region.getEarliestFlushTimeForAllStores() < request.getIfOlderThanTs();
            }
            AdminProtos.FlushRegionResponse.Builder builder = AdminProtos.FlushRegionResponse.newBuilder();
            if (shouldFlush) {
                boolean writeFlushWalMarker = request.hasWriteFlushWalMarker() ? request.getWriteFlushWalMarker() : false;
                HRegion.FlushResultImpl flushResult = null;
                if (request.hasFamily()) {
                    ArrayList<byte[]> families = new ArrayList<byte[]>();
                    families.add(request.getFamily().toByteArray());
                    flushResult = region.flushcache(families, writeFlushWalMarker, FlushLifeCycleTracker.DUMMY);
                } else {
                    flushResult = region.flushcache(true, writeFlushWalMarker, FlushLifeCycleTracker.DUMMY);
                }
                boolean compactionNeeded = flushResult.isCompactionNeeded();
                if (compactionNeeded) {
                    this.regionServer.compactSplitThread.requestSystemCompaction(region, "Compaction through user triggered flush");
                }
                builder.setFlushed(flushResult.isFlushSucceeded());
                builder.setWroteFlushWalMarker(flushResult.wroteFlushWalMarker);
            }
            builder.setLastFlushTime(region.getEarliestFlushTimeForAllStores());
            return builder.build();
        }
        catch (DroppedSnapshotException ex) {
            this.regionServer.abort("Replay of WAL required. Forcing server shutdown", ex);
            throw new ServiceException(ex);
        }
        catch (IOException ie) {
            throw new ServiceException(ie);
        }
    }

    @Override
    @QosPriority(priority=100)
    public AdminProtos.GetOnlineRegionResponse getOnlineRegion(RpcController controller, AdminProtos.GetOnlineRegionRequest request) throws ServiceException {
        try {
            this.checkOpen();
            this.requestCount.increment();
            Map<String, HRegion> onlineRegions = this.regionServer.getOnlineRegions();
            ArrayList<RegionInfo> list = new ArrayList<RegionInfo>(onlineRegions.size());
            for (HRegion region : onlineRegions.values()) {
                list.add(region.getRegionInfo());
            }
            list.sort(RegionInfo.COMPARATOR);
            return ResponseConverter.buildGetOnlineRegionResponse(list);
        }
        catch (IOException ie) {
            throw new ServiceException(ie);
        }
    }

    @Override
    @QosPriority(priority=100)
    public AdminProtos.GetRegionInfoResponse getRegionInfo(RpcController controller, AdminProtos.GetRegionInfoRequest request) throws ServiceException {
        try {
            byte[] bestSplitRow;
            this.checkOpen();
            this.requestCount.increment();
            HRegion region = this.getRegion(request.getRegion());
            RegionInfo info = region.getRegionInfo();
            if (request.hasBestSplitRow() && request.getBestSplitRow()) {
                bestSplitRow = region.checkSplit(true).orElse(null);
                if (bestSplitRow == null) {
                    region.flush(true);
                    bestSplitRow = region.checkSplit(true).orElse(null);
                }
            } else {
                bestSplitRow = null;
            }
            AdminProtos.GetRegionInfoResponse.Builder builder = AdminProtos.GetRegionInfoResponse.newBuilder();
            builder.setRegionInfo(ProtobufUtil.toRegionInfo(info));
            if (request.hasCompactionState() && request.getCompactionState()) {
                builder.setCompactionState(ProtobufUtil.createCompactionState(region.getCompactionState()));
            }
            builder.setSplittable(region.isSplittable());
            builder.setMergeable(region.isMergeable());
            if (request.hasBestSplitRow() && request.getBestSplitRow() && bestSplitRow != null) {
                builder.setBestSplitRow(UnsafeByteOperations.unsafeWrap(bestSplitRow));
            }
            return builder.build();
        }
        catch (IOException ie) {
            throw new ServiceException(ie);
        }
    }

    @Override
    @QosPriority(priority=100)
    public AdminProtos.GetRegionLoadResponse getRegionLoad(RpcController controller, AdminProtos.GetRegionLoadRequest request) throws ServiceException {
        List<HRegion> regions;
        if (request.hasTableName()) {
            TableName tableName = ProtobufUtil.toTableName(request.getTableName());
            regions = this.regionServer.getRegions(tableName);
        } else {
            regions = this.regionServer.getRegions();
        }
        ArrayList<ClusterStatusProtos.RegionLoad> rLoads = new ArrayList<ClusterStatusProtos.RegionLoad>(regions.size());
        ClusterStatusProtos.RegionLoad.Builder regionLoadBuilder = ClusterStatusProtos.RegionLoad.newBuilder();
        HBaseProtos.RegionSpecifier.Builder regionSpecifier = HBaseProtos.RegionSpecifier.newBuilder();
        try {
            for (HRegion region : regions) {
                rLoads.add(this.regionServer.createRegionLoad(region, regionLoadBuilder, regionSpecifier));
            }
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        AdminProtos.GetRegionLoadResponse.Builder builder = AdminProtos.GetRegionLoadResponse.newBuilder();
        builder.addAllRegionLoads(rLoads);
        return builder.build();
    }

    @Override
    @QosPriority(priority=100)
    public AdminProtos.ClearCompactionQueuesResponse clearCompactionQueues(RpcController controller, AdminProtos.ClearCompactionQueuesRequest request) throws ServiceException {
        LOG.debug("Client=" + (String)RpcServer.getRequestUserName().orElse(null) + "/" + RpcServer.getRemoteAddress().orElse(null) + " clear compactions queue");
        AdminProtos.ClearCompactionQueuesResponse.Builder respBuilder = AdminProtos.ClearCompactionQueuesResponse.newBuilder();
        this.requestCount.increment();
        if (this.clearCompactionQueues.compareAndSet(false, true)) {
            try {
                this.checkOpen();
                this.regionServer.getRegionServerCoprocessorHost().preClearCompactionQueues();
                block13: for (String queueName : request.getQueueNameList()) {
                    LOG.debug("clear " + queueName + " compaction queue");
                    switch (queueName) {
                        case "long": {
                            this.regionServer.compactSplitThread.clearLongCompactionsQueue();
                            continue block13;
                        }
                        case "short": {
                            this.regionServer.compactSplitThread.clearShortCompactionsQueue();
                            continue block13;
                        }
                    }
                    LOG.warn("Unknown queue name " + queueName);
                    throw new IOException("Unknown queue name " + queueName);
                }
                this.regionServer.getRegionServerCoprocessorHost().postClearCompactionQueues();
            }
            catch (IOException ie) {
                throw new ServiceException(ie);
            }
            finally {
                this.clearCompactionQueues.set(false);
            }
        } else {
            LOG.warn("Clear compactions queue is executing by other admin.");
        }
        return respBuilder.build();
    }

    @Override
    @QosPriority(priority=100)
    public AdminProtos.GetServerInfoResponse getServerInfo(RpcController controller, AdminProtos.GetServerInfoRequest request) throws ServiceException {
        try {
            this.checkOpen();
        }
        catch (IOException ie) {
            throw new ServiceException(ie);
        }
        this.requestCount.increment();
        int infoPort = this.regionServer.infoServer != null ? this.regionServer.infoServer.getPort() : -1;
        return ResponseConverter.buildGetServerInfoResponse(this.regionServer.serverName, infoPort);
    }

    @Override
    @QosPriority(priority=100)
    public AdminProtos.GetStoreFileResponse getStoreFile(RpcController controller, AdminProtos.GetStoreFileRequest request) throws ServiceException {
        try {
            Set<byte[]> columnFamilies;
            this.checkOpen();
            HRegion region = this.getRegion(request.getRegion());
            this.requestCount.increment();
            if (request.getFamilyCount() == 0) {
                columnFamilies = region.getTableDescriptor().getColumnFamilyNames();
            } else {
                columnFamilies = new TreeSet<byte[]>((Comparator<byte[]>)Bytes.BYTES_RAWCOMPARATOR);
                for (ByteString cf : request.getFamilyList()) {
                    columnFamilies.add(cf.toByteArray());
                }
            }
            int nCF = columnFamilies.size();
            List<String> fileList = region.getStoreFileList((byte[][])columnFamilies.toArray((T[])new byte[nCF][]));
            AdminProtos.GetStoreFileResponse.Builder builder = AdminProtos.GetStoreFileResponse.newBuilder();
            builder.addAllStoreFile(fileList);
            return builder.build();
        }
        catch (IOException ie) {
            throw new ServiceException(ie);
        }
    }

    private void throwOnWrongStartCode(AdminProtos.OpenRegionRequest request) throws ServiceException {
        if (!request.hasServerStartCode()) {
            LOG.warn("OpenRegionRequest for {} does not have a start code", request.getOpenInfoList());
            return;
        }
        this.throwOnWrongStartCode(request.getServerStartCode());
    }

    private void throwOnWrongStartCode(AdminProtos.CloseRegionRequest request) throws ServiceException {
        if (!request.hasServerStartCode()) {
            LOG.warn("CloseRegionRequest for {} does not have a start code", (Object)request.getRegion());
            return;
        }
        this.throwOnWrongStartCode(request.getServerStartCode());
    }

    private void throwOnWrongStartCode(long serverStartCode) throws ServiceException {
        if (this.regionServer.serverName.getStartcode() != serverStartCode) {
            throw new ServiceException(new DoNotRetryIOException("This RPC was intended for a different server with startCode: " + serverStartCode + ", this server is: " + this.regionServer.serverName));
        }
    }

    private void throwOnWrongStartCode(AdminProtos.ExecuteProceduresRequest req) throws ServiceException {
        if (req.getOpenRegionCount() > 0) {
            for (AdminProtos.OpenRegionRequest openReq : req.getOpenRegionList()) {
                this.throwOnWrongStartCode(openReq);
            }
        }
        if (req.getCloseRegionCount() > 0) {
            for (AdminProtos.CloseRegionRequest closeReq : req.getCloseRegionList()) {
                this.throwOnWrongStartCode(closeReq);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @QosPriority(priority=100)
    public AdminProtos.OpenRegionResponse openRegion(RpcController controller, AdminProtos.OpenRegionRequest request) throws ServiceException {
        this.requestCount.increment();
        this.throwOnWrongStartCode(request);
        AdminProtos.OpenRegionResponse.Builder builder = AdminProtos.OpenRegionResponse.newBuilder();
        int regionCount = request.getOpenInfoCount();
        HashMap<TableName, TableDescriptor> htds = new HashMap<TableName, TableDescriptor>(regionCount);
        boolean isBulkAssign = regionCount > 1;
        try {
            this.checkOpen();
        }
        catch (IOException ie) {
            HBaseProtos.RegionInfo ri;
            TableName tableName = null;
            if (regionCount == 1 && (ri = request.getOpenInfo(0).getRegion()) != null) {
                tableName = ProtobufUtil.toTableName(ri.getTableName());
            }
            if (!TableName.META_TABLE_NAME.equals(tableName)) {
                throw new ServiceException(ie);
            }
            int timeout = this.regionServer.getConfiguration().getInt("hbase.rpc.timeout", 60000) >> 2;
            long endTime = System.currentTimeMillis() + (long)timeout;
            AtomicBoolean atomicBoolean = this.regionServer.online;
            synchronized (atomicBoolean) {
                try {
                    while (System.currentTimeMillis() <= endTime && !this.regionServer.isStopped() && !this.regionServer.isOnline()) {
                        this.regionServer.online.wait(this.regionServer.msgInterval);
                    }
                    this.checkOpen();
                }
                catch (InterruptedException t) {
                    Thread.currentThread().interrupt();
                    throw new ServiceException(t);
                }
                catch (IOException e) {
                    throw new ServiceException(e);
                }
            }
        }
        long masterSystemTime = request.hasMasterSystemTime() ? request.getMasterSystemTime() : -1L;
        for (AdminProtos.OpenRegionRequest.RegionOpenInfo regionOpenInfo : request.getOpenInfoList()) {
            RegionInfo region = ProtobufUtil.toRegionInfo(regionOpenInfo.getRegion());
            try {
                String encodedName = region.getEncodedName();
                byte[] encodedNameBytes = region.getEncodedNameAsBytes();
                HRegion onlineRegion = this.regionServer.getRegion(encodedName);
                if (onlineRegion != null) {
                    String error = "Received OPEN for the region:" + region.getRegionNameAsString() + ", which is already online";
                    LOG.warn(error);
                    builder.addOpeningState(AdminProtos.OpenRegionResponse.RegionOpeningState.OPENED);
                    continue;
                }
                LOG.info("Open " + region.getRegionNameAsString());
                Boolean previous = this.regionServer.getRegionsInTransitionInRS().putIfAbsent(encodedNameBytes, Boolean.TRUE);
                if (Boolean.FALSE.equals(previous)) {
                    if (this.regionServer.getRegion(encodedName) != null) {
                        String error = "Received OPEN for the region:" + region.getRegionNameAsString() + ", which we are already trying to CLOSE";
                        this.regionServer.abort(error);
                        throw new IOException(error);
                    }
                    this.regionServer.getRegionsInTransitionInRS().put(encodedNameBytes, Boolean.TRUE);
                }
                if (Boolean.TRUE.equals(previous)) {
                    LOG.info("Receiving OPEN for the region:" + region.getRegionNameAsString() + ", which we are already trying to OPEN - ignoring this new request for this region.");
                }
                this.regionServer.removeFromMovedRegions(region.getEncodedName());
                if (previous == null || !previous.booleanValue()) {
                    TableDescriptor htd = (TableDescriptor)htds.get(region.getTable());
                    if (htd == null) {
                        htd = this.regionServer.tableDescriptors.get(region.getTable());
                        htds.put(region.getTable(), htd);
                    }
                    if (htd == null) {
                        throw new IOException("Missing table descriptor for " + region.getEncodedName());
                    }
                    if (this.regionServer.executorService == null) {
                        LOG.info("No executor executorService; skipping open request");
                    } else if (region.isMetaRegion()) {
                        this.regionServer.executorService.submit(new OpenMetaHandler(this.regionServer, this.regionServer, region, htd, masterSystemTime));
                    } else {
                        if (regionOpenInfo.getFavoredNodesCount() > 0) {
                            this.regionServer.updateRegionFavoredNodesMapping(region.getEncodedName(), regionOpenInfo.getFavoredNodesList());
                        }
                        if (htd.getPriority() >= 100 || region.getTable().isSystemTable()) {
                            this.regionServer.executorService.submit(new OpenPriorityRegionHandler(this.regionServer, this.regionServer, region, htd, masterSystemTime));
                        } else {
                            this.regionServer.executorService.submit(new OpenRegionHandler(this.regionServer, this.regionServer, region, htd, masterSystemTime));
                        }
                    }
                }
                builder.addOpeningState(AdminProtos.OpenRegionResponse.RegionOpeningState.OPENED);
            }
            catch (IOException ie) {
                LOG.warn("Failed opening region " + region.getRegionNameAsString(), (Throwable)ie);
                if (isBulkAssign) {
                    builder.addOpeningState(AdminProtos.OpenRegionResponse.RegionOpeningState.FAILED_OPENING);
                    continue;
                }
                throw new ServiceException(ie);
            }
        }
        return builder.build();
    }

    @Override
    public AdminProtos.WarmupRegionResponse warmupRegion(RpcController controller, AdminProtos.WarmupRegionRequest request) throws ServiceException {
        RegionInfo region = ProtobufUtil.toRegionInfo(request.getRegionInfo());
        AdminProtos.WarmupRegionResponse response = AdminProtos.WarmupRegionResponse.getDefaultInstance();
        try {
            this.checkOpen();
            String encodedName = region.getEncodedName();
            byte[] encodedNameBytes = region.getEncodedNameAsBytes();
            HRegion onlineRegion = this.regionServer.getRegion(encodedName);
            if (onlineRegion != null) {
                LOG.info("{} is online; skipping warmup", (Object)region);
                return response;
            }
            TableDescriptor htd = this.regionServer.tableDescriptors.get(region.getTable());
            if (this.regionServer.getRegionsInTransitionInRS().containsKey(encodedNameBytes)) {
                LOG.info("{} is in transition; skipping warmup", (Object)region);
                return response;
            }
            LOG.info("Warmup {}", (Object)region.getRegionNameAsString());
            HRegion.warmupHRegion(region, htd, this.regionServer.getWAL(region), this.regionServer.getConfiguration(), this.regionServer, null);
        }
        catch (IOException ie) {
            LOG.error("Failed warmup of {}", (Object)region.getRegionNameAsString(), (Object)ie);
            throw new ServiceException(ie);
        }
        return response;
    }

    @Override
    @QosPriority(priority=6)
    public AdminProtos.ReplicateWALEntryResponse replay(RpcController controller, AdminProtos.ReplicateWALEntryRequest request) throws ServiceException {
        long before = EnvironmentEdgeManager.currentTime();
        CellScanner cells = ((HBaseRpcController)controller).cellScanner();
        ((HBaseRpcController)controller).setCellScanner(null);
        try {
            this.checkOpen();
            List<AdminProtos.WALEntry> entries = request.getEntryList();
            if (entries == null || entries.isEmpty()) {
                AdminProtos.ReplicateWALEntryResponse replicateWALEntryResponse = AdminProtos.ReplicateWALEntryResponse.newBuilder().build();
                return replicateWALEntryResponse;
            }
            ByteString regionName = entries.get(0).getKey().getEncodedRegionName();
            HRegion region = this.regionServer.getRegionByEncodedName(regionName.toStringUtf8());
            RegionCoprocessorHost coprocessorHost = ServerRegionReplicaUtil.isDefaultReplica(region.getRegionInfo()) ? region.getCoprocessorHost() : null;
            ArrayList<Pair<WALKey, WALEdit>> walEntries = new ArrayList<Pair<WALKey, WALEdit>>();
            boolean isPrimary = RegionReplicaUtil.isDefaultReplica(region.getRegionInfo());
            Durability durability = isPrimary ? Durability.USE_DEFAULT : Durability.SKIP_WAL;
            for (AdminProtos.WALEntry entry : entries) {
                if (!regionName.equals(entry.getKey().getEncodedRegionName())) {
                    throw new NotServingRegionException("Replay request contains entries from multiple regions. First region:" + regionName.toStringUtf8() + " , other region:" + entry.getKey().getEncodedRegionName());
                }
                if (this.regionServer.nonceManager != null && isPrimary) {
                    long l = entry.getKey().hasNonceGroup() ? entry.getKey().getNonceGroup() : 0L;
                    long nonce = entry.getKey().hasNonce() ? entry.getKey().getNonce() : 0L;
                    this.regionServer.nonceManager.reportOperationFromWal(l, nonce, entry.getKey().getWriteTime());
                }
                Pair<WALKey, WALEdit> pair = coprocessorHost == null ? null : new Pair<WALKey, WALEdit>();
                List<WALSplitUtil.MutationReplay> edits = WALSplitUtil.getMutationsFromWALEntry(entry, cells, pair, durability);
                if (coprocessorHost != null) {
                    if (coprocessorHost.preWALRestore(region.getRegionInfo(), pair.getFirst(), pair.getSecond())) continue;
                    walEntries.add(pair);
                }
                if (edits == null || edits.isEmpty()) continue;
                Collections.sort(edits, (v1, v2) -> Row.COMPARATOR.compare(v1.mutation, v2.mutation));
                long replaySeqId = entry.getKey().hasOrigSequenceNumber() ? entry.getKey().getOrigSequenceNumber() : entry.getKey().getLogSequenceNumber();
                OperationStatus[] result = this.doReplayBatchOp(region, edits, replaySeqId);
                for (int i = 0; result != null && i < result.length; ++i) {
                    if (result[i] == OperationStatus.SUCCESS) continue;
                    throw new IOException(result[i].getExceptionMsg());
                }
            }
            WAL wal = region.getWAL();
            if (wal != null) {
                wal.sync();
            }
            if (coprocessorHost != null) {
                for (Pair pair : walEntries) {
                    coprocessorHost.postWALRestore(region.getRegionInfo(), (WALKey)pair.getFirst(), (WALEdit)pair.getSecond());
                }
            }
            AdminProtos.ReplicateWALEntryResponse replicateWALEntryResponse = AdminProtos.ReplicateWALEntryResponse.newBuilder().build();
            return replicateWALEntryResponse;
        }
        catch (IOException ie) {
            throw new ServiceException(ie);
        }
        finally {
            MetricsRegionServer metricsRegionServer = this.regionServer.getMetrics();
            if (metricsRegionServer != null) {
                metricsRegionServer.updateReplay(EnvironmentEdgeManager.currentTime() - before);
            }
        }
    }

    @Override
    @QosPriority(priority=5)
    public AdminProtos.ReplicateWALEntryResponse replicateWALEntry(RpcController controller, AdminProtos.ReplicateWALEntryRequest request) throws ServiceException {
        try {
            this.checkOpen();
            if (this.regionServer.getReplicationSinkService() != null) {
                this.requestCount.increment();
                List<AdminProtos.WALEntry> entries = request.getEntryList();
                CellScanner cellScanner = ((HBaseRpcController)controller).cellScanner();
                ((HBaseRpcController)controller).setCellScanner(null);
                this.regionServer.getRegionServerCoprocessorHost().preReplicateLogEntries();
                this.regionServer.getReplicationSinkService().replicateLogEntries(entries, cellScanner, request.getReplicationClusterId(), request.getSourceBaseNamespaceDirPath(), request.getSourceHFileArchiveDirPath());
                this.regionServer.getRegionServerCoprocessorHost().postReplicateLogEntries();
                return AdminProtos.ReplicateWALEntryResponse.newBuilder().build();
            }
            throw new ServiceException("Replication services are not initialized yet");
        }
        catch (IOException ie) {
            throw new ServiceException(ie);
        }
    }

    @Override
    public AdminProtos.RollWALWriterResponse rollWALWriter(RpcController controller, AdminProtos.RollWALWriterRequest request) throws ServiceException {
        try {
            this.checkOpen();
            this.requestCount.increment();
            this.regionServer.getRegionServerCoprocessorHost().preRollWALWriterRequest();
            this.regionServer.getWalRoller().requestRollAll();
            this.regionServer.getRegionServerCoprocessorHost().postRollWALWriterRequest();
            AdminProtos.RollWALWriterResponse.Builder builder = AdminProtos.RollWALWriterResponse.newBuilder();
            return builder.build();
        }
        catch (IOException ie) {
            throw new ServiceException(ie);
        }
    }

    @Override
    @QosPriority(priority=100)
    public AdminProtos.StopServerResponse stopServer(RpcController controller, AdminProtos.StopServerRequest request) throws ServiceException {
        this.rpcPreCheck("stopServer");
        this.requestCount.increment();
        String reason = request.getReason();
        this.regionServer.stop(reason);
        return AdminProtos.StopServerResponse.newBuilder().build();
    }

    @Override
    public AdminProtos.UpdateFavoredNodesResponse updateFavoredNodes(RpcController controller, AdminProtos.UpdateFavoredNodesRequest request) throws ServiceException {
        this.rpcPreCheck("updateFavoredNodes");
        List<AdminProtos.UpdateFavoredNodesRequest.RegionUpdateInfo> openInfoList = request.getUpdateInfoList();
        AdminProtos.UpdateFavoredNodesResponse.Builder respBuilder = AdminProtos.UpdateFavoredNodesResponse.newBuilder();
        for (AdminProtos.UpdateFavoredNodesRequest.RegionUpdateInfo regionUpdateInfo : openInfoList) {
            RegionInfo hri = ProtobufUtil.toRegionInfo(regionUpdateInfo.getRegion());
            if (regionUpdateInfo.getFavoredNodesCount() <= 0) continue;
            this.regionServer.updateRegionFavoredNodesMapping(hri.getEncodedName(), regionUpdateInfo.getFavoredNodesList());
        }
        respBuilder.setResponse(openInfoList.size());
        return respBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClientProtos.BulkLoadHFileResponse bulkLoadHFile(RpcController controller, ClientProtos.BulkLoadHFileRequest request) throws ServiceException {
        long start = EnvironmentEdgeManager.currentTime();
        ArrayList<String> clusterIds = new ArrayList<String>(request.getClusterIdsList());
        if (clusterIds.contains(this.regionServer.clusterId)) {
            return ClientProtos.BulkLoadHFileResponse.newBuilder().setLoaded(true).build();
        }
        clusterIds.add(this.regionServer.clusterId);
        try {
            ActivePolicyEnforcement activeSpaceQuotas;
            Object enforcement;
            this.checkOpen();
            this.requestCount.increment();
            HRegion region = this.getRegion(request.getRegion());
            Map<byte[], List<Path>> map = null;
            boolean spaceQuotaEnabled = QuotaUtil.isQuotaEnabled(this.getConfiguration());
            long sizeToBeLoaded = -1L;
            if (spaceQuotaEnabled && (enforcement = (activeSpaceQuotas = this.getSpaceQuotaManager().getActiveEnforcements()).getPolicyEnforcement(region)) != null) {
                ArrayList<String> filePaths = new ArrayList<String>(request.getFamilyPathCount());
                for (ClientProtos.BulkLoadHFileRequest.FamilyPath familyPath : request.getFamilyPathList()) {
                    filePaths.add(familyPath.getPath());
                }
                sizeToBeLoaded = enforcement.computeBulkLoadSize(this.regionServer.getFileSystem(), filePaths);
            }
            ArrayList<Pair<byte[], String>> familyPaths = new ArrayList<Pair<byte[], String>>(request.getFamilyPathCount());
            for (ClientProtos.BulkLoadHFileRequest.FamilyPath familyPath : request.getFamilyPathList()) {
                familyPaths.add(new Pair<byte[], String>(familyPath.getFamily().toByteArray(), familyPath.getPath()));
            }
            if (!request.hasBulkToken()) {
                if (region.getCoprocessorHost() != null) {
                    region.getCoprocessorHost().preBulkLoadHFile(familyPaths);
                }
                try {
                    map = region.bulkLoadHFiles(familyPaths, request.getAssignSeqNum(), null, request.getCopyFile(), clusterIds, request.getReplicate());
                }
                finally {
                    if (region.getCoprocessorHost() != null) {
                        region.getCoprocessorHost().postBulkLoadHFile(familyPaths, map);
                    }
                }
            } else {
                map = this.regionServer.getSecureBulkLoadManager().secureBulkLoadHFiles(region, request, clusterIds);
            }
            ClientProtos.BulkLoadHFileResponse.Builder builder = ClientProtos.BulkLoadHFileResponse.newBuilder();
            builder.setLoaded(map != null);
            if (map != null && spaceQuotaEnabled && sizeToBeLoaded > 0L) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Incrementing space use of " + region.getRegionInfo() + " by " + sizeToBeLoaded + " bytes");
                }
                this.getSpaceQuotaManager().getRegionSizeStore().incrementRegionSize(region.getRegionInfo(), sizeToBeLoaded);
            }
            ClientProtos.BulkLoadHFileResponse bulkLoadHFileResponse = builder.build();
            return bulkLoadHFileResponse;
        }
        catch (IOException ie) {
            throw new ServiceException(ie);
        }
        finally {
            MetricsRegionServer metricsRegionServer = this.regionServer.getMetrics();
            if (metricsRegionServer != null) {
                metricsRegionServer.updateBulkLoad(EnvironmentEdgeManager.currentTime() - start);
            }
        }
    }

    @Override
    public ClientProtos.PrepareBulkLoadResponse prepareBulkLoad(RpcController controller, ClientProtos.PrepareBulkLoadRequest request) throws ServiceException {
        try {
            this.checkOpen();
            this.requestCount.increment();
            HRegion region = this.getRegion(request.getRegion());
            String bulkToken = this.regionServer.getSecureBulkLoadManager().prepareBulkLoad(region, request);
            ClientProtos.PrepareBulkLoadResponse.Builder builder = ClientProtos.PrepareBulkLoadResponse.newBuilder();
            builder.setBulkToken(bulkToken);
            return builder.build();
        }
        catch (IOException ie) {
            throw new ServiceException(ie);
        }
    }

    @Override
    public ClientProtos.CleanupBulkLoadResponse cleanupBulkLoad(RpcController controller, ClientProtos.CleanupBulkLoadRequest request) throws ServiceException {
        try {
            this.checkOpen();
            this.requestCount.increment();
            HRegion region = this.getRegion(request.getRegion());
            this.regionServer.getSecureBulkLoadManager().cleanupBulkLoad(region, request);
            return ClientProtos.CleanupBulkLoadResponse.newBuilder().build();
        }
        catch (IOException ie) {
            throw new ServiceException(ie);
        }
    }

    @Override
    public ClientProtos.CoprocessorServiceResponse execService(RpcController controller, ClientProtos.CoprocessorServiceRequest request) throws ServiceException {
        try {
            this.checkOpen();
            this.requestCount.increment();
            HRegion region = this.getRegion(request.getRegion());
            Message result = this.execServiceOnRegion(region, request.getCall());
            ClientProtos.CoprocessorServiceResponse.Builder builder = ClientProtos.CoprocessorServiceResponse.newBuilder();
            builder.setRegion(RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, region.getRegionInfo().getRegionName()));
            builder.setValue(builder.getValueBuilder().setName(result.getClass().getName()).setValue(ByteString.copyFrom(result.toByteArray())));
            return builder.build();
        }
        catch (IOException ie) {
            throw new ServiceException(ie);
        }
    }

    private Message execServiceOnRegion(HRegion region, ClientProtos.CoprocessorServiceCall serviceCall) throws IOException {
        ServerRpcController execController = new ServerRpcController();
        return region.execService(execController, serviceCall);
    }

    @Override
    public ClientProtos.GetResponse get(RpcController controller, ClientProtos.GetRequest request) throws ServiceException {
        ClientProtos.GetResponse getResponse;
        OperationQuota quota;
        block20: {
            TableDescriptor td;
            MetricsRegionServer metricsRegionServer;
            long before = EnvironmentEdgeManager.currentTime();
            quota = null;
            HRegion region = null;
            try {
                this.checkOpen();
                this.requestCount.increment();
                this.rpcGetRequestCount.increment();
                region = this.getRegion(request.getRegion());
                ClientProtos.GetResponse.Builder builder = ClientProtos.GetResponse.newBuilder();
                ClientProtos.Get get = request.getGet();
                if (get.hasClosestRowBefore() && get.getClosestRowBefore()) {
                    throw new UnknownProtocolException("Is this a pre-hbase-1.0.0 or asynchbase client? Client is invoking getClosestRowBefore removed in hbase-2.0.0 replaced by reverse Scan.");
                }
                Boolean existence = null;
                Result r = null;
                RpcCallContext context = RpcServer.getCurrentCall().orElse(null);
                quota = this.getRpcQuotaManager().checkQuota((Region)region, OperationQuota.OperationType.GET);
                Get clientGet = ProtobufUtil.toGet(get);
                if (get.getExistenceOnly() && region.getCoprocessorHost() != null) {
                    existence = region.getCoprocessorHost().preExists(clientGet);
                }
                if (existence == null) {
                    r = context != null ? this.get(clientGet, region, null, context) : region.get(clientGet);
                    if (get.getExistenceOnly()) {
                        boolean exists = r.getExists();
                        if (region.getCoprocessorHost() != null) {
                            exists = region.getCoprocessorHost().postExists(clientGet, exists);
                        }
                        existence = exists;
                    }
                }
                if (existence != null) {
                    ClientProtos.Result pbr = ProtobufUtil.toResult(existence, region.getRegionInfo().getReplicaId() != 0);
                    builder.setResult(pbr);
                } else if (r != null) {
                    ClientProtos.Result pbr;
                    if (this.isClientCellBlockSupport(context) && controller instanceof HBaseRpcController && VersionInfoUtil.hasMinimumVersion(context.getClientVersionInfo(), 1, 3)) {
                        pbr = ProtobufUtil.toResultNoData(r);
                        ((HBaseRpcController)controller).setCellScanner(CellUtil.createCellScanner(r.rawCells()));
                        this.addSize(context, r, null);
                    } else {
                        pbr = ProtobufUtil.toResult(r);
                    }
                    builder.setResult(pbr);
                }
                if (r != null && r.rawCells() != null) {
                    quota.addGetResult(r);
                }
                getResponse = builder.build();
                metricsRegionServer = this.regionServer.getMetrics();
                if (metricsRegionServer == null) break block20;
                TableDescriptor tableDescriptor = td = region != null ? region.getTableDescriptor() : null;
            }
            catch (IOException ie) {
                try {
                    throw new ServiceException(ie);
                }
                catch (Throwable throwable) {
                    MetricsRegionServer metricsRegionServer2 = this.regionServer.getMetrics();
                    if (metricsRegionServer2 != null) {
                        TableDescriptor td2;
                        TableDescriptor tableDescriptor = td2 = region != null ? region.getTableDescriptor() : null;
                        if (td2 != null) {
                            metricsRegionServer2.updateGet(td2.getTableName(), EnvironmentEdgeManager.currentTime() - before);
                        }
                    }
                    if (quota != null) {
                        quota.close();
                    }
                    throw throwable;
                }
            }
            if (td != null) {
                metricsRegionServer.updateGet(td.getTableName(), EnvironmentEdgeManager.currentTime() - before);
            }
        }
        if (quota != null) {
            quota.close();
        }
        return getResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result get(Get get, HRegion region, RegionScannersCloseCallBack closeCallBack, RpcCallContext context) throws IOException {
        region.prepareGet(get);
        boolean stale = region.getRegionInfo().getReplicaId() != 0;
        ArrayList<Cell> results = new ArrayList<Cell>();
        long before = EnvironmentEdgeManager.currentTime();
        if (region.getCoprocessorHost() != null && region.getCoprocessorHost().preGet(get, results)) {
            region.metricsUpdateForGet(results, before);
            return Result.create(results, get.isCheckExistenceOnly() ? Boolean.valueOf(!results.isEmpty()) : null, stale);
        }
        Scan scan = new Scan(get);
        if (scan.getLoadColumnFamiliesOnDemandValue() == null) {
            scan.setLoadColumnFamiliesOnDemand(region.isLoadingCfsOnDemandDefault());
        }
        HRegion.RegionScannerImpl scanner = null;
        try {
            scanner = region.getScanner(scan);
            scanner.next(results);
        }
        finally {
            if (scanner != null) {
                if (closeCallBack == null) {
                    context.setCallBack(scanner);
                } else {
                    closeCallBack.addScanner(scanner);
                }
            }
        }
        if (region.getCoprocessorHost() != null) {
            region.getCoprocessorHost().postGet(get, results);
        }
        region.metricsUpdateForGet(results, before);
        return Result.create(results, get.isCheckExistenceOnly() ? Boolean.valueOf(!results.isEmpty()) : null, stale);
    }

    private void checkBatchSizeAndLogLargeSize(ClientProtos.MultiRequest request) throws ServiceException {
        int sum = 0;
        String firstRegionName = null;
        for (ClientProtos.RegionAction regionAction : request.getRegionActionList()) {
            if (sum == 0) {
                firstRegionName = Bytes.toStringBinary(regionAction.getRegion().getValue().toByteArray());
            }
            sum += regionAction.getActionCount();
        }
        if (sum > this.rowSizeWarnThreshold) {
            LOG.warn("Large batch operation detected (greater than " + this.rowSizeWarnThreshold + ") (HBASE-18023). Requested Number of Rows: " + sum + " Client: " + (String)RpcServer.getRequestUserName().orElse(null) + "/" + RpcServer.getRemoteAddress().orElse(null) + " first region in multi=" + firstRegionName);
            if (this.rejectRowsWithSizeOverThreshold) {
                throw new ServiceException("Rejecting large batch operation for current batch with firstRegionName: " + firstRegionName + " , Requested Number of Rows: " + sum + " , Size Threshold: " + this.rowSizeWarnThreshold);
            }
        }
    }

    private void failRegionAction(ClientProtos.MultiResponse.Builder responseBuilder, ClientProtos.RegionActionResult.Builder regionActionResultBuilder, ClientProtos.RegionAction regionAction, CellScanner cellScanner, Throwable error) {
        this.rpcServer.getMetrics().exception(error);
        regionActionResultBuilder.setException(ResponseConverter.buildException(error));
        responseBuilder.addRegionActionResult(regionActionResultBuilder.build());
        if (cellScanner != null) {
            this.skipCellsForMutations(regionAction.getActionList(), cellScanner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClientProtos.MultiResponse multi(RpcController rpcc, ClientProtos.MultiRequest request) throws ServiceException {
        CellScanner cellScanner;
        try {
            this.checkOpen();
        }
        catch (IOException ie) {
            throw new ServiceException(ie);
        }
        this.checkBatchSizeAndLogLargeSize(request);
        HBaseRpcController controller = (HBaseRpcController)rpcc;
        CellScanner cellScanner2 = cellScanner = controller != null ? controller.cellScanner() : null;
        if (controller != null) {
            controller.setCellScanner(null);
        }
        long nonceGroup = request.hasNonceGroup() ? request.getNonceGroup() : 0L;
        ClientProtos.MultiResponse.Builder responseBuilder = ClientProtos.MultiResponse.newBuilder();
        ClientProtos.RegionActionResult.Builder regionActionResultBuilder = ClientProtos.RegionActionResult.newBuilder();
        this.rpcMultiRequestCount.increment();
        this.requestCount.increment();
        ActivePolicyEnforcement spaceQuotaEnforcement = this.getSpaceQuotaManager().getActiveEnforcements();
        if (request.hasCondition()) {
            OperationQuota quota;
            HRegion region;
            if (request.getRegionActionList().isEmpty()) {
                responseBuilder.setProcessed(true);
                return responseBuilder.build();
            }
            ClientProtos.RegionAction regionAction = request.getRegionAction(0);
            assert (regionAction.getAtomic());
            HBaseProtos.RegionSpecifier regionSpecifier = regionAction.getRegion();
            try {
                region = this.getRegion(regionSpecifier);
                quota = this.getRpcQuotaManager().checkQuota((Region)region, regionAction.getActionList());
            }
            catch (IOException e) {
                this.failRegionAction(responseBuilder, regionActionResultBuilder, regionAction, cellScanner, e);
                return responseBuilder.build();
            }
            try {
                CheckAndMutateResult result = this.checkAndMutate(region, regionAction.getActionList(), cellScanner, request.getCondition(), nonceGroup, spaceQuotaEnforcement);
                responseBuilder.setProcessed(result.isSuccess());
                ClientProtos.ResultOrException.Builder resultOrExceptionOrBuilder = ClientProtos.ResultOrException.newBuilder();
                for (int i = 0; i < regionAction.getActionCount(); ++i) {
                    resultOrExceptionOrBuilder.clear();
                    resultOrExceptionOrBuilder.setIndex(i);
                    regionActionResultBuilder.addResultOrException(resultOrExceptionOrBuilder.build());
                }
            }
            catch (IOException e) {
                this.rpcServer.getMetrics().exception(e);
                regionActionResultBuilder.setException(ResponseConverter.buildException(e));
            }
            finally {
                quota.close();
            }
            responseBuilder.addRegionActionResult(regionActionResultBuilder.build());
            ClientProtos.RegionLoadStats regionLoadStats = region.getLoadStatistics();
            if (regionLoadStats != null) {
                responseBuilder.setRegionStatistics(ClientProtos.MultiRegionLoadStats.newBuilder().addRegion(regionSpecifier).addStat(regionLoadStats).build());
            }
            return responseBuilder.build();
        }
        List<CellScannable> cellsToReturn = null;
        RegionScannersCloseCallBack closeCallBack = null;
        RpcCallContext context = RpcServer.getCurrentCall().orElse(null);
        HashMap<HBaseProtos.RegionSpecifier, ClientProtos.RegionLoadStats> regionStats = new HashMap<HBaseProtos.RegionSpecifier, ClientProtos.RegionLoadStats>(request.getRegionActionCount());
        for (ClientProtos.RegionAction regionAction : request.getRegionActionList()) {
            HRegion region;
            HBaseProtos.RegionSpecifier regionSpecifier;
            block37: {
                OperationQuota quota;
                regionSpecifier = regionAction.getRegion();
                regionActionResultBuilder.clear();
                try {
                    region = this.getRegion(regionSpecifier);
                    quota = this.getRpcQuotaManager().checkQuota((Region)region, regionAction.getActionList());
                }
                catch (IOException e) {
                    this.failRegionAction(responseBuilder, regionActionResultBuilder, regionAction, cellScanner, e);
                    continue;
                }
                try {
                    if (regionAction.hasCondition()) {
                        try {
                            CheckAndMutateResult result;
                            ClientProtos.ResultOrException.Builder resultOrExceptionOrBuilder = ClientProtos.ResultOrException.newBuilder();
                            if (regionAction.getActionCount() == 1) {
                                result = this.checkAndMutate(region, quota, regionAction.getAction(0).getMutation(), cellScanner, regionAction.getCondition(), nonceGroup, spaceQuotaEnforcement);
                                regionActionResultBuilder.setProcessed(result.isSuccess());
                                resultOrExceptionOrBuilder.setIndex(0);
                                if (result.getResult() != null) {
                                    resultOrExceptionOrBuilder.setResult(ProtobufUtil.toResult(result.getResult()));
                                }
                                regionActionResultBuilder.addResultOrException(resultOrExceptionOrBuilder.build());
                            } else {
                                result = this.checkAndMutate(region, regionAction.getActionList(), cellScanner, regionAction.getCondition(), nonceGroup, spaceQuotaEnforcement);
                                regionActionResultBuilder.setProcessed(result.isSuccess());
                                for (int i = 0; i < regionAction.getActionCount(); ++i) {
                                    if (i == 0 && result.getResult() != null) {
                                        resultOrExceptionOrBuilder.setIndex(i);
                                        regionActionResultBuilder.addResultOrException(resultOrExceptionOrBuilder.setResult(ProtobufUtil.toResult(result.getResult())).build());
                                        continue;
                                    }
                                    resultOrExceptionOrBuilder.clear();
                                    resultOrExceptionOrBuilder.setIndex(i);
                                    regionActionResultBuilder.addResultOrException(resultOrExceptionOrBuilder.build());
                                }
                            }
                            break block37;
                        }
                        catch (IOException e) {
                            this.rpcServer.getMetrics().exception(e);
                            regionActionResultBuilder.setException(ResponseConverter.buildException(e));
                            break block37;
                        }
                    }
                    if (regionAction.hasAtomic() && regionAction.getAtomic()) {
                        try {
                            this.doAtomicBatchOp(regionActionResultBuilder, region, quota, regionAction.getActionList(), cellScanner, nonceGroup, spaceQuotaEnforcement);
                            regionActionResultBuilder.setProcessed(true);
                            responseBuilder.setProcessed(true);
                        }
                        catch (IOException e) {
                            this.rpcServer.getMetrics().exception(e);
                            regionActionResultBuilder.setException(ResponseConverter.buildException(e));
                        }
                    } else {
                        if (context != null && closeCallBack == null) {
                            closeCallBack = new RegionScannersCloseCallBack();
                            context.setCallBack(closeCallBack);
                        }
                        cellsToReturn = this.doNonAtomicRegionMutation(region, quota, regionAction, cellScanner, regionActionResultBuilder, cellsToReturn, nonceGroup, closeCallBack, context, spaceQuotaEnforcement);
                    }
                }
                finally {
                    quota.close();
                }
            }
            responseBuilder.addRegionActionResult(regionActionResultBuilder.build());
            ClientProtos.RegionLoadStats regionLoadStats = region.getLoadStatistics();
            if (regionLoadStats == null) continue;
            regionStats.put(regionSpecifier, regionLoadStats);
        }
        if (cellsToReturn != null && !cellsToReturn.isEmpty() && controller != null) {
            controller.setCellScanner(CellUtil.createCellScanner((List<? extends CellScannable>)cellsToReturn));
        }
        ClientProtos.MultiRegionLoadStats.Builder builder = ClientProtos.MultiRegionLoadStats.newBuilder();
        for (Map.Entry stat : regionStats.entrySet()) {
            builder.addRegion((HBaseProtos.RegionSpecifier)stat.getKey());
            builder.addStat((ClientProtos.RegionLoadStats)stat.getValue());
        }
        responseBuilder.setRegionStatistics(builder);
        return responseBuilder.build();
    }

    private void skipCellsForMutations(List<ClientProtos.Action> actions, CellScanner cellScanner) {
        if (cellScanner == null) {
            return;
        }
        for (ClientProtos.Action action : actions) {
            this.skipCellsForMutation(action, cellScanner);
        }
    }

    private void skipCellsForMutation(ClientProtos.Action action, CellScanner cellScanner) {
        if (cellScanner == null) {
            return;
        }
        try {
            ClientProtos.MutationProto m;
            if (action.hasMutation() && (m = action.getMutation()).hasAssociatedCellCount()) {
                for (int i = 0; i < m.getAssociatedCellCount(); ++i) {
                    cellScanner.advance();
                }
            }
        }
        catch (IOException e) {
            LOG.error("Error while skipping Cells in CellScanner for invalid Region Mutations", (Throwable)e);
        }
    }

    @Override
    public ClientProtos.MutateResponse mutate(RpcController rpcc, ClientProtos.MutateRequest request) throws ServiceException {
        HBaseRpcController controller = (HBaseRpcController)rpcc;
        CellScanner cellScanner = controller != null ? controller.cellScanner() : null;
        OperationQuota quota = null;
        RpcCallContext context = RpcServer.getCurrentCall().orElse(null);
        if (controller != null) {
            controller.setCellScanner(null);
        }
        try {
            this.checkOpen();
            this.requestCount.increment();
            this.rpcMutateRequestCount.increment();
            HRegion region = this.getRegion(request.getRegion());
            ClientProtos.MutateResponse.Builder builder = ClientProtos.MutateResponse.newBuilder();
            ClientProtos.MutationProto mutation = request.getMutation();
            if (!region.getRegionInfo().isMetaRegion()) {
                this.regionServer.getMemStoreFlusher().reclaimMemStoreMemory();
            }
            long nonceGroup = request.hasNonceGroup() ? request.getNonceGroup() : 0L;
            quota = this.getRpcQuotaManager().checkQuota((Region)region, OperationQuota.OperationType.MUTATE);
            ActivePolicyEnforcement spaceQuotaEnforcement = this.getSpaceQuotaManager().getActiveEnforcements();
            if (request.hasCondition()) {
                CheckAndMutateResult result = this.checkAndMutate(region, quota, mutation, cellScanner, request.getCondition(), nonceGroup, spaceQuotaEnforcement);
                builder.setProcessed(result.isSuccess());
                boolean clientCellBlockSupported = this.isClientCellBlockSupport(context);
                this.addResult(builder, result.getResult(), controller, clientCellBlockSupported);
                if (clientCellBlockSupported) {
                    this.addSize(context, result.getResult(), null);
                }
            } else {
                Result r = null;
                Boolean processed = null;
                ClientProtos.MutationProto.MutationType type = mutation.getMutateType();
                switch (type) {
                    case APPEND: {
                        r = this.append(region, quota, mutation, cellScanner, nonceGroup, spaceQuotaEnforcement);
                        break;
                    }
                    case INCREMENT: {
                        r = this.increment(region, quota, mutation, cellScanner, nonceGroup, spaceQuotaEnforcement);
                        break;
                    }
                    case PUT: {
                        this.put(region, quota, mutation, cellScanner, spaceQuotaEnforcement);
                        processed = Boolean.TRUE;
                        break;
                    }
                    case DELETE: {
                        this.delete(region, quota, mutation, cellScanner, spaceQuotaEnforcement);
                        processed = Boolean.TRUE;
                        break;
                    }
                    default: {
                        throw new DoNotRetryIOException("Unsupported mutate type: " + type.name());
                    }
                }
                if (processed != null) {
                    builder.setProcessed(processed);
                }
                boolean clientCellBlockSupported = this.isClientCellBlockSupport(context);
                this.addResult(builder, r, controller, clientCellBlockSupported);
                if (clientCellBlockSupported) {
                    this.addSize(context, r, null);
                }
            }
            ClientProtos.MutateResponse mutateResponse = builder.build();
            return mutateResponse;
        }
        catch (IOException ie) {
            this.regionServer.checkFileSystem();
            throw new ServiceException(ie);
        }
        finally {
            if (quota != null) {
                quota.close();
            }
        }
    }

    private void put(HRegion region, OperationQuota quota, ClientProtos.MutationProto mutation, CellScanner cellScanner, ActivePolicyEnforcement spaceQuota) throws IOException {
        long before = EnvironmentEdgeManager.currentTime();
        Put put = ProtobufUtil.toPut(mutation, cellScanner);
        this.checkCellSizeLimit(region, put);
        spaceQuota.getPolicyEnforcement(region).check(put);
        quota.addMutation(put);
        region.put(put);
        MetricsRegionServer metricsRegionServer = this.regionServer.getMetrics();
        if (metricsRegionServer != null) {
            long after = EnvironmentEdgeManager.currentTime();
            metricsRegionServer.updatePut(region.getRegionInfo().getTable(), after - before);
        }
    }

    private void delete(HRegion region, OperationQuota quota, ClientProtos.MutationProto mutation, CellScanner cellScanner, ActivePolicyEnforcement spaceQuota) throws IOException {
        long before = EnvironmentEdgeManager.currentTime();
        Delete delete = ProtobufUtil.toDelete(mutation, cellScanner);
        this.checkCellSizeLimit(region, delete);
        spaceQuota.getPolicyEnforcement(region).check(delete);
        quota.addMutation(delete);
        region.delete(delete);
        MetricsRegionServer metricsRegionServer = this.regionServer.getMetrics();
        if (metricsRegionServer != null) {
            long after = EnvironmentEdgeManager.currentTime();
            metricsRegionServer.updateDelete(region.getRegionInfo().getTable(), after - before);
        }
    }

    private CheckAndMutateResult checkAndMutate(HRegion region, OperationQuota quota, ClientProtos.MutationProto mutation, CellScanner cellScanner, ClientProtos.Condition condition, long nonceGroup, ActivePolicyEnforcement spaceQuota) throws IOException {
        MetricsRegionServer metricsRegionServer;
        long before = EnvironmentEdgeManager.currentTime();
        CheckAndMutate checkAndMutate = ProtobufUtil.toCheckAndMutate(condition, mutation, cellScanner);
        long nonce = mutation.hasNonce() ? mutation.getNonce() : 0L;
        this.checkCellSizeLimit(region, (Mutation)checkAndMutate.getAction());
        spaceQuota.getPolicyEnforcement(region).check((Mutation)checkAndMutate.getAction());
        quota.addMutation((Mutation)checkAndMutate.getAction());
        CheckAndMutateResult result = null;
        if (region.getCoprocessorHost() != null) {
            result = region.getCoprocessorHost().preCheckAndMutate(checkAndMutate);
        }
        if (result == null) {
            result = region.checkAndMutate(checkAndMutate, nonceGroup, nonce);
            if (region.getCoprocessorHost() != null) {
                result = region.getCoprocessorHost().postCheckAndMutate(checkAndMutate, result);
            }
        }
        if ((metricsRegionServer = this.regionServer.getMetrics()) != null) {
            long after = EnvironmentEdgeManager.currentTime();
            metricsRegionServer.updateCheckAndMutate(region.getRegionInfo().getTable(), after - before);
            ClientProtos.MutationProto.MutationType type = mutation.getMutateType();
            switch (type) {
                case PUT: {
                    metricsRegionServer.updateCheckAndPut(region.getRegionInfo().getTable(), after - before);
                    break;
                }
                case DELETE: {
                    metricsRegionServer.updateCheckAndDelete(region.getRegionInfo().getTable(), after - before);
                    break;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RegionScannerHolder getRegionScanner(ClientProtos.ScanRequest request) throws IOException {
        String scannerName = RSRpcServices.toScannerName(request.getScannerId());
        RegionScannerHolder rsh = (RegionScannerHolder)this.scanners.get(scannerName);
        if (rsh == null) {
            if (this.closedScanners.getIfPresent(scannerName) != null) {
                throw SCANNER_ALREADY_CLOSED;
            }
            LOG.warn("Client tried to access missing scanner " + scannerName);
            throw new UnknownScannerException("Unknown scanner '" + scannerName + "'. This can happen due to any of the following reasons: a) Scanner id given is wrong, b) Scanner lease expired because of long wait between consecutive client checkins, c) Server may be closing down, d) RegionServer restart during upgrade.\nIf the issue is due to reason (b), a possible fix would be increasing the value of'hbase.client.scanner.timeout.period' configuration.");
        }
        RegionInfo hri = rsh.s.getRegionInfo();
        if (this.regionServer.getOnlineRegion(hri.getRegionName()) != rsh.r) {
            String msg = "Region has changed on the scanner " + scannerName + ": regionName=" + hri.getRegionNameAsString() + ", scannerRegionName=" + rsh.r;
            LOG.warn(msg + ", closing...");
            this.scanners.remove(scannerName);
            try {
                rsh.s.close();
            }
            catch (IOException e) {
                LOG.warn("Getting exception closing " + scannerName, (Throwable)e);
            }
            finally {
                try {
                    this.regionServer.getLeaseManager().cancelLease(scannerName);
                }
                catch (LeaseException e) {
                    LOG.warn("Getting exception closing " + scannerName, (Throwable)e);
                }
            }
            throw new NotServingRegionException(msg);
        }
        return rsh;
    }

    private Pair<String, RegionScannerHolder> newRegionScanner(ClientProtos.ScanRequest request, ClientProtos.ScanResponse.Builder builder) throws IOException {
        HRegion.RegionScannerImpl coreScanner;
        HRegion region = this.getRegion(request.getRegion());
        ClientProtos.Scan protoScan = request.getScan();
        boolean isLoadingCfsOnDemandSet = protoScan.hasLoadColumnFamiliesOnDemand();
        Scan scan = ProtobufUtil.toScan(protoScan);
        if (!isLoadingCfsOnDemandSet) {
            scan.setLoadColumnFamiliesOnDemand(region.isLoadingCfsOnDemandDefault());
        }
        if (!scan.hasFamilies()) {
            for (byte[] family : region.getTableDescriptor().getColumnFamilyNames()) {
                scan.addFamily(family);
            }
        }
        if (region.getCoprocessorHost() != null) {
            region.getCoprocessorHost().preScannerOpen(scan);
        }
        HRegion.RegionScannerImpl shipper = coreScanner = region.getScanner(scan);
        RegionScanner scanner = coreScanner;
        if (region.getCoprocessorHost() != null) {
            scanner = region.getCoprocessorHost().postScannerOpen(scan, scanner);
        }
        long scannerId = this.scannerIdGenerator.generateNewScannerId();
        builder.setScannerId(scannerId);
        builder.setMvccReadPoint(scanner.getMvccReadPoint());
        builder.setTtl(this.scannerLeaseTimeoutPeriod);
        String scannerName = RSRpcServices.toScannerName(scannerId);
        boolean fullRegionScan = !region.getRegionInfo().getTable().isSystemTable() && this.isFullRegionScan(scan, region);
        return new Pair<String, RegionScannerHolder>(scannerName, this.addScanner(scannerName, scanner, shipper, region, scan.isNeedCursorResult(), fullRegionScan));
    }

    private static String toScannerName(long scannerId) {
        return Long.toString(scannerId);
    }

    private void checkScanNextCallSeq(ClientProtos.ScanRequest request, RegionScannerHolder rsh) throws OutOfOrderScannerNextException {
        long callSeq;
        if (request.hasNextCallSeq() && !rsh.incNextCallSeq(callSeq = request.getNextCallSeq())) {
            throw new OutOfOrderScannerNextException("Expected nextCallSeq: " + rsh.getNextCallSeq() + " But the nextCallSeq got from client: " + request.getNextCallSeq() + "; request=" + TextFormat.shortDebugString(request));
        }
    }

    private void addScannerLeaseBack(LeaseManager.Lease lease) {
        try {
            this.regionServer.getLeaseManager().addLease(lease);
        }
        catch (LeaseManager.LeaseStillHeldException e) {
            throw new AssertionError((Object)e);
        }
    }

    private long getTimeLimit(HBaseRpcController controller, boolean allowHeartbeatMessages) {
        if (allowHeartbeatMessages && (this.scannerLeaseTimeoutPeriod > 0 || this.rpcTimeout > 0)) {
            long timeLimitDelta;
            if (this.scannerLeaseTimeoutPeriod > 0 && this.rpcTimeout > 0) {
                timeLimitDelta = Math.min(this.scannerLeaseTimeoutPeriod, this.rpcTimeout);
            } else {
                long l = timeLimitDelta = this.scannerLeaseTimeoutPeriod > 0 ? (long)this.scannerLeaseTimeoutPeriod : (long)this.rpcTimeout;
            }
            if (controller != null && controller.getCallTimeout() > 0) {
                timeLimitDelta = Math.min(timeLimitDelta, (long)controller.getCallTimeout());
            }
            timeLimitDelta = Math.max(timeLimitDelta / 2L, this.minimumScanTimeLimitDelta);
            return System.currentTimeMillis() + timeLimitDelta;
        }
        return -1L;
    }

    private void checkLimitOfRows(int numOfCompleteRows, int limitOfRows, boolean moreRows, ScannerContext scannerContext, ClientProtos.ScanResponse.Builder builder) {
        if (numOfCompleteRows >= limitOfRows) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Done scanning, limit of rows reached, moreRows: " + moreRows + " scannerContext: " + scannerContext);
            }
            builder.setMoreResults(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scan(HBaseRpcController controller, ClientProtos.ScanRequest request, RegionScannerHolder rsh, long maxQuotaResultSize, int maxResults, int limitOfRows, List<Result> results, ClientProtos.ScanResponse.Builder builder, MutableObject<Object> lastBlock, RpcCallContext context) throws IOException {
        HRegion region = rsh.r;
        RegionScanner scanner = rsh.s;
        long maxResultSize = scanner.getMaxResultSize() > 0L ? Math.min(scanner.getMaxResultSize(), maxQuotaResultSize) : maxQuotaResultSize;
        ArrayList<Cell> values = new ArrayList<Cell>(32);
        region.startRegionOperation(Region.Operation.SCAN);
        long before = EnvironmentEdgeManager.currentTime();
        int numOfCompleteRows = 0;
        int numOfNextRawCalls = 0;
        try {
            int numOfResults = 0;
            RegionScanner regionScanner = scanner;
            synchronized (regionScanner) {
                boolean stale = region.getRegionInfo().getReplicaId() != 0;
                boolean clientHandlesPartials = request.hasClientHandlesPartials() && request.getClientHandlesPartials();
                boolean clientHandlesHeartbeats = request.hasClientHandlesHeartbeats() && request.getClientHandlesHeartbeats();
                boolean serverGuaranteesOrderOfPartials = results.isEmpty();
                boolean allowPartialResults = clientHandlesPartials && serverGuaranteesOrderOfPartials;
                boolean moreRows = false;
                boolean allowHeartbeatMessages = clientHandlesHeartbeats && allowPartialResults;
                long timeLimit = this.getTimeLimit(controller, allowHeartbeatMessages);
                ScannerContext.LimitScope sizeScope = allowPartialResults ? ScannerContext.LimitScope.BETWEEN_CELLS : ScannerContext.LimitScope.BETWEEN_ROWS;
                ScannerContext.LimitScope timeScope = allowHeartbeatMessages ? ScannerContext.LimitScope.BETWEEN_CELLS : ScannerContext.LimitScope.BETWEEN_ROWS;
                boolean trackMetrics = request.hasTrackScanMetrics() && request.getTrackScanMetrics();
                ScannerContext.Builder contextBuilder = ScannerContext.newBuilder(true);
                contextBuilder.setSizeLimit(sizeScope, maxResultSize, maxResultSize);
                contextBuilder.setBatchLimit(scanner.getBatch());
                contextBuilder.setTimeLimit(timeScope, timeLimit);
                contextBuilder.setTrackMetrics(trackMetrics);
                ScannerContext scannerContext = contextBuilder.build();
                boolean limitReached = false;
                while (numOfResults < maxResults) {
                    int lastIdx;
                    Result r;
                    scannerContext.setBatchProgress(0);
                    moreRows = scanner.nextRaw(values, scannerContext);
                    ++numOfNextRawCalls;
                    if (!values.isEmpty()) {
                        if (limitOfRows > 0) {
                            if (results.isEmpty()) {
                                if (rsh.rowOfLastPartialResult != null && !CellUtil.matchingRows((Cell)values.get(0), rsh.rowOfLastPartialResult)) {
                                    this.checkLimitOfRows(++numOfCompleteRows, limitOfRows, moreRows, scannerContext, builder);
                                }
                            } else {
                                Result lastResult = results.get(results.size() - 1);
                                if (lastResult.mayHaveMoreCellsInRow() && !CellUtil.matchingRows((Cell)values.get(0), lastResult.getRow())) {
                                    this.checkLimitOfRows(++numOfCompleteRows, limitOfRows, moreRows, scannerContext, builder);
                                }
                            }
                            if (builder.hasMoreResults() && !builder.getMoreResults()) break;
                        }
                        boolean mayHaveMoreCellsInRow = scannerContext.mayHaveMoreCellsInRow();
                        Result r2 = Result.create(values, null, stale, mayHaveMoreCellsInRow);
                        lastBlock.setValue(this.addSize(context, r2, lastBlock.getValue()));
                        results.add(r2);
                        ++numOfResults;
                        if (!mayHaveMoreCellsInRow && limitOfRows > 0) {
                            this.checkLimitOfRows(++numOfCompleteRows, limitOfRows, moreRows, scannerContext, builder);
                            if (builder.hasMoreResults() && !builder.getMoreResults()) {
                                break;
                            }
                        }
                    } else if (!moreRows && !results.isEmpty() && (r = results.get(lastIdx = results.size() - 1)).mayHaveMoreCellsInRow()) {
                        results.set(lastIdx, Result.create(r.rawCells(), r.getExists(), r.isStale(), false));
                    }
                    boolean sizeLimitReached = scannerContext.checkSizeLimit(ScannerContext.LimitScope.BETWEEN_ROWS);
                    boolean timeLimitReached = scannerContext.checkTimeLimit(ScannerContext.LimitScope.BETWEEN_ROWS);
                    boolean resultsLimitReached = numOfResults >= maxResults;
                    boolean bl = limitReached = sizeLimitReached || timeLimitReached || resultsLimitReached;
                    if (limitReached || !moreRows) {
                        Cell cursorCell;
                        if (!moreRows || !timeLimitReached) break;
                        builder.setHeartbeatMessage(true);
                        if (!rsh.needCursor || (cursorCell = scannerContext.getLastPeekedCell()) == null) break;
                        builder.setCursor(ProtobufUtil.toCursor(cursorCell));
                        break;
                    }
                    values.clear();
                }
                builder.setMoreResultsInRegion(moreRows);
                if (trackMetrics) {
                    Map<String, Long> metrics = scannerContext.getMetrics().getMetricsMap();
                    MapReduceProtos.ScanMetrics.Builder metricBuilder = MapReduceProtos.ScanMetrics.newBuilder();
                    HBaseProtos.NameInt64Pair.Builder pairBuilder = HBaseProtos.NameInt64Pair.newBuilder();
                    for (Map.Entry<String, Long> entry : metrics.entrySet()) {
                        pairBuilder.setName(entry.getKey());
                        pairBuilder.setValue(entry.getValue());
                        metricBuilder.addMetrics(pairBuilder.build());
                    }
                    builder.setScanMetrics(metricBuilder.build());
                }
            }
        }
        catch (Throwable throwable) {
            region.closeRegionOperation();
            long end = EnvironmentEdgeManager.currentTime();
            long responseCellSize = context != null ? context.getResponseCellSize() : 0L;
            region.getMetrics().updateScanTime(end - before);
            MetricsRegionServer metricsRegionServer = this.regionServer.getMetrics();
            if (metricsRegionServer != null) {
                metricsRegionServer.updateScanSize(region.getTableDescriptor().getTableName(), responseCellSize);
                metricsRegionServer.updateScanTime(region.getTableDescriptor().getTableName(), end - before);
                metricsRegionServer.updateReadQueryMeter(region.getRegionInfo().getTable(), numOfNextRawCalls);
            }
            throw throwable;
        }
        region.closeRegionOperation();
        long end = EnvironmentEdgeManager.currentTime();
        long responseCellSize = context != null ? context.getResponseCellSize() : 0L;
        region.getMetrics().updateScanTime(end - before);
        MetricsRegionServer metricsRegionServer = this.regionServer.getMetrics();
        if (metricsRegionServer != null) {
            metricsRegionServer.updateScanSize(region.getTableDescriptor().getTableName(), responseCellSize);
            metricsRegionServer.updateScanTime(region.getTableDescriptor().getTableName(), end - before);
            metricsRegionServer.updateReadQueryMeter(region.getRegionInfo().getTable(), numOfNextRawCalls);
        }
        if (region.getCoprocessorHost() != null) {
            region.getCoprocessorHost().postScannerNext(scanner, results, maxResults, true);
        }
    }

    @Override
    public ClientProtos.ScanResponse scan(RpcController controller, ClientProtos.ScanRequest request) throws ServiceException {
        boolean closeScanner;
        OperationQuota quota;
        LeaseManager.Lease lease;
        RegionScannerHolder rsh;
        String scannerName;
        if (controller != null && !(controller instanceof HBaseRpcController)) {
            throw new UnsupportedOperationException("We only do HBaseRpcControllers! FIX IF A PROBLEM: " + controller);
        }
        if (!request.hasScannerId() && !request.hasScan()) {
            throw new ServiceException(new DoNotRetryIOException("Missing required input: scannerId or scan"));
        }
        try {
            this.checkOpen();
        }
        catch (IOException e) {
            block52: {
                if (request.hasScannerId()) {
                    LeaseManager leaseManager;
                    String scannerName2 = RSRpcServices.toScannerName(request.getScannerId());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Server shutting down and client tried to access missing scanner " + scannerName2);
                    }
                    if ((leaseManager = this.regionServer.getLeaseManager()) != null) {
                        try {
                            leaseManager.cancelLease(scannerName2);
                        }
                        catch (LeaseException le) {
                            if (!LOG.isTraceEnabled()) break block52;
                            LOG.trace("Un-able to cancel lease of scanner. It could already be closed.");
                        }
                    }
                }
            }
            throw new ServiceException(e);
        }
        this.requestCount.increment();
        this.rpcScanRequestCount.increment();
        ClientProtos.ScanResponse.Builder builder = ClientProtos.ScanResponse.newBuilder();
        try {
            if (request.hasScannerId()) {
                long scannerId = request.getScannerId();
                builder.setScannerId(scannerId);
                scannerName = RSRpcServices.toScannerName(scannerId);
                rsh = this.getRegionScanner(request);
            } else {
                Pair<String, RegionScannerHolder> scannerNameAndRSH = this.newRegionScanner(request, builder);
                scannerName = scannerNameAndRSH.getFirst();
                rsh = scannerNameAndRSH.getSecond();
            }
        }
        catch (IOException e) {
            if (e == SCANNER_ALREADY_CLOSED) {
                return builder.build();
            }
            throw new ServiceException(e);
        }
        if (rsh.fullRegionScan) {
            this.rpcFullScanRequestCount.increment();
        }
        HRegion region = rsh.r;
        try {
            lease = this.regionServer.getLeaseManager().removeLease(scannerName);
        }
        catch (LeaseException e) {
            throw new ServiceException(e);
        }
        if (request.hasRenew() && request.getRenew()) {
            this.addScannerLeaseBack(lease);
            try {
                this.checkScanNextCallSeq(request, rsh);
            }
            catch (OutOfOrderScannerNextException e) {
                throw new ServiceException(e);
            }
            return builder.build();
        }
        try {
            quota = this.getRpcQuotaManager().checkQuota((Region)region, OperationQuota.OperationType.SCAN);
        }
        catch (IOException e) {
            this.addScannerLeaseBack(lease);
            throw new ServiceException(e);
        }
        try {
            this.checkScanNextCallSeq(request, rsh);
        }
        catch (OutOfOrderScannerNextException e) {
            this.addScannerLeaseBack(lease);
            throw new ServiceException(e);
        }
        boolean bl = closeScanner = request.hasCloseScanner() ? request.getCloseScanner() : false;
        int rows = request.hasNumberOfRows() ? request.getNumberOfRows() : (closeScanner ? 0 : 1);
        RpcCallContext context = RpcServer.getCurrentCall().orElse(null);
        long maxQuotaResultSize = Math.min(this.maxScannerResultSize, quota.getReadAvailable());
        RegionScanner scanner = rsh.s;
        int limitOfRows = request.hasLimitOfRows() ? request.getLimitOfRows() : -1;
        MutableObject lastBlock = new MutableObject();
        boolean scannerClosed = false;
        try {
            ArrayList<Result> results = new ArrayList<Result>(Math.min(rows, 512));
            if (rows > 0) {
                boolean done = false;
                if (region.getCoprocessorHost() != null) {
                    Boolean bypass = region.getCoprocessorHost().preScannerNext(scanner, results, rows);
                    if (!results.isEmpty()) {
                        for (Result r : results) {
                            lastBlock.setValue(this.addSize(context, r, lastBlock.getValue()));
                        }
                    }
                    if (bypass != null && bypass.booleanValue()) {
                        done = true;
                    }
                }
                if (!done) {
                    this.scan((HBaseRpcController)controller, request, rsh, maxQuotaResultSize, rows, limitOfRows, results, builder, (MutableObject<Object>)lastBlock, context);
                } else {
                    builder.setMoreResultsInRegion(!results.isEmpty());
                }
            } else {
                builder.setMoreResultsInRegion(true);
            }
            quota.addScanResult(results);
            this.addResults(builder, results, (HBaseRpcController)controller, RegionReplicaUtil.isDefaultReplica(region.getRegionInfo()), this.isClientCellBlockSupport(context));
            if (scanner.isFilterDone() && results.isEmpty()) {
                builder.setMoreResults(false);
            }
            assert (builder.hasMoreResultsInRegion());
            if (!builder.hasMoreResults()) {
                builder.setMoreResults(true);
            }
            if (builder.getMoreResults() && builder.getMoreResultsInRegion() && !results.isEmpty()) {
                Result lastResult = (Result)results.get(results.size() - 1);
                if (lastResult.mayHaveMoreCellsInRow()) {
                    RegionScannerHolder.access$302(rsh, lastResult.getRow());
                } else {
                    RegionScannerHolder.access$302(rsh, null);
                }
            }
            if (!builder.getMoreResults() || !builder.getMoreResultsInRegion() || closeScanner) {
                scannerClosed = true;
                this.closeScanner(region, scanner, scannerName, context);
            }
            ClientProtos.ScanResponse lastResult = builder.build();
            return lastResult;
        }
        catch (IOException e) {
            try {
                scannerClosed = true;
                this.closeScanner(region, scanner, scannerName, context);
                if (e instanceof DoNotRetryIOException) {
                    throw e;
                }
                if (e instanceof FileNotFoundException) {
                    throw new DoNotRetryIOException(e);
                }
                if (VersionInfoUtil.hasMinimumVersion(context.getClientVersionInfo(), 1, 4)) {
                    throw new ScannerResetException("Scanner is closed on the server-side", e);
                }
                throw new UnknownScannerException("Throwing UnknownScannerException to reset the client scanner state for clients older than 1.3.", e);
            }
            catch (IOException ioe) {
                throw new ServiceException(ioe);
            }
        }
        finally {
            if (!scannerClosed) {
                if (context != null) {
                    context.setCallBack(rsh.shippedCallback);
                } else {
                    this.addScannerLeaseBack(lease);
                }
            }
            quota.close();
        }
    }

    private void closeScanner(HRegion region, RegionScanner scanner, String scannerName, RpcCallContext context) throws IOException {
        if (region.getCoprocessorHost() != null && region.getCoprocessorHost().preScannerClose(scanner)) {
            return;
        }
        RegionScannerHolder rsh = (RegionScannerHolder)this.scanners.remove(scannerName);
        if (rsh != null) {
            if (context != null) {
                context.setCallBack(rsh.closeCallBack);
            } else {
                rsh.s.close();
            }
            if (region.getCoprocessorHost() != null) {
                region.getCoprocessorHost().postScannerClose(scanner);
            }
            this.closedScanners.put(scannerName, scannerName);
        }
    }

    @Override
    public ClientProtos.CoprocessorServiceResponse execRegionServerService(RpcController controller, ClientProtos.CoprocessorServiceRequest request) throws ServiceException {
        this.rpcPreCheck("execRegionServerService");
        return this.regionServer.execRegionServerService(controller, request);
    }

    @Override
    public AdminProtos.UpdateConfigurationResponse updateConfiguration(RpcController controller, AdminProtos.UpdateConfigurationRequest request) throws ServiceException {
        try {
            this.requirePermission("updateConfiguration", Permission.Action.ADMIN);
            this.regionServer.updateConfiguration();
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
        return AdminProtos.UpdateConfigurationResponse.getDefaultInstance();
    }

    @Override
    public QuotaProtos.GetSpaceQuotaSnapshotsResponse getSpaceQuotaSnapshots(RpcController controller, QuotaProtos.GetSpaceQuotaSnapshotsRequest request) throws ServiceException {
        try {
            RegionServerSpaceQuotaManager manager = this.regionServer.getRegionServerSpaceQuotaManager();
            QuotaProtos.GetSpaceQuotaSnapshotsResponse.Builder builder = QuotaProtos.GetSpaceQuotaSnapshotsResponse.newBuilder();
            if (manager != null) {
                Map<TableName, SpaceQuotaSnapshot> snapshots = manager.copyQuotaSnapshots();
                for (Map.Entry<TableName, SpaceQuotaSnapshot> snapshot : snapshots.entrySet()) {
                    builder.addSnapshots(QuotaProtos.GetSpaceQuotaSnapshotsResponse.TableQuotaSnapshot.newBuilder().setTableName(ProtobufUtil.toProtoTableName(snapshot.getKey())).setSnapshot(SpaceQuotaSnapshot.toProtoSnapshot(snapshot.getValue())).build());
                }
            }
            return builder.build();
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public AdminProtos.ClearRegionBlockCacheResponse clearRegionBlockCache(RpcController controller, AdminProtos.ClearRegionBlockCacheRequest request) throws ServiceException {
        this.rpcPreCheck("clearRegionBlockCache");
        AdminProtos.ClearRegionBlockCacheResponse.Builder builder = AdminProtos.ClearRegionBlockCacheResponse.newBuilder();
        CacheEvictionStatsBuilder stats = CacheEvictionStats.builder();
        List<HRegion> regions = this.getRegions(request.getRegionList(), stats);
        for (HRegion region : regions) {
            try {
                stats = stats.append(this.regionServer.clearRegionBlockCache(region));
            }
            catch (Exception e) {
                stats.addException(region.getRegionInfo().getRegionName(), e);
            }
        }
        stats.withMaxCacheSize(this.regionServer.getBlockCache().map(BlockCache::getMaxSize).orElse(0L));
        return builder.setStats(ProtobufUtil.toCacheEvictionStats(stats.build())).build();
    }

    private void executeOpenRegionProcedures(AdminProtos.OpenRegionRequest request, Map<TableName, TableDescriptor> tdCache) {
        long masterSystemTime = request.hasMasterSystemTime() ? request.getMasterSystemTime() : -1L;
        for (AdminProtos.OpenRegionRequest.RegionOpenInfo regionOpenInfo : request.getOpenInfoList()) {
            long procId;
            RegionInfo regionInfo = ProtobufUtil.toRegionInfo(regionOpenInfo.getRegion());
            TableName tableName = regionInfo.getTable();
            TableDescriptor tableDesc = tdCache.get(tableName);
            if (tableDesc == null) {
                try {
                    tableDesc = this.regionServer.getTableDescriptors().get(regionInfo.getTable());
                }
                catch (IOException e) {
                    LOG.warn("Failed to get TableDescriptor of {}, will try again in the handler", (Object)regionInfo.getTable(), (Object)e);
                }
                if (tableDesc != null) {
                    tdCache.put(tableName, tableDesc);
                }
            }
            if (regionOpenInfo.getFavoredNodesCount() > 0) {
                this.regionServer.updateRegionFavoredNodesMapping(regionInfo.getEncodedName(), regionOpenInfo.getFavoredNodesList());
            }
            if (!this.regionServer.submitRegionProcedure(procId = regionOpenInfo.getOpenProcId())) continue;
            this.regionServer.executorService.submit(AssignRegionHandler.create(this.regionServer, regionInfo, procId, tableDesc, masterSystemTime));
        }
    }

    private void executeCloseRegionProcedures(AdminProtos.CloseRegionRequest request) {
        String encodedName;
        try {
            encodedName = ProtobufUtil.getRegionEncodedName(request.getRegion());
        }
        catch (DoNotRetryIOException e) {
            throw new UncheckedIOException("Should not happen", e);
        }
        ServerName destination = request.hasDestinationServer() ? ProtobufUtil.toServerName(request.getDestinationServer()) : null;
        long procId = request.getCloseProcId();
        if (this.regionServer.submitRegionProcedure(procId)) {
            this.regionServer.executorService.submit(UnassignRegionHandler.create(this.regionServer, encodedName, procId, false, destination));
        }
    }

    private void executeProcedures(AdminProtos.RemoteProcedureRequest request) {
        RSProcedureCallable callable;
        try {
            callable = Class.forName(request.getProcClass()).asSubclass(RSProcedureCallable.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            LOG.warn("Failed to instantiating remote procedure {}, pid={}", new Object[]{request.getProcClass(), request.getProcId(), e});
            this.regionServer.remoteProcedureComplete(request.getProcId(), e);
            return;
        }
        callable.init(request.getProcData().toByteArray(), this.regionServer);
        LOG.debug("Executing remote procedure {}, pid={}", callable.getClass(), (Object)request.getProcId());
        this.regionServer.executeProcedure(request.getProcId(), callable);
    }

    @Override
    @QosPriority(priority=100)
    public AdminProtos.ExecuteProceduresResponse executeProcedures(RpcController controller, AdminProtos.ExecuteProceduresRequest request) throws ServiceException {
        try {
            this.checkOpen();
            this.throwOnWrongStartCode(request);
            this.regionServer.getRegionServerCoprocessorHost().preExecuteProcedures();
            if (request.getOpenRegionCount() > 0) {
                HashMap tdCache = new HashMap();
                request.getOpenRegionList().forEach(req -> this.executeOpenRegionProcedures((AdminProtos.OpenRegionRequest)req, tdCache));
            }
            if (request.getCloseRegionCount() > 0) {
                request.getCloseRegionList().forEach(this::executeCloseRegionProcedures);
            }
            if (request.getProcCount() > 0) {
                request.getProcList().forEach(this::executeProcedures);
            }
            this.regionServer.getRegionServerCoprocessorHost().postExecuteProcedures();
            return AdminProtos.ExecuteProceduresResponse.getDefaultInstance();
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }

    @Override
    @QosPriority(priority=100)
    public AdminProtos.SlowLogResponses getSlowLogResponses(RpcController controller, AdminProtos.SlowLogResponseRequest request) {
        NamedQueueRecorder namedQueueRecorder = this.regionServer.getNamedQueueRecorder();
        List<TooSlowLog.SlowLogPayload> slowLogPayloads = this.getSlowLogPayloads(request, namedQueueRecorder);
        AdminProtos.SlowLogResponses slowLogResponses = AdminProtos.SlowLogResponses.newBuilder().addAllSlowLogPayloads(slowLogPayloads).build();
        return slowLogResponses;
    }

    private List<TooSlowLog.SlowLogPayload> getSlowLogPayloads(AdminProtos.SlowLogResponseRequest request, NamedQueueRecorder namedQueueRecorder) {
        if (namedQueueRecorder == null) {
            return Collections.emptyList();
        }
        NamedQueueGetRequest namedQueueGetRequest = new NamedQueueGetRequest();
        namedQueueGetRequest.setNamedQueueEvent(0);
        namedQueueGetRequest.setSlowLogResponseRequest(request);
        NamedQueueGetResponse namedQueueGetResponse = namedQueueRecorder.getNamedQueueRecords(namedQueueGetRequest);
        List<TooSlowLog.SlowLogPayload> slowLogPayloads = namedQueueGetResponse != null ? namedQueueGetResponse.getSlowLogPayloads() : Collections.emptyList();
        return slowLogPayloads;
    }

    @Override
    @QosPriority(priority=100)
    public AdminProtos.SlowLogResponses getLargeLogResponses(RpcController controller, AdminProtos.SlowLogResponseRequest request) {
        NamedQueueRecorder namedQueueRecorder = this.regionServer.getNamedQueueRecorder();
        List<TooSlowLog.SlowLogPayload> slowLogPayloads = this.getSlowLogPayloads(request, namedQueueRecorder);
        AdminProtos.SlowLogResponses slowLogResponses = AdminProtos.SlowLogResponses.newBuilder().addAllSlowLogPayloads(slowLogPayloads).build();
        return slowLogResponses;
    }

    @Override
    @QosPriority(priority=100)
    public AdminProtos.ClearSlowLogResponses clearSlowLogsResponses(RpcController controller, AdminProtos.ClearSlowLogResponseRequest request) throws ServiceException {
        this.rpcPreCheck("clearSlowLogsResponses");
        NamedQueueRecorder namedQueueRecorder = this.regionServer.getNamedQueueRecorder();
        boolean slowLogsCleaned = Optional.ofNullable(namedQueueRecorder).map(queueRecorder -> queueRecorder.clearNamedQueue(NamedQueuePayload.NamedQueueEvent.SLOW_LOG)).orElse(false);
        AdminProtos.ClearSlowLogResponses clearSlowLogResponses = AdminProtos.ClearSlowLogResponses.newBuilder().setIsCleaned(slowLogsCleaned).build();
        return clearSlowLogResponses;
    }

    @Override
    public HBaseProtos.LogEntry getLogEntries(RpcController controller, HBaseProtos.LogRequest request) throws ServiceException {
        try {
            String logClassName = request.getLogClassName();
            Class<org.apache.hudi.org.apache.hbase.thirdparty.com.google.protobuf.Message> logClass = Class.forName(logClassName).asSubclass(org.apache.hudi.org.apache.hbase.thirdparty.com.google.protobuf.Message.class);
            Method method = logClass.getMethod("parseFrom", ByteString.class);
            if (logClassName.contains("SlowLogResponseRequest")) {
                AdminProtos.SlowLogResponseRequest slowLogResponseRequest = (AdminProtos.SlowLogResponseRequest)method.invoke(null, request.getLogMessage());
                NamedQueueRecorder namedQueueRecorder = this.regionServer.getNamedQueueRecorder();
                List<TooSlowLog.SlowLogPayload> slowLogPayloads = this.getSlowLogPayloads(slowLogResponseRequest, namedQueueRecorder);
                AdminProtos.SlowLogResponses slowLogResponses = AdminProtos.SlowLogResponses.newBuilder().addAllSlowLogPayloads(slowLogPayloads).build();
                return HBaseProtos.LogEntry.newBuilder().setLogClassName(slowLogResponses.getClass().getName()).setLogMessage(slowLogResponses.toByteString()).build();
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            LOG.error("Error while retrieving log entries.", (Throwable)e);
            throw new ServiceException(e);
        }
        throw new ServiceException("Invalid request params");
    }

    public RpcScheduler getRpcScheduler() {
        return this.rpcServer.getScheduler();
    }

    protected AccessChecker getAccessChecker() {
        return this.accessChecker;
    }

    protected ZKPermissionWatcher getZkPermissionWatcher() {
        return this.zkPermissionWatcher;
    }

    private class ScannerListener
    implements LeaseListener {
        private final String scannerName;

        ScannerListener(String n) {
            this.scannerName = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void leaseExpired() {
            block15: {
                HRegion region;
                RegionScanner s;
                RegionScannerHolder rsh;
                block14: {
                    rsh = (RegionScannerHolder)RSRpcServices.this.scanners.remove(this.scannerName);
                    if (rsh == null) {
                        LOG.warn("Scanner lease {} expired but no outstanding scanner", (Object)this.scannerName);
                        return;
                    }
                    LOG.info("Scanner lease {} expired {}", (Object)this.scannerName, (Object)rsh);
                    s = rsh.s;
                    region = null;
                    region = RSRpcServices.this.regionServer.getRegion(s.getRegionInfo().getRegionName());
                    if (region == null || region.getCoprocessorHost() == null) break block14;
                    region.getCoprocessorHost().preScannerClose(s);
                }
                try {
                    s.close();
                    if (region != null && region.getCoprocessorHost() != null) {
                        region.getCoprocessorHost().postScannerClose(s);
                    }
                    break block15;
                }
                catch (IOException e) {
                    LOG.error("Closing scanner {} {}", new Object[]{this.scannerName, rsh, e});
                }
                break block15;
                catch (IOException e) {
                    try {
                        LOG.error("Closing scanner {} {}", new Object[]{this.scannerName, rsh, e});
                    }
                    catch (Throwable throwable) {
                        try {
                            s.close();
                            if (region != null && region.getCoprocessorHost() != null) {
                                region.getCoprocessorHost().postScannerClose(s);
                            }
                        }
                        catch (IOException e2) {
                            LOG.error("Closing scanner {} {}", new Object[]{this.scannerName, rsh, e2});
                        }
                        throw throwable;
                    }
                    try {
                        s.close();
                        if (region != null && region.getCoprocessorHost() != null) {
                            region.getCoprocessorHost().postScannerClose(s);
                        }
                    }
                    catch (IOException e3) {
                        LOG.error("Closing scanner {} {}", new Object[]{this.scannerName, rsh, e3});
                    }
                }
            }
        }
    }

    static final class RegionScannerHolder {
        private final AtomicLong nextCallSeq = new AtomicLong(0L);
        private final RegionScanner s;
        private final HRegion r;
        private final RpcCallback closeCallBack;
        private final RpcCallback shippedCallback;
        private byte[] rowOfLastPartialResult;
        private boolean needCursor;
        private boolean fullRegionScan;
        private final String clientIPAndPort;
        private final String userName;

        RegionScannerHolder(RegionScanner s, HRegion r, RpcCallback closeCallBack, RpcCallback shippedCallback, boolean needCursor, boolean fullRegionScan, String clientIPAndPort, String userName) {
            this.s = s;
            this.r = r;
            this.closeCallBack = closeCallBack;
            this.shippedCallback = shippedCallback;
            this.needCursor = needCursor;
            this.fullRegionScan = fullRegionScan;
            this.clientIPAndPort = clientIPAndPort;
            this.userName = userName;
        }

        long getNextCallSeq() {
            return this.nextCallSeq.get();
        }

        boolean incNextCallSeq(long currentSeq) {
            return this.nextCallSeq.compareAndSet(currentSeq, currentSeq + 1L);
        }

        public String toString() {
            return "clientIPAndPort=" + this.clientIPAndPort + ", userName=" + this.userName + ", regionInfo=" + this.r.getRegionInfo().getRegionNameAsString();
        }

        static /* synthetic */ byte[] access$302(RegionScannerHolder x0, byte[] x1) {
            x0.rowOfLastPartialResult = x1;
            return x1;
        }
    }

    static class RegionScannersCloseCallBack
    implements RpcCallback {
        private final List<RegionScanner> scanners = new ArrayList<RegionScanner>();

        RegionScannersCloseCallBack() {
        }

        public void addScanner(RegionScanner scanner) {
            this.scanners.add(scanner);
        }

        @Override
        public void run() {
            for (RegionScanner scanner : this.scanners) {
                try {
                    scanner.close();
                }
                catch (IOException e) {
                    LOG.error("Exception while closing the scanner " + scanner, (Throwable)e);
                }
            }
        }
    }

    private class RegionScannerShippedCallBack
    implements RpcCallback {
        private final String scannerName;
        private final Shipper shipper;
        private final LeaseManager.Lease lease;

        public RegionScannerShippedCallBack(String scannerName, Shipper shipper, LeaseManager.Lease lease) {
            this.scannerName = scannerName;
            this.shipper = shipper;
            this.lease = lease;
        }

        @Override
        public void run() throws IOException {
            this.shipper.shipped();
            if (RSRpcServices.this.scanners.containsKey(this.scannerName) && this.lease != null) {
                RSRpcServices.this.regionServer.getLeaseManager().addLease(this.lease);
            }
        }
    }

    private static final class RegionScannerCloseCallBack
    implements RpcCallback {
        private final RegionScanner scanner;

        public RegionScannerCloseCallBack(RegionScanner scanner) {
            this.scanner = scanner;
        }

        @Override
        public void run() throws IOException {
            this.scanner.close();
        }
    }
}

