/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling.unmarshallers;

import com.amazonaws.services.dynamodbv2.datamodeling.unmarshallers.BSUnmarshaller;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import java.nio.ByteBuffer;
import java.util.HashSet;

public class ByteArraySetUnmarshaller
extends BSUnmarshaller {
    private static final ByteArraySetUnmarshaller INSTANCE = new ByteArraySetUnmarshaller();

    public static ByteArraySetUnmarshaller instance() {
        return INSTANCE;
    }

    private ByteArraySetUnmarshaller() {
    }

    @Override
    public Object unmarshall(AttributeValue value) {
        HashSet<byte[]> result = new HashSet<byte[]>();
        for (ByteBuffer buffer : value.getBS()) {
            if (buffer.hasArray()) {
                result.add(buffer.array());
                continue;
            }
            byte[] array2 = new byte[buffer.remaining()];
            buffer.get(array2);
            result.add(array2);
        }
        return result;
    }
}

