/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling.unmarshallers;

import com.amazonaws.services.dynamodbv2.datamodeling.ArgumentUnmarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMappingException;
import com.amazonaws.services.dynamodbv2.datamodeling.unmarshallers.LUnmarshaller;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import java.text.ParseException;
import java.util.LinkedHashSet;
import java.util.List;

public class ObjectSetUnmarshaller
extends LUnmarshaller {
    private static final ObjectSetUnmarshaller INSTANCE = new ObjectSetUnmarshaller();
    private final ArgumentUnmarshaller memberUnmarshaller;

    public static ObjectSetUnmarshaller instance() {
        return INSTANCE;
    }

    private ObjectSetUnmarshaller() {
        this.memberUnmarshaller = null;
    }

    public ObjectSetUnmarshaller(ArgumentUnmarshaller memberUnmarshaller) {
        if (memberUnmarshaller == null) {
            throw new NullPointerException("memberUnmarshaller");
        }
        this.memberUnmarshaller = memberUnmarshaller;
    }

    @Override
    public Object unmarshall(AttributeValue value) throws ParseException {
        List<AttributeValue> values2 = value.getL();
        int size = Math.max(values2.size() * 2, 11);
        LinkedHashSet<Object> objects = new LinkedHashSet<Object>(size);
        for (AttributeValue v : values2) {
            this.memberUnmarshaller.typeCheck(v, null);
            Object o = this.memberUnmarshaller.unmarshall(v);
            if (objects.add(o)) continue;
            throw new DynamoDBMappingException("Duplicate value (" + o + ") found in " + values2);
        }
        return objects;
    }
}

