/*
 * Decompiled with CFR 0.152.
 */
package io.javalin;

import io.javalin.ErrorHandler;
import io.javalin.EventListener;
import io.javalin.ExceptionHandler;
import io.javalin.Extension;
import io.javalin.Handler;
import io.javalin.HandlerMetaInfo;
import io.javalin.JavalinEvent;
import io.javalin.RequestLogger;
import io.javalin.apibuilder.ApiBuilder;
import io.javalin.apibuilder.EndpointGroup;
import io.javalin.core.ErrorMapper;
import io.javalin.core.EventManager;
import io.javalin.core.ExceptionMapper;
import io.javalin.core.HandlerEntry;
import io.javalin.core.HandlerType;
import io.javalin.core.JavalinServlet;
import io.javalin.core.PathMatcher;
import io.javalin.core.util.CorsBeforeHandler;
import io.javalin.core.util.CorsOptionsHandler;
import io.javalin.core.util.JettyServerUtil;
import io.javalin.core.util.LogUtil;
import io.javalin.core.util.RouteOverviewRenderer;
import io.javalin.core.util.SinglePageHandler;
import io.javalin.core.util.Util;
import io.javalin.metrics.JavalinMicrometer;
import io.javalin.security.AccessManager;
import io.javalin.security.CoreRoles;
import io.javalin.security.Role;
import io.javalin.security.SecurityUtil;
import io.javalin.serversentevent.SseClient;
import io.javalin.serversentevent.SseHandler;
import io.javalin.staticfiles.JettyResourceHandler;
import io.javalin.staticfiles.Location;
import io.javalin.staticfiles.StaticFileConfig;
import io.javalin.websocket.WsEntry;
import io.javalin.websocket.WsHandler;
import io.javalin.websocket.WsPathMatcher;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.hudi.org.eclipse.jetty.server.Server;
import org.apache.hudi.org.eclipse.jetty.server.session.SessionHandler;
import org.apache.hudi.org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Javalin {
    private static Logger log = LoggerFactory.getLogger(Javalin.class);
    protected Server jettyServer;
    protected SessionHandler jettySessionHandler;
    protected Set<StaticFileConfig> staticFileConfig = new HashSet<StaticFileConfig>();
    protected boolean ignoreTrailingSlashes = true;
    protected int port = 7000;
    protected String contextPath = "/";
    protected String defaultContentType = "text/plain";
    protected long maxRequestCacheBodySize = 4096L;
    protected boolean debugLogging = false;
    protected boolean dynamicGzipEnabled = true;
    protected boolean autogeneratedEtagsEnabled = false;
    protected boolean showStartupBanner = true;
    protected boolean prefer405over404 = false;
    protected boolean caseSensitiveUrls = false;
    protected boolean started = false;
    protected AccessManager accessManager = SecurityUtil::noopAccessManager;
    protected RequestLogger requestLogger = null;
    protected SinglePageHandler singlePageHandler = new SinglePageHandler();
    protected PathMatcher pathMatcher = new PathMatcher();
    protected WsPathMatcher wsPathMatcher = new WsPathMatcher();
    protected ExceptionMapper exceptionMapper = new ExceptionMapper();
    protected ErrorMapper errorMapper = new ErrorMapper();
    protected EventManager eventManager = new EventManager();
    protected List<HandlerMetaInfo> handlerMetaInfo = new ArrayList<HandlerMetaInfo>();
    protected Map<Class, Object> appAttributes = new HashMap<Class, Object>();
    protected Consumer<WebSocketServletFactory> wsFactoryConfig = WebSocketServletFactory::getPolicy;

    protected Javalin(Server jettyServer, SessionHandler jettySessionHandler) {
        this.jettyServer = jettyServer;
        this.jettySessionHandler = jettySessionHandler;
    }

    protected Javalin() {
        this(JettyServerUtil.defaultServer(), JettyServerUtil.defaultSessionHandler());
    }

    public static Javalin create() {
        JettyServerUtil.INSTANCE.printHelpfulMessageIfNoServerHasBeenStartedAfterOneSecond();
        return new Javalin();
    }

    public Javalin start(int port) {
        return this.port(port).start();
    }

    public Javalin start() {
        long startupTimer = System.currentTimeMillis();
        if (this.started) {
            throw new IllegalStateException("Cannot call start() again on a started server.");
        }
        if (this.showStartupBanner) {
            log.info(Util.INSTANCE.javalinBanner());
        }
        Util.INSTANCE.printHelpfulMessageIfLoggerIsMissing();
        this.eventManager.fireEvent(JavalinEvent.SERVER_STARTING);
        try {
            log.info("Starting Javalin ...");
            this.port = JettyServerUtil.initialize(this.jettyServer, this.jettySessionHandler, this.port, this.contextPath, this.createServlet(), this.wsPathMatcher, this.wsFactoryConfig);
            log.info("Javalin started in " + (System.currentTimeMillis() - startupTimer) + "ms \\o/");
            this.started = true;
            JettyServerUtil.INSTANCE.setNoJettyStarted(false);
            this.eventManager.fireEvent(JavalinEvent.SERVER_STARTED);
        }
        catch (Exception e) {
            log.error("Failed to start Javalin");
            this.eventManager.fireEvent(JavalinEvent.SERVER_START_FAILED);
            if (e.getMessage() != null && e.getMessage().contains("Failed to bind to")) {
                throw new RuntimeException("Port already in use. Make sure no other process is using port " + this.port + " and try again.", e);
            }
            if (e.getMessage() != null && e.getMessage().contains("Permission denied")) {
                throw new RuntimeException("Port 1-1023 require elevated privileges (process must be started by admin).", e);
            }
            throw new RuntimeException(e);
        }
        JettyServerUtil.reEnableJettyLogger();
        return this;
    }

    @NotNull
    public JavalinServlet createServlet() {
        return new JavalinServlet(this, this.pathMatcher, this.exceptionMapper, this.errorMapper, this.debugLogging, this.requestLogger, this.dynamicGzipEnabled, this.autogeneratedEtagsEnabled, this.defaultContentType, this.maxRequestCacheBodySize, this.prefer405over404, this.singlePageHandler, new JettyResourceHandler(this.staticFileConfig, this.jettyServer, this.ignoreTrailingSlashes));
    }

    public Javalin stop() {
        this.eventManager.fireEvent(JavalinEvent.SERVER_STOPPING);
        log.info("Stopping Javalin ...");
        try {
            this.jettyServer.stop();
        }
        catch (Exception e) {
            log.error("Javalin failed to stop gracefully", (Throwable)e);
        }
        log.info("Javalin has stopped");
        this.eventManager.fireEvent(JavalinEvent.SERVER_STOPPED);
        return this;
    }

    public Javalin prefer405over404() {
        this.ensureActionIsPerformedBeforeServerStart("Telling Javalin to return 405 instead of 404 when applicable");
        this.prefer405over404 = true;
        return this;
    }

    public Javalin enableCaseSensitiveUrls() {
        this.ensureActionIsPerformedBeforeServerStart("Enabling case sensitive urls");
        this.caseSensitiveUrls = true;
        return this;
    }

    public Javalin disableStartupBanner() {
        this.ensureActionIsPerformedBeforeServerStart("Telling Javalin to not show banner in logs");
        this.showStartupBanner = false;
        return this;
    }

    public Javalin dontIgnoreTrailingSlashes() {
        this.ensureActionIsPerformedBeforeServerStart("Telling Javalin to not ignore slashes");
        this.pathMatcher.setIgnoreTrailingSlashes(false);
        this.ignoreTrailingSlashes = false;
        return this;
    }

    public Javalin server(@NotNull Supplier<Server> server) {
        this.ensureActionIsPerformedBeforeServerStart("Setting a custom server");
        this.jettyServer = server.get();
        return this;
    }

    public Javalin sessionHandler(@NotNull Supplier<SessionHandler> sessionHandler) {
        this.ensureActionIsPerformedBeforeServerStart("Setting a custom session handler");
        this.jettySessionHandler = JettyServerUtil.INSTANCE.getSessionHandler(sessionHandler);
        return this;
    }

    public Javalin wsFactoryConfig(@NotNull Consumer<WebSocketServletFactory> wsFactoryConfig) {
        this.ensureActionIsPerformedBeforeServerStart("Setting a custom WebSocket factory config");
        this.wsFactoryConfig = wsFactoryConfig;
        return this;
    }

    public Javalin enableStaticFiles(@NotNull String classpathPath) {
        return this.enableStaticFiles(classpathPath, Location.CLASSPATH);
    }

    public Javalin enableStaticFiles(@NotNull String path, @NotNull Location location) {
        this.ensureActionIsPerformedBeforeServerStart("Enabling static files");
        this.staticFileConfig.add(new StaticFileConfig(path, location));
        return this;
    }

    public Javalin enableWebJars() {
        return this.enableStaticFiles("/webjars", Location.CLASSPATH);
    }

    public Javalin enableSinglePageMode(@NotNull String path, @NotNull String filePath) {
        return this.enableSinglePageMode(path, filePath, Location.CLASSPATH);
    }

    public Javalin enableSinglePageMode(@NotNull String path, @NotNull String filePath, @NotNull Location location) {
        this.ensureActionIsPerformedBeforeServerStart("Enabling single page mode");
        this.singlePageHandler.add(path, filePath, location);
        return this;
    }

    public Javalin contextPath(@NotNull String contextPath) {
        this.ensureActionIsPerformedBeforeServerStart("Setting the context path");
        this.contextPath = Util.INSTANCE.normalizeContextPath(contextPath);
        return this;
    }

    public int port() {
        return this.port;
    }

    public Javalin port(int port) {
        this.ensureActionIsPerformedBeforeServerStart("Setting the port");
        this.port = port;
        return this;
    }

    public Javalin enableDebugLogging() {
        this.ensureActionIsPerformedBeforeServerStart("Enabling debug-logging");
        this.debugLogging = true;
        this.wsLogger(LogUtil::wsDebugLogger);
        return this;
    }

    public Javalin requestLogger(@NotNull RequestLogger requestLogger) {
        this.ensureActionIsPerformedBeforeServerStart("Setting a custom request logger");
        this.requestLogger = requestLogger;
        return this;
    }

    public Javalin enableMicrometer() {
        JavalinMicrometer.init(this.jettyServer);
        return this;
    }

    public Javalin enableCorsForOrigin(String ... origin) {
        this.ensureActionIsPerformedBeforeServerStart("Enabling CORS");
        if (origin.length == 0) {
            throw new IllegalArgumentException("Origins cannot be empty.");
        }
        this.before("*", new CorsBeforeHandler(origin));
        this.options("*", new CorsOptionsHandler(), SecurityUtil.roles(CoreRoles.NO_WRAP));
        return this;
    }

    public Javalin enableCorsForAllOrigins() {
        return this.enableCorsForOrigin("*");
    }

    public Javalin disableDynamicGzip() {
        this.ensureActionIsPerformedBeforeServerStart("Disabling dynamic GZIP");
        this.dynamicGzipEnabled = false;
        return this;
    }

    public Javalin enableAutogeneratedEtags() {
        this.ensureActionIsPerformedBeforeServerStart("Enabling autogenerated etags");
        this.autogeneratedEtagsEnabled = true;
        return this;
    }

    public Javalin enableRouteOverview(@NotNull String path) {
        return this.enableRouteOverview(path, new HashSet<Role>());
    }

    public Javalin enableRouteOverview(@NotNull String path, @NotNull Set<Role> permittedRoles) {
        this.ensureActionIsPerformedBeforeServerStart("Enabling route overview");
        return this.get(path, new RouteOverviewRenderer(this), permittedRoles);
    }

    public Javalin defaultContentType(@NotNull String contentType) {
        this.ensureActionIsPerformedBeforeServerStart("Changing default content type");
        this.defaultContentType = contentType;
        return this;
    }

    public Javalin maxBodySizeForRequestCache(long bodySizeInBytes) {
        this.ensureActionIsPerformedBeforeServerStart("Changing request cache body size");
        this.maxRequestCacheBodySize = bodySizeInBytes;
        return this;
    }

    public Javalin attribute(Class clazz, Object obj) {
        this.ensureActionIsPerformedBeforeServerStart("Registering app attributes");
        this.appAttributes.put(clazz, obj);
        return this;
    }

    public <T> T attribute(Class<T> clazz) {
        return (T)this.appAttributes.get(clazz);
    }

    public Javalin disableRequestCache() {
        return this.maxBodySizeForRequestCache(0L);
    }

    private void ensureActionIsPerformedBeforeServerStart(@NotNull String action) {
        if (this.started) {
            throw new IllegalStateException(action + " must be done before starting the server.");
        }
    }

    public Javalin accessManager(@NotNull AccessManager accessManager) {
        this.ensureActionIsPerformedBeforeServerStart("Setting an AccessManager");
        this.accessManager = accessManager;
        return this;
    }

    public <T extends Exception> Javalin exception(@NotNull Class<T> exceptionClass, @NotNull ExceptionHandler<? super T> exceptionHandler) {
        this.exceptionMapper.getExceptionMap().put(exceptionClass, exceptionHandler);
        return this;
    }

    public Javalin event(@NotNull JavalinEvent javalinEvent, @NotNull EventListener eventListener) {
        this.ensureActionIsPerformedBeforeServerStart("Event-mapping");
        this.eventManager.getListenerMap().get((Object)javalinEvent).add(eventListener);
        return this;
    }

    public Javalin wsLogger(@NotNull Consumer<WsHandler> ws) {
        this.ensureActionIsPerformedBeforeServerStart("Adding a WebSocket logger");
        WsHandler wsLogger = new WsHandler();
        ws.accept(wsLogger);
        this.wsPathMatcher.setWsLogger(wsLogger);
        return this;
    }

    public Javalin error(int statusCode, @NotNull ErrorHandler errorHandler) {
        this.errorMapper.getErrorHandlerMap().put(statusCode, errorHandler);
        return this;
    }

    public Javalin register(Extension extension) {
        extension.registerOnJavalin(this);
        return this;
    }

    public Javalin routes(@NotNull EndpointGroup endpointGroup) {
        ApiBuilder.setStaticJavalin(this);
        endpointGroup.addEndpoints();
        ApiBuilder.clearStaticJavalin();
        return this;
    }

    public Javalin addHandler(@NotNull HandlerType handlerType, @NotNull String path, @NotNull Handler handler, @NotNull Set<Role> roles) {
        boolean shouldWrap = handlerType.isHttpMethod() && !roles.contains(CoreRoles.NO_WRAP);
        String prefixedPath = Util.prefixContextPath(this.contextPath, path);
        Handler protectedHandler = shouldWrap ? ctx -> this.accessManager.manage(handler, ctx, roles) : handler;
        this.pathMatcher.add(new HandlerEntry(handlerType, prefixedPath, protectedHandler, handler, this.caseSensitiveUrls));
        this.handlerMetaInfo.add(new HandlerMetaInfo(handlerType, prefixedPath, handler, roles));
        return this;
    }

    public Javalin addHandler(@NotNull HandlerType httpMethod, @NotNull String path, @NotNull Handler handler) {
        return this.addHandler(httpMethod, path, handler, new HashSet<Role>());
    }

    public Javalin get(@NotNull String path, @NotNull Handler handler) {
        return this.addHandler(HandlerType.GET, path, handler);
    }

    public Javalin post(@NotNull String path, @NotNull Handler handler) {
        return this.addHandler(HandlerType.POST, path, handler);
    }

    public Javalin put(@NotNull String path, @NotNull Handler handler) {
        return this.addHandler(HandlerType.PUT, path, handler);
    }

    public Javalin patch(@NotNull String path, @NotNull Handler handler) {
        return this.addHandler(HandlerType.PATCH, path, handler);
    }

    public Javalin delete(@NotNull String path, @NotNull Handler handler) {
        return this.addHandler(HandlerType.DELETE, path, handler);
    }

    public Javalin head(@NotNull String path, @NotNull Handler handler) {
        return this.addHandler(HandlerType.HEAD, path, handler);
    }

    public Javalin trace(@NotNull String path, @NotNull Handler handler) {
        return this.addHandler(HandlerType.TRACE, path, handler);
    }

    public Javalin connect(@NotNull String path, @NotNull Handler handler) {
        return this.addHandler(HandlerType.CONNECT, path, handler);
    }

    public Javalin options(@NotNull String path, @NotNull Handler handler) {
        return this.addHandler(HandlerType.OPTIONS, path, handler);
    }

    public Javalin get(@NotNull String path, @NotNull Handler handler, @NotNull Set<Role> permittedRoles) {
        return this.addHandler(HandlerType.GET, path, handler, permittedRoles);
    }

    public Javalin post(@NotNull String path, @NotNull Handler handler, @NotNull Set<Role> permittedRoles) {
        return this.addHandler(HandlerType.POST, path, handler, permittedRoles);
    }

    public Javalin put(@NotNull String path, @NotNull Handler handler, @NotNull Set<Role> permittedRoles) {
        return this.addHandler(HandlerType.PUT, path, handler, permittedRoles);
    }

    public Javalin patch(@NotNull String path, @NotNull Handler handler, @NotNull Set<Role> permittedRoles) {
        return this.addHandler(HandlerType.PATCH, path, handler, permittedRoles);
    }

    public Javalin delete(@NotNull String path, @NotNull Handler handler, @NotNull Set<Role> permittedRoles) {
        return this.addHandler(HandlerType.DELETE, path, handler, permittedRoles);
    }

    public Javalin head(@NotNull String path, @NotNull Handler handler, @NotNull Set<Role> permittedRoles) {
        return this.addHandler(HandlerType.HEAD, path, handler, permittedRoles);
    }

    public Javalin trace(@NotNull String path, @NotNull Handler handler, @NotNull Set<Role> permittedRoles) {
        return this.addHandler(HandlerType.TRACE, path, handler, permittedRoles);
    }

    public Javalin connect(@NotNull String path, @NotNull Handler handler, @NotNull Set<Role> permittedRoles) {
        return this.addHandler(HandlerType.CONNECT, path, handler, permittedRoles);
    }

    public Javalin options(@NotNull String path, @NotNull Handler handler, @NotNull Set<Role> permittedRoles) {
        return this.addHandler(HandlerType.OPTIONS, path, handler, permittedRoles);
    }

    public Javalin before(@NotNull String path, @NotNull Handler handler) {
        return this.addHandler(HandlerType.BEFORE, path, handler);
    }

    public Javalin before(@NotNull Handler handler) {
        return this.before("*", handler);
    }

    public Javalin after(@NotNull String path, @NotNull Handler handler) {
        return this.addHandler(HandlerType.AFTER, path, handler);
    }

    public Javalin after(@NotNull Handler handler) {
        return this.after("*", handler);
    }

    public Javalin ws(@NotNull String path, @NotNull Consumer<WsHandler> ws) {
        String prefixedPath = Util.prefixContextPath(this.contextPath, path);
        WsHandler configuredWebSocket = new WsHandler();
        ws.accept(configuredWebSocket);
        this.wsPathMatcher.add(new WsEntry(prefixedPath, configuredWebSocket, this.caseSensitiveUrls));
        this.handlerMetaInfo.add(new HandlerMetaInfo(HandlerType.WEBSOCKET, prefixedPath, ws, new HashSet()));
        return this;
    }

    public List<HandlerMetaInfo> getHandlerMetaInfo() {
        return new ArrayList<HandlerMetaInfo>(this.handlerMetaInfo);
    }

    public Javalin sse(@NotNull String path, @NotNull Consumer<SseClient> client) {
        return this.sse(path, client, new HashSet<Role>());
    }

    public Javalin sse(@NotNull String path, @NotNull Consumer<SseClient> client, @NotNull Set<Role> permittedRoles) {
        return this.get(path, new SseHandler(client), permittedRoles);
    }
}

