/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.errorhandling;

import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class TimeoutException
extends Exception {
    private final String sourceName;
    private final long start;
    private final long end;
    private final long expected;

    public TimeoutException(String sourceName, long start2, long end, long expected) {
        super("Timeout elapsed! Source:" + sourceName + " Start:" + start2 + ", End:" + end + ", diff:" + (end - start2) + ", max:" + expected + " ms");
        this.sourceName = sourceName;
        this.start = start2;
        this.end = end;
        this.expected = expected;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public long getMaxAllowedOperationTime() {
        return this.expected;
    }

    public String getSourceName() {
        return this.sourceName;
    }
}

