/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.exceptions;

import java.net.ConnectException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class PreemptiveFastFailException
extends ConnectException {
    private static final long serialVersionUID = 7129103682617007177L;
    private long failureCount;
    private long timeOfFirstFailureMilliSec;
    private long timeOfLatestAttemptMilliSec;

    public PreemptiveFastFailException(long count2, long timeOfFirstFailureMilliSec, long timeOfLatestAttemptMilliSec, ServerName serverName) {
        super("Exception happened " + count2 + " times. to" + serverName);
        this.failureCount = count2;
        this.timeOfFirstFailureMilliSec = timeOfFirstFailureMilliSec;
        this.timeOfLatestAttemptMilliSec = timeOfLatestAttemptMilliSec;
    }

    public long getFirstFailureAt() {
        return this.timeOfFirstFailureMilliSec;
    }

    public long getLastAttemptAt() {
        return this.timeOfLatestAttemptMilliSec;
    }

    public long getFailureCount() {
        return this.failureCount;
    }

    public boolean wasOperationAttemptedByServer() {
        return false;
    }
}

