/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.hadoop.hbase.classification.InterfaceAudience;

@InterfaceAudience.Private
public class ArrayUtils {
    public static int length(byte[] a) {
        if (a == null) {
            return 0;
        }
        return a.length;
    }

    public static int length(long[] a) {
        if (a == null) {
            return 0;
        }
        return a.length;
    }

    public static int length(Object[] a) {
        if (a == null) {
            return 0;
        }
        return a.length;
    }

    public static boolean isEmpty(byte[] a) {
        if (a == null) {
            return true;
        }
        return a.length == 0;
    }

    public static boolean isEmpty(long[] a) {
        if (a == null) {
            return true;
        }
        return a.length == 0;
    }

    public static boolean isEmpty(Object[] a) {
        if (a == null) {
            return true;
        }
        return a.length == 0;
    }

    public static long getFirst(long[] a) {
        return a[0];
    }

    public static long getLast(long[] a) {
        return a[a.length - 1];
    }

    public static int getTotalLengthOfArrays(Iterable<byte[]> arrays) {
        if (arrays == null) {
            return 0;
        }
        int length = 0;
        for (byte[] bytes : arrays) {
            length += ArrayUtils.length(bytes);
        }
        return length;
    }

    public static ArrayList<Long> toList(long[] array2) {
        int length = ArrayUtils.length(array2);
        ArrayList<Long> list = new ArrayList<Long>(length);
        for (int i = 0; i < length; ++i) {
            list.add(array2[i]);
        }
        return list;
    }

    public static byte[] growIfNecessary(byte[] array2, int minLength, int numAdditionalBytes) {
        if (array2.length >= minLength) {
            return array2;
        }
        return Arrays.copyOf(array2, minLength + numAdditionalBytes);
    }

    public static int[] growIfNecessary(int[] array2, int minLength, int numAdditionalInts) {
        if (array2.length >= minLength) {
            return array2;
        }
        return Arrays.copyOf(array2, minLength + numAdditionalInts);
    }

    public static long[] growIfNecessary(long[] array2, int minLength, int numAdditionalLongs) {
        if (array2.length >= minLength) {
            return array2;
        }
        return Arrays.copyOf(array2, minLength + numAdditionalLongs);
    }
}

