/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.DataSourceUtils;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.HoodieDatasetBulkInsertHelper;
import org.apache.hudi.HoodieSparkSqlWriter;
import org.apache.hudi.HoodieSparkUtils$;
import org.apache.hudi.HoodieWriterUtils$;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.client.HoodieWriteResult;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.util.CommitUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.config.HoodieBootstrapConfig;
import org.apache.hudi.config.HoodieInternalConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.execution.bulkinsert.BulkInsertInternalPartitionerWithRowsFactory;
import org.apache.hudi.execution.bulkinsert.NonSortPartitionerWithRows;
import org.apache.hudi.hive.HiveSyncConfig;
import org.apache.hudi.hive.HiveSyncTool;
import org.apache.hudi.index.SparkHoodieIndexFactory;
import org.apache.hudi.keygen.KeyGenerator;
import org.apache.hudi.keygen.factory.HoodieSparkKeyGeneratorFactory;
import org.apache.hudi.sync.common.AbstractSyncTool;
import org.apache.hudi.table.BulkInsertPartitioner;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.package$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.StaticSQLConf$;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple6;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;

public final class HoodieSparkSqlWriter$ {
    public static final HoodieSparkSqlWriter$ MODULE$;
    private final Logger org$apache$hudi$HoodieSparkSqlWriter$$log;
    private boolean tableExists;
    private boolean asyncCompactionTriggerFnDefined;
    private boolean asyncClusteringTriggerFnDefined;

    static {
        new HoodieSparkSqlWriter$();
    }

    public Logger org$apache$hudi$HoodieSparkSqlWriter$$log() {
        return this.org$apache$hudi$HoodieSparkSqlWriter$$log;
    }

    private boolean tableExists() {
        return this.tableExists;
    }

    private void tableExists_$eq(boolean x$1) {
        this.tableExists = x$1;
    }

    private boolean asyncCompactionTriggerFnDefined() {
        return this.asyncCompactionTriggerFnDefined;
    }

    private void asyncCompactionTriggerFnDefined_$eq(boolean x$1) {
        this.asyncCompactionTriggerFnDefined = x$1;
    }

    private boolean asyncClusteringTriggerFnDefined() {
        return this.asyncClusteringTriggerFnDefined;
    }

    private void asyncClusteringTriggerFnDefined_$eq(boolean x$1) {
        this.asyncClusteringTriggerFnDefined = x$1;
    }

    public Tuple6<Object, Option<String>, Option<String>, Option<String>, SparkRDDWriteClient<HoodieRecordPayload<Nothing$>>, HoodieTableConfig> write(SQLContext sqlContext, SaveMode mode, scala.collection.immutable.Map<String, String> optParams, Dataset<Row> df, scala.Option<HoodieTableConfig> hoodieTableConfigOpt, scala.Option<SparkRDDWriteClient<HoodieRecordPayload<Nothing$>>> hoodieWriteClient, scala.Option<Function1<SparkRDDWriteClient<HoodieRecordPayload<Nothing$>>, BoxedUnit>> asyncCompactionTriggerFn, scala.Option<Function1<SparkRDDWriteClient<HoodieRecordPayload<Nothing$>>, BoxedUnit>> asyncClusteringTriggerFn) {
        Tuple2<scala.collection.immutable.Map<String, String>, HoodieConfig> tuple2;
        block13: {
            block14: {
                Tuple2<String, String> tuple22;
                block22: {
                    Tuple2 tuple23;
                    block23: {
                        Tuple3<Object, Option<String>, Option<String>> tuple3;
                        block24: {
                            Tuple6 tuple6;
                            block16: {
                                Tuple3 tuple32;
                                Tuple2 tuple24;
                                Tuple2 tuple25;
                                String commitActionType;
                                String instantTime;
                                JavaSparkContext jsc;
                                WriteOperationType operation;
                                scala.collection.immutable.Map parameters;
                                HoodieTableConfig tableConfig;
                                Path basePath;
                                block19: {
                                    Tuple2 tuple26;
                                    boolean reconcileSchema;
                                    Boolean dropPartitionColumns;
                                    String partitionColumns;
                                    KeyGenerator keyGenerator;
                                    String tblName;
                                    HoodieConfig hoodieConfig;
                                    FileSystem fs;
                                    SparkContext sparkContext;
                                    String path;
                                    block20: {
                                        block21: {
                                            List<Object> list;
                                            WriteOperationType writeOperationType;
                                            block17: {
                                                block18: {
                                                    HoodieTableType tableType;
                                                    block15: {
                                                        Some some;
                                                        String ser;
                                                        Tuple2 tuple27;
                                                        Predef$.MODULE$.assert(optParams.get((Object)"path").exists((Function1)new Serializable(){
                                                            public static final long serialVersionUID = 0L;

                                                            public final boolean apply(String x$1) {
                                                                return !StringUtils.isNullOrEmpty(x$1);
                                                            }
                                                        }), (Function0)new Serializable(){
                                                            public static final long serialVersionUID = 0L;

                                                            public final String apply() {
                                                                return "'path' must be set";
                                                            }
                                                        });
                                                        path = (String)optParams.apply((Object)"path");
                                                        basePath = new Path(path);
                                                        sparkContext = sqlContext.sparkContext();
                                                        fs = basePath.getFileSystem(sparkContext.hadoopConfiguration());
                                                        this.tableExists_$eq(fs.exists(new Path(basePath, ".hoodie")));
                                                        tableConfig = this.getHoodieTableConfig(sparkContext, path, hoodieTableConfigOpt);
                                                        HoodieWriterUtils$.MODULE$.validateTableConfig(sqlContext.sparkSession(), optParams, tableConfig);
                                                        tuple2 = this.mergeParamsAndGetHoodieConfig(optParams, tableConfig);
                                                        if (tuple2 == null) break block13;
                                                        scala.collection.immutable.Map parameters2 = (scala.collection.immutable.Map)tuple2._1();
                                                        HoodieConfig hoodieConfig2 = (HoodieConfig)tuple2._2();
                                                        Tuple2 tuple28 = tuple27 = new Tuple2((Object)parameters2, (Object)hoodieConfig2);
                                                        parameters = (scala.collection.immutable.Map)tuple28._1();
                                                        hoodieConfig = (HoodieConfig)tuple28._2();
                                                        tblName = hoodieConfig.getStringOrThrow(HoodieWriteConfig.TBL_NAME, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "' must be set."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{HoodieWriteConfig.TBL_NAME.key()}))).trim();
                                                        Predef$.MODULE$.assert(!StringUtils.isNullOrEmpty(hoodieConfig.getString(HoodieWriteConfig.TBL_NAME)), (Function0)new Serializable(){
                                                            public static final long serialVersionUID = 0L;

                                                            public final String apply() {
                                                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "' must be set."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{HoodieWriteConfig.TBL_NAME.key()}));
                                                            }
                                                        });
                                                        this.asyncCompactionTriggerFnDefined_$eq(asyncCompactionTriggerFn.isDefined());
                                                        this.asyncClusteringTriggerFnDefined_$eq(asyncClusteringTriggerFn.isDefined());
                                                        scala.Option option2 = sparkContext.getConf().getOption("spark.serializer");
                                                        if (!(option2 instanceof Some) || !(ser = (String)(some = (Some)option2).x()).equals("org.apache.spark.serializer.KryoSerializer")) break block14;
                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                        tableType = HoodieTableType.valueOf(hoodieConfig.getString(DataSourceWriteOptions$.MODULE$.TABLE_TYPE()));
                                                        operation = WriteOperationType.fromValue(hoodieConfig.getString(DataSourceWriteOptions$.MODULE$.OPERATION()));
                                                        if (Predef$.MODULE$.Boolean2boolean(hoodieConfig.getBoolean(DataSourceWriteOptions$.MODULE$.INSERT_DROP_DUPS()))) {
                                                            WriteOperationType writeOperationType2 = operation;
                                                            WriteOperationType writeOperationType3 = WriteOperationType.UPSERT;
                                                            if (!(writeOperationType2 != null ? !((Object)((Object)writeOperationType2)).equals((Object)writeOperationType3) : writeOperationType3 != null)) {
                                                                this.org$apache$hudi$HoodieSparkSqlWriter$$log().warn((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not applicable "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"when ", " is set to be true, "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DataSourceWriteOptions$.MODULE$.INSERT_DROP_DUPS()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"overriding the ", " to be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DataSourceWriteOptions$.MODULE$.OPERATION(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()}))).toString());
                                                                operation = WriteOperationType.INSERT;
                                                            }
                                                        }
                                                        jsc = new JavaSparkContext(sparkContext);
                                                        instantTime = HoodieActiveTimeline.createNewInstantTime();
                                                        keyGenerator = HoodieSparkKeyGeneratorFactory.createKeyGenerator(new TypedProperties(hoodieConfig.getProps()));
                                                        SaveMode saveMode = mode;
                                                        SaveMode saveMode2 = SaveMode.Ignore;
                                                        if ((saveMode != null ? !saveMode.equals(saveMode2) : saveMode2 != null) || !this.tableExists()) break block15;
                                                        this.org$apache$hudi$HoodieSparkSqlWriter$$log().warn((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hoodie table at ", " already exists. Ignoring & not performing actual writes."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{basePath})));
                                                        tuple6 = new Tuple6((Object)BoxesRunTime.boxToBoolean((boolean)false), Option.empty(), Option.empty(), Option.empty(), hoodieWriteClient.orNull(Predef$.MODULE$.$conforms()), (Object)tableConfig);
                                                        break block16;
                                                    }
                                                    this.handleSaveModes(sqlContext.sparkSession(), mode, basePath, tableConfig, tblName, operation, fs);
                                                    partitionColumns = HoodieSparkUtils$.MODULE$.getPartitionColumns(keyGenerator, this.toProperties((scala.collection.immutable.Map<String, String>)parameters));
                                                    if (!this.tableExists()) {
                                                        String baseFileFormat = hoodieConfig.getStringOrDefault(HoodieTableConfig.BASE_FILE_FORMAT);
                                                        String archiveLogFolder = hoodieConfig.getStringOrDefault(HoodieTableConfig.ARCHIVELOG_FOLDER);
                                                        String recordKeyFields = hoodieConfig.getString(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD());
                                                        boolean populateMetaFields = hoodieConfig.getBooleanOrDefault(HoodieTableConfig.POPULATE_META_FIELDS);
                                                        HoodieTableMetaClient tableMetaClient = HoodieTableMetaClient.withPropertyBuilder().setTableType(tableType).setTableName(tblName).setRecordKeyFields(recordKeyFields).setBaseFileFormat(baseFileFormat).setArchiveLogFolder(archiveLogFolder).setPayloadClassName(hoodieConfig.getString(DataSourceWriteOptions$.MODULE$.PAYLOAD_CLASS_NAME())).setPreCombineField(hoodieConfig.getStringOrDefault(DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD(), null)).setPartitionFields(partitionColumns).setPopulateMetaFields(populateMetaFields).setRecordKeyFields(hoodieConfig.getString(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD())).setKeyGeneratorClassProp(HoodieWriterUtils$.MODULE$.getOriginKeyGenerator((scala.collection.immutable.Map<String, String>)parameters)).setHiveStylePartitioningEnable(hoodieConfig.getBoolean(DataSourceWriteOptions$.MODULE$.HIVE_STYLE_PARTITIONING())).setUrlEncodePartitioning(hoodieConfig.getBoolean(DataSourceWriteOptions$.MODULE$.URL_ENCODE_PARTITIONING())).initTable(sparkContext.hadoopConfiguration(), path);
                                                        tableConfig = tableMetaClient.getTableConfig();
                                                    }
                                                    commitActionType = CommitUtils.getCommitActionType(operation, tableConfig.getTableType());
                                                    dropPartitionColumns = hoodieConfig.getBoolean(DataSourceWriteOptions$.MODULE$.DROP_PARTITION_COLUMNS());
                                                    if (Predef$.MODULE$.Boolean2boolean(hoodieConfig.getBoolean(DataSourceWriteOptions$.MODULE$.ENABLE_ROW_WRITER()))) {
                                                        WriteOperationType writeOperationType4 = operation;
                                                        WriteOperationType writeOperationType5 = WriteOperationType.BULK_INSERT;
                                                        if (!(writeOperationType4 != null ? !((Object)((Object)writeOperationType4)).equals((Object)writeOperationType5) : writeOperationType5 != null)) {
                                                            Tuple2<Object, Option<String>> tuple29 = this.bulkInsertAsRow(sqlContext, (scala.collection.immutable.Map<String, String>)parameters, df, tblName, basePath, path, instantTime, partitionColumns);
                                                            if (tuple29 != null) {
                                                                boolean success = tuple29._1$mcZ$sp();
                                                                Option commitTime = (Option)tuple29._2();
                                                                if (commitTime != null) {
                                                                    Tuple2 tuple210;
                                                                    Option option3 = commitTime;
                                                                    Tuple2 tuple211 = tuple210 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)success), (Object)option3);
                                                                    boolean success2 = tuple211._1$mcZ$sp();
                                                                    Option commitTime2 = (Option)tuple211._2();
                                                                    return new Tuple6((Object)BoxesRunTime.boxToBoolean((boolean)success2), (Object)commitTime2, Option.empty(), Option.empty(), hoodieWriteClient.orNull(Predef$.MODULE$.$conforms()), (Object)tableConfig);
                                                                }
                                                            }
                                                            throw new MatchError(tuple29);
                                                        }
                                                    }
                                                    reconcileSchema = new StringOps(Predef$.MODULE$.augmentString((String)parameters.apply((Object)DataSourceWriteOptions$.MODULE$.RECONCILE_SCHEMA().key()))).toBoolean();
                                                    writeOperationType = operation;
                                                    if (!((Object)((Object)WriteOperationType.DELETE)).equals((Object)writeOperationType)) break block17;
                                                    RDD<GenericRecord> genericRecords = this.registerKryoClassesAndGetGenericRecords(tblName, sparkContext, df, reconcileSchema);
                                                    JavaRDD hoodieKeysToDelete = genericRecords.map((Function1)new Serializable(keyGenerator){
                                                        public static final long serialVersionUID = 0L;
                                                        private final KeyGenerator keyGenerator$1;

                                                        public final HoodieKey apply(GenericRecord gr) {
                                                            return this.keyGenerator$1.getKey(gr);
                                                        }
                                                        {
                                                            this.keyGenerator$1 = keyGenerator$1;
                                                        }
                                                    }, ClassTag$.MODULE$.apply(HoodieKey.class)).toJavaRDD();
                                                    if (!this.tableExists()) break block18;
                                                    SparkRDDWriteClient client = (SparkRDDWriteClient)hoodieWriteClient.getOrElse((Function0)new Serializable(path, parameters, tblName, jsc){
                                                        public static final long serialVersionUID = 0L;
                                                        private final String path$1;
                                                        private final scala.collection.immutable.Map parameters$1;
                                                        private final String tblName$1;
                                                        private final JavaSparkContext jsc$1;

                                                        public final SparkRDDWriteClient<HoodieRecordPayload> apply() {
                                                            return DataSourceUtils.createHoodieClient(this.jsc$1, null, this.path$1, this.tblName$1, JavaConversions$.MODULE$.mapAsJavaMap(this.parameters$1.$minus((Object)HoodieWriteConfig.AUTO_COMMIT_ENABLE.key())));
                                                        }
                                                        {
                                                            this.path$1 = path$1;
                                                            this.parameters$1 = parameters$1;
                                                            this.tblName$1 = tblName$1;
                                                            this.jsc$1 = jsc$1;
                                                        }
                                                    });
                                                    Object object = this.isAsyncCompactionEnabled(client, tableConfig, (scala.collection.immutable.Map<String, String>)parameters, jsc.hadoopConfiguration()) ? ((Function1)asyncCompactionTriggerFn.get()).apply((Object)client) : BoxedUnit.UNIT;
                                                    Object object2 = this.isAsyncClusteringEnabled(client, (scala.collection.immutable.Map<String, String>)parameters) ? ((Function1)asyncClusteringTriggerFn.get()).apply((Object)client) : BoxedUnit.UNIT;
                                                    client.startCommitWithTime(instantTime, commitActionType);
                                                    HoodieWriteResult writeStatuses = DataSourceUtils.doDeleteOperation(client, (JavaRDD<HoodieKey>)hoodieKeysToDelete, instantTime);
                                                    tuple25 = new Tuple2((Object)writeStatuses, (Object)client);
                                                    break block19;
                                                }
                                                throw new HoodieException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hoodie table at ", " does not exist"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{basePath})));
                                            }
                                            if (!((Object)((Object)WriteOperationType.DELETE_PARTITION)).equals((Object)writeOperationType)) break block20;
                                            RDD<GenericRecord> genericRecords = this.registerKryoClassesAndGetGenericRecords(tblName, sparkContext, df, reconcileSchema);
                                            if (!this.tableExists()) break block21;
                                            if (JavaConversions$.MODULE$.mapAsJavaMap((Map)parameters).containsKey(DataSourceWriteOptions$.MODULE$.PARTITIONS_TO_DELETE().key())) {
                                                String[] partitionColsToDelete = ((String)parameters.get((Object)DataSourceWriteOptions$.MODULE$.PARTITIONS_TO_DELETE().key()).get()).split(",");
                                                list = Arrays.asList((Object[])partitionColsToDelete);
                                            } else {
                                                list = genericRecords.map((Function1)new Serializable(keyGenerator){
                                                    public static final long serialVersionUID = 0L;
                                                    private final KeyGenerator keyGenerator$1;

                                                    public final String apply(GenericRecord gr) {
                                                        return this.keyGenerator$1.getKey(gr).getPartitionPath();
                                                    }
                                                    {
                                                        this.keyGenerator$1 = keyGenerator$1;
                                                    }
                                                }, ClassTag$.MODULE$.apply(String.class)).toJavaRDD().distinct().collect();
                                            }
                                            List<Object> partitionsToDelete = list;
                                            SparkRDDWriteClient client = (SparkRDDWriteClient)hoodieWriteClient.getOrElse((Function0)new Serializable(path, parameters, tblName, jsc){
                                                public static final long serialVersionUID = 0L;
                                                private final String path$1;
                                                private final scala.collection.immutable.Map parameters$1;
                                                private final String tblName$1;
                                                private final JavaSparkContext jsc$1;

                                                public final SparkRDDWriteClient<HoodieRecordPayload> apply() {
                                                    return DataSourceUtils.createHoodieClient(this.jsc$1, null, this.path$1, this.tblName$1, JavaConversions$.MODULE$.mapAsJavaMap(this.parameters$1.$minus((Object)HoodieWriteConfig.AUTO_COMMIT_ENABLE.key())));
                                                }
                                                {
                                                    this.path$1 = path$1;
                                                    this.parameters$1 = parameters$1;
                                                    this.tblName$1 = tblName$1;
                                                    this.jsc$1 = jsc$1;
                                                }
                                            });
                                            client.startCommitWithTime(instantTime, commitActionType);
                                            HoodieWriteResult writeStatuses = DataSourceUtils.doDeletePartitionsOperation(client, partitionsToDelete, instantTime);
                                            tuple25 = new Tuple2((Object)writeStatuses, (Object)client);
                                            break block19;
                                        }
                                        throw new HoodieException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hoodie table at ", " does not exist"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{basePath})));
                                    }
                                    tuple22 = AvroConversionUtils$.MODULE$.getAvroRecordNameAndNamespace(tblName);
                                    if (tuple22 == null) break block22;
                                    String structName = (String)tuple22._1();
                                    String nameSpace = (String)tuple22._2();
                                    Tuple2 tuple212 = tuple26 = new Tuple2((Object)structName, (Object)nameSpace);
                                    String structName2 = (String)tuple212._1();
                                    String nameSpace2 = (String)tuple212._2();
                                    sparkContext.getConf().registerKryoClasses((Class[])((Object[])new Class[]{GenericData.class, Schema.class}));
                                    Schema schema2 = AvroConversionUtils$.MODULE$.convertStructTypeToAvroSchema(df.schema(), structName2, nameSpace2);
                                    if (reconcileSchema) {
                                        schema2 = this.getLatestTableSchema(fs, basePath, sparkContext, schema2);
                                    }
                                    sparkContext.getConf().registerAvroSchemas((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Schema[]{schema2}));
                                    this.org$apache$hudi$HoodieSparkSqlWriter$$log().info((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Registered avro schema : ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{schema2.toString(true)})));
                                    RDD<GenericRecord> genericRecords = HoodieSparkUtils$.MODULE$.createRdd(df, structName2, nameSpace2, reconcileSchema, Option.of(schema2));
                                    boolean shouldCombine = new StringOps(Predef$.MODULE$.augmentString((String)parameters.apply((Object)DataSourceWriteOptions$.MODULE$.INSERT_DROP_DUPS().key()))).toBoolean() || operation.equals((Object)WriteOperationType.UPSERT) || new StringOps(Predef$.MODULE$.augmentString((String)parameters.getOrElse((Object)HoodieWriteConfig.COMBINE_BEFORE_INSERT.key(), (Function0)new Serializable(){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply() {
                                            return HoodieWriteConfig.COMBINE_BEFORE_INSERT.defaultValue();
                                        }
                                    }))).toBoolean();
                                    JavaRDD<HoodieRecord> hoodieAllIncomingRecords = genericRecords.map((Function1)new Serializable(hoodieConfig, keyGenerator, partitionColumns, dropPartitionColumns, shouldCombine){
                                        public static final long serialVersionUID = 0L;
                                        private final HoodieConfig hoodieConfig$1;
                                        private final KeyGenerator keyGenerator$1;
                                        private final String partitionColumns$1;
                                        private final Boolean dropPartitionColumns$1;
                                        private final boolean shouldCombine$1;

                                        /*
                                         * WARNING - void declaration
                                         */
                                        public final HoodieRecord<? extends HoodieRecordPayload<?>> apply(GenericRecord gr) {
                                            void var3_4;
                                            HoodieRecord hoodieRecord;
                                            GenericRecord processedRecord = HoodieSparkSqlWriter$.MODULE$.getProcessedRecord(this.partitionColumns$1, gr, Predef$.MODULE$.Boolean2boolean(this.dropPartitionColumns$1));
                                            if (this.shouldCombine$1) {
                                                Comparable orderingVal = (Comparable)HoodieAvroUtils.getNestedFieldVal(gr, this.hoodieConfig$1.getString(DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD()), false);
                                                hoodieRecord = DataSourceUtils.createHoodieRecord(processedRecord, orderingVal, this.keyGenerator$1.getKey(gr), this.hoodieConfig$1.getString(DataSourceWriteOptions$.MODULE$.PAYLOAD_CLASS_NAME()));
                                            } else {
                                                hoodieRecord = DataSourceUtils.createHoodieRecord(processedRecord, this.keyGenerator$1.getKey(gr), this.hoodieConfig$1.getString(DataSourceWriteOptions$.MODULE$.PAYLOAD_CLASS_NAME()));
                                            }
                                            HoodieRecord hoodieRecord2 = hoodieRecord;
                                            return var3_4;
                                        }
                                        {
                                            this.hoodieConfig$1 = hoodieConfig$1;
                                            this.keyGenerator$1 = keyGenerator$1;
                                            this.partitionColumns$1 = partitionColumns$1;
                                            this.dropPartitionColumns$1 = dropPartitionColumns$1;
                                            this.shouldCombine$1 = shouldCombine$1;
                                        }
                                    }, ClassTag$.MODULE$.apply(HoodieRecord.class)).toJavaRDD();
                                    Schema writeSchema = Predef$.MODULE$.Boolean2boolean(dropPartitionColumns) ? this.generateSchemaWithoutPartitionColumns(partitionColumns, schema2) : schema2;
                                    SparkRDDWriteClient client = (SparkRDDWriteClient)hoodieWriteClient.getOrElse((Function0)new Serializable(path, parameters, tblName, jsc, writeSchema){
                                        public static final long serialVersionUID = 0L;
                                        private final String path$1;
                                        private final scala.collection.immutable.Map parameters$1;
                                        private final String tblName$1;
                                        private final JavaSparkContext jsc$1;
                                        private final Schema writeSchema$1;

                                        public final SparkRDDWriteClient<HoodieRecordPayload> apply() {
                                            return DataSourceUtils.createHoodieClient(this.jsc$1, this.writeSchema$1.toString(), this.path$1, this.tblName$1, JavaConversions$.MODULE$.mapAsJavaMap(this.parameters$1.$minus((Object)HoodieWriteConfig.AUTO_COMMIT_ENABLE.key())));
                                        }
                                        {
                                            this.path$1 = path$1;
                                            this.parameters$1 = parameters$1;
                                            this.tblName$1 = tblName$1;
                                            this.jsc$1 = jsc$1;
                                            this.writeSchema$1 = writeSchema$1;
                                        }
                                    });
                                    Object object = this.isAsyncCompactionEnabled(client, tableConfig, (scala.collection.immutable.Map<String, String>)parameters, jsc.hadoopConfiguration()) ? ((Function1)asyncCompactionTriggerFn.get()).apply((Object)client) : BoxedUnit.UNIT;
                                    Object object3 = this.isAsyncClusteringEnabled(client, (scala.collection.immutable.Map<String, String>)parameters) ? ((Function1)asyncClusteringTriggerFn.get()).apply((Object)client) : BoxedUnit.UNIT;
                                    JavaRDD<HoodieRecord> hoodieRecords = Predef$.MODULE$.Boolean2boolean(hoodieConfig.getBoolean(DataSourceWriteOptions$.MODULE$.INSERT_DROP_DUPS())) ? DataSourceUtils.dropDuplicates(jsc, hoodieAllIncomingRecords, JavaConversions$.MODULE$.mapAsJavaMap((Map)parameters)) : hoodieAllIncomingRecords;
                                    client.startCommitWithTime(instantTime, commitActionType);
                                    HoodieWriteResult writeResult = DataSourceUtils.doWriteOperation(client, hoodieRecords, instantTime, operation);
                                    tuple25 = new Tuple2((Object)writeResult, (Object)client);
                                }
                                tuple23 = tuple25;
                                if (tuple23 == null) break block23;
                                HoodieWriteResult writeResult = (HoodieWriteResult)tuple23._1();
                                SparkRDDWriteClient writeClient = (SparkRDDWriteClient)tuple23._2();
                                if (writeClient == null) break block23;
                                SparkRDDWriteClient sparkRDDWriteClient = writeClient;
                                Tuple2 tuple213 = tuple24 = new Tuple2((Object)writeResult, (Object)sparkRDDWriteClient);
                                HoodieWriteResult writeResult2 = (HoodieWriteResult)tuple213._1();
                                SparkRDDWriteClient writeClient2 = (SparkRDDWriteClient)tuple213._2();
                                tuple3 = this.commitAndPerformPostOperations(sqlContext.sparkSession(), df.schema(), writeResult2, (scala.collection.immutable.Map<String, String>)parameters, writeClient2, tableConfig, jsc, new HoodieSparkSqlWriter.TableInstantInfo(basePath, instantTime, commitActionType, operation));
                                if (tuple3 == null) break block24;
                                boolean writeSuccessful = BoxesRunTime.unboxToBoolean((Object)tuple3._1());
                                Option compactionInstant = (Option)tuple3._2();
                                Option clusteringInstant = (Option)tuple3._3();
                                Tuple3 tuple33 = tuple32 = new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)writeSuccessful), (Object)compactionInstant, (Object)clusteringInstant);
                                boolean writeSuccessful2 = BoxesRunTime.unboxToBoolean((Object)tuple33._1());
                                Option compactionInstant2 = (Option)tuple33._2();
                                Option clusteringInstant2 = (Option)tuple33._3();
                                tuple6 = new Tuple6((Object)BoxesRunTime.boxToBoolean((boolean)writeSuccessful2), Option.ofNullable(instantTime), (Object)compactionInstant2, (Object)clusteringInstant2, (Object)writeClient2, (Object)tableConfig);
                            }
                            return tuple6;
                        }
                        throw new MatchError(tuple3);
                    }
                    throw new MatchError((Object)tuple23);
                }
                throw new MatchError(tuple22);
            }
            throw new HoodieException("hoodie only support org.apache.spark.serializer.KryoSerializer as spark.serializer");
        }
        throw new MatchError(tuple2);
    }

    public scala.Option<HoodieTableConfig> write$default$5() {
        return Option$.MODULE$.empty();
    }

    public scala.Option<SparkRDDWriteClient<HoodieRecordPayload<Nothing$>>> write$default$6() {
        return Option$.MODULE$.empty();
    }

    public scala.Option<Function1<SparkRDDWriteClient<HoodieRecordPayload<Nothing$>>, BoxedUnit>> write$default$7() {
        return Option$.MODULE$.empty();
    }

    public scala.Option<Function1<SparkRDDWriteClient<HoodieRecordPayload<Nothing$>>, BoxedUnit>> write$default$8() {
        return Option$.MODULE$.empty();
    }

    public Schema generateSchemaWithoutPartitionColumns(String partitionParam, Schema schema2) {
        ArrayList<String> fieldsToRemove = new ArrayList<String>();
        Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])partitionParam.split(",")).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String partitionField) {
                return partitionField.trim();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String s) {
                return !s.isEmpty();
            }
        })).map((Function1)new Serializable(fieldsToRemove){
            public static final long serialVersionUID = 0L;
            private final ArrayList fieldsToRemove$1;

            public final boolean apply(String field) {
                return this.fieldsToRemove$1.add(field);
            }
            {
                this.fieldsToRemove$1 = fieldsToRemove$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Boolean()));
        return HoodieAvroUtils.removeFields(schema2, fieldsToRemove);
    }

    public GenericRecord getProcessedRecord(String partitionParam, GenericRecord record, boolean dropPartitionColumns) {
        GenericRecord processedRecord = record;
        if (dropPartitionColumns) {
            Schema writeSchema = this.generateSchemaWithoutPartitionColumns(partitionParam, record.getSchema());
            processedRecord = HoodieAvroUtils.rewriteRecord(record, writeSchema);
        }
        return processedRecord;
    }

    public Schema getLatestTableSchema(FileSystem fs, Path basePath, SparkContext sparkContext, Schema schema2) {
        Schema latestSchema = schema2;
        if (FSUtils.isTableExists(basePath.toString(), fs)) {
            HoodieTableMetaClient tableMetaClient = HoodieTableMetaClient.builder().setConf(sparkContext.hadoopConfiguration()).setBasePath(basePath.toString()).build();
            TableSchemaResolver tableSchemaResolver = new TableSchemaResolver(tableMetaClient);
            latestSchema = tableSchemaResolver.getLatestSchema(schema2, false, null);
        }
        return latestSchema;
    }

    public RDD<GenericRecord> registerKryoClassesAndGetGenericRecords(String tblName, SparkContext sparkContext, Dataset<Row> df, boolean reconcileSchema) {
        String structName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "_record"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tblName}));
        String nameSpace = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hoodie.", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tblName}));
        sparkContext.getConf().registerKryoClasses((Class[])((Object[])new Class[]{GenericData.class, Schema.class}));
        return HoodieSparkUtils$.MODULE$.createRdd(df, structName, nameSpace, reconcileSchema, HoodieSparkUtils$.MODULE$.createRdd$default$5());
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean bootstrap(SQLContext sqlContext, SaveMode mode, scala.collection.immutable.Map<String, String> optParams, Dataset<Row> df, scala.Option<HoodieTableConfig> hoodieTableConfigOpt, scala.Option<SparkRDDWriteClient<HoodieRecordPayload<Nothing$>>> hoodieWriteClient) {
        Object object;
        Object object2;
        Tuple2 tuple2;
        Predef$.MODULE$.assert(optParams.get((Object)"path").exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$7) {
                return !StringUtils.isNullOrEmpty(x$7);
            }
        }), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "'path' must be set";
            }
        });
        String path = (String)optParams.apply((Object)"path");
        Path basePath = new Path(path);
        SparkContext sparkContext = sqlContext.sparkContext();
        FileSystem fs = basePath.getFileSystem(sparkContext.hadoopConfiguration());
        this.tableExists_$eq(fs.exists(new Path(basePath, ".hoodie")));
        HoodieTableConfig tableConfig = this.getHoodieTableConfig(sparkContext, path, hoodieTableConfigOpt);
        HoodieWriterUtils$.MODULE$.validateTableConfig(sqlContext.sparkSession(), optParams, tableConfig);
        Tuple2<scala.collection.immutable.Map<String, String>, HoodieConfig> tuple22 = this.mergeParamsAndGetHoodieConfig(optParams, tableConfig);
        if (tuple22 == null) throw new MatchError(tuple22);
        scala.collection.immutable.Map parameters = (scala.collection.immutable.Map)tuple22._1();
        HoodieConfig hoodieConfig = (HoodieConfig)tuple22._2();
        Tuple2 tuple23 = tuple2 = new Tuple2((Object)parameters, (Object)hoodieConfig);
        scala.collection.immutable.Map parameters2 = (scala.collection.immutable.Map)tuple23._1();
        HoodieConfig hoodieConfig2 = (HoodieConfig)tuple23._2();
        String tableName = hoodieConfig2.getStringOrThrow(HoodieWriteConfig.TBL_NAME, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "' must be set."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{HoodieWriteConfig.TBL_NAME.key()})));
        String tableType = hoodieConfig2.getStringOrDefault(DataSourceWriteOptions$.MODULE$.TABLE_TYPE());
        String bootstrapBasePath = hoodieConfig2.getStringOrThrow(HoodieBootstrapConfig.BASE_PATH, new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "' is required for '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{HoodieBootstrapConfig.BASE_PATH.key(), DataSourceWriteOptions$.MODULE$.BOOTSTRAP_OPERATION_OPT_VAL()}))).append((Object)" operation'").toString());
        String bootstrapIndexClass = hoodieConfig2.getStringOrDefault(HoodieBootstrapConfig.INDEX_CLASS_NAME);
        ObjectRef schema2 = ObjectRef.create(null);
        if (df.schema().nonEmpty()) {
            Tuple2 tuple24;
            Tuple2<String, String> tuple25 = AvroConversionUtils$.MODULE$.getAvroRecordNameAndNamespace(tableName);
            if (tuple25 == null) throw new MatchError(tuple25);
            String structName = (String)tuple25._1();
            String namespace = (String)tuple25._2();
            Tuple2 tuple26 = tuple24 = new Tuple2((Object)structName, (Object)namespace);
            String structName2 = (String)tuple26._1();
            String namespace2 = (String)tuple26._2();
            schema2.elem = AvroConversionUtils$.MODULE$.convertStructTypeToAvroSchema(df.schema(), structName2, namespace2).toString();
        } else {
            schema2.elem = HoodieAvroUtils.getNullSchema().toString();
        }
        SaveMode saveMode = mode;
        SaveMode saveMode2 = SaveMode.Ignore;
        if (!(saveMode != null ? !saveMode.equals(saveMode2) : saveMode2 != null) && this.tableExists()) {
            this.org$apache$hudi$HoodieSparkSqlWriter$$log().warn((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hoodie table at ", " already exists. Ignoring & not performing actual writes."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{basePath})));
            object2 = BoxesRunTime.boxToBoolean((boolean)false);
        } else {
            this.handleSaveModes(sqlContext.sparkSession(), mode, basePath, tableConfig, tableName, WriteOperationType.BOOTSTRAP, fs);
            object2 = BoxedUnit.UNIT;
        }
        if (this.tableExists()) {
            object = BoxedUnit.UNIT;
        } else {
            String archiveLogFolder = hoodieConfig2.getStringOrDefault(HoodieTableConfig.ARCHIVELOG_FOLDER);
            String partitionColumns = HoodieWriterUtils$.MODULE$.getPartitionColumns((scala.collection.immutable.Map<String, String>)parameters2);
            String recordKeyFields = hoodieConfig2.getString(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD());
            String keyGenProp = hoodieConfig2.getString(HoodieTableConfig.KEY_GENERATOR_CLASS_NAME);
            boolean populateMetaFields = new StringOps(Predef$.MODULE$.augmentString((String)parameters2.getOrElse((Object)HoodieTableConfig.POPULATE_META_FIELDS.key(), (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return HoodieTableConfig.POPULATE_META_FIELDS.defaultValue();
                }
            }))).toBoolean();
            String baseFileFormat = hoodieConfig2.getStringOrDefault(HoodieTableConfig.BASE_FILE_FORMAT);
            object = HoodieTableMetaClient.withPropertyBuilder().setTableType(HoodieTableType.valueOf(tableType)).setTableName(tableName).setRecordKeyFields(recordKeyFields).setArchiveLogFolder(archiveLogFolder).setPayloadClassName(hoodieConfig2.getStringOrDefault(DataSourceWriteOptions$.MODULE$.PAYLOAD_CLASS_NAME())).setPreCombineField(hoodieConfig2.getStringOrDefault(DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD(), null)).setBootstrapIndexClass(bootstrapIndexClass).setBaseFileFormat(baseFileFormat).setBootstrapBasePath(bootstrapBasePath).setPartitionFields(partitionColumns).setPopulateMetaFields(populateMetaFields).setKeyGeneratorClassProp(keyGenProp).setHiveStylePartitioningEnable(hoodieConfig2.getBoolean(DataSourceWriteOptions$.MODULE$.HIVE_STYLE_PARTITIONING())).setUrlEncodePartitioning(hoodieConfig2.getBoolean(DataSourceWriteOptions$.MODULE$.URL_ENCODE_PARTITIONING())).initTable(sparkContext.hadoopConfiguration(), path);
        }
        JavaSparkContext jsc = new JavaSparkContext(sqlContext.sparkContext());
        SparkRDDWriteClient writeClient = (SparkRDDWriteClient)hoodieWriteClient.getOrElse((Function0)new Serializable(path, parameters2, tableName, schema2, jsc){
            public static final long serialVersionUID = 0L;
            private final String path$2;
            private final scala.collection.immutable.Map parameters$3;
            private final String tableName$1;
            private final ObjectRef schema$1;
            private final JavaSparkContext jsc$2;

            public final SparkRDDWriteClient<HoodieRecordPayload> apply() {
                return DataSourceUtils.createHoodieClient(this.jsc$2, (String)this.schema$1.elem, this.path$2, this.tableName$1, JavaConversions$.MODULE$.mapAsJavaMap((Map)this.parameters$3));
            }
            {
                this.path$2 = path$2;
                this.parameters$3 = parameters$3;
                this.tableName$1 = tableName$1;
                this.schema$1 = schema$1;
                this.jsc$2 = jsc$2;
            }
        });
        try {
            writeClient.bootstrap(Option.empty());
        }
        catch (Throwable throwable) {
            void var39_39;
            var39_39.close();
            throw throwable;
        }
        writeClient.close();
        return this.metaSync(sqlContext.sparkSession(), hoodieConfig2, basePath, df.schema());
    }

    public scala.Option<HoodieTableConfig> bootstrap$default$5() {
        return Option$.MODULE$.empty();
    }

    public scala.Option<SparkRDDWriteClient<HoodieRecordPayload<Nothing$>>> bootstrap$default$6() {
        return Option$.MODULE$.empty();
    }

    public Tuple2<Object, Option<String>> bulkInsertAsRow(SQLContext sqlContext, scala.collection.immutable.Map<String, String> parameters, Dataset<Row> df, String tblName, Path basePath, String path, String instantTime, String partitionColumns) {
        Tuple2<String, String> tuple2;
        block5: {
            block8: {
                scala.collection.immutable.Map params;
                block7: {
                    Dataset<Row> hoodieDF;
                    block6: {
                        Option<BulkInsertPartitioner<Dataset<Row>>> userDefinedBulkInsertPartitionerOpt;
                        Tuple2 tuple22;
                        SparkContext sparkContext = sqlContext.sparkContext();
                        boolean populateMetaFields = new StringOps(Predef$.MODULE$.augmentString((String)parameters.getOrElse((Object)HoodieTableConfig.POPULATE_META_FIELDS.key(), (Function0)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return HoodieTableConfig.POPULATE_META_FIELDS.defaultValue();
                            }
                        }))).toBoolean();
                        boolean dropPartitionColumns = new StringOps(Predef$.MODULE$.augmentString((String)parameters.getOrElse((Object)DataSourceWriteOptions$.MODULE$.DROP_PARTITION_COLUMNS().key(), (Function0)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return DataSourceWriteOptions$.MODULE$.DROP_PARTITION_COLUMNS().defaultValue();
                            }
                        }))).toBoolean();
                        tuple2 = AvroConversionUtils$.MODULE$.getAvroRecordNameAndNamespace(tblName);
                        if (tuple2 == null) break block5;
                        String structName = (String)tuple2._1();
                        String nameSpace = (String)tuple2._2();
                        Tuple2 tuple23 = tuple22 = new Tuple2((Object)structName, (Object)nameSpace);
                        String structName2 = (String)tuple23._1();
                        String nameSpace2 = (String)tuple23._2();
                        sparkContext.getConf().registerKryoClasses((Class[])((Object[])new Class[]{GenericData.class, Schema.class}));
                        Schema schema2 = AvroConversionUtils$.MODULE$.convertStructTypeToAvroSchema(df.schema(), structName2, nameSpace2);
                        if (dropPartitionColumns) {
                            schema2 = this.generateSchemaWithoutPartitionColumns(partitionColumns, schema2);
                        }
                        sparkContext.getConf().registerAvroSchemas((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Schema[]{schema2}));
                        this.org$apache$hudi$HoodieSparkSqlWriter$$log().info((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Registered avro schema : ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{schema2.toString(true)})));
                        if (new StringOps(Predef$.MODULE$.augmentString((String)parameters.apply((Object)DataSourceWriteOptions$.MODULE$.INSERT_DROP_DUPS().key()))).toBoolean()) {
                            throw new HoodieException("Dropping duplicates with bulk_insert in row writer path is not supported yet");
                        }
                        params = parameters.updated((Object)HoodieWriteConfig.AVRO_SCHEMA_STRING.key(), (Object)schema2.toString());
                        HoodieWriteConfig writeConfig = DataSourceUtils.createHoodieConfig(schema2.toString(), path, tblName, JavaConversions$.MODULE$.mapAsJavaMap((Map)params));
                        NonSortPartitionerWithRows bulkInsertPartitionerRows = populateMetaFields ? ((userDefinedBulkInsertPartitionerOpt = DataSourceUtils.createUserDefinedBulkInsertPartitionerWithRows(writeConfig)).isPresent() ? userDefinedBulkInsertPartitionerOpt.get() : BulkInsertInternalPartitionerWithRowsFactory.get(writeConfig.getBulkInsertSortMode())) : new NonSortPartitionerWithRows();
                        boolean arePartitionRecordsSorted = bulkInsertPartitionerRows.arePartitionRecordsSorted();
                        parameters.updated((Object)"hoodie.bulkinsert.are.partitioner.records.sorted", (Object)((Object)BoxesRunTime.boxToBoolean((boolean)arePartitionRecordsSorted)).toString());
                        boolean isGlobalIndex = populateMetaFields ? SparkHoodieIndexFactory.isGlobalIndex(writeConfig) : false;
                        Dataset<Row> dataset = hoodieDF = populateMetaFields ? HoodieDatasetBulkInsertHelper.prepareHoodieDatasetForBulkInsert(sqlContext, writeConfig, df, structName2, nameSpace2, bulkInsertPartitionerRows, isGlobalIndex, dropPartitionColumns) : HoodieDatasetBulkInsertHelper.prepareHoodieDatasetForBulkInsertWithoutMetaFields(df);
                        if (!package$.MODULE$.SPARK_VERSION().startsWith("2.")) break block6;
                        hoodieDF.write().format("org.apache.hudi.internal").option("hoodie.instant.time", instantTime).options((Map)params).mode(SaveMode.Append).save();
                        break block7;
                    }
                    if (!package$.MODULE$.SPARK_VERSION().startsWith("3.")) break block8;
                    hoodieDF.write().format("org.apache.hudi.spark3.internal").option("hoodie.instant.time", instantTime).option(HoodieInternalConfig.BULKINSERT_INPUT_DATA_SCHEMA_DDL.key(), hoodieDF.schema().toDDL()).options((Map)params).mode(SaveMode.Append).save();
                }
                HoodieConfig hoodieConfig = HoodieWriterUtils$.MODULE$.convertMapToHoodieConfig((scala.collection.immutable.Map<String, String>)params);
                boolean hiveSyncEnabled = new StringOps(Predef$.MODULE$.augmentString(hoodieConfig.getStringOrDefault(DataSourceWriteOptions$.MODULE$.HIVE_SYNC_ENABLED()))).toBoolean();
                boolean metaSyncEnabled = new StringOps(Predef$.MODULE$.augmentString(hoodieConfig.getStringOrDefault(DataSourceWriteOptions$.MODULE$.META_SYNC_ENABLED()))).toBoolean();
                boolean syncHiveSuccess = hiveSyncEnabled || metaSyncEnabled ? this.metaSync(sqlContext.sparkSession(), hoodieConfig, basePath, df.schema()) : true;
                return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)syncHiveSuccess), Option.ofNullable(instantTime));
            }
            throw new HoodieException("Bulk insert using row writer is not supported with current Spark version. To use row writer please switch to spark 2 or spark 3");
        }
        throw new MatchError(tuple2);
    }

    /*
     * WARNING - void declaration
     */
    public TypedProperties toProperties(scala.collection.immutable.Map<String, String> params) {
        void var2_2;
        TypedProperties props = new TypedProperties();
        params.foreach((Function1)new Serializable(props){
            public static final long serialVersionUID = 0L;
            private final TypedProperties props$1;

            public final Object apply(Tuple2<String, String> kv) {
                return this.props$1.setProperty((String)kv._1(), (String)kv._2());
            }
            {
                this.props$1 = props$1;
            }
        });
        return var2_2;
    }

    private void handleSaveModes(SparkSession spark, SaveMode mode, Path tablePath, HoodieTableConfig tableConfig, String tableName, WriteOperationType operation, FileSystem fs) {
        SaveMode saveMode = mode;
        SaveMode saveMode2 = SaveMode.Append;
        if (!(saveMode != null ? !saveMode.equals(saveMode2) : saveMode2 != null) && this.tableExists()) {
            String existingTableName = tableConfig.getTableName();
            Function2 resolver = spark.sessionState().conf().resolver();
            if (!BoxesRunTime.unboxToBoolean((Object)resolver.apply((Object)existingTableName, (Object)tableName))) {
                throw new HoodieException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hoodie table with name ", " already exists at ", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{existingTableName, tablePath}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" can not append data to the table with another name ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName}))).toString());
            }
        }
        WriteOperationType writeOperationType = operation;
        WriteOperationType writeOperationType2 = WriteOperationType.DELETE;
        if (!(writeOperationType != null ? !((Object)((Object)writeOperationType)).equals((Object)writeOperationType2) : writeOperationType2 != null)) {
            SaveMode saveMode3 = mode;
            SaveMode saveMode4 = SaveMode.Append;
            if (saveMode3 == null ? saveMode4 != null : !saveMode3.equals(saveMode4)) {
                throw new HoodieException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Append is the only save mode applicable for ", " operation"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operation.toString()})));
            }
        } else {
            SaveMode saveMode5 = mode;
            SaveMode saveMode6 = SaveMode.ErrorIfExists;
            if (!(saveMode5 != null ? !saveMode5.equals(saveMode6) : saveMode6 != null) && this.tableExists()) {
                throw new HoodieException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hoodie table at ", " already exists."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tablePath})));
            }
            SaveMode saveMode7 = mode;
            SaveMode saveMode8 = SaveMode.Overwrite;
            if (!(saveMode7 != null ? !saveMode7.equals(saveMode8) : saveMode8 != null) && this.tableExists()) {
                WriteOperationType writeOperationType3 = operation;
                WriteOperationType writeOperationType4 = WriteOperationType.INSERT_OVERWRITE_TABLE;
                if (writeOperationType3 == null ? writeOperationType4 != null : !((Object)((Object)writeOperationType3)).equals((Object)writeOperationType4)) {
                    this.org$apache$hudi$HoodieSparkSqlWriter$$log().warn((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hoodie table at ", " already exists. Deleting existing data & overwriting with new data."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tablePath})));
                    fs.delete(tablePath, true);
                    this.tableExists_$eq(false);
                }
            }
        }
    }

    public boolean org$apache$hudi$HoodieSparkSqlWriter$$syncHive(Path basePath, FileSystem fs, HoodieConfig hoodieConfig, SQLConf sqlConf) {
        HiveSyncConfig hiveSyncConfig = this.buildSyncConfig(basePath, hoodieConfig, sqlConf);
        HiveConf hiveConf = new HiveConf();
        hiveConf.addResource(fs.getConf());
        new HiveSyncTool(hiveSyncConfig, hiveConf, fs).syncHoodieTable();
        return true;
    }

    private HiveSyncConfig buildSyncConfig(Path basePath, HoodieConfig hoodieConfig, SQLConf sqlConf) {
        HiveSyncConfig hiveSyncConfig = new HiveSyncConfig();
        hiveSyncConfig.basePath = basePath.toString();
        hiveSyncConfig.baseFileFormat = hoodieConfig.getString(DataSourceWriteOptions$.MODULE$.HIVE_BASE_FILE_FORMAT());
        hiveSyncConfig.usePreApacheInputFormat = Predef$.MODULE$.boolean2Boolean(new StringOps(Predef$.MODULE$.augmentString(hoodieConfig.getStringOrDefault(DataSourceWriteOptions$.MODULE$.HIVE_USE_PRE_APACHE_INPUT_FORMAT()))).toBoolean());
        hiveSyncConfig.databaseName = hoodieConfig.getString(DataSourceWriteOptions$.MODULE$.HIVE_DATABASE());
        hiveSyncConfig.tableName = hoodieConfig.getString(DataSourceWriteOptions$.MODULE$.HIVE_TABLE());
        hiveSyncConfig.hiveUser = hoodieConfig.getString(DataSourceWriteOptions$.MODULE$.HIVE_USER());
        hiveSyncConfig.hivePass = hoodieConfig.getString(DataSourceWriteOptions$.MODULE$.HIVE_PASS());
        hiveSyncConfig.jdbcUrl = hoodieConfig.getString(DataSourceWriteOptions$.MODULE$.HIVE_URL());
        hiveSyncConfig.skipROSuffix = Predef$.MODULE$.boolean2Boolean(new StringOps(Predef$.MODULE$.augmentString(hoodieConfig.getStringOrDefault(DataSourceWriteOptions$.MODULE$.HIVE_SKIP_RO_SUFFIX_FOR_READ_OPTIMIZED_TABLE(), DataSourceWriteOptions$.MODULE$.HIVE_SKIP_RO_SUFFIX_FOR_READ_OPTIMIZED_TABLE().defaultValue()))).toBoolean());
        hiveSyncConfig.partitionFields = JavaConversions$.MODULE$.bufferAsJavaList((Buffer)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])hoodieConfig.getString(DataSourceWriteOptions$.MODULE$.HIVE_PARTITION_FIELDS()).split(",")).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$11) {
                return x$11.trim();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$12) {
                return !x$12.isEmpty();
            }
        })).toList()));
        hiveSyncConfig.partitionValueExtractorClass = hoodieConfig.getString(DataSourceWriteOptions$.MODULE$.HIVE_PARTITION_EXTRACTOR_CLASS());
        hiveSyncConfig.useJdbc = hoodieConfig.getBoolean(DataSourceWriteOptions$.MODULE$.HIVE_USE_JDBC());
        hiveSyncConfig.useFileListingFromMetadata = hoodieConfig.getBoolean(HoodieMetadataConfig.ENABLE);
        hiveSyncConfig.ignoreExceptions = Predef$.MODULE$.boolean2Boolean(new StringOps(Predef$.MODULE$.augmentString(hoodieConfig.getStringOrDefault(DataSourceWriteOptions$.MODULE$.HIVE_IGNORE_EXCEPTIONS()))).toBoolean());
        hiveSyncConfig.supportTimestamp = Predef$.MODULE$.boolean2Boolean(new StringOps(Predef$.MODULE$.augmentString(hoodieConfig.getStringOrDefault(DataSourceWriteOptions$.MODULE$.HIVE_SUPPORT_TIMESTAMP_TYPE()))).toBoolean());
        hiveSyncConfig.autoCreateDatabase = Predef$.MODULE$.boolean2Boolean(new StringOps(Predef$.MODULE$.augmentString(hoodieConfig.getStringOrDefault(DataSourceWriteOptions$.MODULE$.HIVE_AUTO_CREATE_DATABASE()))).toBoolean());
        hiveSyncConfig.decodePartition = Predef$.MODULE$.boolean2Boolean(new StringOps(Predef$.MODULE$.augmentString(hoodieConfig.getStringOrDefault(DataSourceWriteOptions$.MODULE$.URL_ENCODE_PARTITIONING()))).toBoolean());
        hiveSyncConfig.batchSyncNum = Predef$.MODULE$.int2Integer(new StringOps(Predef$.MODULE$.augmentString(hoodieConfig.getStringOrDefault(DataSourceWriteOptions$.MODULE$.HIVE_BATCH_SYNC_PARTITION_NUM()))).toInt());
        hiveSyncConfig.syncAsSparkDataSourceTable = Predef$.MODULE$.boolean2Boolean(new StringOps(Predef$.MODULE$.augmentString(hoodieConfig.getStringOrDefault(DataSourceWriteOptions$.MODULE$.HIVE_SYNC_AS_DATA_SOURCE_TABLE()))).toBoolean());
        hiveSyncConfig.sparkSchemaLengthThreshold = BoxesRunTime.unboxToInt((Object)sqlConf.getConf(StaticSQLConf$.MODULE$.SCHEMA_STRING_LENGTH_THRESHOLD()));
        hiveSyncConfig.createManagedTable = hoodieConfig.getBoolean(DataSourceWriteOptions$.MODULE$.HIVE_CREATE_MANAGED_TABLE());
        hiveSyncConfig.syncMode = hoodieConfig.getString(DataSourceWriteOptions$.MODULE$.HIVE_SYNC_MODE());
        hiveSyncConfig.serdeProperties = hoodieConfig.getString(DataSourceWriteOptions$.MODULE$.HIVE_TABLE_SERDE_PROPERTIES());
        hiveSyncConfig.tableProperties = hoodieConfig.getString(DataSourceWriteOptions$.MODULE$.HIVE_TABLE_PROPERTIES());
        return hiveSyncConfig;
    }

    private boolean metaSync(SparkSession spark, HoodieConfig hoodieConfig, Path basePath, StructType schema2) {
        BoxedUnit boxedUnit;
        boolean hiveSyncEnabled = new StringOps(Predef$.MODULE$.augmentString(hoodieConfig.getStringOrDefault(DataSourceWriteOptions$.MODULE$.HIVE_SYNC_ENABLED()))).toBoolean();
        boolean metaSyncEnabled = new StringOps(Predef$.MODULE$.augmentString(hoodieConfig.getStringOrDefault(DataSourceWriteOptions$.MODULE$.META_SYNC_ENABLED()))).toBoolean();
        ObjectRef syncClientToolClassSet = ObjectRef.create((Object)((Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$)));
        Predef$.MODULE$.refArrayOps((Object[])hoodieConfig.getString(DataSourceWriteOptions$.MODULE$.META_SYNC_CLIENT_TOOL_CLASS_NAME()).split(",")).foreach((Function1)new Serializable(syncClientToolClassSet){
            public static final long serialVersionUID = 0L;
            private final ObjectRef syncClientToolClassSet$1;

            public final Set<String> apply(String syncClass) {
                return (Set)((Set)this.syncClientToolClassSet$1.elem).$plus$eq((Object)syncClass);
            }
            {
                this.syncClientToolClassSet$1 = syncClientToolClassSet$1;
            }
        });
        if (hiveSyncEnabled) {
            metaSyncEnabled = true;
            boxedUnit = ((Set)syncClientToolClassSet.elem).$plus$eq((Object)HiveSyncTool.class.getName());
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        BooleanRef metaSyncSuccess = BooleanRef.create((boolean)true);
        if (metaSyncEnabled) {
            FileSystem fs = basePath.getFileSystem(spark.sessionState().newHadoopConf());
            ((Set)syncClientToolClassSet.elem).foreach((Function1)new Serializable(spark, hoodieConfig, basePath, metaSyncSuccess, fs){
                public static final long serialVersionUID = 0L;
                private final SparkSession spark$1;
                private final HoodieConfig hoodieConfig$2;
                private final Path basePath$1;
                private final BooleanRef metaSyncSuccess$1;
                private final FileSystem fs$1;

                public final void apply(String impl) {
                    boolean bl;
                    String string = impl.trim();
                    if ("org.apache.hudi.hive.HiveSyncTool".equals(string)) {
                        HoodieSparkSqlWriter$.MODULE$.org$apache$hudi$HoodieSparkSqlWriter$$log().info((Object)new StringBuilder().append((Object)"Syncing to Hive Metastore (URL: ").append((Object)this.hoodieConfig$2.getString(DataSourceWriteOptions$.MODULE$.HIVE_URL())).append((Object)")").toString());
                        HoodieSparkSqlWriter$.MODULE$.org$apache$hudi$HoodieSparkSqlWriter$$syncHive(this.basePath$1, this.fs$1, this.hoodieConfig$2, this.spark$1.sessionState().conf());
                        bl = true;
                    } else {
                        Properties properties = new Properties();
                        properties.putAll((java.util.Map<?, ?>)this.hoodieConfig$2.getProps());
                        properties.put("basePath", this.basePath$1.toString());
                        AbstractSyncTool syncHoodie = (AbstractSyncTool)ReflectionUtils.loadClass(impl.trim(), (Class[])((Object[])new Class[]{Properties.class, FileSystem.class}), new Object[]{properties, this.fs$1});
                        syncHoodie.syncHoodieTable();
                        bl = true;
                    }
                    boolean syncSuccess = bl;
                    this.metaSyncSuccess$1.elem = this.metaSyncSuccess$1.elem && syncSuccess;
                }
                {
                    this.spark$1 = spark$1;
                    this.hoodieConfig$2 = hoodieConfig$2;
                    this.basePath$1 = basePath$1;
                    this.metaSyncSuccess$1 = metaSyncSuccess$1;
                    this.fs$1 = fs$1;
                }
            });
        }
        return metaSyncSuccess.elem;
    }

    private Tuple3<Object, Option<String>, Option<String>> commitAndPerformPostOperations(SparkSession spark, StructType schema2, HoodieWriteResult writeResult, scala.collection.immutable.Map<String, String> parameters, SparkRDDWriteClient<HoodieRecordPayload<Nothing$>> client, HoodieTableConfig tableConfig, JavaSparkContext jsc, HoodieSparkSqlWriter.TableInstantInfo tableInstantInfo) {
        Tuple3 tuple3;
        if (writeResult.getWriteStatuses().rdd().filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(WriteStatus ws) {
                return ws.hasErrors();
            }
        }).isEmpty()) {
            this.org$apache$hudi$HoodieSparkSqlWriter$$log().info((Object)"Proceeding to commit the write.");
            scala.collection.immutable.Map metaMap = (scala.collection.immutable.Map)parameters.filter((Function1)new Serializable(parameters){
                public static final long serialVersionUID = 0L;
                private final scala.collection.immutable.Map parameters$2;

                public final boolean apply(Tuple2<String, String> kv) {
                    return ((String)kv._1()).startsWith((String)this.parameters$2.apply((Object)DataSourceWriteOptions$.MODULE$.COMMIT_METADATA_KEYPREFIX().key()));
                }
                {
                    this.parameters$2 = parameters$2;
                }
            });
            boolean commitSuccess = client.commit(tableInstantInfo.instantTime(), writeResult.getWriteStatuses(), Option.of(new HashMap(JavaConversions$.MODULE$.mapAsJavaMap((Map)metaMap))), tableInstantInfo.commitActionType(), writeResult.getPartitionToReplaceFileIds());
            if (commitSuccess) {
                this.org$apache$hudi$HoodieSparkSqlWriter$$log().info((Object)new StringBuilder().append((Object)"Commit ").append((Object)tableInstantInfo.instantTime()).append((Object)" successful!").toString());
            } else {
                this.org$apache$hudi$HoodieSparkSqlWriter$$log().info((Object)new StringBuilder().append((Object)"Commit ").append((Object)tableInstantInfo.instantTime()).append((Object)" failed!").toString());
            }
            boolean asyncCompactionEnabled = this.isAsyncCompactionEnabled(client, tableConfig, parameters, jsc.hadoopConfiguration());
            Option compactionInstant = asyncCompactionEnabled ? client.scheduleCompaction(Option.of(new HashMap(JavaConversions$.MODULE$.mapAsJavaMap((Map)metaMap)))) : Option.empty();
            this.org$apache$hudi$HoodieSparkSqlWriter$$log().info((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compaction Scheduled is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{compactionInstant})));
            boolean asyncClusteringEnabled = this.isAsyncClusteringEnabled(client, parameters);
            Option clusteringInstant = asyncClusteringEnabled ? client.scheduleClustering(Option.of(new HashMap(JavaConversions$.MODULE$.mapAsJavaMap((Map)metaMap)))) : Option.empty();
            this.org$apache$hudi$HoodieSparkSqlWriter$$log().info((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Clustering Scheduled is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{clusteringInstant})));
            boolean metaSyncSuccess = this.metaSync(spark, HoodieWriterUtils$.MODULE$.convertMapToHoodieConfig(parameters), tableInstantInfo.basePath(), schema2);
            this.org$apache$hudi$HoodieSparkSqlWriter$$log().info((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Is Async Compaction Enabled ? ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)asyncCompactionEnabled)})));
            if (!asyncCompactionEnabled && !asyncClusteringEnabled) {
                client.close();
            }
            tuple3 = new Tuple3((Object)BoxesRunTime.boxToBoolean((commitSuccess && metaSyncSuccess ? 1 : 0) != 0), compactionInstant, clusteringInstant);
        } else {
            this.org$apache$hudi$HoodieSparkSqlWriter$$log().error((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " failed with errors"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableInstantInfo.operation()})));
            if (this.org$apache$hudi$HoodieSparkSqlWriter$$log().isTraceEnabled()) {
                this.org$apache$hudi$HoodieSparkSqlWriter$$log().trace((Object)"Printing out the top 100 errors");
                Predef$.MODULE$.refArrayOps((Object[])writeResult.getWriteStatuses().rdd().filter((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(WriteStatus ws) {
                        return ws.hasErrors();
                    }
                }).take(100)).foreach((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final void apply(WriteStatus ws) {
                        HoodieSparkSqlWriter$.MODULE$.org$apache$hudi$HoodieSparkSqlWriter$$log().trace((Object)"Global error :", ws.getGlobalError());
                        if (ws.getErrors().size() > 0) {
                            JavaConversions$.MODULE$.mapAsScalaMap(ws.getErrors()).foreach((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final void apply(Tuple2<HoodieKey, Throwable> kt) {
                                    HoodieSparkSqlWriter$.MODULE$.org$apache$hudi$HoodieSparkSqlWriter$$log().trace((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error for key: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{kt._1()})), (Throwable)kt._2());
                                }
                            });
                        }
                    }
                });
            }
            tuple3 = new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)false), Option.empty(), Option.empty());
        }
        return tuple3;
    }

    private boolean isAsyncCompactionEnabled(SparkRDDWriteClient<HoodieRecordPayload<Nothing$>> client, HoodieTableConfig tableConfig, scala.collection.immutable.Map<String, String> parameters, Configuration configuration) {
        boolean bl;
        this.org$apache$hudi$HoodieSparkSqlWriter$$log().info((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Config.inlineCompactionEnabled ? ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)client.getConfig().inlineCompactionEnabled())})));
        if (this.asyncCompactionTriggerFnDefined() && !client.getConfig().inlineCompactionEnabled() && parameters.get((Object)DataSourceWriteOptions$.MODULE$.ASYNC_COMPACT_ENABLE().key()).exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String r) {
                return new StringOps(Predef$.MODULE$.augmentString(r)).toBoolean();
            }
        })) {
            HoodieTableType hoodieTableType = tableConfig.getTableType();
            HoodieTableType hoodieTableType2 = HoodieTableType.MERGE_ON_READ;
            bl = !(hoodieTableType != null ? !((Object)((Object)hoodieTableType)).equals((Object)hoodieTableType2) : hoodieTableType2 != null);
        } else {
            bl = false;
        }
        return bl;
    }

    private boolean isAsyncClusteringEnabled(SparkRDDWriteClient<HoodieRecordPayload<Nothing$>> client, scala.collection.immutable.Map<String, String> parameters) {
        this.org$apache$hudi$HoodieSparkSqlWriter$$log().info((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Config.asyncClusteringEnabled ? ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)client.getConfig().isAsyncClusteringEnabled())})));
        return this.asyncClusteringTriggerFnDefined() && client.getConfig().isAsyncClusteringEnabled() && parameters.get((Object)DataSourceWriteOptions$.MODULE$.ASYNC_CLUSTERING_ENABLE().key()).exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String r) {
                return new StringOps(Predef$.MODULE$.augmentString(r)).toBoolean();
            }
        });
    }

    private HoodieTableConfig getHoodieTableConfig(SparkContext sparkContext, String tablePath, scala.Option<HoodieTableConfig> hoodieTableConfigOpt) {
        return this.tableExists() ? (HoodieTableConfig)hoodieTableConfigOpt.getOrElse((Function0)new Serializable(sparkContext, tablePath){
            public static final long serialVersionUID = 0L;
            private final SparkContext sparkContext$1;
            private final String tablePath$1;

            public final HoodieTableConfig apply() {
                return HoodieTableMetaClient.builder().setConf(this.sparkContext$1.hadoopConfiguration()).setBasePath(this.tablePath$1).build().getTableConfig();
            }
            {
                this.sparkContext$1 = sparkContext$1;
                this.tablePath$1 = tablePath$1;
            }
        }) : null;
    }

    private Tuple2<scala.collection.immutable.Map<String, String>, HoodieConfig> mergeParamsAndGetHoodieConfig(scala.collection.immutable.Map<String, String> optParams, HoodieTableConfig tableConfig) {
        scala.collection.immutable.Map<String, String> translatedOptions = DataSourceWriteOptions$.MODULE$.translateSqlOptions(optParams);
        scala.collection.mutable.Map mergedParams = Map$.MODULE$.empty().$plus$plus(HoodieWriterUtils$.MODULE$.parametersWithWriteDefaults(translatedOptions));
        if (!mergedParams.contains((Object)HoodieTableConfig.KEY_GENERATOR_CLASS_NAME.key()) && mergedParams.contains((Object)DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME().key())) {
            mergedParams.update((Object)HoodieTableConfig.KEY_GENERATOR_CLASS_NAME.key(), mergedParams.apply((Object)DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME().key()));
        }
        if (tableConfig != null) {
            JavaConversions$.MODULE$.propertiesAsScalaMap((Properties)tableConfig.getProps()).foreach((Function1)new Serializable(mergedParams){
                public static final long serialVersionUID = 0L;
                private final scala.collection.mutable.Map mergedParams$1;

                public final void apply(Tuple2<String, String> x0$1) {
                    Tuple2<String, String> tuple2 = x0$1;
                    if (tuple2 != null) {
                        String key = (String)tuple2._1();
                        String value = (String)tuple2._2();
                        this.mergedParams$1.update((Object)key, (Object)value);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.mergedParams$1 = mergedParams$1;
                }
            });
        }
        scala.collection.immutable.Map params = mergedParams.toMap(Predef$.MODULE$.$conforms());
        return new Tuple2((Object)params, (Object)HoodieWriterUtils$.MODULE$.convertMapToHoodieConfig((scala.collection.immutable.Map<String, String>)params));
    }

    private HoodieSparkSqlWriter$() {
        MODULE$ = this;
        this.org$apache$hudi$HoodieSparkSqlWriter$$log = LogManager.getLogger(this.getClass());
        this.tableExists = false;
        this.asyncCompactionTriggerFnDefined = false;
        this.asyncClusteringTriggerFnDefined = false;
    }
}

