/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.AvroConversionHelper$;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.HoodieSparkUtils$;
import org.apache.hudi.SparkAdapterSupport;
import org.apache.hudi.SparkAdapterSupport$class;
import org.apache.hudi.client.utils.SparkRowSerDe;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.keygen.BaseKeyGenerator;
import org.apache.hudi.keygen.CustomAvroKeyGenerator;
import org.apache.hudi.keygen.CustomKeyGenerator;
import org.apache.hudi.keygen.KeyGenerator;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.hudi.keygen.factory.HoodieSparkKeyGeneratorFactory;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.encoders.RowEncoder$;
import org.apache.spark.sql.catalyst.expressions.And$;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.EqualNullSafe;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GreaterThan;
import org.apache.spark.sql.catalyst.expressions.GreaterThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.IsNotNull;
import org.apache.spark.sql.catalyst.expressions.LessThan;
import org.apache.spark.sql.catalyst.expressions.LessThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Or;
import org.apache.spark.sql.execution.datasources.FileStatusCache;
import org.apache.spark.sql.execution.datasources.FileStatusCache$;
import org.apache.spark.sql.execution.datasources.InMemoryFileIndex;
import org.apache.spark.sql.hudi.SparkAdapter;
import org.apache.spark.sql.sources.And;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.In;
import org.apache.spark.sql.sources.IsNull;
import org.apache.spark.sql.sources.Not;
import org.apache.spark.sql.sources.StringContains;
import org.apache.spark.sql.sources.StringEndsWith;
import org.apache.spark.sql.sources.StringStartsWith;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.ObjectRef;

public final class HoodieSparkUtils$
implements SparkAdapterSupport {
    public static final HoodieSparkUtils$ MODULE$;
    private final SparkAdapter sparkAdapter;
    private volatile boolean bitmap$0;

    static {
        new HoodieSparkUtils$();
    }

    private SparkAdapter sparkAdapter$lzycompute() {
        HoodieSparkUtils$ hoodieSparkUtils$ = this;
        synchronized (hoodieSparkUtils$) {
            if (!this.bitmap$0) {
                this.sparkAdapter = SparkAdapterSupport$class.sparkAdapter(this);
                this.bitmap$0 = true;
            }
            return this.sparkAdapter;
        }
    }

    @Override
    public SparkAdapter sparkAdapter() {
        return this.bitmap$0 ? this.sparkAdapter : this.sparkAdapter$lzycompute();
    }

    public boolean isSpark3() {
        return org.apache.spark.package$.MODULE$.SPARK_VERSION().startsWith("3.");
    }

    public StructType getMetaSchema() {
        return StructType$.MODULE$.apply((Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(HoodieRecord.HOODIE_META_COLUMNS).asScala()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final StructField apply(String col) {
                return new StructField(col, (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
            }
        }, Buffer$.MODULE$.canBuildFrom()));
    }

    public boolean isGlobPath(Path pattern) {
        Set set = new StringOps(Predef$.MODULE$.augmentString("{}[]*?\\")).toSet();
        return new StringOps(Predef$.MODULE$.augmentString(pattern.toString())).exists((Function1)new Serializable(set){
            public static final long serialVersionUID = 0L;
            private final Set eta$0$1$1;

            public final boolean apply(Object elem) {
                return this.eta$0$1$1.contains(elem);
            }
            {
                this.eta$0$1$1 = eta$0$1$1;
            }
        });
    }

    public Seq<Path> globPath(FileSystem fs, Path pattern) {
        ObjectRef basePath = ObjectRef.create((Object)pattern.getParent());
        while (((Path)basePath.elem).getName().equals("*")) {
            basePath.elem = ((Path)basePath.elem).getParent();
        }
        return (Seq)Option$.MODULE$.apply((Object)fs.globStatus(pattern)).map((Function1)new Serializable(fs, basePath){
            public static final long serialVersionUID = 0L;
            public final FileSystem fs$1;
            public final ObjectRef basePath$1;

            public final Seq<Path> apply(FileStatus[] statuses) {
                FileStatus[] nonMetaStatuses = (FileStatus[])Predef$.MODULE$.refArrayOps((Object[])statuses).filterNot((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.globPath.1 $outer;

                    public final boolean apply(FileStatus entry) {
                        Path leafPath = entry.getPath();
                        while (!leafPath.equals((Object)((Path)this.$outer.basePath$1.elem)) && !leafPath.getName().equals(".hoodie")) {
                            Path path;
                            path = path.getParent();
                        }
                        return leafPath.getName().equals(".hoodie");
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])nonMetaStatuses).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.globPath.1 $outer;

                    public final Path apply(FileStatus x$1) {
                        return x$1.getPath().makeQualified(this.$outer.fs$1.getUri(), this.$outer.fs$1.getWorkingDirectory());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Path.class)))).toSeq();
            }
            {
                this.fs$1 = fs$1;
                this.basePath$1 = basePath$1;
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<Path> apply() {
                return (Seq)Seq$.MODULE$.empty();
            }
        });
    }

    public Seq<Path> globPathIfNecessary(FileSystem fs, Path pattern) {
        return this.isGlobPath(pattern) ? this.globPath(fs, pattern) : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Path[]{pattern}));
    }

    public Seq<Path> checkAndGlobPathIfNecessary(Seq<String> paths, FileSystem fs) {
        return (Seq)paths.flatMap((Function1)new Serializable(fs){
            public static final long serialVersionUID = 0L;
            private final FileSystem fs$2;

            public final Seq<Path> apply(String path) {
                Path qualified = new Path(path).makeQualified(this.fs$2.getUri(), this.fs$2.getWorkingDirectory());
                return HoodieSparkUtils$.MODULE$.globPathIfNecessary(this.fs$2, qualified);
            }
            {
                this.fs$2 = fs$2;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public InMemoryFileIndex createInMemoryFileIndex(SparkSession sparkSession, Seq<Path> globbedPaths) {
        FileStatusCache fileStatusCache = FileStatusCache$.MODULE$.getOrCreate(sparkSession);
        return new InMemoryFileIndex(sparkSession, globbedPaths, (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), Option$.MODULE$.empty(), fileStatusCache);
    }

    public RDD<GenericRecord> createRdd(Dataset<Row> df, String structName, String recordNamespace, boolean reconcileToLatestSchema, Option<Schema> latestTableSchema) {
        Schema dfWriteSchema = AvroConversionUtils$.MODULE$.convertStructTypeToAvroSchema(df.schema(), structName, recordNamespace);
        Schema writeSchema = null;
        Schema toReconcileSchema = null;
        if (reconcileToLatestSchema && latestTableSchema.isPresent()) {
            writeSchema = dfWriteSchema;
            toReconcileSchema = latestTableSchema.get();
        } else {
            writeSchema = latestTableSchema.isPresent() ? latestTableSchema.get() : dfWriteSchema;
        }
        return this.createRddInternal(df, writeSchema, toReconcileSchema, structName, recordNamespace);
    }

    public Option<Schema> createRdd$default$5() {
        return Option.empty();
    }

    public RDD<GenericRecord> createRddInternal(Dataset<Row> df, Schema writeSchema, Schema latestTableSchema, String structName, String recordNamespace) {
        StructType writeDataType = AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(writeSchema);
        ExpressionEncoder qual$1 = RowEncoder$.MODULE$.apply(writeDataType);
        Seq x$4 = qual$1.resolveAndBind$default$1();
        Analyzer x$5 = qual$1.resolveAndBind$default$2();
        ExpressionEncoder encoder2 = qual$1.resolveAndBind(x$4, x$5);
        SparkRowSerDe deserializer = this.sparkAdapter().createSparkRowSerDe((ExpressionEncoder<Row>)encoder2);
        StructType reconciledDataType = latestTableSchema == null ? writeDataType : AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(latestTableSchema);
        RDD qual$2 = df.queryExecution().toRdd().map((Function1)new Serializable(deserializer){
            public static final long serialVersionUID = 0L;
            private final SparkRowSerDe deserializer$1;

            public final Row apply(InternalRow row) {
                return this.deserializer$1.deserializeRow(row);
            }
            {
                this.deserializer$1 = deserializer$1;
            }
        }, ClassTag$.MODULE$.apply(Row.class));
        Serializable x$6 = new Serializable(structName, recordNamespace, reconciledDataType){
            public static final long serialVersionUID = 0L;
            private final String structName$1;
            private final String recordNamespace$1;
            private final StructType reconciledDataType$1;

            public final Iterator<GenericRecord> apply(Iterator<Row> records) {
                Iterator iterator2;
                if (records.isEmpty()) {
                    iterator2 = scala.package$.MODULE$.Iterator().empty();
                } else {
                    Function1<Object, Object> convertor = AvroConversionHelper$.MODULE$.createConverterToAvro((DataType)this.reconciledDataType$1, this.structName$1, this.recordNamespace$1);
                    iterator2 = records.map((Function1)new Serializable(this, convertor){
                        public static final long serialVersionUID = 0L;
                        private final Function1 convertor$1;

                        public final GenericRecord apply(Row x) {
                            return (GenericRecord)this.convertor$1.apply((Object)x);
                        }
                        {
                            this.convertor$1 = convertor$1;
                        }
                    });
                }
                return iterator2;
            }
            {
                this.structName$1 = structName$1;
                this.recordNamespace$1 = recordNamespace$1;
                this.reconciledDataType$1 = reconciledDataType$1;
            }
        };
        boolean x$7 = qual$2.mapPartitions$default$2();
        return qual$2.mapPartitions((Function1)x$6, x$7, ClassTag$.MODULE$.apply(GenericRecord.class));
    }

    public SparkRowSerDe getDeserializer(StructType structType) {
        ExpressionEncoder qual$3 = RowEncoder$.MODULE$.apply(structType);
        Seq x$8 = qual$3.resolveAndBind$default$1();
        Analyzer x$9 = qual$3.resolveAndBind$default$2();
        ExpressionEncoder encoder2 = qual$3.resolveAndBind(x$8, x$9);
        return this.sparkAdapter().createSparkRowSerDe((ExpressionEncoder<Row>)encoder2);
    }

    public scala.Option<Expression> convertToCatalystExpressions(Filter[] filters, StructType tableSchema2) {
        scala.Option[] expressions = (scala.Option[])Predef$.MODULE$.refArrayOps((Object[])filters).map((Function1)new Serializable(tableSchema2){
            public static final long serialVersionUID = 0L;
            private final StructType tableSchema$1;

            public final scala.Option<Expression> apply(Filter x$2) {
                return HoodieSparkUtils$.MODULE$.convertToCatalystExpression(x$2, this.tableSchema$1);
            }
            {
                this.tableSchema$1 = tableSchema$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(scala.Option.class)));
        return Predef$.MODULE$.refArrayOps((Object[])expressions).forall((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(scala.Option<Expression> p) {
                return p.isDefined();
            }
        }) ? (Predef$.MODULE$.refArrayOps((Object[])expressions).isEmpty() ? None$.MODULE$ : (expressions.length == 1 ? expressions[0] : new Some(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])expressions).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Expression apply(scala.Option<Expression> x$3) {
                return (Expression)x$3.get();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Expression.class)))).reduce((Function2)And$.MODULE$)))) : None$.MODULE$;
    }

    public scala.Option<Expression> convertToCatalystExpression(Filter filter, StructType tableSchema2) {
        EqualTo equalTo;
        Filter filter2 = filter;
        if (filter2 instanceof org.apache.spark.sql.sources.EqualTo) {
            org.apache.spark.sql.sources.EqualTo equalTo2 = (org.apache.spark.sql.sources.EqualTo)filter2;
            String attribute = equalTo2.attribute();
            Object value = equalTo2.value();
            equalTo = new EqualTo((Expression)this.toAttribute(attribute, tableSchema2), (Expression)Literal$.MODULE$.create(value, ((TypeTags)package$.MODULE$.universe()).TypeTag().Any()));
        } else if (filter2 instanceof org.apache.spark.sql.sources.EqualNullSafe) {
            org.apache.spark.sql.sources.EqualNullSafe equalNullSafe = (org.apache.spark.sql.sources.EqualNullSafe)filter2;
            String attribute = equalNullSafe.attribute();
            Object value = equalNullSafe.value();
            equalTo = new EqualNullSafe((Expression)this.toAttribute(attribute, tableSchema2), (Expression)Literal$.MODULE$.create(value, ((TypeTags)package$.MODULE$.universe()).TypeTag().Any()));
        } else if (filter2 instanceof org.apache.spark.sql.sources.GreaterThan) {
            org.apache.spark.sql.sources.GreaterThan greaterThan = (org.apache.spark.sql.sources.GreaterThan)filter2;
            String attribute = greaterThan.attribute();
            Object value = greaterThan.value();
            equalTo = new GreaterThan((Expression)this.toAttribute(attribute, tableSchema2), (Expression)Literal$.MODULE$.create(value, ((TypeTags)package$.MODULE$.universe()).TypeTag().Any()));
        } else if (filter2 instanceof org.apache.spark.sql.sources.GreaterThanOrEqual) {
            org.apache.spark.sql.sources.GreaterThanOrEqual greaterThanOrEqual = (org.apache.spark.sql.sources.GreaterThanOrEqual)filter2;
            String attribute = greaterThanOrEqual.attribute();
            Object value = greaterThanOrEqual.value();
            equalTo = new GreaterThanOrEqual((Expression)this.toAttribute(attribute, tableSchema2), (Expression)Literal$.MODULE$.create(value, ((TypeTags)package$.MODULE$.universe()).TypeTag().Any()));
        } else if (filter2 instanceof org.apache.spark.sql.sources.LessThan) {
            org.apache.spark.sql.sources.LessThan lessThan = (org.apache.spark.sql.sources.LessThan)filter2;
            String attribute = lessThan.attribute();
            Object value = lessThan.value();
            equalTo = new LessThan((Expression)this.toAttribute(attribute, tableSchema2), (Expression)Literal$.MODULE$.create(value, ((TypeTags)package$.MODULE$.universe()).TypeTag().Any()));
        } else if (filter2 instanceof org.apache.spark.sql.sources.LessThanOrEqual) {
            org.apache.spark.sql.sources.LessThanOrEqual lessThanOrEqual = (org.apache.spark.sql.sources.LessThanOrEqual)filter2;
            String attribute = lessThanOrEqual.attribute();
            Object value = lessThanOrEqual.value();
            equalTo = new LessThanOrEqual((Expression)this.toAttribute(attribute, tableSchema2), (Expression)Literal$.MODULE$.create(value, ((TypeTags)package$.MODULE$.universe()).TypeTag().Any()));
        } else if (filter2 instanceof In) {
            In in = (In)filter2;
            String attribute = in.attribute();
            Object[] values2 = in.values();
            AttributeReference attrExp = this.toAttribute(attribute, tableSchema2);
            Literal[] valuesExp = (Literal[])Predef$.MODULE$.genericArrayOps((Object)values2).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Literal apply(Object v) {
                    return Literal$.MODULE$.create(v, ((TypeTags)package$.MODULE$.universe()).TypeTag().Any());
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Literal.class)));
            equalTo = new org.apache.spark.sql.catalyst.expressions.In((Expression)attrExp, (Seq)Predef$.MODULE$.wrapRefArray((Object[])valuesExp));
        } else if (filter2 instanceof IsNull) {
            IsNull isNull = (IsNull)filter2;
            String attribute = isNull.attribute();
            equalTo = new org.apache.spark.sql.catalyst.expressions.IsNull((Expression)this.toAttribute(attribute, tableSchema2));
        } else if (filter2 instanceof org.apache.spark.sql.sources.IsNotNull) {
            org.apache.spark.sql.sources.IsNotNull isNotNull = (org.apache.spark.sql.sources.IsNotNull)filter2;
            String attribute = isNotNull.attribute();
            equalTo = new IsNotNull((Expression)this.toAttribute(attribute, tableSchema2));
        } else if (filter2 instanceof And) {
            And and = (And)filter2;
            Filter left = and.left();
            Filter right = and.right();
            scala.Option<Expression> leftExp = this.convertToCatalystExpression(left, tableSchema2);
            scala.Option<Expression> rightExp = this.convertToCatalystExpression(right, tableSchema2);
            equalTo = leftExp.isEmpty() || rightExp.isEmpty() ? null : new org.apache.spark.sql.catalyst.expressions.And((Expression)leftExp.get(), (Expression)rightExp.get());
        } else if (filter2 instanceof org.apache.spark.sql.sources.Or) {
            org.apache.spark.sql.sources.Or or = (org.apache.spark.sql.sources.Or)filter2;
            Filter left = or.left();
            Filter right = or.right();
            scala.Option<Expression> leftExp = this.convertToCatalystExpression(left, tableSchema2);
            scala.Option<Expression> rightExp = this.convertToCatalystExpression(right, tableSchema2);
            equalTo = leftExp.isEmpty() || rightExp.isEmpty() ? null : new Or((Expression)leftExp.get(), (Expression)rightExp.get());
        } else if (filter2 instanceof Not) {
            Not not = (Not)filter2;
            Filter child = not.child();
            scala.Option<Expression> childExp = this.convertToCatalystExpression(child, tableSchema2);
            equalTo = childExp.isEmpty() ? null : new org.apache.spark.sql.catalyst.expressions.Not((Expression)childExp.get());
        } else if (filter2 instanceof StringStartsWith) {
            StringStartsWith stringStartsWith = (StringStartsWith)filter2;
            String attribute = stringStartsWith.attribute();
            String value = stringStartsWith.value();
            AttributeReference leftExp = this.toAttribute(attribute, tableSchema2);
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
            public final class Org_apache_hudi_HoodieSparkUtils$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
                }

                public Org_apache_hudi_HoodieSparkUtils$$typecreator1$1() {
                }
            }
            Literal rightExp = Literal$.MODULE$.create((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "%"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{value})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_hudi_HoodieSparkUtils$$typecreator1$1()));
            equalTo = this.sparkAdapter().createLike((Expression)leftExp, (Expression)rightExp);
        } else if (filter2 instanceof StringEndsWith) {
            StringEndsWith stringEndsWith = (StringEndsWith)filter2;
            String attribute = stringEndsWith.attribute();
            String value = stringEndsWith.value();
            AttributeReference leftExp = this.toAttribute(attribute, tableSchema2);
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
            public final class Org_apache_hudi_HoodieSparkUtils$$typecreator2$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
                }

                public Org_apache_hudi_HoodieSparkUtils$$typecreator2$1() {
                }
            }
            Literal rightExp = Literal$.MODULE$.create((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"%", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{value})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_hudi_HoodieSparkUtils$$typecreator2$1()));
            equalTo = this.sparkAdapter().createLike((Expression)leftExp, (Expression)rightExp);
        } else if (filter2 instanceof StringContains) {
            StringContains stringContains = (StringContains)filter2;
            String attribute = stringContains.attribute();
            String value = stringContains.value();
            AttributeReference leftExp = this.toAttribute(attribute, tableSchema2);
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
            public final class Org_apache_hudi_HoodieSparkUtils$$typecreator3$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
                }

                public Org_apache_hudi_HoodieSparkUtils$$typecreator3$1() {
                }
            }
            Literal rightExp = Literal$.MODULE$.create((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"%", "%"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{value})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_hudi_HoodieSparkUtils$$typecreator3$1()));
            equalTo = this.sparkAdapter().createLike((Expression)leftExp, (Expression)rightExp);
        } else {
            equalTo = null;
        }
        return Option$.MODULE$.apply((Object)equalTo);
    }

    public String getPartitionColumns(Properties properties) {
        TypedProperties props = new TypedProperties(properties);
        KeyGenerator keyGenerator = HoodieSparkKeyGeneratorFactory.createKeyGenerator(props);
        return this.getPartitionColumns(keyGenerator, props);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getPartitionColumns(KeyGenerator keyGen, TypedProperties typedProperties) {
        boolean bl = false;
        ObjectRef objectRef = ObjectRef.create(null);
        KeyGenerator keyGenerator = keyGen;
        if (keyGenerator instanceof BaseKeyGenerator) {
            bl = true;
            objectRef.elem = (BaseKeyGenerator)keyGenerator;
            if ((BaseKeyGenerator)objectRef.elem instanceof CustomKeyGenerator) return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((BaseKeyGenerator)objectRef.elem).getPartitionPathFields()).asScala()).map((Function1)new Serializable(objectRef){
                public static final long serialVersionUID = 0L;
                public final ObjectRef x2$1;

                public final String apply(String pathField) {
                    return (String)Predef$.MODULE$.refArrayOps((Object[])pathField.split(":")).headOption().getOrElse((Function0)new Serializable(this, pathField){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.getPartitionColumns.1 $outer;
                        private final String pathField$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Illegal partition path field format: '", "' for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.pathField$1, ((BaseKeyGenerator)this.$outer.x2$1.elem).getClass().getSimpleName()}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.pathField$1 = pathField$1;
                        }
                    });
                }
                {
                    this.x2$1 = x2$1;
                }
            }, Buffer$.MODULE$.canBuildFrom())).mkString(",");
            if ((BaseKeyGenerator)objectRef.elem instanceof CustomAvroKeyGenerator) {
                return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((BaseKeyGenerator)objectRef.elem).getPartitionPathFields()).asScala()).map((Function1)new /* invalid duplicate definition of identical inner class */, Buffer$.MODULE$.canBuildFrom())).mkString(",");
            }
        }
        if (!bl) return typedProperties.getString(KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key());
        return ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(((BaseKeyGenerator)objectRef.elem).getPartitionPathFields()).asScala()).mkString(",");
    }

    private AttributeReference toAttribute(String columnName, StructType tableSchema2) {
        scala.Option field = tableSchema2.find((Function1)new Serializable(columnName){
            public static final long serialVersionUID = 0L;
            private final String columnName$1;

            public final boolean apply(StructField p) {
                String string = p.name();
                String string2 = this.columnName$1;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.columnName$1 = columnName$1;
            }
        });
        Predef$.MODULE$.assert(field.isDefined(), (Function0)new Serializable(columnName, tableSchema2){
            public static final long serialVersionUID = 0L;
            private final String columnName$1;
            private final StructType tableSchema$2;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot find column: ", ", Table Columns are: "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.columnName$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])this.tableSchema$2.fieldNames()).mkString(",")}))).toString();
            }
            {
                this.columnName$1 = columnName$1;
                this.tableSchema$2 = tableSchema$2;
            }
        });
        String x$10 = columnName;
        DataType x$11 = ((StructField)field.get()).dataType();
        boolean x$12 = ((StructField)field.get()).nullable();
        Metadata x$13 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$14 = AttributeReference$.MODULE$.apply$default$5(x$10, x$11, x$12, x$13);
        Seq x$15 = AttributeReference$.MODULE$.apply$default$6(x$10, x$11, x$12, x$13);
        return new AttributeReference(x$10, x$11, x$12, x$13, x$14, x$15);
    }

    private HoodieSparkUtils$() {
        MODULE$ = this;
        SparkAdapterSupport$class.$init$(this);
    }
}

