/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.async;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.IntStream;
import org.apache.hudi.async.HoodieAsyncService;
import org.apache.hudi.client.AbstractCompactor;
import org.apache.hudi.client.AbstractHoodieWriteClient;
import org.apache.hudi.common.engine.EngineProperty;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public abstract class AsyncCompactService
extends HoodieAsyncService {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LogManager.getLogger(AsyncCompactService.class);
    public static final String COMPACT_POOL_NAME = "hoodiecompact";
    private final int maxConcurrentCompaction;
    private transient AbstractCompactor compactor;
    protected transient HoodieEngineContext context;

    public AsyncCompactService(HoodieEngineContext context, AbstractHoodieWriteClient client) {
        this(context, client, false);
    }

    public AsyncCompactService(HoodieEngineContext context, AbstractHoodieWriteClient client, boolean runInDaemonMode) {
        super(runInDaemonMode);
        this.context = context;
        this.compactor = this.createCompactor(client);
        this.maxConcurrentCompaction = 1;
    }

    protected abstract AbstractCompactor createCompactor(AbstractHoodieWriteClient var1);

    @Override
    protected Pair<CompletableFuture, ExecutorService> startService() {
        ExecutorService executor = Executors.newFixedThreadPool(this.maxConcurrentCompaction, r -> {
            Thread t = new Thread(r, "async_compact_thread");
            t.setDaemon(this.isRunInDaemonMode());
            return t;
        });
        return Pair.of(CompletableFuture.allOf((CompletableFuture[])IntStream.range(0, this.maxConcurrentCompaction).mapToObj(i -> CompletableFuture.supplyAsync(() -> {
            try {
                LOG.info((Object)"Setting pool name for compaction to hoodiecompact");
                this.context.setProperty(EngineProperty.COMPACTION_POOL_NAME, COMPACT_POOL_NAME);
                while (!this.isShutdownRequested()) {
                    HoodieInstant instant = this.fetchNextAsyncServiceInstant();
                    if (null == instant) continue;
                    LOG.info((Object)("Starting Compaction for instant " + instant));
                    this.compactor.compact(instant);
                    LOG.info((Object)("Finished Compaction for instant " + instant));
                }
                LOG.info((Object)"Compactor shutting down properly!!");
            }
            catch (InterruptedException ie) {
                LOG.warn((Object)"Compactor executor thread got interrupted exception. Stopping", (Throwable)ie);
            }
            catch (IOException e) {
                LOG.error((Object)"Compactor executor failed", (Throwable)e);
                throw new HoodieIOException(e.getMessage(), e);
            }
            return true;
        }, executor)).toArray(CompletableFuture[]::new)), executor);
    }

    protected boolean shouldStopCompactor() {
        return false;
    }

    public synchronized void updateWriteClient(AbstractHoodieWriteClient writeClient) {
        this.compactor.updateWriteClient(writeClient);
    }
}

