/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.embedded;

import java.io.IOException;
import org.apache.hudi.common.config.SerializableConfiguration;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.table.marker.MarkerType;
import org.apache.hudi.common.table.view.FileSystemViewManager;
import org.apache.hudi.common.table.view.FileSystemViewStorageConfig;
import org.apache.hudi.common.table.view.FileSystemViewStorageType;
import org.apache.hudi.common.util.NetworkUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.timeline.service.TimelineService;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class EmbeddedTimelineService {
    private static final Logger LOG = LogManager.getLogger(EmbeddedTimelineService.class);
    private int serverPort;
    private String hostAddr;
    private HoodieEngineContext context;
    private final SerializableConfiguration hadoopConf;
    private final HoodieWriteConfig writeConfig;
    private final String basePath;
    private transient FileSystemViewManager viewManager;
    private transient TimelineService server;

    public EmbeddedTimelineService(HoodieEngineContext context, String embeddedTimelineServiceHostAddr, HoodieWriteConfig writeConfig) {
        this.setHostAddr(embeddedTimelineServiceHostAddr);
        this.context = context;
        this.writeConfig = writeConfig;
        this.basePath = writeConfig.getBasePath();
        this.hadoopConf = context.getHadoopConf();
        this.viewManager = this.createViewManager();
    }

    private FileSystemViewManager createViewManager() {
        FileSystemViewStorageConfig.Builder builder = FileSystemViewStorageConfig.newBuilder().fromProperties(this.writeConfig.getClientSpecifiedViewStorageConfig().getProps());
        FileSystemViewStorageType storageType = builder.build().getStorageType();
        if (storageType.equals((Object)FileSystemViewStorageType.REMOTE_ONLY) || storageType.equals((Object)FileSystemViewStorageType.REMOTE_FIRST)) {
            builder.withStorageType(FileSystemViewStorageType.MEMORY);
        }
        return FileSystemViewManager.createViewManager(this.context, this.writeConfig.getMetadataConfig(), builder.build(), this.writeConfig.getCommonConfig(), this.basePath);
    }

    public void startServer() throws IOException {
        TimelineService.Config.Builder timelineServiceConfBuilder = TimelineService.Config.builder().serverPort(this.writeConfig.getEmbeddedTimelineServerPort()).numThreads(this.writeConfig.getEmbeddedTimelineServerThreads()).compress(this.writeConfig.getEmbeddedTimelineServerCompressOutput()).async(this.writeConfig.getEmbeddedTimelineServerUseAsync());
        if (this.writeConfig.getMarkersType() == MarkerType.TIMELINE_SERVER_BASED) {
            timelineServiceConfBuilder.enableMarkerRequests(true).markerBatchNumThreads(this.writeConfig.getMarkersTimelineServerBasedBatchNumThreads()).markerBatchIntervalMs(this.writeConfig.getMarkersTimelineServerBasedBatchIntervalMs()).markerParallelism(this.writeConfig.getMarkersDeleteParallelism());
        }
        this.server = new TimelineService(this.context, this.hadoopConf.newCopy(), timelineServiceConfBuilder.build(), FSUtils.getFs(this.basePath, this.hadoopConf.newCopy()), this.viewManager);
        this.serverPort = this.server.startService();
        LOG.info((Object)("Started embedded timeline server at " + this.hostAddr + ":" + this.serverPort));
    }

    private void setHostAddr(String embeddedTimelineServiceHostAddr) {
        if (embeddedTimelineServiceHostAddr != null) {
            LOG.info((Object)("Overriding hostIp to (" + embeddedTimelineServiceHostAddr + ") found in spark-conf. It was " + this.hostAddr));
            this.hostAddr = embeddedTimelineServiceHostAddr;
        } else {
            LOG.warn((Object)"Unable to find driver bind address from spark config");
            this.hostAddr = NetworkUtils.getHostname();
        }
    }

    public FileSystemViewStorageConfig getRemoteFileSystemViewConfig() {
        FileSystemViewStorageType viewStorageType = this.writeConfig.getClientSpecifiedViewStorageConfig().shouldEnableBackupForRemoteFileSystemView() ? FileSystemViewStorageType.REMOTE_FIRST : FileSystemViewStorageType.REMOTE_ONLY;
        return FileSystemViewStorageConfig.newBuilder().withStorageType(viewStorageType).withRemoteServerHost(this.hostAddr).withRemoteServerPort(this.serverPort).build();
    }

    public FileSystemViewManager getViewManager() {
        return this.viewManager;
    }

    public boolean canReuseFor(String basePath) {
        return this.server != null && this.viewManager != null && this.basePath.equals(basePath);
    }

    public void stop() {
        if (null != this.server) {
            LOG.info((Object)"Closing Timeline server");
            this.server.close();
            this.server = null;
            this.viewManager = null;
            LOG.info((Object)"Closed Timeline server");
        }
    }
}

