/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.validator;

import java.util.List;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.validator.SqlQueryInequalityPreCommitValidator;
import org.apache.hudi.client.validator.SqlQueryPreCommitValidator;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.config.HoodiePreCommitValidatorConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieValidationException;
import org.apache.hudi.table.HoodieSparkTable;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;

public class SqlQuerySingleResultPreCommitValidator<T extends HoodieRecordPayload, I, K, O extends JavaRDD<WriteStatus>>
extends SqlQueryPreCommitValidator<T, I, K, O> {
    private static final Logger LOG = LogManager.getLogger(SqlQueryInequalityPreCommitValidator.class);

    public SqlQuerySingleResultPreCommitValidator(HoodieSparkTable<T> table, HoodieEngineContext engineContext, HoodieWriteConfig config) {
        super(table, engineContext, config);
    }

    @Override
    protected String getQueryConfigName() {
        return HoodiePreCommitValidatorConfig.SINGLE_VALUE_SQL_QUERIES.key();
    }

    @Override
    protected void validateUsingQuery(String query, String prevTableSnapshot, String newTableSnapshot, SQLContext sqlContext) {
        String[] queryWithExpectedResult = query.split("#");
        if (queryWithExpectedResult.length != 2) {
            throw new HoodieValidationException("Invalid query format " + query);
        }
        String queryToRun = queryWithExpectedResult[0];
        String expectedResult = queryWithExpectedResult[1];
        LOG.info((Object)("Running query on new state: " + queryToRun));
        String queryWithNewSnapshot = queryToRun.replaceAll("<TABLE_NAME>", newTableSnapshot);
        List newRows = sqlContext.sql(queryWithNewSnapshot).collectAsList();
        if (newRows.size() != 1 && ((Row)newRows.get(0)).size() != 1) {
            throw new HoodieValidationException("Invalid query result. expect single value for '" + query + "'");
        }
        Object result = ((Row)newRows.get(0)).apply(0);
        if (result == null || !expectedResult.equals(result.toString())) {
            LOG.error((Object)("Mismatch query result. Expected: " + expectedResult + " got " + result + "Query: " + query));
            throw new HoodieValidationException("Query validation failed for '" + query + "'. Expected " + expectedResult + " rows, Found " + result);
        }
        LOG.info((Object)("Query validation successful. Expected: " + expectedResult + " got " + result));
    }
}

