/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.config;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;

public class TypedProperties
extends Properties
implements Serializable {
    public TypedProperties() {
        super((Properties)null);
    }

    public TypedProperties(Properties defaults) {
        if (Objects.nonNull(defaults)) {
            for (String key : defaults.stringPropertyNames()) {
                this.put(key, defaults.getProperty(key));
            }
        }
    }

    private void checkKey(String property) {
        if (!this.keyExists(property)) {
            throw new IllegalArgumentException("Property " + property + " not found");
        }
    }

    private boolean keyExists(String property) {
        Set<String> keys2 = super.stringPropertyNames();
        return keys2.contains(property);
    }

    public String getString(String property) {
        this.checkKey(property);
        return this.getProperty(property);
    }

    public String getString(String property, String defaultValue) {
        return this.keyExists(property) ? this.getProperty(property) : defaultValue;
    }

    public List<String> getStringList(String property, String delimiter, List<String> defaultVal) {
        if (!this.keyExists(property)) {
            return defaultVal;
        }
        return Arrays.stream(this.getProperty(property).split(delimiter)).map(String::trim).collect(Collectors.toList());
    }

    public int getInteger(String property) {
        this.checkKey(property);
        return Integer.parseInt(this.getProperty(property));
    }

    public int getInteger(String property, int defaultValue) {
        return this.keyExists(property) ? Integer.parseInt(this.getProperty(property)) : defaultValue;
    }

    public long getLong(String property) {
        this.checkKey(property);
        return Long.parseLong(this.getProperty(property));
    }

    public long getLong(String property, long defaultValue) {
        return this.keyExists(property) ? Long.parseLong(this.getProperty(property)) : defaultValue;
    }

    public boolean getBoolean(String property) {
        this.checkKey(property);
        return Boolean.parseBoolean(this.getProperty(property));
    }

    public boolean getBoolean(String property, boolean defaultValue) {
        return this.keyExists(property) ? Boolean.parseBoolean(this.getProperty(property)) : defaultValue;
    }

    public double getDouble(String property) {
        this.checkKey(property);
        return Double.parseDouble(this.getProperty(property));
    }

    public double getDouble(String property, double defaultValue) {
        return this.keyExists(property) ? Double.parseDouble(this.getProperty(property)) : defaultValue;
    }
}

