/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.hudi.avro.model.HoodieClusteringGroup;
import org.apache.hudi.common.model.ClusteringOperation;

public class ClusteringGroupInfo
implements Serializable {
    private List<ClusteringOperation> operations;
    private int numOutputGroups;

    public static ClusteringGroupInfo create(HoodieClusteringGroup clusteringGroup) {
        List<ClusteringOperation> operations = clusteringGroup.getSlices().stream().map(ClusteringOperation::create).collect(Collectors.toList());
        return new ClusteringGroupInfo(operations, clusteringGroup.getNumOutputFileGroups());
    }

    @Deprecated
    public ClusteringGroupInfo() {
    }

    private ClusteringGroupInfo(List<ClusteringOperation> operations, int numOutputGroups) {
        this.operations = operations;
        this.numOutputGroups = numOutputGroups;
    }

    public List<ClusteringOperation> getOperations() {
        return this.operations;
    }

    public void setOperations(List<ClusteringOperation> operations) {
        this.operations = operations;
    }

    public int getNumOutputGroups() {
        return this.numOutputGroups;
    }

    public void setNumOutputGroups(int numOutputGroups) {
        this.numOutputGroups = numOutputGroups;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusteringGroupInfo that = (ClusteringGroupInfo)o;
        return Objects.equals(this.getFilePathsInGroup(), that.getFilePathsInGroup());
    }

    public int hashCode() {
        return Objects.hash(this.getFilePathsInGroup());
    }

    private String getFilePathsInGroup() {
        return this.getOperations().stream().map(op -> op.getDataFilePath()).collect(Collectors.joining(","));
    }
}

