/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public enum HoodieFileFormat {
    PARQUET(".parquet"),
    HOODIE_LOG(".log"),
    HFILE(".hfile"),
    ORC(".orc");

    public static final Set<String> BASE_FILE_EXTENSIONS;
    private final String extension;

    private HoodieFileFormat(String extension) {
        this.extension = extension;
    }

    public String getFileExtension() {
        return this.extension;
    }

    static {
        BASE_FILE_EXTENSIONS = Arrays.stream(HoodieFileFormat.values()).map(HoodieFileFormat::getFileExtension).filter(x -> !x.equals(HOODIE_LOG.getFileExtension())).collect(Collectors.toCollection(HashSet::new));
    }
}

