/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.config.metrics;

import java.util.Map;
import java.util.Properties;
import org.apache.hudi.common.config.ConfigClassProperty;
import org.apache.hudi.common.config.ConfigGroups;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.HoodieConfig;

@ConfigClassProperty(name="Metrics Configurations for Prometheus", groupName=ConfigGroups.Names.METRICS, description="Enables reporting on Hudi metrics using Prometheus.  Hudi publishes metrics on every commit, clean, rollback etc.")
public class HoodieMetricsPrometheusConfig
extends HoodieConfig {
    public static final String PUSHGATEWAY_PREFIX = "hoodie.metrics.pushgateway";
    public static final ConfigProperty<String> PUSHGATEWAY_HOST_NAME = ConfigProperty.key("hoodie.metrics.pushgateway.host").defaultValue("localhost").sinceVersion("0.6.0").withDocumentation("Hostname of the prometheus push gateway.");
    public static final ConfigProperty<Integer> PUSHGATEWAY_PORT_NUM = ConfigProperty.key("hoodie.metrics.pushgateway.port").defaultValue(9091).sinceVersion("0.6.0").withDocumentation("Port for the push gateway.");
    public static final ConfigProperty<Integer> PUSHGATEWAY_REPORT_PERIOD_IN_SECONDS = ConfigProperty.key("hoodie.metrics.pushgateway.report.period.seconds").defaultValue(30).sinceVersion("0.6.0").withDocumentation("Reporting interval in seconds.");
    public static final ConfigProperty<Boolean> PUSHGATEWAY_DELETE_ON_SHUTDOWN_ENABLE = ConfigProperty.key("hoodie.metrics.pushgateway.delete.on.shutdown").defaultValue(true).sinceVersion("0.6.0").withDocumentation("Delete the pushgateway info or not when job shutdown, true by default.");
    public static final ConfigProperty<String> PUSHGATEWAY_JOBNAME = ConfigProperty.key("hoodie.metrics.pushgateway.job.name").defaultValue("").sinceVersion("0.6.0").withDocumentation("Name of the push gateway job.");
    public static final ConfigProperty<Boolean> PUSHGATEWAY_RANDOM_JOBNAME_SUFFIX = ConfigProperty.key("hoodie.metrics.pushgateway.random.job.name.suffix").defaultValue(true).sinceVersion("0.6.0").withDocumentation("Whether the pushgateway name need a random suffix , default true.");
    public static final String PROMETHEUS_PREFIX = "hoodie.metrics.prometheus";
    public static final ConfigProperty<Integer> PROMETHEUS_PORT_NUM = ConfigProperty.key("hoodie.metrics.prometheus.port").defaultValue(9090).sinceVersion("0.6.0").withDocumentation("Port for prometheus server.");
    @Deprecated
    public static final String PUSHGATEWAY_HOST = PUSHGATEWAY_HOST_NAME.key();
    @Deprecated
    public static final String DEFAULT_PUSHGATEWAY_HOST = PUSHGATEWAY_HOST_NAME.defaultValue();
    @Deprecated
    public static final String PUSHGATEWAY_PORT = PUSHGATEWAY_PORT_NUM.key();
    @Deprecated
    public static final int DEFAULT_PUSHGATEWAY_PORT = PUSHGATEWAY_PORT_NUM.defaultValue();
    @Deprecated
    public static final String PUSHGATEWAY_REPORT_PERIOD_SECONDS = PUSHGATEWAY_REPORT_PERIOD_IN_SECONDS.key();
    @Deprecated
    public static final int DEFAULT_PUSHGATEWAY_REPORT_PERIOD_SECONDS = PUSHGATEWAY_REPORT_PERIOD_IN_SECONDS.defaultValue();
    @Deprecated
    public static final String PUSHGATEWAY_DELETE_ON_SHUTDOWN = PUSHGATEWAY_DELETE_ON_SHUTDOWN_ENABLE.key();
    @Deprecated
    public static final boolean DEFAULT_PUSHGATEWAY_DELETE_ON_SHUTDOWN = PUSHGATEWAY_DELETE_ON_SHUTDOWN_ENABLE.defaultValue();
    @Deprecated
    public static final String PUSHGATEWAY_JOB_NAME = PUSHGATEWAY_JOBNAME.key();
    @Deprecated
    public static final String DEFAULT_PUSHGATEWAY_JOB_NAME = PUSHGATEWAY_JOBNAME.defaultValue();
    @Deprecated
    public static final String PUSHGATEWAY_RANDOM_JOB_NAME_SUFFIX = PUSHGATEWAY_RANDOM_JOBNAME_SUFFIX.key();
    @Deprecated
    public static final boolean DEFAULT_PUSHGATEWAY_RANDOM_JOB_NAME_SUFFIX = PUSHGATEWAY_RANDOM_JOBNAME_SUFFIX.defaultValue();
    @Deprecated
    public static final String PROMETHEUS_PORT = PROMETHEUS_PORT_NUM.key();
    @Deprecated
    public static final int DEFAULT_PROMETHEUS_PORT = PROMETHEUS_PORT_NUM.defaultValue();

    private HoodieMetricsPrometheusConfig() {
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private HoodieMetricsPrometheusConfig hoodieMetricsPrometheusConfig = new HoodieMetricsPrometheusConfig();

        public Builder fromProperties(Properties props) {
            this.hoodieMetricsPrometheusConfig.getProps().putAll((Map<?, ?>)props);
            return this;
        }

        public Builder withPushgatewayHostName(String hostName) {
            this.hoodieMetricsPrometheusConfig.setValue(PUSHGATEWAY_HOST_NAME, String.valueOf(hostName));
            return this;
        }

        public Builder withPushgatewayPortNum(Integer pushgatewayPortNum) {
            this.hoodieMetricsPrometheusConfig.setValue(PUSHGATEWAY_PORT_NUM, String.valueOf(pushgatewayPortNum));
            return this;
        }

        public Builder withPushgatewayReportPeriodInSeconds(String periodTime) {
            this.hoodieMetricsPrometheusConfig.setValue(PUSHGATEWAY_REPORT_PERIOD_IN_SECONDS, periodTime);
            return this;
        }

        public Builder withPushgatewayDeleteOnShutdownEnable(boolean deleteOnShutdownEnable) {
            this.hoodieMetricsPrometheusConfig.setValue(PUSHGATEWAY_DELETE_ON_SHUTDOWN_ENABLE, String.valueOf(deleteOnShutdownEnable));
            return this;
        }

        public Builder withPushgatewayJobname(String jobname) {
            this.hoodieMetricsPrometheusConfig.setValue(PUSHGATEWAY_JOBNAME, jobname);
            return this;
        }

        public Builder withPushgatewayRandomJobnameSuffix(boolean randomJobnameSuffix) {
            this.hoodieMetricsPrometheusConfig.setValue(PUSHGATEWAY_RANDOM_JOBNAME_SUFFIX, String.valueOf(randomJobnameSuffix));
            return this;
        }

        public Builder withPrometheusPortNum(int prometheusPortNum) {
            this.hoodieMetricsPrometheusConfig.setValue(PROMETHEUS_PORT_NUM, String.valueOf(prometheusPortNum));
            return this;
        }

        public HoodieMetricsPrometheusConfig build() {
            this.hoodieMetricsPrometheusConfig.setDefaults(HoodieMetricsPrometheusConfig.class.getName());
            return this.hoodieMetricsPrometheusConfig;
        }
    }
}

