/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.hadoop.BaseFileWithLogsSplit;
import org.apache.hudi.hadoop.PathWithBootstrapFileStatus;

public class PathWithLogFilePath
extends Path {
    private boolean belongToIncrementalPath = false;
    private List<HoodieLogFile> deltaLogFiles = new ArrayList<HoodieLogFile>();
    private String maxCommitTime = "";
    private String basePath = "";
    private String baseFilePath = "";
    private PathWithBootstrapFileStatus pathWithBootstrapFileStatus;

    public PathWithLogFilePath(Path parent, String child) {
        super(parent, child);
    }

    public void setBelongToIncrementalPath(boolean belongToIncrementalPath) {
        this.belongToIncrementalPath = belongToIncrementalPath;
    }

    public List<HoodieLogFile> getDeltaLogFiles() {
        return this.deltaLogFiles;
    }

    public void setDeltaLogFiles(List<HoodieLogFile> deltaLogFiles) {
        this.deltaLogFiles = deltaLogFiles;
    }

    public String getMaxCommitTime() {
        return this.maxCommitTime;
    }

    public void setMaxCommitTime(String maxCommitTime) {
        this.maxCommitTime = maxCommitTime;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public void setBaseFilePath(String baseFilePath) {
        this.baseFilePath = baseFilePath;
    }

    public boolean splitable() {
        return !this.baseFilePath.isEmpty();
    }

    public PathWithBootstrapFileStatus getPathWithBootstrapFileStatus() {
        return this.pathWithBootstrapFileStatus;
    }

    public void setPathWithBootstrapFileStatus(PathWithBootstrapFileStatus pathWithBootstrapFileStatus) {
        this.pathWithBootstrapFileStatus = pathWithBootstrapFileStatus;
    }

    public boolean includeBootstrapFilePath() {
        return this.pathWithBootstrapFileStatus != null;
    }

    public BaseFileWithLogsSplit buildSplit(Path file, long start2, long length, String[] hosts) {
        BaseFileWithLogsSplit bs = new BaseFileWithLogsSplit(file, start2, length, hosts);
        bs.setBelongToIncrementalSplit(this.belongToIncrementalPath);
        bs.setDeltaLogFiles(this.deltaLogFiles);
        bs.setMaxCommitTime(this.maxCommitTime);
        bs.setBasePath(this.basePath);
        bs.setBaseFilePath(this.baseFilePath);
        return bs;
    }
}

