/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.hadoop.PathWithBootstrapFileStatus;
import org.apache.hudi.hadoop.PathWithLogFilePath;

public class RealtimeFileStatus
extends FileStatus {
    private boolean belongToIncrementalFileStatus = false;
    private List<HoodieLogFile> deltaLogFiles = new ArrayList<HoodieLogFile>();
    private String maxCommitTime = "";
    private String basePath = "";
    private String baseFilePath = "";
    private FileStatus bootStrapFileStatus;

    public RealtimeFileStatus(FileStatus fileStatus) throws IOException {
        super(fileStatus);
    }

    public Path getPath() {
        Path path = super.getPath();
        PathWithLogFilePath pathWithLogFilePath = new PathWithLogFilePath(path.getParent(), path.getName());
        pathWithLogFilePath.setBelongToIncrementalPath(this.belongToIncrementalFileStatus);
        pathWithLogFilePath.setDeltaLogFiles(this.deltaLogFiles);
        pathWithLogFilePath.setMaxCommitTime(this.maxCommitTime);
        pathWithLogFilePath.setBasePath(this.basePath);
        pathWithLogFilePath.setBaseFilePath(this.baseFilePath);
        if (this.bootStrapFileStatus != null) {
            pathWithLogFilePath.setPathWithBootstrapFileStatus((PathWithBootstrapFileStatus)this.bootStrapFileStatus.getPath());
        }
        return pathWithLogFilePath;
    }

    public void setBelongToIncrementalFileStatus(boolean belongToIncrementalFileStatus) {
        this.belongToIncrementalFileStatus = belongToIncrementalFileStatus;
    }

    public List<HoodieLogFile> getDeltaLogFiles() {
        return this.deltaLogFiles;
    }

    public void setDeltaLogFiles(List<HoodieLogFile> deltaLogFiles) {
        this.deltaLogFiles = deltaLogFiles;
    }

    public String getMaxCommitTime() {
        return this.maxCommitTime;
    }

    public void setMaxCommitTime(String maxCommitTime) {
        this.maxCommitTime = maxCommitTime;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public void setBaseFilePath(String baseFilePath) {
        this.baseFilePath = baseFilePath;
    }

    public void setBootStrapFileStatus(FileStatus bootStrapFileStatus) {
        this.bootStrapFileStatus = bootStrapFileStatus;
    }
}

