/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.keygen;

import java.io.IOException;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.exception.HoodieKeyException;
import org.apache.hudi.exception.HoodieKeyGeneratorException;
import org.apache.hudi.keygen.BaseKeyGenerator;
import org.apache.hudi.keygen.ComplexAvroKeyGenerator;
import org.apache.hudi.keygen.SimpleAvroKeyGenerator;
import org.apache.hudi.keygen.TimestampBasedAvroKeyGenerator;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;

public class CustomAvroKeyGenerator
extends BaseKeyGenerator {
    private static final String DEFAULT_PARTITION_PATH_SEPARATOR = "/";
    public static final String SPLIT_REGEX = ":";

    public CustomAvroKeyGenerator(TypedProperties props) {
        super(props);
        this.recordKeyFields = Arrays.stream(props.getString(KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key()).split(",")).map(String::trim).collect(Collectors.toList());
        this.partitionPathFields = Arrays.stream(props.getString(KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key()).split(",")).map(String::trim).collect(Collectors.toList());
    }

    @Override
    public String getPartitionPath(GenericRecord record) {
        if (this.getPartitionPathFields() == null) {
            throw new HoodieKeyException("Unable to find field names for partition path in cfg");
        }
        StringBuilder partitionPath = new StringBuilder();
        if (this.getPartitionPathFields().size() == 1 && this.getPartitionPathFields().get(0).isEmpty()) {
            return "";
        }
        for (String field : this.getPartitionPathFields()) {
            String[] fieldWithType = field.split(SPLIT_REGEX);
            if (fieldWithType.length != 2) {
                throw new HoodieKeyException("Unable to find field names for partition path in proper format");
            }
            String partitionPathField = fieldWithType[0];
            PartitionKeyType keyType = PartitionKeyType.valueOf(fieldWithType[1].toUpperCase());
            switch (keyType) {
                case SIMPLE: {
                    partitionPath.append(new SimpleAvroKeyGenerator(this.config, partitionPathField).getPartitionPath(record));
                    break;
                }
                case TIMESTAMP: {
                    try {
                        partitionPath.append(new TimestampBasedAvroKeyGenerator(this.config, partitionPathField).getPartitionPath(record));
                        break;
                    }
                    catch (IOException e) {
                        throw new HoodieKeyGeneratorException("Unable to initialise TimestampBasedKeyGenerator class", e);
                    }
                }
                default: {
                    throw new HoodieKeyGeneratorException("Please provide valid PartitionKeyType with fields! You provided: " + (Object)((Object)keyType));
                }
            }
            partitionPath.append(DEFAULT_PARTITION_PATH_SEPARATOR);
        }
        partitionPath.deleteCharAt(partitionPath.length() - 1);
        return partitionPath.toString();
    }

    @Override
    public String getRecordKey(GenericRecord record) {
        this.validateRecordKeyFields();
        return this.getRecordKeyFields().size() == 1 ? new SimpleAvroKeyGenerator(this.config).getRecordKey(record) : new ComplexAvroKeyGenerator(this.config).getRecordKey(record);
    }

    private void validateRecordKeyFields() {
        if (this.getRecordKeyFields() == null || this.getRecordKeyFields().isEmpty()) {
            throw new HoodieKeyException("Unable to find field names for record key in cfg");
        }
    }

    public String getDefaultPartitionPathSeparator() {
        return DEFAULT_PARTITION_PATH_SEPARATOR;
    }

    public static enum PartitionKeyType {
        SIMPLE,
        TIMESTAMP;

    }
}

