/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.model.HoodieCleanMetadata;
import org.apache.hudi.avro.model.HoodieRestoreMetadata;
import org.apache.hudi.avro.model.HoodieRollbackMetadata;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieDefaultTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.exception.HoodieMetadataException;
import org.apache.hudi.metadata.HoodieMetadataPayload;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class HoodieTableMetadataUtil {
    private static final Logger LOG = LogManager.getLogger(HoodieTableMetadataUtil.class);

    public static void deleteMetadataTable(String basePath, HoodieEngineContext context) {
        String metadataTablePath = HoodieTableMetadata.getMetadataTableBasePath(basePath);
        FileSystem fs = FSUtils.getFs(metadataTablePath, context.getHadoopConf().get());
        try {
            fs.delete(new Path(metadataTablePath), true);
        }
        catch (Exception e) {
            throw new HoodieMetadataException("Failed to remove metadata table from path " + metadataTablePath, e);
        }
    }

    public static List<HoodieRecord> convertMetadataToRecords(HoodieCommitMetadata commitMetadata, String instantTime) {
        LinkedList<HoodieRecord> records = new LinkedList<HoodieRecord>();
        LinkedList allPartitions = new LinkedList();
        commitMetadata.getPartitionToWriteStats().forEach((partitionStatName, writeStats) -> {
            String partition = partitionStatName.equals("") ? "." : partitionStatName;
            allPartitions.add(partition);
            HashMap newFiles = new HashMap(writeStats.size());
            writeStats.forEach(hoodieWriteStat -> {
                String pathWithPartition = hoodieWriteStat.getPath();
                if (pathWithPartition == null) {
                    LOG.warn((Object)("Unable to find path in write stat to update metadata table " + hoodieWriteStat));
                    return;
                }
                int offset = partition.equals(".") ? (pathWithPartition.startsWith("/") ? 1 : 0) : partition.length() + 1;
                String filename = pathWithPartition.substring(offset);
                long totalWriteBytes = newFiles.containsKey(filename) ? (Long)newFiles.get(filename) + hoodieWriteStat.getTotalWriteBytes() : hoodieWriteStat.getTotalWriteBytes();
                newFiles.put(filename, totalWriteBytes);
            });
            HoodieRecord<HoodieMetadataPayload> record = HoodieMetadataPayload.createPartitionFilesRecord(partition, Option.of(newFiles), Option.empty());
            records.add(record);
        });
        HoodieRecord<HoodieMetadataPayload> record = HoodieMetadataPayload.createPartitionListRecord(new ArrayList<String>(allPartitions));
        records.add(record);
        LOG.info((Object)("Updating at " + instantTime + " from Commit/" + (Object)((Object)commitMetadata.getOperationType()) + ". #partitions_updated=" + records.size()));
        return records;
    }

    public static List<HoodieRecord> convertMetadataToRecords(HoodieCleanMetadata cleanMetadata, String instantTime) {
        LinkedList<HoodieRecord> records = new LinkedList<HoodieRecord>();
        int[] fileDeleteCount = new int[]{0};
        cleanMetadata.getPartitionMetadata().forEach((partition, partitionMetadata) -> {
            List<String> deletedFiles = partitionMetadata.getDeletePathPatterns();
            HoodieRecord<HoodieMetadataPayload> record = HoodieMetadataPayload.createPartitionFilesRecord(partition, Option.empty(), Option.of(new ArrayList<String>(deletedFiles)));
            records.add(record);
            fileDeleteCount[0] = fileDeleteCount[0] + deletedFiles.size();
        });
        LOG.info((Object)("Updating at " + instantTime + " from Clean. #partitions_updated=" + records.size() + ", #files_deleted=" + fileDeleteCount[0]));
        return records;
    }

    public static List<HoodieRecord> convertMetadataToRecords(HoodieActiveTimeline metadataTableTimeline, HoodieRestoreMetadata restoreMetadata, String instantTime, Option<String> lastSyncTs) {
        HashMap<String, Map<String, Long>> partitionToAppendedFiles = new HashMap<String, Map<String, Long>>();
        HashMap<String, List<String>> partitionToDeletedFiles = new HashMap<String, List<String>>();
        restoreMetadata.getHoodieRestoreMetadata().values().forEach(rms -> rms.forEach(rm -> HoodieTableMetadataUtil.processRollbackMetadata(metadataTableTimeline, rm, partitionToDeletedFiles, partitionToAppendedFiles, lastSyncTs)));
        return HoodieTableMetadataUtil.convertFilesToRecords(partitionToDeletedFiles, partitionToAppendedFiles, instantTime, "Restore");
    }

    public static List<HoodieRecord> convertMetadataToRecords(HoodieActiveTimeline metadataTableTimeline, HoodieRollbackMetadata rollbackMetadata, String instantTime, Option<String> lastSyncTs, boolean wasSynced) {
        HashMap<String, Map<String, Long>> partitionToAppendedFiles = new HashMap<String, Map<String, Long>>();
        HashMap<String, List<String>> partitionToDeletedFiles = new HashMap<String, List<String>>();
        HoodieTableMetadataUtil.processRollbackMetadata(metadataTableTimeline, rollbackMetadata, partitionToDeletedFiles, partitionToAppendedFiles, lastSyncTs);
        if (!wasSynced) {
            partitionToDeletedFiles.clear();
        }
        return HoodieTableMetadataUtil.convertFilesToRecords(partitionToDeletedFiles, partitionToAppendedFiles, instantTime, "Rollback");
    }

    private static void processRollbackMetadata(HoodieActiveTimeline metadataTableTimeline, HoodieRollbackMetadata rollbackMetadata, Map<String, List<String>> partitionToDeletedFiles, Map<String, Map<String, Long>> partitionToAppendedFiles, Option<String> lastSyncTs) {
        rollbackMetadata.getPartitionMetadata().values().forEach(pm -> {
            boolean shouldSkip;
            String instantToRollback = rollbackMetadata.getCommitsRollback().get(0);
            boolean hasRollbackLogFiles = pm.getRollbackLogFiles() != null && !pm.getRollbackLogFiles().isEmpty();
            boolean hasNonZeroRollbackLogFiles = hasRollbackLogFiles && pm.getRollbackLogFiles().values().stream().mapToLong(Long::longValue).sum() > 0L;
            boolean bl = shouldSkip = lastSyncTs.isPresent() && HoodieTimeline.compareTimestamps(instantToRollback, HoodieTimeline.GREATER_THAN, (String)lastSyncTs.get());
            if (!hasNonZeroRollbackLogFiles && shouldSkip) {
                LOG.info((Object)String.format("Skipping syncing of rollbackMetadata at %s, given metadata table is already synced upto to %s", instantToRollback, lastSyncTs.get()));
                return;
            }
            HoodieInstant syncedInstant = new HoodieInstant(false, "deltacommit", instantToRollback);
            if (metadataTableTimeline.getCommitsTimeline().isBeforeTimelineStarts(syncedInstant.getTimestamp())) {
                throw new HoodieMetadataException(String.format("The instant %s required to sync rollback of %s has been archived", syncedInstant, instantToRollback));
            }
            boolean bl2 = shouldSkip = !metadataTableTimeline.containsInstant(syncedInstant);
            if (!hasNonZeroRollbackLogFiles && shouldSkip) {
                LOG.info((Object)String.format("Skipping syncing of rollbackMetadata at %s, since this instant was never committed to Metadata Table", instantToRollback));
                return;
            }
            String partition = pm.getPartitionPath();
            if (!(pm.getSuccessDeleteFiles().isEmpty() && pm.getFailedDeleteFiles().isEmpty() || shouldSkip)) {
                if (!partitionToDeletedFiles.containsKey(partition)) {
                    partitionToDeletedFiles.put(partition, new ArrayList());
                }
                List deletedFiles = pm.getSuccessDeleteFiles().stream().map(p -> new Path(p).getName()).collect(Collectors.toList());
                if (!pm.getFailedDeleteFiles().isEmpty()) {
                    deletedFiles.addAll(pm.getFailedDeleteFiles().stream().map(p -> new Path(p).getName()).collect(Collectors.toList()));
                }
                ((List)partitionToDeletedFiles.get(partition)).addAll(deletedFiles);
            }
            BiFunction<Long, Long, Long> fileMergeFn = (oldSize, newSizeCopy) -> oldSize > newSizeCopy ? oldSize : newSizeCopy;
            if (hasRollbackLogFiles) {
                if (!partitionToAppendedFiles.containsKey(partition)) {
                    partitionToAppendedFiles.put(partition, new HashMap());
                }
                pm.getRollbackLogFiles().forEach((path, size) -> ((Map)partitionToAppendedFiles.get(partition)).merge(new Path(path).getName(), size, fileMergeFn));
            }
            if (pm.getWrittenLogFiles() != null && !pm.getWrittenLogFiles().isEmpty()) {
                if (!partitionToAppendedFiles.containsKey(partition)) {
                    partitionToAppendedFiles.put(partition, new HashMap());
                }
                pm.getWrittenLogFiles().forEach((path, size) -> ((Map)partitionToAppendedFiles.get(partition)).merge(new Path(path).getName(), size, fileMergeFn));
            }
        });
    }

    private static List<HoodieRecord> convertFilesToRecords(Map<String, List<String>> partitionToDeletedFiles, Map<String, Map<String, Long>> partitionToAppendedFiles, String instantTime, String operation) {
        LinkedList<HoodieRecord> records = new LinkedList<HoodieRecord>();
        int[] fileChangeCount = new int[]{0, 0};
        partitionToDeletedFiles.forEach((partition, deletedFiles) -> {
            fileChangeCount[0] = fileChangeCount[0] + deletedFiles.size();
            Option<Map<String, Long>> filesAdded = Option.empty();
            if (partitionToAppendedFiles.containsKey(partition)) {
                filesAdded = Option.of(partitionToAppendedFiles.remove(partition));
            }
            HoodieRecord<HoodieMetadataPayload> record = HoodieMetadataPayload.createPartitionFilesRecord(partition, filesAdded, Option.of(new ArrayList(deletedFiles)));
            records.add(record);
        });
        partitionToAppendedFiles.forEach((partition, appendedFileMap) -> {
            fileChangeCount[1] = fileChangeCount[1] + appendedFileMap.size();
            ValidationUtils.checkState(!appendedFileMap.keySet().removeAll(partitionToDeletedFiles.getOrDefault(partition, Collections.emptyList())), "Rollback file cannot both be appended and deleted");
            HoodieRecord<HoodieMetadataPayload> record = HoodieMetadataPayload.createPartitionFilesRecord(partition, Option.of(appendedFileMap), Option.empty());
            records.add(record);
        });
        LOG.info((Object)("Found at " + instantTime + " from " + operation + ". #partitions_updated=" + records.size() + ", #files_deleted=" + fileChangeCount[0] + ", #files_appended=" + fileChangeCount[1]));
        return records;
    }

    public static int mapRecordKeyToFileGroupIndex(String recordKey, int numFileGroups) {
        int h = 0;
        for (int i = 0; i < recordKey.length(); ++i) {
            h = 31 * h + recordKey.charAt(i);
        }
        return Math.abs(Math.abs(h) % numFileGroups);
    }

    public static List<FileSlice> loadPartitionFileGroupsWithLatestFileSlices(HoodieTableMetaClient metaClient, String partition, boolean isReader) {
        LOG.info((Object)("Loading file groups for metadata table partition " + partition));
        HoodieDefaultTimeline timeline = metaClient.getActiveTimeline();
        if (timeline.empty()) {
            HoodieInstant instant = new HoodieInstant(false, "deltacommit", HoodieActiveTimeline.createNewInstantTime());
            timeline = new HoodieDefaultTimeline(Arrays.asList(instant).stream(), metaClient.getActiveTimeline()::getInstantDetails);
        }
        HoodieTableFileSystemView fsView = new HoodieTableFileSystemView(metaClient, timeline);
        Stream<FileSlice> fileSliceStream = isReader ? fsView.getLatestMergedFileSlicesBeforeOrOn(partition, timeline.filterCompletedInstants().lastInstant().get().getTimestamp()) : fsView.getLatestFileSlices(partition);
        return fileSliceStream.sorted((s1, s2) -> s1.getFileId().compareTo(s2.getFileId())).collect(Collectors.toList());
    }
}

