/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.savepoint;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hudi.avro.model.HoodieCleanMetadata;
import org.apache.hudi.avro.model.HoodieSavepointMetadata;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.BaseFile;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.table.view.TableFileSystemView;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.ImmutablePair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieSavepointException;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.BaseActionExecutor;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class SavepointActionExecutor<T extends HoodieRecordPayload, I, K, O>
extends BaseActionExecutor<T, I, K, O, HoodieSavepointMetadata> {
    private static final Logger LOG = LogManager.getLogger(SavepointActionExecutor.class);
    private final String user;
    private final String comment;

    public SavepointActionExecutor(HoodieEngineContext context, HoodieWriteConfig config, HoodieTable<T, I, K, O> table, String instantTime, String user, String comment) {
        super(context, config, table, instantTime);
        this.user = user;
        this.comment = comment;
    }

    @Override
    public HoodieSavepointMetadata execute() {
        if (this.table.getMetaClient().getTableType() == HoodieTableType.MERGE_ON_READ) {
            throw new UnsupportedOperationException("Savepointing is not supported or MergeOnRead table types");
        }
        Option<HoodieInstant> cleanInstant = this.table.getCompletedCleanTimeline().lastInstant();
        HoodieInstant commitInstant = new HoodieInstant(false, "commit", this.instantTime);
        if (!this.table.getCompletedCommitsTimeline().containsInstant(commitInstant)) {
            throw new HoodieSavepointException("Could not savepoint non-existing commit " + commitInstant);
        }
        try {
            String lastCommitRetained;
            if (cleanInstant.isPresent()) {
                HoodieCleanMetadata cleanMetadata = TimelineMetadataUtils.deserializeHoodieCleanMetadata(this.table.getActiveTimeline().getInstantDetails(cleanInstant.get()).get());
                lastCommitRetained = cleanMetadata.getEarliestCommitToRetain();
            } else {
                lastCommitRetained = this.table.getCompletedCommitsTimeline().firstInstant().get().getTimestamp();
            }
            ValidationUtils.checkArgument(HoodieTimeline.compareTimestamps(this.instantTime, HoodieTimeline.GREATER_THAN_OR_EQUALS, lastCommitRetained), "Could not savepoint commit " + this.instantTime + " as this is beyond the lookup window " + lastCommitRetained);
            this.context.setJobStatus(this.getClass().getSimpleName(), "Collecting latest files for savepoint " + this.instantTime);
            List<String> partitions = FSUtils.getAllPartitionPaths(this.context, this.config.getMetadataConfig(), this.table.getMetaClient().getBasePath());
            Map<String, List<String>> latestFilesMap = this.context.mapToPair(partitions, partitionPath -> {
                LOG.info((Object)("Collecting latest files in partition path " + partitionPath));
                TableFileSystemView.BaseFileOnlyView view = this.table.getBaseFileOnlyView();
                List latestFiles = view.getLatestBaseFilesBeforeOrOn((String)partitionPath, this.instantTime).map(BaseFile::getFileName).collect(Collectors.toList());
                return new ImmutablePair((String)partitionPath, latestFiles);
            }, null);
            HoodieSavepointMetadata metadata = TimelineMetadataUtils.convertSavepointMetadata(this.user, this.comment, latestFilesMap);
            this.table.getActiveTimeline().createNewInstant(new HoodieInstant(true, "savepoint", this.instantTime));
            this.table.getActiveTimeline().saveAsComplete(new HoodieInstant(true, "savepoint", this.instantTime), TimelineMetadataUtils.serializeSavepointMetadata(metadata));
            LOG.info((Object)("Savepoint " + this.instantTime + " created"));
            return metadata;
        }
        catch (IOException e) {
            throw new HoodieSavepointException("Failed to savepoint " + this.instantTime, e);
        }
    }
}

